// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Max/MaxSceneExport/hctMaxSceneExport.h>
#include <ContentTools/Max/MaxSceneExport/Exporter/CommonInterfaces/hctCommonSkinInterface.h>

#include <iSkinPose.h>

static INode* _calcRootBone(INode* firstBone)
{
  Interface* ip = GetCOREInterface();
  INode* sceneRoot = ip->GetRootNode();
  INode* rootBone = HK_NULL;
  INode* curBone = firstBone;
  while (curBone != sceneRoot)
  {
    if (hctMaxUtils::isBone(curBone))
    {
      rootBone = curBone;
    }
    curBone = curBone->GetParentNode();
  }
  return rootBone;
}

static IBipedExport* _getBipedController(INode* n)
{
  Control* c = n->GetTMController();
  if (c)
  {
    IBipedExport *bipIface = (IBipedExport *) (c->GetInterface(I_BIPINTERFACE));
    return bipIface;
  }
  return HK_NULL;
}

static void _toggleBipedFigureMode(IBipedExport *bipIface, bool enable)
{
  if (enable)
    bipIface->BeginFigureMode(true);
  else
    bipIface->EndFigureMode(true);
}

/*
** STANDARD SKIN
*/

hctStandardSkinInterface::hctStandardSkinInterface (ISkin* skinMod, INode* node)
:
    m_skinMod (skinMod), m_inode(node)
{
    m_contextData = skinMod->GetContextInterface(node);
}

/*virtual*/ bool hctStandardSkinInterface::initialize ()
{
    // No known issues with Skin modifier
    return true;
}

/*virtual*/ bool hctStandardSkinInterface::toggleSkinPose(bool enable, INode* node)
{
  if ( m_skinMod->GetNumBones() < 1) return false;

  // Possible to use Biped controller with Skin or Physique
  IBipedExport* bip = _getBipedController(node? node : m_skinMod->GetBone(0));
  if (bip)
  {
    _toggleBipedFigureMode(bip, enable);
    return true;
  }

  // Handle other controllers here.

  // Try as Max bones
  if (node)
  {
    ISkinPose* pPose = ISkinPose::GetISkinPose(*node);
    if(pPose)
    {
      pPose->SetSkinPoseMode(enable);
      return true;
    }
    return false;
  }
  else
  {
    bool didSome = false;
    int iNumBones = m_skinMod->GetNumBones();
    for(int i=0; i < iNumBones; i++)
    {
      //Use a recursive approach, putting all parent bones into
      //bind pose, as the current bones transformation might be influenced
      //by one of its parents' transforms in bind pose
      INode* pCurBone = m_skinMod->GetBone(i);
      toggleAllParentINodeBindPose(pCurBone,enable);
    }
    return didSome;
  }
}

/*virtual*/ int hctStandardSkinInterface::getNumSkinnedVerts () const
{
    return m_contextData->GetNumPoints();
}

/*virtual*/ int hctStandardSkinInterface::getNumVertexBones (int vertex) const
{
    return m_contextData->GetNumAssignedBones(vertex);
}

/*virtual*/  float hctStandardSkinInterface::getVertexBoneWeight (int vertex, int bone) const
{
    return m_contextData->GetBoneWeight(vertex, bone);
}

/*virtual*/  const INode* hctStandardSkinInterface::getVertexBoneNode (int vertex, int bone) const
{
    const int boneIdx = m_contextData->GetAssignedBone(vertex,bone);
    return m_skinMod->GetBone(boneIdx);
}

/*
** PHYSIQUE
*/


hctPhysiqueSkinInterface::hctPhysiqueSkinInterface (IPhysiqueExport* physiqueMod, INode* node)
:
m_physiqueMod (physiqueMod), m_inode(node)
{
    m_contextData = physiqueMod->GetContextInterface(node);
}


hctPhysiqueSkinInterface::~hctPhysiqueSkinInterface()
{
    if (m_contextData)
    {
        m_physiqueMod->ReleaseContextInterface(m_contextData);
    }
}

/*virtual*/ bool hctPhysiqueSkinInterface::initialize ()
{
    if (!m_contextData)
    {
        // Physique is not initialized
        HK_WARN_ALWAYS(0xabba3ffa, "Physique modifier ("<<m_inode->GetName()<<") not initialized - ignoring skin");
        return false;
    }

    // EXP-792
    int numverts = m_contextData->GetNumberVertices();
    for(int i=0;i<numverts;i++)
    {
        IPhyVertexExport* vi = m_contextData->GetVertexInterface(i);

        if (!vi)
        {
            // Physique is not initialized
            HK_WARN_ALWAYS(0xabba3ffa, "Physique modifier ("<<m_inode->GetName()<<") not initialized - ignoring skin");
            return false;
        }

        m_contextData->ReleaseVertexInterface(vi);
    }

    m_contextData->ConvertToRigid(TRUE);

    return true;
}



static void _setBonePoseStateRecursive(INode* bone, bool poseState)
{
  ISkinPose* pose = ISkinPose::GetISkinPose(*bone);
  if(pose)
  {
    //First enable all parents in bind pose mode
    //With the recursion of this method the below method is
    //performing redundant tasks, so in case of performance issues
    //_setBonePoseStateRecursive should traverse to the leaf node
    //an then call toggleAllParentINodeBindPose only once.
    toggleAllParentINodeBindPose(bone,poseState);

    //Now put all children in pose mode
    int numChildren = bone->NumberOfChildren();
    for (int i=0; i < numChildren; i++)
    {
      INode* child = bone->GetChildNode(i);
      _setBonePoseStateRecursive(child, poseState);
    }
  }
}

void toggleAllParentINodeBindPose( INode* pNode, bool bMode )
{
  //First gather all bones back from current bone up to root node
  //and store the nodes
  hkArray<INode*> boneArray;
  while (pNode && pNode != GetCOREInterface()->GetRootNode())
  {
    if(hctMaxUtils::isBone(pNode))
    {
      boneArray.pushBack(pNode);
    }
    pNode = pNode->GetParentNode();
  }

  //Now go down from root bone to pNode and enable bind pose mode
  //as 3DSMax might prevent successful setting of bind pose mode on
  //bones when parents are not in bind pose. (Uncertain about that
  //but this way, it is the save way)
  int iNumBones = boneArray.getSize();
  for(int b=iNumBones-1; b >= 0; --b)
  {
    INode* pBone = boneArray[b];
    // Possible to use Biped controller with Skin or Physique
    IBipedExport* bip = _getBipedController(pBone);
    if (bip)
    {
      _toggleBipedFigureMode(bip,bMode);
    }

    ISkinPose* pPose = ISkinPose::GetISkinPose(*pBone);
    if(pPose)
    {
      pPose->SetSkinPoseMode(bMode);
    }
  }
}


/*virtual*/ bool hctPhysiqueSkinInterface::toggleSkinPose(bool enable, INode* node)
{
  // Possible to use Biped controller with Skin or Physique
  IBipedExport* bip = _getBipedController(node? node : const_cast<INode*>( getVertexBoneNode(0,0) ) );
  if (bip)
  {
    _toggleBipedFigureMode(bip, enable);
    return true;
  }

  // Could be Physique modifier, but Max bone nodes
  if (node)
  {
    ISkinPose* pose = ISkinPose::GetISkinPose(*node);
    if(pose)
    {
      pose->SetSkinPoseMode(enable);
      return true;
    }
  }
  else
  {
    INode* anyBone = const_cast<INode*>( getVertexBoneNode(0,0) );
    _setBonePoseStateRecursive(_calcRootBone(anyBone), enable);
    return true;
  }

  return false;
}

/*virtual*/  int hctPhysiqueSkinInterface::getNumSkinnedVerts () const
{
    return m_contextData->GetNumberVertices();

}

/*virtual*/  int hctPhysiqueSkinInterface::getNumVertexBones (int vertex) const
{
    IPhyVertexExport* vertexExp = m_contextData->GetVertexInterface(vertex);

    if (!vertexExp)
    {
        HK_WARN_ALWAYS(0xabba8732, "Physique Skin not initialized - ignoring it");
        return -1;
    }

    const int vType = vertexExp->GetVertexType();
    if (vType & BLENDED_TYPE )
    {
        IPhyBlendedRigidVertex *blendedVtx = (IPhyBlendedRigidVertex*) vertexExp;
        const int result =  blendedVtx->GetNumberNodes();
        m_contextData->ReleaseVertexInterface(blendedVtx);
        return result;
    }

    // else (RIGID)

    IPhyRigidVertex* rigidVtx = (IPhyRigidVertex*) vertexExp;
    const int result = rigidVtx->GetNode() ? 1 : 0;
    m_contextData->ReleaseVertexInterface(rigidVtx);
    return result;
}

/*virtual*/  float hctPhysiqueSkinInterface::getVertexBoneWeight (int vertex, int bone) const
{
    IPhyVertexExport* vertexExp = m_contextData->GetVertexInterface(vertex);

    if (!vertexExp)
    {
        HK_WARN_ALWAYS(0xabba8176, "!!");
        return 0.0f;
    }

    const int vType = vertexExp->GetVertexType();
    if (vType & BLENDED_TYPE)
    {
        IPhyBlendedRigidVertex *blendedVtx = (IPhyBlendedRigidVertex*) vertexExp;
        const float result =  blendedVtx->GetWeight(bone);;
        m_contextData->ReleaseVertexInterface(blendedVtx);
        return result;
    }

    // else (RIGID)

    IPhyRigidVertex* rigidVtx = (IPhyRigidVertex*) vertexExp;
    const float result = rigidVtx->GetNode() ? 1.0f : 0.0f;
    m_contextData->ReleaseVertexInterface(rigidVtx);
    return result;
}

/*virtual*/  const INode* hctPhysiqueSkinInterface::getVertexBoneNode (int vertex, int bone) const
{
    IPhyVertexExport* vertexExp = m_contextData->GetVertexInterface(vertex);

    if (!vertexExp)
    {
        HK_WARN_ALWAYS(0xabbab2a9, "!!");
        return HK_NULL;
    }

    const int vType = vertexExp->GetVertexType();
    if ( vType & BLENDED_TYPE)
    {
        IPhyBlendedRigidVertex *blendedVtx = (IPhyBlendedRigidVertex*) vertexExp;
        const INode* result =  blendedVtx->GetNode(bone);
        m_contextData->ReleaseVertexInterface(blendedVtx);
        return result;
    }

    // else (RIGID)

    IPhyRigidVertex* rigidVtx = (IPhyRigidVertex*) vertexExp;
    const INode* result = rigidVtx->GetNode();
    m_contextData->ReleaseVertexInterface(rigidVtx);
    return result;
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
