// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/SceneData/Attributes/hkxAttributeGroup.h>

/// 3ds Max has multiple technologies available to store and interface to parameters. In order to simplify the code
/// of the exporters, those technologies are all abstracted through this interface. In particular, we provide support for
/// both the pre-v3 IParamBlock1 technology and the newer IParamBlock2 technology.
class hctCommonParameterInterface
{
    public:

        enum AttributeType
        {
            AT_STRING,
            AT_FLOAT,
            AT_INT,
            AT_BOOL,
            AT_VECTOR,
            AT_MATRIX,
            AT_MAXOBJECT,
            AT_UNSUPPORTED,
        };

        virtual ~hctCommonParameterInterface();

            /// Return the name of the parameter block
        virtual MSTR getPBlockName() const = 0;

            /// Return the internal class name of the object holding this parameter block
        virtual MSTR getInternalClassName() const = 0;

            /// Return the UI (localized) class name of the object holding this parameter block
        virtual MSTR getUIClassName() const = 0;

            /// Number of parameters stored in the parameter block
        virtual int getNumParameters() const = 0;

            /// Returns the attribute type to which the parameter will be converted to.
            /// For example, INode*, Bitmap* and String parameter are all converted to strings (AT_STRING)
        virtual AttributeType getAttributeType (int index) const = 0;

            /// Return any hints (additional dimension information) for the given parameter.
        virtual hkxAttribute::Hint getAttributeHint (int index) const=0;

            /// Return the internal (maxscript) name of the parameter.
        virtual MSTR getParameterInternalName (int index) const =0;

            /// Return the UI (localized) name of the parameter
        virtual MSTR getParameterUIName (int index) const =0;

            /// Returns true if the parameter is animatable and animated
        virtual bool isParameterAnimated (int index) const =0;

            /// Access to the value of the parameter. Results HK_FAILURE/HK_SUCCESS.
        virtual hkResult getParameterValue (int index, TimeValue timem, MSTR& stringOut) const =0;

            /// Access to the value of the parameter. Results HK_FAILURE/HK_SUCCESS.
        virtual hkResult getParameterValue (int index, TimeValue time, float& floatOut) const = 0;

            /// Access to the value of the parameter. Results HK_FAILURE/HK_SUCCESS.
        virtual hkResult getParameterValue (int index, TimeValue time, int& intOut) const = 0;

            /// Access to the value of the parameter. Results HK_FAILURE/HK_SUCCESS.
        virtual hkResult getParameterValue (int index, TimeValue time, hkBool& boolOut) const = 0;

            /// Access to the value of the parameter. Results HK_FAILURE/HK_SUCCESS.
        virtual hkResult getParameterValue (int index, TimeValue time, hkVector4& vectorOut) const = 0;

            /// Access to the value of the parameter. Results HK_FAILURE/HK_SUCCESS.
        virtual hkResult getParameterValue (int index, TimeValue time, hkMatrix4& matrixOut) const = 0;

            /// Access to the value of the parameter. Results HK_FAILURE/HK_SUCCESS.
        virtual hkResult getParameterValue (int index, TimeValue time, ReferenceTarget*& refTargetOut) const = 0;

            /// Access to the value of the parameter. Results HK_FAILURE/HK_SUCCESS.
        virtual hkResult getParameterValue (int index, TimeValue time, INode*& iNodeOut) const = 0;
};


/// Implementation of the interface, based on the IParamBlock2* technology.
class hctParamBlock2Interface : public hctCommonParameterInterface
{
    public:

        /// Constructor - gets the parameter block
        hctParamBlock2Interface (IParamBlock2* pblock2);

        /*virtual*/ MSTR getPBlockName() const;

        /*virtual*/ MSTR getInternalClassName() const;

        /*virtual*/ MSTR getUIClassName() const;

        /*virtual*/ int getNumParameters() const;

        /*virtual*/ AttributeType getAttributeType (int index) const;

        /*virtual*/ hkxAttribute::Hint getAttributeHint (int index) const;

        /*virtual*/ MSTR getParameterInternalName (int index) const;

        /*virtual*/ MSTR getParameterUIName (int index) const;

        /*virtual*/ bool isParameterAnimated (int index) const;

        /*virtual*/ hkResult getParameterValue (int index, TimeValue time, MSTR& stringOut) const;

        /*virtual*/ hkResult getParameterValue (int index, TimeValue time, float& floatOut) const;

        /*virtual*/ hkResult getParameterValue (int index, TimeValue time, int& intOut) const;

        /*virtual*/ hkResult getParameterValue (int index, TimeValue time, hkBool& boolOut) const;

        /*virtual*/ hkResult getParameterValue (int index, TimeValue time, hkVector4& vectorOut) const;

        /*virtual*/ hkResult getParameterValue (int index, TimeValue time, hkMatrix4& matrixOut) const;

        /*virtual*/ hkResult getParameterValue (int index, TimeValue time, ReferenceTarget*& refTargetOut) const;

        /*virtual*/ hkResult getParameterValue (int index, TimeValue time, INode*& iNodeOut) const;

    private:

        IParamBlock2* m_pblock2;
};

/// Implementation of the interface, based on the older IParamBlock1* technlogy
class hctParamBlock1Interface : public hctCommonParameterInterface
{
    public:

        /// Constructor - pass a pointer to the object holding the ParamBlock* and the reference index of it
        hctParamBlock1Interface ( ReferenceTarget* owner, int referenceIndex );

        /*virtual*/ MSTR getPBlockName() const;

        /*virtual*/ MSTR getInternalClassName() const;

        /*virtual*/ MSTR getUIClassName() const;

        /*virtual*/ int getNumParameters() const;

        /*virtual*/ AttributeType getAttributeType (int index) const;

        /*virtual*/ hkxAttribute::Hint getAttributeHint (int index) const;

        /*virtual*/ MSTR getParameterInternalName (int index) const;

        /*virtual*/ MSTR getParameterUIName (int index) const;

        /*virtual*/ bool isParameterAnimated (int index) const;

        /*virtual*/ hkResult getParameterValue (int index, TimeValue time, MSTR& stringOut) const;

        /*virtual*/ hkResult getParameterValue (int index, TimeValue time, float& floatOut) const;

        /*virtual*/ hkResult getParameterValue (int index, TimeValue time, int& intOut) const;

        /*virtual*/ hkResult getParameterValue (int index, TimeValue time, hkBool& boolOut) const;

        /*virtual*/ hkResult getParameterValue (int index, TimeValue time, hkVector4& vectorOut) const;

        /*virtual*/ hkResult getParameterValue (int index, TimeValue time, hkMatrix4& matrixOut) const;

        /*virtual*/ hkResult getParameterValue (int index, TimeValue time, ReferenceTarget*& refTargetOut) const;

        /*virtual*/ hkResult getParameterValue (int index, TimeValue time, INode*& iNodeOut) const;

    private:

        int indexToParamID (int index) const;
        int indextoAnimID (int index) const;

        ReferenceTarget* m_owner;
        IParamBlock* m_pblock1;
        MSTR m_pblockName;

        struct PBlockParam
        {
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_EXPORT, PBlockParam);
            MSTR m_internalName;
            MSTR m_uiName;
            int m_paramID;
            int m_subAnimID;
        };

        hkArray<PBlockParam> m_parameters;

        void exploreParameters ();

};

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
