// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0
#include <ContentTools/Max/MaxSceneExport/hctMaxSceneExport.h>
#include <ContentTools/Max/MaxSceneExport/Exporter/CommonInterfaces/hctCommonParameterInterface.h>
#include <ContentTools/Max/MaxSceneExport/Utils/hctMaxUtils.h>


/*virtual*/ hctCommonParameterInterface::~hctCommonParameterInterface()
{

}

//////////////////////////////////////////////////////////////////////////
// PARAMBLOCK2 IMPLEMENTATION
//////////////////////////////////////////////////////////////////////////


hctParamBlock2Interface::hctParamBlock2Interface (IParamBlock2* pblock2) : m_pblock2 (pblock2)
{

}

/*virtual*/ MSTR hctParamBlock2Interface::getPBlockName() const
{
    return m_pblock2->GetDesc()->int_name;
}

/*virtual*/ MSTR hctParamBlock2Interface::getInternalClassName() const
{
    return MSTR (m_pblock2->GetDesc()->cd->InternalName());
}

/*virtual*/ MSTR hctParamBlock2Interface::getUIClassName() const
{
    MSTR str;
    ReferenceMaker *refMaker = m_pblock2->GetOwner();
    if(refMaker)
    {
        refMaker->GetClassName(str);
    }
    else
    {
        return TEXT("Unnamed");
    }
    return MSTR (str);
}

/*virtual*/ int hctParamBlock2Interface::getNumParameters() const
{
    return m_pblock2->NumParams();
}

/*virtual*/ hctParamBlock2Interface::AttributeType hctParamBlock2Interface::getAttributeType (int index) const
{
    const ParamID paramID = m_pblock2->IndextoID(index);
    const int param_type = m_pblock2->GetParameterType( paramID);
    switch ( param_type ) //of type ParamType2
    {
    case TYPE_MTL:
    case TYPE_TEXMAP:
    case TYPE_BITMAP:
    case TYPE_INODE:
    case TYPE_FILENAME:
    case TYPE_STRING:
        {
            return AT_STRING;
        }
    case TYPE_COLOR_CHANNEL:
    case TYPE_ANGLE:
    case TYPE_PCNT_FRAC:
    case TYPE_WORLD:
    case TYPE_FLOAT:
        {
            return AT_FLOAT;
        }
    case TYPE_BOOL:
        {
            return AT_BOOL;
        }
    case TYPE_INDEX:
    case TYPE_TIMEVALUE:
    case TYPE_INT:
        {
            return AT_INT;
        }
    case TYPE_RGBA:
    case TYPE_POINT3:
    case TYPE_FRGBA:
    case TYPE_POINT4:
        {
            return AT_VECTOR;
        }
    case TYPE_MATRIX3:
        {
            return AT_MATRIX;
        }
    case TYPE_REFTARG:
        {
            return AT_MAXOBJECT;
        }
    }

    return AT_UNSUPPORTED;
}

/*virtual*/ hkxAttribute::Hint hctParamBlock2Interface::getAttributeHint (int index) const
{
    const ParamID paramID = m_pblock2->IndextoID(index);
    const int param_type = m_pblock2->GetParameterType( paramID);
    const ParamDimension* param_dim = m_pblock2->GetParamDef(paramID).dim;


    switch ( param_type ) //of type ParamType2
    {
    case TYPE_ANGLE:
        {
            return hkxAttribute::HINT_FLIP;
        }

    case TYPE_WORLD:
        {
            return hkxAttribute::HINT_SCALE;
        }

    case TYPE_FLOAT:
        {
            if (param_dim == stdAngleDim)
            {
                return hkxAttribute::HINT_FLIP;
            }
            if (param_dim == stdWorldDim)
            {
                return hkxAttribute::HINT_SCALE;
            }

            ParamDef& pdef= m_pblock2->GetParamDef(paramID);

            if ((pdef.ctrl_count>0) && (pdef.ctrl_type==TYPE_SPINNER)
                && ( (pdef.spin_type==EDITTYPE_UNIVERSE) || (pdef.spin_type==EDITTYPE_POS_UNIVERSE) ) )
            {
                return hkxAttribute::HINT_SCALE;
            }

            return hkxAttribute::HINT_NONE;
        }
    case TYPE_POINT3:
    case TYPE_POINT4:
        {
            if (param_dim == stdAngleDim)
            {
                return hkxAttribute::HINT_FLIP;
            }
            if (param_dim == stdWorldDim)
            {
                return hkxAttribute::HINT_TRANSFORM_AND_SCALE;
            }

            ParamDef& pdef= m_pblock2->GetParamDef(paramID);

            if ((pdef.ctrl_count>0) && (pdef.ctrl_type==TYPE_SPINNER)
                && ( (pdef.spin_type==EDITTYPE_UNIVERSE) || (pdef.spin_type==EDITTYPE_POS_UNIVERSE) ) )
            {
                return hkxAttribute::HINT_TRANSFORM_AND_SCALE;
            }

            return hkxAttribute::HINT_NONE;
        }

    case TYPE_MATRIX3:
        {
            return hkxAttribute::HINT_TRANSFORM_AND_SCALE;
        }
    }

    return hkxAttribute::HINT_NONE;

}

/*virtual*/ MSTR hctParamBlock2Interface::getParameterInternalName (int index) const
{
    const ParamID paramID = m_pblock2->IndextoID(index);
    return MSTR (m_pblock2->GetParamDef( paramID ).int_name);

}

/*virtual*/ MSTR hctParamBlock2Interface::getParameterUIName (int index) const
{

    if (getAttributeType(index) == AT_UNSUPPORTED)
    {
        return TEXT("Unsupported");
    }

    // else

    const ParamID paramID = m_pblock2->IndextoID(index);
    MSTR tstr = m_pblock2->GetLocalName(paramID);

    return tstr;
}

/*virtual*/ bool hctParamBlock2Interface::isParameterAnimated (int index) const
{
    const ParamID paramID = m_pblock2->IndextoID(index);
    const AttributeType attributeType = getAttributeType(index);
    Interval interval;

    switch (attributeType)
    {
    case AT_INT:
    case AT_BOOL:
        {
            int anInt;
            m_pblock2->GetValue(paramID, 0, anInt, interval);

            return !interval.Empty();
        }
    case AT_FLOAT:
        {
            float aFloat;
            m_pblock2->GetValue(paramID, 0, aFloat, interval);

            return !interval.Empty();
        }
    case AT_VECTOR:
        {
            const ParamType2 maxType = m_pblock2->GetParameterType(paramID);
            const bool isV4 = (maxType == TYPE_FRGBA) || (maxType == TYPE_POINT4);
            if (isV4)
            {
                Point4 aPoint4;
                m_pblock2->GetValue(paramID, 0, aPoint4, interval);
            }
            else
            {
                Point3 aPoint3;
                m_pblock2->GetValue(paramID, 0, aPoint3, interval);
            }

            return !interval.Empty();
        }
    case AT_MATRIX:
        {
            Matrix3 aMatrix;
            m_pblock2->GetValue ( paramID, 0, aMatrix, interval );

            return !interval.Empty();
        }

    }

    // strings are not animated
    return false;
}

/*virtual*/ hkResult hctParamBlock2Interface::getParameterValue (int index, TimeValue time, INode*& iNodeOut) const
{
    const ParamID paramID = m_pblock2->IndextoID(index);
    const ParamType2 paramType = m_pblock2->GetParameterType(paramID);
    Interval interval;

    iNodeOut = HK_NULL;

    if ( paramType == TYPE_INODE )
    {
        INode* node;
        const BOOL okVal = m_pblock2->GetValue ( paramID, time, node, interval );
        if (okVal && node )
        {
            iNodeOut = node;
            return HK_SUCCESS;
        }
    }

    return HK_FAILURE;
}

/*virtual*/ hkResult hctParamBlock2Interface::getParameterValue (int index, TimeValue time, MSTR& stringOut) const
{
    HK_ASSERT_NO_MSG(0x15bd0d21, getAttributeType(index)==AT_STRING);

    BOOL okVal = false;
    const ParamID paramID = m_pblock2->IndextoID(index);
    const ParamType2 paramType = m_pblock2->GetParameterType(paramID);
    Interval interval;

    stringOut = TEXT("");
    switch (paramType)
    {
    case TYPE_INODE:
        {
            INode* node;
            okVal = m_pblock2->GetValue ( paramID, time, node, interval );
            if (okVal && (node != NULL))
            {
                stringOut = node->GetName();
            }

            break;
        }
    case TYPE_BITMAP:
        {
            PBBitmap* bm;
            okVal = m_pblock2->GetValue ( paramID, time, bm, interval );
            if (okVal && (bm != NULL) )
            {
                stringOut = bm->bi.Name();
            }

            break;
        }
    case TYPE_TEXMAP:
        {
            Texmap* tm;
            okVal = m_pblock2->GetValue ( paramID, time, tm, interval );
            if (okVal && (tm != NULL))
            {
                stringOut = tm->GetName();
            }

            break;
        }
    case  TYPE_MTL:
        {
            Mtl* m;
            okVal = m_pblock2->GetValue ( paramID, time, m, interval );
            if (okVal && (m != NULL))
            {
                stringOut = m->GetName();
            }

            break;

        }
    case TYPE_STRING:
        {
            CONST12 MCHAR* tstr;
            okVal = m_pblock2->GetValue( paramID, time, tstr, interval );

            if (okVal)
            {
                stringOut = tstr;
            }

            break;

        }
    }

    return (okVal) ? HK_SUCCESS : HK_FAILURE;
}

/*virtual*/ hkResult hctParamBlock2Interface::getParameterValue (int index, TimeValue time, float& floatOut) const
{
    HK_ASSERT_NO_MSG(0x32a579e4, getAttributeType(index)==AT_FLOAT);

    const ParamID paramID = m_pblock2->IndextoID(index);
    Interval interval;
    BOOL okVal = m_pblock2->GetValue ( paramID, time , floatOut, interval );

    return okVal ? HK_SUCCESS : HK_FAILURE;

}

/*virtual*/ hkResult hctParamBlock2Interface::getParameterValue (int index, TimeValue time, int& intOut) const
{
    HK_ASSERT_NO_MSG(0x30072e86, getAttributeType(index)==AT_INT);

    const ParamID paramID = m_pblock2->IndextoID(index);
    Interval interval;
    BOOL okVal = m_pblock2->GetValue ( paramID, time , intOut, interval );

    return okVal ? HK_SUCCESS : HK_FAILURE;
}

/*virtual*/ hkResult hctParamBlock2Interface::getParameterValue (int index, TimeValue time, hkBool& boolOut) const
{
    HK_ASSERT_NO_MSG(0x6216820b, getAttributeType(index)==AT_BOOL);

    const ParamID paramID = m_pblock2->IndextoID(index);
    Interval interval;
    int anInt = FALSE;
    BOOL okVal = m_pblock2->GetValue ( paramID, time , anInt, interval );
    boolOut = (anInt!=FALSE);

    return okVal ? HK_SUCCESS : HK_FAILURE;

}

/*virtual*/ hkResult hctParamBlock2Interface::getParameterValue (int index, TimeValue time, hkVector4& vectorOut) const
{
    HK_ASSERT_NO_MSG(0x23b6fa18, getAttributeType(index)==AT_VECTOR);

    const ParamID paramID = m_pblock2->IndextoID(index);
    const ParamType2 maxType = m_pblock2->GetParameterType(paramID);
    const bool isV4 = (maxType == TYPE_FRGBA) || (maxType == TYPE_POINT4);
    Interval interval;

    BOOL okVal = FALSE;
    if (isV4)
    {
        Point4 aPoint4;
        okVal = m_pblock2->GetValue(paramID, 0, aPoint4, interval);
        vectorOut.set(aPoint4[0], aPoint4[1], aPoint4[2], aPoint4[3]);
    }
    else
    {
        Point3 aPoint3;
        okVal = m_pblock2->GetValue(paramID, 0, aPoint3, interval);
        vectorOut.set(aPoint3[0], aPoint3[1], aPoint3[2], 0.0f);
    }

    return okVal ? HK_SUCCESS : HK_FAILURE;

}

/*virtual*/ hkResult hctParamBlock2Interface::getParameterValue (int index, TimeValue time, hkMatrix4& matrixOut) const
{
    HK_ASSERT_NO_MSG(0x1aaf1e84, getAttributeType(index)==AT_MATRIX);

    const ParamID paramID = m_pblock2->IndextoID(index);
    Interval interval;

    Matrix3 matValue(1);
    BOOL okVal = m_pblock2->GetValue ( paramID, time, matValue, interval );

    hctMaxUtils::convertToMatrix4( matValue, matrixOut );

    return okVal ? HK_SUCCESS : HK_FAILURE;

}

/*virtual*/ hkResult hctParamBlock2Interface::getParameterValue (int index, TimeValue time, ReferenceTarget*& refTargetOut) const
{
    HK_ASSERT_NO_MSG(0x1bc7d2c2, getAttributeType(index)==AT_MAXOBJECT);

    const ParamID paramID = m_pblock2->IndextoID(index);
    Interval interval;
    BOOL okVal = m_pblock2->GetValue(paramID, time, refTargetOut, interval);

    return okVal ? HK_SUCCESS : HK_FAILURE;
}


//////////////////////////////////////////////////////////////////////////
// PARAMBLOCK1 IMPLEMENTATION
//////////////////////////////////////////////////////////////////////////

hctParamBlock1Interface::hctParamBlock1Interface (ReferenceTarget* owner, int referenceIndex)
{
    m_owner = owner;
    ReferenceTarget *refTarget = m_owner->GetReference(referenceIndex);

    HK_ASSERT_NO_MSG(0x7f700512, refTarget);
    HK_ASSERT_NO_MSG(0x6902c7a4, refTarget->SuperClassID()== PARAMETER_BLOCK_CLASS_ID);

    m_pblock1 = (IParamBlock*) refTarget;

    // Look for the name of the parameter block
    m_pblockName = TEXT("<Properties>");
    for (int si=0; si<m_owner->NumSubs(); si++)
    {
        if (m_owner->SubAnim(si) == m_pblock1)
        {
            m_pblockName = m_owner->SubAnimName(si);
        }

    }

    exploreParameters();
}

void hctParamBlock1Interface::exploreParameters()
{
    // Search for the maxscript equivalent of the object to find maxscript parameter names
    MAXClass* mxsClass = HK_NULL;
    {
        Class_ID objCID = m_owner->ClassID();

        mxsClass = MAXClass::lookup_class( &objCID, m_owner->SuperClassID(), false);

        if (mxsClass)
        {
            if (mxsClass->md_flags & (md_new_plugin | md_auto_parms))
            {
                // fill out the parm-desc table if needed. hack, since build_parm_descs is not exported
                init_thread_locals();
                push_alloc_frame();
                mxsClass->apply_keyword_parms(m_owner,NULL,0);
                pop_alloc_frame();
            }

            // make sure its the pb we have info about
            const bool samePBlock =
                (mxsClass->paramblock_ref_no >= 0) &&
                (mxsClass->paramblock_ref_no < m_owner->NumRefs()) &&
                (m_pblock1 == (IParamBlock*)m_owner->GetReference(mxsClass->paramblock_ref_no));

            if (!samePBlock)
            {
                mxsClass = HK_NULL;
            }
        }
    }

    const int numParameters = m_pblock1->NumParams();

    for (int i=0; i<numParameters; i++)
    {
        PBlockParam parameterInfo;
        parameterInfo.m_paramID = i;
        parameterInfo.m_subAnimID = -1;
        parameterInfo.m_internalName = TEXT("");
        parameterInfo.m_uiName = TEXT("");

        // Search for subanims
        for (int si=0; si<m_pblock1->NumSubs(); si++)
        {
            const int paramID = m_pblock1->AnimNumToParamNum(si);
            if (paramID == i)
            {
                parameterInfo.m_subAnimID = si;
                MSTR uiName =m_pblock1->SubAnimName(si);
                parameterInfo.m_uiName = uiName;
                parameterInfo.m_internalName = parameterInfo.m_uiName;
                break;
            }
        }

        // Look for names in maxscript
        if (mxsClass)
        {
            // loop over all parms looking for the indexed param
            parm_desc* pd;

            int j;
            for (j = mxsClass->n_parms, pd = mxsClass->parms; j--; pd++)
            {

                MCHAR type = pd->desc_type;
                int paramID = pd->parm_id;

                if ((type == paramblock) && (paramID == i))
                {
                    parameterInfo.m_internalName = pd->name->to_string();

                    // If we didn't find a UI name, use the internal
                    if (parameterInfo.m_uiName.length()==0)
                    {
                        parameterInfo.m_uiName = parameterInfo.m_internalName;
                    }
                }
            }
        }

        // Ignore parameters with no name
        if (parameterInfo.m_internalName.length()!=0)
        {
            m_parameters.pushBack(parameterInfo);
        }

    }



}


// Currently index = subAnimID
int hctParamBlock1Interface::indexToParamID (int index) const
{
    return m_parameters[index].m_paramID;
}

int hctParamBlock1Interface::indextoAnimID (int index) const
{
    return m_parameters[index].m_subAnimID;
}

/*virtual*/ MSTR hctParamBlock1Interface::getPBlockName() const
{
    return m_pblockName;
}

/*virtual*/ MSTR hctParamBlock1Interface::getInternalClassName() const
{
    // No internal class name in pblock1s -> use the UI name
    return getUIClassName();
}

/*virtual*/ MSTR hctParamBlock1Interface::getUIClassName() const
{
    MSTR str; m_owner->GetClassName(str);
    return MSTR (str);
}


/*virtual*/ int hctParamBlock1Interface::getNumParameters() const
{
    // If we change this (to support non-animated params), modify also
    //      indexToParamID()
    //      indexToAnimID()
    return m_parameters.getSize();
}

/*virtual*/ hctCommonParameterInterface::AttributeType hctParamBlock1Interface::getAttributeType (int index) const
{
    const int paramID = indexToParamID(index);

    const ParamType type = m_pblock1->GetParameterType(paramID);

    switch (type)
    {
        case TYPE_FLOAT:
            return AT_FLOAT;
        case TYPE_INT:
            return AT_INT;
        case TYPE_RGBA:
        case TYPE_POINT3:
            return AT_VECTOR;
        case TYPE_BOOL:
            return AT_BOOL;
    }

    return AT_UNSUPPORTED;
}

/*virtual*/ hkxAttribute::Hint hctParamBlock1Interface::getAttributeHint (int index) const
{
    const int paramID = indexToParamID(index);
    const int subAnimID = indextoAnimID(index);

    const ParamType type = m_pblock1->GetParameterType(paramID);
    ParamDimension* pdim = (subAnimID>=0) ? m_pblock1->GetParamDimension(subAnimID) : HK_NULL;

    switch (type)
    {
        case TYPE_FLOAT:
            {
                if (pdim == stdWorldDim)
                {
                    return hkxAttribute::HINT_SCALE;
                }

                if (pdim == stdAngleDim)
                {
                    return hkxAttribute::HINT_FLIP;
                }

                break;
            }

        case TYPE_RGBA:
            {
                return hkxAttribute::HINT_NONE;
            }
        case TYPE_POINT3:
            {
                if (pdim == stdWorldDim)
                {
                    return hkxAttribute::HINT_TRANSFORM_AND_SCALE;
                }

                break;
            }
    }

    return hkxAttribute::HINT_NONE;


}
//
/*virtual*/ MSTR hctParamBlock1Interface::getParameterInternalName (int index) const
{
    return m_parameters[index].m_internalName;
}

/*virtual*/ MSTR hctParamBlock1Interface::getParameterUIName (int index) const
{
    return m_parameters[index].m_uiName;
}

/*virtual*/ bool hctParamBlock1Interface::isParameterAnimated (int index) const
{
    const int subAnimID = indextoAnimID(index);

    if (subAnimID<0) return false;

    return (m_pblock1->SubAnim(subAnimID)->IsAnimated()!=FALSE);
}


/*virtual*/ hkResult hctParamBlock1Interface::getParameterValue (int index, TimeValue time, INode*& iNodeOut) const
{
    HK_ASSERT_NO_MSG(0x36fba82, !"No INode parameters in pblock1s!");
    iNodeOut = HK_NULL;
    return HK_FAILURE;
}

/*virtual*/ hkResult hctParamBlock1Interface::getParameterValue (int index, TimeValue time, MSTR& stringOut) const
{
    HK_ASSERT_NO_MSG(0x36fba82, !"No string parameters in pblock1s!");
    return HK_FAILURE;
}

/*virtual*/ hkResult hctParamBlock1Interface::getParameterValue (int index, TimeValue time, float& floatOut) const
{
    const int paramID = indexToParamID(index);

    floatOut = m_pblock1->GetFloat(paramID, time);

    return HK_SUCCESS;
}

/*virtual*/ hkResult hctParamBlock1Interface::getParameterValue (int index, TimeValue time, int& intOut) const
{
    const int paramID = indexToParamID(index);

    intOut = m_pblock1->GetInt(paramID, time);

    return HK_SUCCESS;
}

/*virtual*/ hkResult hctParamBlock1Interface::getParameterValue (int index, TimeValue time, hkBool& boolOut) const
{
    const int paramID = indexToParamID(index);

    boolOut = (m_pblock1->GetInt(paramID, time) != FALSE);

    return HK_SUCCESS;
}

/*virtual*/ hkResult hctParamBlock1Interface::getParameterValue (int index, TimeValue time, hkVector4& vectorOut) const
{
    const int paramID = indexToParamID(index);

    Point3 point3 = m_pblock1->GetPoint3(paramID, time);

    vectorOut.set(point3[0], point3[1], point3[2], 0.0f);

    return HK_SUCCESS;

}

/*virtual*/ hkResult hctParamBlock1Interface::getParameterValue (int index, TimeValue time, hkMatrix4& matrixOut) const
{
    HK_ASSERT_NO_MSG(0x5aa424ed, !"No matrix parameters in pblock1s!");
    return HK_FAILURE;
}

/*virtual*/ hkResult hctParamBlock1Interface::getParameterValue (int index, TimeValue time, ReferenceTarget*& refTargetOut) const
{
    HK_ASSERT_NO_MSG(0x515874de, !"No reference target parameters in pblock1s!");
    return HK_FAILURE;
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
