// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <iFnPub.h>

/*
** C++ Interface to the Collision geometry optimizer Utility.
**
** Exposed to MAXScript as hctCgoUtility
**
** The methods here correspond to the methods and properties (get/set) exposed to MaxScript.
** Those, in turn, correspond to the fields exposed to the 3ds max UI
**
*/

// Class ID
#define HK_CGO_UTILITY_CLASS_ID Class_ID(0x4EAC64CB, 0x4EA84181)

// Reference number of the PBlock
#define PBLOCK_CgoUtility   0

// Param block IDs
enum
{
    PB_CGO_UTILITY_PBLOCK,
};

// Normal Parameters
enum
{
    PA_CGO_UTILITY_MAXERROR,
    PA_CGO_UTILITY_SHRINKING,
    PA_CGO_UTILITY_TARGET_NUM_VERTICES,
    PA_CGO_UTILITY_RETAIN_TARGET_NUM_VERTICES,
    PA_CGO_UTILITY_TARGET_RATIO,
    PA_CGO_UTILITY_RETAIN_TARGET_RATIO,
    PA_CGO_UTILITY_RETAINMENT_TYPE,
    PA_CGO_UTILITY_KEEP_RATIO,
    PA_CGO_UTILITY_PROTECT_MATERIALS,
    PA_CGO_UTILITY_PROTECT_EDGES,
    PA_CGO_UTILITY_USE_WEIGHTS,
    PA_CGO_UTILITY_DELETE_INPUT,
    PA_CGO_UTILITY_MULTIPASS,
};

//
// Function publishing
//

#define HK_CGO_UTILITY_FPINTERFACE_ID Interface_ID(0x62ed5ad2, 0xdf34ffa2)

enum
{
    FPI_CanOptimize,
    FPI_Optimize,
    FPI_GetMaxError,
    FPI_SetMaxError,
    FPI_GetTargetNumVertices,
    FPI_SetTargetNumVertices,
    FPI_GetRetainTargetNumVertices,
    FPI_SetRetainTargetNumVertices,
    FPI_GetTargetRatio,
    FPI_SetTargetRatio,
    FPI_GetRetainTargetRatio,
    FPI_SetRetainTargetRatio,
    FPI_GetRetainmentType,
    FPI_SetRetainmentType,
    FPI_GetKeepRatio,
    FPI_SetKeepRatio,
    FPI_GetShrinking,
    FPI_SetShrinking,
    FPI_GetProtectMaterials,
    FPI_SetProtectMaterials,
    FPI_GetProtectEdges,
    FPI_SetProtectEdges,
    FPI_GetUseWeights,
    FPI_SetUseWeights,
    FPI_GetDeleteInput,
    FPI_SetDeleteInput,
    FPI_GetMultipass,
    FPI_SetMultipass,
};

/// WARNING: This feature is currently in BETA. Changes in interface, behavior or performance may be expected.
class hctCgoUtilityFPInterface : public FPStaticInterface
{
    public:

        virtual BOOL    iCanOptimize() = 0;
        virtual INode*  iOptimize(INode* node) = 0;

        virtual void    iSetMaxError (float value) = 0;
        virtual float   iGetMaxError () = 0;

        virtual void    iSetTargetNumVertices(int value) = 0;
        virtual int     iGetTargetNumVertices() = 0;

        virtual void    iSetRetainTargetNumVertices(bool value) = 0;
        virtual bool    iGetRetainTargetNumVertices() = 0;

        virtual void    iSetTargetRatio(float value) = 0;
        virtual float   iGetTargetRatio() = 0;

        virtual void    iSetRetainTargetRatio(bool value) = 0;
        virtual bool    iGetRetainTargetRatio() = 0;

        virtual void    iSetRetainmentType(int value) = 0;
        virtual int     iGetRetainmentType() = 0;

        virtual void    iSetKeepRatio(bool value) = 0;
        virtual bool    iGetKeepRatio() = 0;

        virtual void    iSetShrinking(float value) = 0;
        virtual float   iGetShrinking() = 0;

        virtual void    iSetProtectMaterials (bool value)=0;
        virtual bool    iGetProtectMaterials ()=0;

        virtual void    iSetProtectEdges (bool value)=0;
        virtual bool    iGetProtectEdges ()=0;

        virtual void    iSetUseWeights (bool value)=0;
        virtual bool    iGetUseWeights ()=0;

        virtual void    iSetDeleteInput (bool value)=0;
        virtual bool    iGetDeleteInput ()=0;

        virtual void    iSetMultipass (bool value)=0;
        virtual bool    iGetMultipass ()=0;
};


//
// Action publishing
//

#define HK_CGO_UTILITY_ACTIONS_ID Interface_ID(0xf1ed017b, 0xca3ad130)

enum
{
    ACT_OptimizeEnabled,
    ACT_Optimize,
};

class hctCgoUtilityActions : public FPStaticInterface
{
    public:

        virtual BOOL        iOptimizeEnabled() = 0;
        virtual FPStatus    iOptimize() = 0;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
