// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <iFnPub.h>

// Class ID
#define HK_CONVEX_DECOMPOSITION_UTILITY_CLASS_ID Class_ID(0x30445f93, 0x245e334a)

/*
** FUNCTION PUBLISHING
*/

#define HK_CONVEX_DECOMPOSITION_UTILITY_FPINTERFACE_ID Interface_ID(0x7d4a26d1, 0x399371a)

enum
{
    FPI_CheckValidity,
    FPI_Decompose,
    FPI_Combine
};

/*
** C++ Interface to the Havok Content Tools Convex Decompostion Utilities
**
** Exposed to MAXScript as hctConvexDecompositionUtilGUP
**
** The methods here correspond to the methods exposed to MaxScript
**
*/
class hctConvexDecompositionUtilGUPInterface : public FPStaticInterface
{
public:
    virtual BOOL iCheckValidity() = 0;
    virtual BOOL iDecompose (Tab<INode*>& nodesIn, Tab<INode*>& nodesOut, BOOL detachParts, BOOL singleOut, double guardTolerance, BOOL hideMesh, INT reduceOverlapPasses, INT octreeDepth, INT method, INT reduceMethod, INT witerations, double wconcavity) = 0;
    virtual BOOL iCombine (INode* baseNode, Tab<INode*>& origMeshNodes, Tab<INode*>& nodesIn, Tab<INode*>& nodesOut, double accuracyCombine, BOOL singleOutCombine, BOOL genGuards, INT octreeDepth, INT reduceMethod ) = 0;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
