// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <iFnPub.h>

// Class ID
#define HK_CONVERSION_UTIL_GUP_CLASS_ID Class_ID(0x5fcd3256, 0x46f60d66)

/*
** FUNCTION PUBLISHING
*/

#define HK_CONVERSION_UTIL_GUP_FPINTERFACE_ID   Interface_ID(0x32881fdd, 0x34e953ee)

enum
{
    FPI_ConvertSelectionToVertexChannel,
    FPI_ConvertVertexChannelToSelection,
    FPI_AssignVertexColors
};

/*
** C++ Interface to the Havok Content Tools Conversion Utilities.
**
** Exposed to MAXScript as hctConversionUtilGUP
**
** The methods here correspond to the methods exposed to MaxScript.
**
*/
class hctConversionUtilGUPInterface : public FPStaticInterface
{
    public:

        virtual void iConvertSelectionToVertexChannel( INode* selectedNode, ReferenceTarget* vpModifier, FLOAT selectedValue, FLOAT unselectedValue ) = 0;
        virtual void iConvertVertexChannelToSelection( INode* selectedNode, ReferenceTarget* vpModifier, FLOAT thresholdValue, BOOL invert, const MCHAR* selectionName ) = 0;
        virtual void iAssignVertexColors( INode* selectedNode, ReferenceTarget* vpModifier, INT channelID, BOOL byVertex ) = 0;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
