// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Common/ViewportUtils/hctviewportutils.h>
#include <ContentTools/Common/ViewportUtils/hctViewportUtilsImpl.h>

void showTool(hctViewportUtilsImpl* filterImpl);

using namespace System;
using namespace System::Windows::Forms;
using namespace Havok;
using namespace Havok::Tool;
using namespace System::Resources;

#pragma unmanaged

#include <ContentTools/Common/Tool/ToolInterfaces/ToolInterfaceMacros.h>

void havokThread( hctViewportUtilsImpl* utils )
{
    hkMemoryRouter mem;
    hkMemorySystem::getInstance().threadInit(mem, "hctViewportUtilsManaged");

    utils->notifyNewThread( &mem); // will call thread init on all dlls appropriately registered (incl this one)

    showTool(utils);
    hkMemorySystem::getInstance().threadQuit(mem);
}

#pragma managed


public ref class MainViewportForm : public Form
{
public:

    MainViewportForm(String^ renderer, int w, int h)
    {
        havokUI = nullptr;
        components = nullptr;

        InitializeComponent(w, h);
        InitializeHavokCtrl(renderer,w, h);

    }

    ~MainViewportForm()
    {
        if (components)
        {
            delete components;

            delete havokUI;
            havokUI = nullptr;
        }
    }

    void Resize(int x, int y)
    {
        this->Size = Drawing::Size(x,y);
    }

    void InitializeHavokCtrl(String^ renderer,int w, int h)
    {
        SuspendLayout();

        IntPtr baseInfo;
        HAVOK_TOOLS_BASE_SYSTEM_GET_INFO(baseInfo);

        havokUI = gcnew Havok::Tool::ToolUI(renderer, baseInfo);
        havokUI->Dock = System::Windows::Forms::DockStyle::Fill;
        havokUI->Location = System::Drawing::Point(0, 0);
        havokUI->Name = "ui";
        havokUI->Size = System::Drawing::Size(w, h);
        havokUI->TabIndex = 0;

        this->Controls->Add(havokUI);

        ResumeLayout(true);
    }

    void MainForm_Shown( Object^ sender, EventArgs^ e )
    {
        havokUI->CloseSplashScreen();
    }

    void InitializeComponent(int w, int h)
    {
        this->FormBorderStyle = System::Windows::Forms::FormBorderStyle::None;
        this->ClientSize = System::Drawing::Size(w, h);
        this->Name = "HavokPreviewWindow";
        this->Text = "";
        this->Shown += gcnew System::EventHandler( this, &MainViewportForm::MainForm_Shown);
    }

public:

    Havok::Tool::ToolUI^ havokUI;
    System::ComponentModel::IContainer^ components;

    static MainViewportForm^ globalLastForm;
};


private ref class PreviewThread
{
public:

    PreviewThread( hctViewportUtilsImpl* utils )
    {
        m_utils = utils;
    }

    void Exec()
    {
        ::havokThread(m_utils);
    }

    hctViewportUtilsImpl* m_utils;
};


void showTool(hctViewportUtilsImpl* utils)
{
    Application::EnableVisualStyles();
    Application::SetCompatibleTextRenderingDefault(false);

    String^ renderer = nullptr;
    int x,y,w,h;
    utils->getDesiredDimensions(x,y,w,h);

    MainViewportForm^ form = gcnew MainViewportForm(renderer, w, h  );
    HWND windowHandle = (HWND) form->Handle.ToPointer();
    SetWindowLong( windowHandle, GWL_STYLE, WS_CHILD | GetWindowLong( windowHandle, GWL_STYLE ) );
    SetParent(windowHandle, (HWND)utils->getParentWindowHandle());
    form->Location = System::Drawing::Point(x,y);
    form->Update();

    MainViewportForm::globalLastForm = form; //XXX change to a map etc (Like the managed filter preview 'active' list)

    utils->setWindowHandle( (void*)windowHandle );

    form->Show();

    Application::Run(form);

    MainViewportForm::globalLastForm = nullptr;

}

void startViewport(hctViewportUtilsImpl* utils )
{
    // Create preview thread:
    // easier to make it a managed thread, that way the COM opartment model etc will be correct

    PreviewThread^ previewThread = gcnew PreviewThread( utils );
    System::Threading::ThreadStart^ theThreadStarter = gcnew System::Threading::ThreadStart(previewThread, &PreviewThread::Exec);
    System::Threading::Thread^ pThread = gcnew System::Threading::Thread(theThreadStarter);
    pThread->SetApartmentState( System::Threading::ApartmentState::STA );// The magic sauce to make sure that the DragNDrop etc work (requires COM calls etc from the Windows Forms).
    pThread->Start();
}

void endViewport(hctViewportUtilsImpl* utils )
{
    CloseWindow((HWND)utils->getWindowHandle());
}

public delegate void resizeDelegate( int x, int y );

void resizeViewport( hctViewportUtilsImpl* utils, int x, int y )
{
    if (MainViewportForm::globalLastForm != nullptr)
    {
        MainViewportForm^ f = MainViewportForm::globalLastForm;
        f->Invoke( gcnew resizeDelegate( f, &MainViewportForm::Resize ), x, y);
    }
}

void updateScene( hctViewportUtilsImpl* utils, hkRootLevelContainer* scene )
{
    // Make a delegate to do the update in the destination thread:
    //   public void SetContentsFromMemory(IntPtr root /* hkRootLevelContainer* */ , bool drag, Int32 x, Int32 y, IntPtr vtableReg)
    if (MainViewportForm::globalLastForm != nullptr)
    {
        HK_ASSERT_NO_MSG(0x783e78f2, 0); // todo.nt4
        MainViewportForm^ f = MainViewportForm::globalLastForm;
        f->havokUI->Invoke( gcnew setContentsFromMemoryDelegate( f->havokUI, &Havok::Tool::ToolUI::SetContentsFromMemory ), IntPtr( scene ), IntPtr(HK_NULL), true, false ); // todo.nt4
    }
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
