// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#pragma managed(push, off)

#ifndef _WIN32_WINNT
#define _WIN32_WINNT 0x0500     // win2000
#endif

#ifndef WINVER
#define WINVER 0x0500
#endif

#if (_MSC_VER >= 1400)
#   define _CRT_SECURE_NO_DEPRECATE 1
#   define _CRT_NONSTDC_NO_DEPRECATE 1
#endif

//#define WIN32_LEAN_AND_MEAN

#include <windows.h>
#include <commctrl.h>



#include <ContentTools/Common/ViewportUtils/hctviewportutils.h>
#include <ContentTools/Common/SceneExport/Filters/hctFilterProcessingUtil.h>

class hkRootLevelContainer;
class hkMemoryMeshSystem;

class hctViewportUtilsImpl : public hctViewportUtils
{
    public:

        hctViewportUtilsImpl();
        virtual ~hctViewportUtilsImpl();

        virtual void setFilterManagerPath( const char* path );

        virtual void registerThreadCallback (const class hctFilterThreadCallback* cb);

        virtual void* createPreviewWindow( void* parentWindowHandle, int x, int y, int w, int h  );
        virtual void resizeWindow( int w, int h );
        virtual void destroyPreviewWindow( void* windowHandle );

        virtual void updateScene( hkRootLevelContainer* newScene );
        virtual void filterAndUpdateScene( hkRootLevelContainer* rawScene, char* filterOptions, int filterOptionsSize );


    public:

        void notifyNewThread(hkMemoryRouter* t);

        void startFilterManager();
        void endFilterManager();

        const char* getFilterManagerPath() const;
        hctFilterManagerInterface* getFilterManager() { return m_filters.getFilterManagerInterface(); }

        void setWindowHandle( void* h ) { m_windowHandle = h; }
        void* getWindowHandle() const { return (void*)m_windowHandle; }

        void* getParentWindowHandle() const { return m_parentWindowHandle; }

        void getDesiredDimensions( int& x, int& y, int& w, int&h ) const { x=m_startX; y=m_startY; w=m_startW; h=m_startH; }

    protected:

        hkStringOld m_filterManagerPath;
        hctFilterProcessingUtil m_filters;
        const class hctFilterThreadCallback* m_threadCallback;

        volatile void* m_windowHandle;
        void* m_parentWindowHandle;

        int m_startX;
        int m_startY;
        int m_startW;
        int m_startH;

        bool m_registeredDllThreadCallback;

};

__declspec(dllexport) class hctBaseDll* HK_CALL getBaseDllInterface();
__declspec(dllexport) hctViewportUtils* HK_CALL getViewportUtilInterface();
__declspec(dllexport) hctViewportUtils::DllError HK_CALL getViewportDllError();

#pragma managed(pop)

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
