// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Common/ViewportUtils/hctviewportutils.h>
#include <ContentTools/Common/ViewportUtils/hctViewportUtilsImpl.h>
#include <Common/Base/Serialize/Resource/hkResource.h>


void startViewport(hctViewportUtilsImpl* utils);
void updateScene( hctViewportUtilsImpl* utils, hkRootLevelContainer* scene );
void resizeViewport( hctViewportUtilsImpl* utils, int x, int y);
void endViewport(hctViewportUtilsImpl* utils );


#pragma unmanaged

#include <ContentTools/Common/Filters/Common/hctBaseDll.h>
#include <ContentTools/Common/Filters/Common/FilterManager/hctFilterManagerInterface.h>

#include <ContentTools/Common/SceneExport/Memory/hctSceneExportMemory.h>

#include <Common/SceneData/Scene/hkxScene.h>
#include <Common/Serialize/Util/hkRootLevelContainer.h>

#include <Common/Base/System/Io/IStream/hkIStream.h>
#include <Common/Base/System/Io/Reader/hkStreamReader.h>

extern HINSTANCE hInstance;

static hctViewportUtils::DllError HK_dll_status = hctViewportUtils::DLL_INIT_ERROR;

hctBaseDll* HK_CALL getBaseDllInterface()
{
    return new hctBaseDll(hInstance); // no need to sub class as it has everything we need already
}

hctViewportUtils* HK_CALL getViewportUtilInterface()
{
    return new hctViewportUtilsImpl();
}

hctViewportUtils::DllError HK_CALL getViewportDllError()
{
    return HK_dll_status;
}

hctViewportUtilsImpl::hctViewportUtilsImpl()
{

#ifdef HK_PLATFORM_WIN64
    bool try64bit = true;
#else
    bool try64bit = false;
#endif

    const char* keyPath;
    if (try64bit)
        keyPath = "Software\\Havok\\ViewportUtils_x64";
    else
        keyPath = "Software\\Havok\\ViewportUtils";

    HKEY registryKey;
    RegCreateKeyExA( HKEY_CURRENT_USER, keyPath, 0, NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &registryKey, NULL);

//  char str[4096];
//  DWORD strSize = 4096;
//  DWORD byteSize = 1;

    //if ( RegQueryValueEx( registryKey, "InitSettingsFile", NULL, NULL, (LPBYTE)str, &strSize ) == ERROR_SUCCESS )

    RegCloseKey(registryKey);

    m_registeredDllThreadCallback = false;

    m_startX = 0;
    m_startY = 0;
    m_startW = 64;
    m_startH = 64;

}

hctViewportUtilsImpl::~hctViewportUtilsImpl()
{
    if (0)
    {
#ifdef HK_PLATFORM_WIN64
        bool try64bit = true;
#else
        bool try64bit = false;
#endif
        const char* keyPath;
        if (try64bit)
            keyPath = "Software\\Havok\\ViewportUtils_x64";
        else
            keyPath = "Software\\Havok\\ViewportUtils";

        HKEY registryKey;
        RegCreateKeyExA( HKEY_CURRENT_USER, keyPath, 0, NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &registryKey, NULL);
//      RegSetValueEx( registryKey, "EnableNodeReparenting", NULL, REG_BINARY, &enableNodeReparenting, sizeof(hkUint8));
        RegCloseKey(registryKey);
    }

    endFilterManager();
}

void hctViewportUtilsImpl::setFilterManagerPath( const char* path )
{
    m_filterManagerPath = path;
}

const char* hctViewportUtilsImpl::getFilterManagerPath() const
{
    return m_filterManagerPath.cString();
}

void hctViewportUtilsImpl::startFilterManager()
{
    if (!m_filters.getFilterManagerInterface())
    {
        m_filters.load( m_filterManagerPath.cString() );
    }

    if (!m_registeredDllThreadCallback)
    {
        // This DLLs default thread callback
        m_filters.getFilterManagerInterface()->registerThreadCallback( hctFilterProcessingUtil::getDefaultThreadCallback() );

        // user / owner DLL
        if (m_threadCallback)
        {
            m_filters.getFilterManagerInterface()->registerThreadCallback( m_threadCallback );
        }

        m_registeredDllThreadCallback = true;
    }
}

void hctViewportUtilsImpl::endFilterManager()
{
    if (m_filters.getFilterManagerInterface())
    {
        m_filters.unload( );
    }

    m_registeredDllThreadCallback = false;
}


void hctViewportUtilsImpl::registerThreadCallback (const class hctFilterThreadCallback* cb)
{
    m_threadCallback = cb;
    if (m_filters.getFilterManagerInterface())
    {
        m_filters.getFilterManagerInterface()->registerThreadCallback( m_threadCallback );
    }
}

void hctViewportUtilsImpl::notifyNewThread(hkMemoryRouter* r)
{
    // owner
    if (m_threadCallback)
    {
        m_threadCallback->newThreadCreated(r);
    }

    // us
    hctFilterProcessingUtil::getDefaultThreadCallback()->newThreadCreated(r);
}

void hctViewportUtilsImpl::filterAndUpdateScene(hkRootLevelContainer* rawScene, char* filterOptions, int filterOptionsSize )
{
    startFilterManager();

    m_filters.setOptions( filterOptions, filterOptionsSize );

    hkResource* tracker = HK_NULL;
    hkRootLevelContainer* newScene = m_filters.processBatchReturnData( *rawScene, 0 /*(config)*/, false, tracker);
    updateScene(newScene);

    if (tracker)
        tracker->removeReference();

    endFilterManager();
}

void* hctViewportUtilsImpl::createPreviewWindow( void* parentWindowHandle, int x, int y, int w, int h  )
{
    m_parentWindowHandle = parentWindowHandle;
    m_startX = x;
    m_startY = y;
    m_startW = w;
    m_startH = h;

    startViewport(this);

    while (!m_windowHandle) Sleep(0); //XXX make a proper section and map etc

    m_filters.setOwnerHandle( (void*)m_windowHandle );

    return (void*)m_windowHandle;
}

void hctViewportUtilsImpl::resizeWindow( int w, int h )
{
    resizeViewport(this, w,h);
}

void hctViewportUtilsImpl::destroyPreviewWindow( void* windowHandle )
{
    endViewport(this);

    m_windowHandle = HK_NULL;
    m_parentWindowHandle = HK_NULL;
}

void hctViewportUtilsImpl::updateScene( hkRootLevelContainer* newScene )
{
    startFilterManager();

    if (m_windowHandle)
    {
        ::updateScene(this, newScene);
    }

    // We have to unload the filter manager as the
    // base system in say the normal export DLE is different
    // so filter init will fail otherwise.
    endFilterManager();
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
