// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64 !REFLECT
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

/// This links the Managed Graphics assembly with the unmanaged hkVisualize debug display
using namespace Havok::Graphics;
using namespace System;
class hkgDisplayHandler;
class hkServerObjectSerializer;
class hkVisualDebugger;
class hkProcess;

namespace Havok
{
    namespace Graphics
    {
        public ref class GraphicsBridgeBaseSystem : public Havok::Tool::IBaseSystem
        {
            public:

                virtual void initBaseSystem(IntPtr info, System::IntPtr graphicsInfo);
                virtual void pushErrorHandler(System::IntPtr error);
                virtual void popErrorHandler();
                virtual void getVersionInfo(System::String^% interfaceVersion, System::String^% havokSdkVersion );
                virtual void quitBaseSystem();
        };

        struct GraphicsBridgeImpl;

        public ref class GraphicsBridge
        {
            public:

                GraphicsBridge( hkgDisplayWorldCLR^ world, hkgDisplayContextCLR^ ctx, hkgWindowCLR^ window );
                ~GraphicsBridge();

                void init( bool runVdbServer );
                void init( IntPtr ctx, IntPtr processFactory, bool runVdbServer, array< String^ >^ viewerNames );
                void init( array< IntPtr >^ ctxs, IntPtr processFactory, bool runVdbServer, array< String^ >^ viewerNames );
                void quit();

                void addViewers( array< String^ >^ viewerNames);
                void removeViewers( array< String^ >^ viewerNames);

                void step( float dt );
                void renderImmediate();
                void clearImmediate();

                hkgDisplayWorldCLR^ m_world;
                hkgDisplayContextCLR^ m_context;
                hkgWindowCLR^ m_window;

                IntPtr getInternalPtr();//returns:  hkDebugDisplayHandler*  (hkgDisplayHandler*)

            internal:

                hkgDisplayHandler* m_debugDisplay;
                hkServerObjectSerializer* m_vdbObjectSerializer;

                GraphicsBridgeImpl* m_impl;

        };
    }
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
