// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma unmanaged

#define HK_EXCLUDE_FEATURE_RegisterReflectedClasses
#define HK_EXCLUDE_FEATURE_DestructionRuntime
#define HK_EXCLUDE_FEATURE_NewDestructionRuntime
#define HK_EXCLUDE_FEATURE_hkndAssetProcessing
#define HK_EXCLUDE_FEATURE_hkndDebrisFracture_execute
#define HK_EXCLUDE_FEATURE_hkndParticleEffectFracture_execute
#include <Common/Base/hkBase.h>
#include <Common/Base/Config/hkProductFeaturesNoPatchesOrCompat.h>
#include <Common/Base/Config/hkProductFeatures.cxx>

#pragma managed

#include <Util/GraphicsBridge/hctManagedGraphicsBridge.h>

#pragma unmanaged

#include <ToolInterfaces/ToolInterfaceMacros.h>
#include <ToolInterfaces/ToolInterfacesVersion.h>

#include <Graphics/Bridge/hkGraphicsBridge.h>
#include <Graphics/Bridge/DisplayHandler/hkgDisplayHandler.h>


#include <Common/Visualize/hkProcess.h>
#include <Common/Visualize/hkProcessRegisterUtil.h>
#include <Common/Visualize/hkVisualDebugger.h>
#include <Common/Visualize/hkProcessFactory.h>
#include <Common/Visualize/Process/hkDebugDisplayProcess.h>
#include <Common/Visualize/hkServerObjectHandler.h>

//#include <Physics2012/Utilities/VisualDebugger/Viewer/Collide/hkpShapeDisplayViewer.h>
//#include <Physics2012/Utilities/VisualDebugger/Viewer/Dynamics/hkpPhantomDisplayViewer.h>
//#include <Physics2012/Utilities/VisualDebugger/hkpPhysicsContext.h>
//#include <Physics2012/Dynamics/World/hkpWorld.h>

#include <Common/Base/keycode.cxx>

#include <Graphics/Common/Window/hkgWindow.h>
#include <Graphics/Common/DisplayWorld/hkgDisplayWorld.h>
#include <Graphics/Common/hkgSystemFunctions.h>
#include <Common/Base/Thread/CriticalSection/hkCriticalSection.h>
#include <Common/Base/Config/hkConfigVersion.h>

#include <Common/Base/Fwd/hkwindows.h>

HAVOK_TOOLS_BASE_SYSTEM_DLL_MAIN_DECL

#pragma managed

using namespace System;
using namespace System::Runtime::InteropServices;
using namespace Havok;
using namespace Havok::Graphics;

void GraphicsBridgeBaseSystem::initBaseSystem(System::IntPtr info, System::IntPtr graphicsInfo)
{
    HAVOK_TOOLS_BASE_SYSTEM_LOCK();

    HAVOK_TOOLS_BASE_SYSTEM_INIT( (hkMemoryInitUtil::SyncInfo*)info.ToPointer() );

    if (graphicsInfo.ToPointer())
    {
        hkgSystemSetCreateFunctions(*(hkgSystemCreateFuncs*)graphicsInfo.ToPointer());
    }

    HAVOK_TOOLS_BASE_SYSTEM_UNLOCK();

}

void GraphicsBridgeBaseSystem::pushErrorHandler(System::IntPtr error)
{
    HAVOK_TOOLS_BASE_SYSTEM_LOCK();
    HAVOK_TOOLS_BASE_SYSTEM_PUSH_ERROR(error);
    HAVOK_TOOLS_BASE_SYSTEM_UNLOCK();
}

void GraphicsBridgeBaseSystem::popErrorHandler()
{
    HAVOK_TOOLS_BASE_SYSTEM_LOCK();
    HAVOK_TOOLS_BASE_SYSTEM_POP_ERROR(error);
    HAVOK_TOOLS_BASE_SYSTEM_UNLOCK();
}

void GraphicsBridgeBaseSystem::getVersionInfo( System::String^% interfaceVersion, System::String^% havokSdkVersion )
{
    interfaceVersion = HCT_TOOL_INTERFACE_VERSION;
    havokSdkVersion = HAVOK_SDK_VERSION_STRING;
}

void GraphicsBridgeBaseSystem::quitBaseSystem()
{
    HAVOK_TOOLS_BASE_SYSTEM_LOCK();

    HAVOK_TOOLS_BASE_SYSTEM_QUIT();

    HAVOK_TOOLS_BASE_SYSTEM_UNLOCK();
}

struct Havok::Graphics::GraphicsBridgeImpl
{
    public:

        GraphicsBridgeImpl();
        ~GraphicsBridgeImpl();

        void quit();

        hkArray<hkProcessContext*> m_vdbContexts;   // not owned

        hkRefPtr<hkVisualDebugger> m_vdb;
        void* m_vdbClassReg;

        hkArray<hkProcess*> m_localProcesses;
        hkProcess* m_debugDisplayProcess;
};

GraphicsBridgeImpl::GraphicsBridgeImpl()
{
    m_vdbClassReg = HK_NULL;
    m_debugDisplayProcess = HK_NULL;
}

void GraphicsBridgeImpl::quit()
{
    m_vdb = HK_NULL;

    for (int p=0; p < m_localProcesses.getSize(); ++p)
    {
        delete m_localProcesses[p];
    }
    m_localProcesses.setSize(0);

    if (m_debugDisplayProcess) delete m_debugDisplayProcess;

    m_vdbContexts.setSize(0);
    m_debugDisplayProcess = HK_NULL;
}


GraphicsBridgeImpl::~GraphicsBridgeImpl()
{
    quit();
}

GraphicsBridge::GraphicsBridge( hkgDisplayWorldCLR^ world, hkgDisplayContextCLR^ ctx, hkgWindowCLR^ window )
{
    //
    m_world = world;
    m_context = ctx;
    m_window = window;

    m_impl = new GraphicsBridgeImpl();

    // Can reuse the normal display handler:
    m_debugDisplay = new hkgDisplayHandler(
        (hkgDisplayWorld*)(world->getInternalPtr().ToPointer()),
        (hkgDisplayContext*)(ctx->getInternalPtr().ToPointer()),
        (hkgWindow*)(window->getInternalPtr().ToPointer()) );

     m_vdbObjectSerializer = new hkServerObjectSerializer( HK_NULL, HK_NULL );
}


void GraphicsBridge::init( array< System::IntPtr >^ ctxs, System::IntPtr processFactory, bool runVdbServer, array< String^ >^ viewerNames )
{
    hkProcessFactory* factory = (hkProcessFactory*)( processFactory.ToPointer() );
    if (factory && (factory != &hkProcessFactory::getInstance()) )
    {
        factory->addReference();
        hkProcessFactory::replaceInstance( factory );
    }

    m_impl->m_vdbContexts.setSize(0);
    for (int ci =0; ci < ctxs->Length; ++ci)
    {
        hkProcessContext* vdbContext = (hkProcessContext*)( ctxs[ci].ToPointer() );
        if (vdbContext)
        {
            m_impl->m_vdbContexts.pushBack( vdbContext );
        }
    }

    hkArray<const char*> debugViewerNames;
    for (int vi=0; (viewerNames!=nullptr) && (vi < viewerNames->Length); ++vi )
    {
        const char* name = (char*)Marshal::StringToHGlobalAnsi( viewerNames[vi] ).ToPointer();
        debugViewerNames.pushBack( name );
    }

    if (debugViewerNames.getSize() < 1)
    {
        debugViewerNames.pushBack( hkDebugDisplayProcess::getName() );
    }

    for (int dvi=0; dvi < debugViewerNames.getSize(); ++dvi)
    {
        hkProcess* p = hkProcessFactory::getInstance().createProcess( debugViewerNames[dvi], m_impl->m_vdbContexts );
        if (p)
        {
            p->m_displayHandler = m_debugDisplay;
            p->init();
            m_impl->m_localProcesses.pushBack(p); // so we can delete them later one
        }
    }
    for (int vii=0; vii < viewerNames->Length; ++vii )
    {
        Marshal::FreeHGlobal( System::IntPtr( (void*)debugViewerNames[vii] ) );
    }

    if( runVdbServer )
    {
        //XXX m_impl->m_vdbClassReg = &hkVtableClassRegistry::getInstance();
        //XXX m_impl->m_vdbClassReg->registerList(hkBuiltinTypeRegistry::StaticLinkedTypeInfos, hkBuiltinTypeRegistry::StaticLinkedClasses);

        m_impl->m_vdb = hkRefNew<hkVisualDebugger>( new hkVisualDebugger(m_impl->m_vdbContexts, m_impl->m_vdbClassReg ) );
        m_impl->m_vdb->serve(HK_VISUAL_DEBUGGER_DEFAULT_PORT + 1);
    }
}

void GraphicsBridge::init( System::IntPtr ctx, System::IntPtr processFactory, bool runVdbServer, array< String^ >^ viewerNames )
{
    array< IntPtr >^ ctxs = { ctx };
    init( ctxs, processFactory, runVdbServer, viewerNames );
}

void GraphicsBridge::init(bool runVdbServer)
{
    init( IntPtr(0), IntPtr(0), runVdbServer, nullptr);
}

void GraphicsBridge::addViewers( array< String^ >^ viewerNames )
{
    hkArray<const char*> debugViewerNames;
    for (int vi=0; (viewerNames!=nullptr) && (vi < viewerNames->Length); ++vi )
    {
        const char* name = (char*)Marshal::StringToHGlobalAnsi( viewerNames[vi] ).ToPointer();
        debugViewerNames.pushBack( name );
    }

    for (int dvi=0; dvi < debugViewerNames.getSize(); ++dvi)
    {
        hkProcess* p = hkProcessFactory::getInstance().createProcess( debugViewerNames[dvi], m_impl->m_vdbContexts );
        if (p)
        {
            p->m_displayHandler = m_debugDisplay;
            p->m_objectHandler = hkRefNew<hkServerObjectHandler>( new hkServerObjectHandler( *m_vdbObjectSerializer ) );
            p->init();
            m_impl->m_localProcesses.pushBack(p); // so we can delete them later on
        }
    }
    for (int vii=0; vii < viewerNames->Length; ++vii )
    {
        Marshal::FreeHGlobal( System::IntPtr( (void*)debugViewerNames[vii] ) );
    }
}

void GraphicsBridge::removeViewers( array< String^ >^ viewerNames )
{
    hkArray<const char*> debugViewerNames;
    for (int vi=0; (viewerNames!=nullptr) && (vi < viewerNames->Length); ++vi )
    {
        const char* name = (char*)Marshal::StringToHGlobalAnsi( viewerNames[vi] ).ToPointer();
        debugViewerNames.pushBack( name );
    }

    for (int dvi=0; dvi < debugViewerNames.getSize(); ++dvi)
    {
        int viewerId = hkProcessFactory::getInstance().getProcessTag(debugViewerNames[dvi]);
        for (int p=0; p<m_impl->m_localProcesses.getSize(); ++p)
        {
            hkProcess* proc = m_impl->m_localProcesses[p];
            if (proc->getProcessTag() == viewerId)
            {
                delete proc;
                m_impl->m_localProcesses.removeAt(p);
                break;
            }
        }
    }
    for (int vii=0; vii < viewerNames->Length; ++vii )
    {
        Marshal::FreeHGlobal( System::IntPtr( (void*)debugViewerNames[vii] ) );
    }
}


void GraphicsBridge::renderImmediate()
{
    if (m_debugDisplay)
    {
        m_debugDisplay->drawImmediate();
    }
}

void GraphicsBridge::clearImmediate()
{
    if (m_debugDisplay)
    {
        m_debugDisplay->clearImmediate();
    }
}

#pragma unmanaged
static void _updateCamera( hkgCamera* c )
{
    float floatFrom[3]; c->getFrom(floatFrom);
    float floatTo[3]; c->getTo(floatTo);
    float floatUp[3]; c->getUp(floatUp);

    hkVector4 from; from.set( floatFrom[0], floatFrom[1], floatFrom[2] );
    hkVector4 to;   to.set( floatTo[0], floatTo[1], floatTo[2] );
    hkVector4 up;   up.set( floatUp[0], floatUp[1], floatUp[2] );

    HK_UPDATE_CAMERA(from, to, up, c->getNear(), c->getFar(), c->getFOV(), "PreviewTool");
}
#pragma managed
void GraphicsBridge::step(float dt)
{
    // VDB:
    if (m_impl && m_impl->m_vdb)
    {
        hkgWindow* w = (hkgWindow*) m_window->getInternalPtr().ToPointer();
        hkgCamera* c = w->getCurrentViewport()->getCamera();
        _updateCamera(c);

        m_impl->m_vdb->step(dt * 1000.0f); // dt is in secs, vdb step takes ms
    }
}

System::IntPtr GraphicsBridge::getInternalPtr()
{
    return System::IntPtr(m_debugDisplay);
}

void GraphicsBridge::quit()
{
    if (m_impl) m_impl->quit();
}

GraphicsBridge::~GraphicsBridge()
{
    quit();
    if (m_debugDisplay) m_debugDisplay->removeReference();
    if (m_impl) delete m_impl;
    delete m_vdbObjectSerializer;
}

#pragma unmanaged

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
