// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Win32;


namespace Havok.Tool.UI
{
    static class ToolUISettings
    {
        public static void saveValue(String propertyName, System.Object propValue)
        {
            String key = (m_root + m_folder);
            RegistryKey subKey = Registry.CurrentUser.CreateSubKey(key, RegistryKeyPermissionCheck.ReadWriteSubTree);
            if ( subKey != null )
            {
                subKey.SetValue(propertyName, propValue);
            }
        }

        public static System.Object loadValue(String propertyName)
        {
            return loadValue(propertyName, null);
        }

        public static System.Object loadValue(String propertyName, System.Object propDefaultValue)
        {
            String key = (m_root + m_folder);
            RegistryKey subKey = Registry.CurrentUser.OpenSubKey(key);
            System.Object res = null;
            if (subKey != null)
            {
                res = subKey.GetValue(propertyName, propDefaultValue);
            }

            return (res != null) ? res : propDefaultValue;
        }

        public static void deleteValue(String propertyName)
        {
            String key = (m_root + m_folder);

            RegistryKey rk = Registry.CurrentUser.OpenSubKey(key, true);

            if (!key.EndsWith("\\"))
            {
                key += "\\";
            }

            if (rk != null)
            {
                Registry.CurrentUser.DeleteValue(key + propertyName);
            }
        }

        public static void deleteCurrentFolder()
        {
            String key = (m_root + m_folder);
            RegistryKey rk = Registry.CurrentUser.OpenSubKey(key, true);

            if (rk != null)
            {
                Registry.CurrentUser.DeleteSubKeyTree(key);
            }
        }

        public static void setRoot(String newRoot)
        {
            m_root = newRoot;
        }

        public static void setFolder(String folder)
        {
            m_folder = folder;

            if (!m_root.EndsWith("\\"))
            {
                m_folder = "\\" + m_folder;
            }
        }


        private static String m_root = "Software\\Havok\\ManagedTools";
        private static String m_folder = "";
    }
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
