﻿ // TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

using System;
using System.Collections.Generic;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using System.Net.Sockets;
using Microsoft.Win32;
using System.Runtime.InteropServices;

using Havok.Graphics;
using Havok.Tool.UI;


namespace Havok.Tool
{
    partial class ToolUI
    {
        private void toggleFollowCam(Boolean on)
        {
            m_graphicsCtrl.m_followCamActive = on;
            followCamToolStripButton.Checked = on;
            followCamToolStripMenuItem.Checked = on;
        }

        void enableEdgedFacesMode(bool enable)
        {
            int vi = m_graphicsCtrl.m_windowHKG.getCurrentViewportIndex();
            m_graphicsCtrl.m_viewportOptions[vi].m_displayEdgedFaces = enable;
        }

        private Boolean isUsingLeftHandedCoords()
        {
            hkgViewportCLR v = m_graphicsCtrl.m_windowHKG.getCurrentViewport();
            hkgCameraCLR c = v.getCamera();
            Boolean isLeft = c.getHandednessMode() == hkgCameraCLR.HandednessMode.LEFT;
            c.Dispose();
            v.Dispose();
            return isLeft;
        }

        private void toggleLeftHandedCoords(Boolean on)
        {
            // applies to all viewports
            for (int vi = 0; vi < m_graphicsCtrl.m_windowHKG.getNumViewports(); ++vi)
            {
                hkgViewportCLR v = m_graphicsCtrl.m_windowHKG.getViewport(vi);
                hkgCameraCLR c = v.getCamera();

                hkgCameraCLR.HandednessMode prevHandedness = c.getHandednessMode();
                hkgCameraCLR.HandednessMode newHandedness = on ? hkgCameraCLR.HandednessMode.LEFT : hkgCameraCLR.HandednessMode.RIGHT;
                c.setHandednessMode(newHandedness);

                if (newHandedness != prevHandedness)
                {
                    hkgDisplayContextCLR context = m_graphicsCtrl.m_windowHKG.getContext();
                    context.lockContext();
                    hkgDisplayContextCLR.CullFaceMode sm = v.getDesiredCullFaceMode();
                    v.setDesiredCullFaceMode(sm == hkgDisplayContextCLR.CullFaceMode.CCW ? hkgDisplayContextCLR.CullFaceMode.CW : hkgDisplayContextCLR.CullFaceMode.CCW);
                    context.unlockContext();
                    context.Dispose();
                }

                c.Dispose();
                v.Dispose();
            }
            
            clearCachedViewports();

        }

        public void clearCachedViewports()
        {
            if (m_cachedViewports != null)
            {
                for (int vi = m_cachedViewports.Count - 1; vi >= 0; --vi)
                {
                    hkgViewportCLR v = (hkgViewportCLR)m_cachedViewports[vi];
                    m_cachedViewports.RemoveAt(vi);
                    v.Dispose(); // force dispose
                }
            }
        }


        public void setNumViewports(int i)
        {
            int numCurrent = m_graphicsCtrl.m_windowHKG.getNumViewports();
            if (numCurrent == i)
                return;

            // remove any we don't neeed (but cache them so we can add them again if we choose later)
            for (int ii = (numCurrent - 1); ii >= i; --ii)
            {
                if (m_cachedViewports == null)
                {
                    m_cachedViewports = new ArrayList();
                }

                m_cachedViewports.Add(m_graphicsCtrl.m_windowHKG.removeViewport(ii));
            }

            // add any we don't have
            hkgViewportCLR v0 = m_graphicsCtrl.m_windowHKG.getViewport(0);
            for (int ij = numCurrent; ij < i; ++ij)
            {
                hkgViewportCLR v;
                if ((m_cachedViewports != null) && (m_cachedViewports.Count > 0))
                {
                    v = (hkgViewportCLR)m_cachedViewports[0];
                    m_cachedViewports.RemoveAt(0);
                }
                else
                {
                    v = v0.copy(m_graphicsCtrl.m_windowHKG);
                }
                m_graphicsCtrl.m_windowHKG.addViewport(v);
                v.Dispose(); // get rid of clr wrapper
            }

            // resize all to fit together
            if (i == 1)
            {
                v0.setExtentsRelative(0, 0, 1, 1);
                m_graphicsCtrl.m_windowHKG.setWantViewportBorders(false);
                m_graphicsCtrl.m_windowHKG.setWantViewportResizeByMouse(false);
            }
            else
            {
                m_graphicsCtrl.m_windowHKG.setWantViewportBorders(true);
                m_graphicsCtrl.m_windowHKG.setWantViewportResizeByMouse(true);

                hkgViewportCLR v1 = m_graphicsCtrl.m_windowHKG.getViewport(1);
                if (i == 2)
                {
                    v0.setExtentsRelative(0, 0, 0.5f, 1);
                    v1.setExtentsRelative(0.5f, 0, 1, 1);
                }
                else // 4
                {
                    hkgViewportCLR v2 = m_graphicsCtrl.m_windowHKG.getViewport(2);
                    hkgViewportCLR v3 = m_graphicsCtrl.m_windowHKG.getViewport(3);
                    v0.setExtentsRelative(0, 0, 0.5f, 0.5f);
                    v1.setExtentsRelative(0, 0.5f, 0.5f, 1.0f);
                    v2.setExtentsRelative(0.5f, 0.5f, 1, 1);
                    v3.setExtentsRelative(0.5f, 0, 1, 0.5f);

                    v2.Dispose();
                    v3.Dispose();
                }
                v1.Dispose();
            }
            v0.Dispose();
        }

        public void reflectViewportSettings()
        {
            // Camera and some render state are per viewport
            using (hkgViewportCLR v = m_graphicsCtrl.m_windowHKG.getCurrentViewport())
            {
                int curViewIndex = m_graphicsCtrl.m_windowHKG.getCurrentViewportIndex();
                GraphicsControl.ViewportOptions viewOptions = m_graphicsCtrl.m_viewportOptions[curViewIndex];

                // Lights are across all views (exept flash which is per view, but a global settting on/off at the moment)
                // Fly / Trackball camera
                bool flymode = v.getNavigationMode() == hkgViewportCLR.CameraNavigationMode.FLY;
                hkgViewportCLR.MouseConvention mc = v.getMouseConvention();
                toolStripFlyModeButton.Checked = flymode;
                toolStripFirstPersonButton.Checked = false;
                toolStripTrackBallButton.Checked = !flymode;
                flyModeToolStripMenuItem.Checked = flymode;
                mayaTrackballModeToolStripMenuItem.Checked = !flymode && (v.getMouseConvention() == hkgViewportCLR.MouseConvention.MAYA);
                maxTrackballModeToolStripMenuItem.Checked = !flymode && (v.getMouseConvention() == hkgViewportCLR.MouseConvention.MAX);

                using (hkgCameraCLR c = v.getCamera())
                {
                    leftHandedSystemToolStripMenuItem.Checked = c.getHandednessMode() == hkgCameraCLR.HandednessMode.LEFT;
                }

                // Render state
                hkgDisplayContextCLR.EnabledState es = v.getDesiredState();
                hkgDisplayContextCLR.CullFaceMode cm = v.getDesiredCullFaceMode();

                texturesToolStripMenuItem.Checked = (es & hkgDisplayContextCLR.EnabledState.MATERIALOVERRIDE) == 0;
                wireframeToolStripMenuItem.Checked = (es & hkgDisplayContextCLR.EnabledState.WIREFRAME) != 0;
                lightsToolStripMenuItem.Checked = (es & hkgDisplayContextCLR.EnabledState.LIGHTING) != 0;
                noneToolStripMenuItem.Checked = (es & hkgDisplayContextCLR.EnabledState.CULLFACE) == 0;
                cWToolStripMenuItem.Checked = (!noneToolStripMenuItem.Checked) && (cm == hkgDisplayContextCLR.CullFaceMode.CW);
                cCWToolStripMenuItem.Checked = (!noneToolStripMenuItem.Checked) && (cm == hkgDisplayContextCLR.CullFaceMode.CCW);

                // View options not in state above
                shadowsToolStripMenuItem.Checked = viewOptions.m_shadowsEnabled;
                edgedFacesToolStripMenuItem.Checked = viewOptions.m_displayEdgedFaces;
                displayNormalsToolStripMenuItem.Checked = viewOptions.m_displayNormals;
                displayTangentsToolStripMenuItem.Checked = viewOptions.m_displayTangents;
                displayBiTangentsToolStripMenuItem.Checked = viewOptions.m_displayBiTangents;
            }
        }
    }
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
