﻿ // TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

using System;
using System.Collections.Generic;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using System.Net.Sockets;
using Microsoft.Win32;
using System.Runtime.InteropServices;

using Havok.Graphics;
using Havok.Tool.UI;


namespace Havok.Tool
{
    partial class ToolUI
    {
        // Save user settings

        void saveViewPreferences(hkgViewportCLR v, int viewportIndex)
        {
            // Camera settings
            // Save camera mode
            string viewString = viewportIndex > 0 ? viewportIndex.ToString() : "";
            GraphicsControl.ViewportOptions viewOptions = m_graphicsCtrl.m_viewportOptions[viewportIndex];

            hkgDisplayContextCLR.EnabledState es = v.getDesiredState();
            hkgViewportCLR.CameraNavigationMode cm = v.getNavigationMode();
            bool hasTextures = (es & hkgDisplayContextCLR.EnabledState.MATERIALOVERRIDE) == 0;

            if (cm == hkgViewportCLR.CameraNavigationMode.FLY)
            {
                ToolUISettings.saveValue("cameraMode" + viewString, "fly");
            }
            else
            {
                if (v.getMouseConvention() == hkgViewportCLR.MouseConvention.MAYA)
                {
                    ToolUISettings.saveValue("cameraMode" + viewString, "mayaTrackBall");
                }
                else
                {
                    ToolUISettings.saveValue("cameraMode" + viewString, "maxTrackBall");
                }
            }

            // Render settings
            // Textures
            ToolUISettings.saveValue("renderTextures" + viewString, hasTextures);

            // Wireframe
            ToolUISettings.saveValue("renderWireframe" + viewString, (es & hkgDisplayContextCLR.EnabledState.WIREFRAME) != 0);

            // Lights
            ToolUISettings.saveValue("renderLights" + viewString, (es & hkgDisplayContextCLR.EnabledState.LIGHTING) != 0);


            // Backface culling
            if ((es & hkgDisplayContextCLR.EnabledState.CULLFACE) == 0)
            {
                ToolUISettings.saveValue("renderBackfaceCulling" + viewString, "none");
            }
            else
            {
                hkgDisplayContextCLR.CullFaceMode cfm = v.getDesiredCullFaceMode();
                if (cfm == hkgDisplayContextCLR.CullFaceMode.CW)
                {
                    ToolUISettings.saveValue("renderBackfaceCulling" + viewString, "CW");
                }
                else //CCW
                {
                    ToolUISettings.saveValue("renderBackfaceCulling" + viewString, "CCW");
                }
            }

            // Shadows
            ToolUISettings.saveValue("renderShadows" + viewString, hasTextures);

            // Edged faces
            ToolUISettings.saveValue("renderEdgedFaces" + viewString, edgedFacesToolStripMenuItem.Checked);

            // Normals/Tangents/Bitangents
            ToolUISettings.saveValue("displayMeshNormals" + viewString, displayNormalsToolStripMenuItem.Checked);
            ToolUISettings.saveValue("displayMeshTangents" + viewString, displayTangentsToolStripMenuItem.Checked);
            ToolUISettings.saveValue("displayMeshBitangents" + viewString, displayBiTangentsToolStripMenuItem.Checked);

            // Grid
            ToolUISettings.saveValue("gridEnabled" + viewString, viewOptions.m_gridEnabled);
               
            // Camera
            ToolUISettings.saveValue("projectionViewMode" + viewString, (int)viewOptions.m_cameraType);
        }

        void savePreferences()
        {
            ToolUISettings.setFolder("ToolUI");
            for (int vi = 0; vi < m_graphicsCtrl.m_windowHKG.getNumViewports(); ++vi)
            {
                using (hkgViewportCLR v = m_graphicsCtrl.m_windowHKG.getViewport(vi))
                {
                    saveViewPreferences(v, vi);
                }
            }

            //
            // Across all viewports (for now anyway)
            //
            ToolUISettings.saveValue("numViewports", (int)m_graphicsCtrl.m_windowHKG.getNumViewports());

            // Follow camera ( tracker )
            ToolUISettings.saveValue("cameraFollow", followCamToolStripMenuItem.Checked);
            ToolUISettings.saveValue("cameraFollowSmoothness", m_graphicsCtrl.m_followCamSmoothness);
            ToolUISettings.saveValue("cameraLeftHanded", leftHandedSystemToolStripMenuItem.Checked);

            // Lighting
            if (singleDirLightToolStripButton.Checked)
            {
                ToolUISettings.saveValue("renderLightsType", "renderSingleDirLight");
            }
            else if (singleDirLightTrackToolStripButton.Checked)
            {
                ToolUISettings.saveValue("renderLightsType", "renderSingleDirLightTrack");
            }
            else if (useSceneLightsToolStripMenuItem.Checked)
            {
                ToolUISettings.saveValue("renderLightsType", "renderSceneLight");
            }

           
            // Background color
            {
                hkgVector3CLR colorVec = m_graphicsCtrl.m_windowHKG.getClearColor();
                ToolUISettings.saveValue("BackgroundColorX", colorVec.X);
                ToolUISettings.saveValue("BackgroundColorY", colorVec.Y);
                ToolUISettings.saveValue("BackgroundColorZ", colorVec.Z);
            }

            // Grid
            {
                String orientation = "none";
                if (m_graphicsCtrl.m_gridOrientation == GraphicsControl.GridOrientation.GRID_XY)
                {
                    orientation = "gridOrientationXY";
                }
                else if (m_graphicsCtrl.m_gridOrientation == GraphicsControl.GridOrientation.GRID_XZ)
                {
                    orientation = "gridOrientationXZ";
                }
                else if (m_graphicsCtrl.m_gridOrientation == GraphicsControl.GridOrientation.GRID_YZ)
                {
                    orientation = "gridOrientationYZ";
                }
                ToolUISettings.saveValue("gridOrientation", orientation);

                ToolUISettings.saveValue("gridCellSize", m_graphicsCtrl.m_gridCellSize);
            }

            // Fly Mode View Up
            {
                String upVector = "PosY";

                if (flyModePosXToolStripMenuItem.Checked)
                {
                    upVector = "PosX";
                }
                else if (flyModePosYToolStripMenuItem.Checked)
                {
                    upVector = "PosY";
                }
                else if (flyModePosZToolStripMenuItem.Checked)
                {
                    upVector = "PosZ";
                }
                else if (flyModeNegXToolStripMenuItem.Checked)
                {
                    upVector = "NegX";
                }
                else if (flyModeNegYToolStripMenuItem.Checked)
                {
                    upVector = "NegY";
                }
                else if (flyModeNegZToolStripMenuItem.Checked)
                {
                    upVector = "NegZ";
                }
                ToolUISettings.saveValue("flyModeUpVector", upVector);
            }

        }

        void loadViewPreferences(hkgViewportCLR v, int viewportIndex)
        {
            string viewString = viewportIndex > 0 ? viewportIndex.ToString() : "";
            GraphicsControl.ViewportOptions viewOptions = m_graphicsCtrl.m_viewportOptions[viewportIndex];

             /// Render settings
            // Textures
            {
                Convert.ToBoolean(ToolUISettings.loadValue("renderTextures" + viewString, "true"));

                // Always start with textures on. This is mostly because the shader lib is loaded after the
                // preferences and we end-up with an override material with no shaders.
                texturesToolStripMenuItem.Checked = true;
                m_graphicsCtrl.SetForcedMaterial(false);
            }
            // Wireframe
            {
                bool renderWireframe = Convert.ToBoolean(ToolUISettings.loadValue("renderWireframe" + viewString, "false"));
                wireframeToolStripMenuItem.Checked = renderWireframe;
                m_graphicsCtrl.SetState(hkgDisplayContextCLR.EnabledState.WIREFRAME, renderWireframe);
            }
            // Shadows
            {
                bool renderShadows = Convert.ToBoolean(ToolUISettings.loadValue("renderShadows" + viewString, "false"));
                shadowsToolStripMenuItem.Checked = renderShadows;
                viewOptions.m_shadowsEnabled = renderShadows;
            }
            // Hardware Skinning
            {
                bool hwSkinning = Convert.ToBoolean(ToolUISettings.loadValue("hwSkinning" + viewString, "false"));
                m_graphicsCtrl.EnableHardwareSkinning(hwSkinning);
            }

            String cameraMode = (String)ToolUISettings.loadValue("cameraMode" + viewString, "defaultTrackBall");

            if (cameraMode == "mayaTrackBall")
            {
                mayaTrackballModeToolStripMenuItem_Click(null, null);
            }
            else if (cameraMode == "maxTrackBall")
            {
                maxTrackballModeToolStripMenuItem_Click(null, null);
            }
            else if (cameraMode == "fly")
            {
                flyModeToolStripMenuItem_Click(null, null);
            }


            // Backface culling
            {
                String cullingMode = (String)ToolUISettings.loadValue("renderBackfaceCulling" + viewString, "none");
                if (cullingMode == "none")
                {
                    noneToolStripMenuItem_Click(noneToolStripMenuItem, null);
                }
                else if (cullingMode == "CW")
                {
                    cWToolStripMenuItem_Click(cWToolStripMenuItem, null);
                }
                else if (cullingMode == "CCW")
                {
                    cCWToolStripMenuItem_Click(cCWToolStripMenuItem, null);
                }
            }

            // Edged faces
            {
                bool edgedFaces = Convert.ToBoolean(ToolUISettings.loadValue("renderEdgedFaces" + viewString, "false"));
                viewOptions.m_displayEdgedFaces = edgedFaces;
                edgedFacesToolStripMenuItem.Checked = edgedFaces;
            }

            // Normals/Tangents/Bitangents
            {
                bool displayNormals = Convert.ToBoolean(ToolUISettings.loadValue("displayMeshNormals" + viewString, "false"));
                viewOptions.m_displayNormals = displayNormals;
                displayNormalsToolStripMenuItem.Checked = displayNormals;

                bool displayTangents = Convert.ToBoolean(ToolUISettings.loadValue("displayMeshTangents" + viewString, "false"));
                viewOptions.m_displayTangents = displayTangents;
                displayTangentsToolStripMenuItem.Checked = displayTangents;

                bool displayBiTangents = Convert.ToBoolean(ToolUISettings.loadValue("displayMeshBitangents" + viewString, "false"));
                viewOptions.m_displayBiTangents = displayBiTangents;
                displayBiTangentsToolStripMenuItem.Checked = displayBiTangents;
            }

            viewOptions.m_gridEnabled = Convert.ToBoolean(ToolUISettings.loadValue("gridEnabled" + viewString, true));

            viewOptions.m_cameraType = (GraphicsControl.ViewportOptions.CameraType) Convert.ToInt32(ToolUISettings.loadValue("projectionViewMode" + viewString, (int)GraphicsControl.ViewportOptions.CameraType.Perspective));
            setCameraMode( viewOptions.m_cameraType );
        }

        // Load user settings
        void loadPreferences()
        {
            ToolUISettings.setFolder("ToolUI");

            int numViewports = Convert.ToInt32(ToolUISettings.loadValue("numViewports", "1"));
            numViewports = Math.Max(Math.Min(numViewports, 4), 1);
            setNumViewports(numViewports);

            oneViewportToolStripButton.Checked = numViewports == 1;
            twoViewportsToolStripButton.Checked = numViewports == 2;
            fourViewportsToolStripButton.Checked = numViewports == 4;

            oneViewportToolStripMenuItem.Checked = numViewports == 1;
            twoViewportsToolStripMenuItem.Checked = numViewports == 2;
            fourViewportsToolStripMenuItem.Checked = numViewports == 4;

            // Camera settings
            for (int vi = 0; vi < m_graphicsCtrl.m_windowHKG.getNumViewports(); ++vi)
            {
                using (hkgViewportCLR v = m_graphicsCtrl.m_windowHKG.getViewport(vi))
                {
                    m_graphicsCtrl.m_windowHKG.setCurrentViewport(vi);
                    loadViewPreferences(v, vi);
                }
            }

            // Follow camera ( tracker )
            {
                bool useFollow = Convert.ToBoolean(ToolUISettings.loadValue("cameraFollow", "false"));
                toggleFollowCam(useFollow);
                m_graphicsCtrl.m_followCamSmoothness = Convert.ToSingle(ToolUISettings.loadValue("cameraFollowSmoothness", "0.1"));
            }

            {
                bool useLeftHanded = Convert.ToBoolean(ToolUISettings.loadValue("cameraLeftHanded", "false"));
                leftHandedSystemToolStripMenuItem.Checked = useLeftHanded;
                toggleLeftHandedCoords(useLeftHanded);
            }


            // Lights
            {
                bool renderLights = Convert.ToBoolean(ToolUISettings.loadValue("renderLights", "true"));
                lightsToolStripMenuItem.Checked = renderLights;
                m_graphicsCtrl.SetState(hkgDisplayContextCLR.EnabledState.LIGHTING, renderLights);

                String lights = (String)ToolUISettings.loadValue("renderLightsType", "renderSingleDirLightTrack");
                if (lights == "renderSingleDirLight")
                {
                    singleLightToolStripMenuItem_Click(null, null);
                }
                else if (lights == "renderSingleDirLightTrack")
                {
                    singleDirLightTrackToolStripButton_Click(null, null);
                }
                else if (lights == "renderSceneLight")
                {
                    useSceneLightsToolStripMenuItem_Click(null, null);
                }
            }


            // Background color
            {
                hkgVector3CLR colorVec = m_graphicsCtrl.m_windowHKG.getClearColor();

                colorVec.X = System.Decimal.ToSingle(Convert.ToDecimal(ToolUISettings.loadValue("BackgroundColorX", 0.3f)));
                colorVec.Y = System.Decimal.ToSingle(Convert.ToDecimal(ToolUISettings.loadValue("BackgroundColorY", 0.3f)));
                colorVec.Z = System.Decimal.ToSingle(Convert.ToDecimal(ToolUISettings.loadValue("BackgroundColorZ", 0.4f)));
                m_graphicsCtrl.m_windowHKG.setClearColor(colorVec);
            }

            // Grid
            {
                String orientation = (String)ToolUISettings.loadValue("gridOrientation", "gridOrientationXY");

                if (orientation == "gridOrientationXY")
                {
                    m_graphicsCtrl.m_gridOrientation = GraphicsControl.GridOrientation.GRID_XY;
                }
                else if (orientation == "gridOrientationXZ")
                {
                    m_graphicsCtrl.m_gridOrientation = GraphicsControl.GridOrientation.GRID_XZ;
                }
                else if (orientation == "gridOrientationYZ")
                {
                    m_graphicsCtrl.m_gridOrientation = GraphicsControl.GridOrientation.GRID_YZ;
                }

                m_graphicsCtrl.m_gridCellSize = System.Decimal.ToSingle(Convert.ToDecimal(ToolUISettings.loadValue("gridCellSize", 1.0f)));
            }

            // Fly Mode View Up Vector
            {
                String upVector = (String)ToolUISettings.loadValue("flyModeUpVector", "PosY");

                uncheckFlyModeUpVectors();

                if (upVector == "PosX")
                {
                    setWorldUp(1.0f, 0.0f, 0.0f);
                    flyModePosXToolStripMenuItem.Checked = true;
                }
                else if (upVector == "PosY")
                {
                    setWorldUp(0.0f, 1.0f, 0.0f);
                    flyModePosYToolStripMenuItem.Checked = true;
                }
                else if (upVector == "PosZ")
                {
                    setWorldUp(0.0f, 0.0f, 1.0f);
                    flyModePosZToolStripMenuItem.Checked = true;
                }
                else if (upVector == "NegX")
                {
                    setWorldUp(-1.0f, 0.0f, 0.0f);
                    flyModeNegXToolStripMenuItem.Checked = true;
                }
                else if (upVector == "NegY")
                {
                    setWorldUp(0.0f, -1.0f, 0.0f);
                    flyModeNegYToolStripMenuItem.Checked = true;
                }
                else if (upVector == "NegZ")
                {
                    setWorldUp(1.0f, 0.0f, -1.0f);
                    flyModeNegZToolStripMenuItem.Checked = true;
                }
            }
        }

        void restoreDefaultPreferences()
        {
            // Remove settings folder
            ToolUISettings.setFolder("ToolUI");
            ToolUISettings.deleteCurrentFolder();

            // Then load the defaults
            loadPreferences();
        }
    }
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
