﻿  // TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

using System;
using System.Collections.Generic;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using System.Net.Sockets;
using Microsoft.Win32;
using System.Runtime.InteropServices;

using Havok.Graphics;
using Havok.Tool.UI;

namespace Havok.Tool
{
    partial class ToolUI
    {



        private void showConsoleButton_Click(object sender, EventArgs e)
        {
            if (m_errorConsole.Visible)
            {
                showConsoleButton.Checked = false;
                // Hide console
                m_errorConsole.Hide();
            }
            else
            {
                showConsoleButton.Checked = true;
                // Show console
                m_errorConsole.Show(this);
                m_errorConsole.WindowState = FormWindowState.Normal;
            }
        }

        private void aboutToolStripMenuItem_Click(object sender, EventArgs e)
        {
            UI.AboutForm aboutForm = new UI.AboutForm();
            if (m_plugins.m_pluginAssemblies.Count > 0)
            {
                aboutForm.textBoxDescription.Text += "\r\nCurrent loaded plugins:\r\n";
                for (int ea = 0; ea < m_plugins.m_pluginAssemblies.Count; ++ea)
                {
                    PluginAssembly assm = (PluginAssembly)m_plugins.m_pluginAssemblies[ea];
                    aboutForm.textBoxDescription.Text += assm.assm.ToString() + "\r\n";
                    for (int ei = 0; ei < assm.pluginTypes.Count; ++ei)
                    {
                        aboutForm.textBoxDescription.Text += assm.pluginTypes[ei].ToString() + "\r\n";
                    }
                }
            }
            else
            {
                aboutForm.textBoxDescription.Text += "ERROR: No tools plugins found. Check your Install / registry settings.\r\n";
            }

            // Add OS and CLR version
            aboutForm.textBoxDescription.Text += "\r\nOS Version : " + System.Environment.OSVersion + "\r\n";
            aboutForm.textBoxDescription.Text += "CLR Version : " + System.Environment.Version;

            aboutForm.ShowDialog(this);
        }

        private void restoreDefaultsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            // Restore ToolUI preferences
            restoreDefaultPreferences();
            // Restore plugin preferences
            m_plugins.RestorePluginDefaultProperties();
        }

        private void connectToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (!m_serverForm.Visible)
            {
                m_serverForm.Show(this);
            }
        }
      
    }
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
