﻿ // TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

using System;
using System.Collections.Generic;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using System.Net.Sockets;
using Microsoft.Win32;
using System.Runtime.InteropServices;

using Havok.Graphics;
using Havok.Tool.UI;


namespace Havok.Tool
{
    partial class ToolUI
    {
        public void SetContentsFromMemory(IntPtr root /* hkRootLevelContainer* */, IntPtr vtableReg, bool copy, bool allowInstances)
        {
            m_plugins.SetContentsFromMemory(root, vtableReg, copy, allowInstances);
            reflectDesiredLightState();
        }

        public void SetContentsFromFile(String path)
        {
            m_plugins.SetContentsFromFile(path, true, 0, 0, false);
            reflectDesiredLightState();
        }

        private void openHKXToolStripMenuItem_Click(object sender, EventArgs e)
        {
            OpenFileDialog openFileDlg = new OpenFileDialog();
            openFileDlg.FileName = "";
            openFileDlg.Filter = s_havokFileExtenstions;
            openFileDlg.FilterIndex = 0;
            openFileDlg.Title = "Select a Havok packfile/tagfile to load into source scene";
            openFileDlg.CheckPathExists = true;
            openFileDlg.CheckFileExists = true;
            if (openFileDlg.ShowDialog(this) == DialogResult.OK)
            {
                m_plugins.SetContentsFromFile(openFileDlg.FileName, false, 0, 0, false);
                reflectDesiredLightState();
            }
        }

        private void addHKXToolStripMenuItem_Click(object sender, EventArgs e)
        {
            OpenFileDialog openFileDlg = new OpenFileDialog();
            openFileDlg.FileName = "";
            openFileDlg.Filter = s_havokFileExtenstions;
            openFileDlg.FilterIndex = 0;
            openFileDlg.Title = "Select a Havok HKX packfile/tagfile to add to source scene";
            openFileDlg.CheckPathExists = true;
            openFileDlg.CheckFileExists = true;
            if (openFileDlg.ShowDialog(this) == DialogResult.OK)
            {
                m_plugins.SetContentsFromFile(openFileDlg.FileName, true, 0, 0, false);
                reflectDesiredLightState();
            }
            reflectDesiredLightState();
        }

        private void saveHKXToolStripMenuItem_Click(object sender, EventArgs e)
        {
            SaveSceneForm sf = new SaveSceneForm();
            if (sf.ShowDialog(this) == DialogResult.OK)
            {
                if (sf.filenameTextBox.Text.Length > 0)
                {
                    m_plugins.SaveContentsToFile(sf.filenameTextBox.Text, sf.getFormat(), sf.getLayout(), sf.metaDataCheckBox.Checked);
                }
            }
        }
        public void ShowDragDropTargetsForFile(String path)
        {
            m_plugins.ShowDragDropTargets(path);
        }

        public void DragDropAddFile(String path, Int32 x, Int32 y)
        {
            // bring to front so that the drop menu will be visible etc
            Form parent = FindForm();
            parent.TopMost = true;
            parent.Focus();
            parent.BringToFront();
            parent.TopMost = false;

            m_plugins.SetContentsFromFile(path, true, x, y, true);
            reflectDesiredLightState();
        }

        public void EndDragDropTargets()
        {
            m_plugins.EndDragDropTargets();
        }

        public void CheckForNewAssets()
        {
            bool pending = false;
            if (m_tcpUpdateListener != null)
            {
                try
                {
                    pending = m_tcpUpdateListener.Pending();
                }
                catch (SocketException)
                {
                    pending = false;
                }
            }

            if (pending)
            {
                try
                {
                    TcpClient socketForClient = m_tcpUpdateListener.AcceptTcpClient();
                    if (socketForClient.Connected)
                    {
                        NetworkStream networkStream = socketForClient.GetStream();
                        System.IO.BinaryReader streamReader = new System.IO.BinaryReader(networkStream);

                        // System.IO.BinaryWriter streamWriter = new System.IO.BinaryWriter(networkStream);
                        // Write our layout first (4101 or 8101 normally)
                        // XX Add proper local format discovery
                        //streamWriter.Write((byte)IntPtr.Size);
                        //streamWriter.Write((byte)1);
                        //streamWriter.Write((byte)0);
                        //streamWriter.Write((byte)1);

                        int numBytes = streamReader.ReadInt32();
                        byte[] buffer = new byte[numBytes];
                        int numRead = streamReader.Read(buffer, 0, numBytes);
                        while ((numRead < numBytes) && socketForClient.Connected)
                        {
                            numRead += streamReader.Read(buffer, numRead, numBytes - numRead);
                        }

                        if (numRead >= numBytes)
                        {
                            m_plugins.UpdateContentFromPackfile(buffer);
                            reflectDesiredLightState();
                        }
                    }
                }
                catch { }
            }
        }

        private static void TimerEventProcessor(Object myObject, EventArgs myEventArgs)
        {
            System.Windows.Forms.Timer timer = (System.Windows.Forms.Timer)myObject;
            ToolUI ui = (ToolUI)timer.Tag;

            ui.CheckForNewAssets();

            // update display. It will in turn step the plugins if required.
            // The reason the ctrl updates the display and it in turn steps the plugin
            // is that during heavy user interaction, the display is updating a lot
            // and will need to step the plugins every now and agin explicitly anyway
            // to stop them being starved. Also, we are in a seperate thread here.

            ui.graphicsMouseMove(ui, null);
            ui.m_graphicsCtrl.Invalidate();
        }
    }
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
