﻿ // TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

using System;
using System.Collections.Generic;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using System.Net.Sockets;
using Microsoft.Win32;
using System.Runtime.InteropServices;

using Havok.Graphics;
using Havok.Tool.UI;


namespace Havok.Tool
{
    partial class ToolUI
    {

        //
        // Viewports
        //

        private void oneViewportToolStripButton_Click(object sender, EventArgs e)
        {
            oneViewportToolStripMenuItem_Click(sender, e);
        }

        private void oneViewportToolStripMenuItem_Click(object sender, EventArgs e)
        {
            oneViewportToolStripButton.Checked = true;
            twoViewportsToolStripButton.Checked = false;
            fourViewportsToolStripButton.Checked = false;

            oneViewportToolStripMenuItem.Checked = true;
            twoViewportsToolStripMenuItem.Checked = false;
            fourViewportsToolStripMenuItem.Checked = false;

            setNumViewports(1);
        }

        private void twoViewportsToolStripButton_Click(object sender, EventArgs e)
        {
            twoViewportsToolStripMenuItem_Click(sender, e);
        }

        private void twoViewportsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            oneViewportToolStripButton.Checked = false;
            twoViewportsToolStripButton.Checked = true;
            fourViewportsToolStripButton.Checked = false;

            oneViewportToolStripMenuItem.Checked = false;
            twoViewportsToolStripMenuItem.Checked = true;
            fourViewportsToolStripMenuItem.Checked = false;

            setNumViewports(2);
        }

        private void fourViewportsToolStripButton_Click(object sender, EventArgs e)
        {
            fourViewportsToolStripMenuItem_Click(sender, e);
        }

        private void fourViewportsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            oneViewportToolStripButton.Checked = false;
            twoViewportsToolStripButton.Checked = false;
            fourViewportsToolStripButton.Checked = true;

            oneViewportToolStripMenuItem.Checked = false;
            twoViewportsToolStripMenuItem.Checked = false;
            fourViewportsToolStripMenuItem.Checked = true;

            setNumViewports(4);
        }


        //
        // Render State
        //


        private void edgedFacesToolStripMenuItem_Click(object sender, EventArgs e)
        {
            ToolStripMenuItem mi = (ToolStripMenuItem)sender;
            mi.Checked = !mi.Checked;

            int vi = m_graphicsCtrl.m_windowHKG.getCurrentViewportIndex();
            m_graphicsCtrl.m_viewportOptions[vi].m_displayEdgedFaces = mi.Checked;
        }

        private void texturesToolStripMenuItem_Click(object sender, EventArgs e)
        {
            ToolStripMenuItem mi = (ToolStripMenuItem)sender;
            mi.Checked = !mi.Checked;
            m_graphicsCtrl.SetForcedMaterial(!mi.Checked);
        }

        private void wireframeToolStripMenuItem_Click(object sender, EventArgs e)
        {
            ToolStripMenuItem mi = (ToolStripMenuItem)sender;
            mi.Checked = !mi.Checked;
            m_graphicsCtrl.SetState(hkgDisplayContextCLR.EnabledState.WIREFRAME, mi.Checked);
        }

        private void shadowsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            ToolStripMenuItem mi = (ToolStripMenuItem)sender;
            mi.Checked = !mi.Checked;
            int vi = m_graphicsCtrl.m_windowHKG.getCurrentViewportIndex();
            m_graphicsCtrl.m_viewportOptions[vi].m_shadowsEnabled = mi.Checked;
        }
        
        private void noneToolStripMenuItem_Click(object sender, EventArgs e)
        {
            ToolStripMenuItem mi = (ToolStripMenuItem)sender;
            mi.Checked = true;
            cWToolStripMenuItem.Checked = false;
            cCWToolStripMenuItem.Checked = false;
            m_graphicsCtrl.SetState(hkgDisplayContextCLR.EnabledState.CULLFACE, false);
        }

        private void cWToolStripMenuItem_Click(object sender, EventArgs e)
        {
            ToolStripMenuItem mi = (ToolStripMenuItem)sender;
            mi.Checked = true;
            noneToolStripMenuItem.Checked = false;
            cCWToolStripMenuItem.Checked = false;
            m_graphicsCtrl.SetState(hkgDisplayContextCLR.EnabledState.CULLFACE, true);
            m_graphicsCtrl.SetCullMode(isUsingLeftHandedCoords() ? hkgDisplayContextCLR.CullFaceMode.CCW : hkgDisplayContextCLR.CullFaceMode.CW);
        }

        private void cCWToolStripMenuItem_Click(object sender, EventArgs e)
        {
            ToolStripMenuItem mi = (ToolStripMenuItem)sender;
            mi.Checked = true;
            cWToolStripMenuItem.Checked = false;
            noneToolStripMenuItem.Checked = false;
            m_graphicsCtrl.SetState(hkgDisplayContextCLR.EnabledState.CULLFACE, true);
            m_graphicsCtrl.SetCullMode(isUsingLeftHandedCoords() ? hkgDisplayContextCLR.CullFaceMode.CW : hkgDisplayContextCLR.CullFaceMode.CCW);
        }

        private void backgroundColorToolStripMenuItem_Click(object sender, EventArgs e)
        {
            ColorDialog MyDialog = new ColorDialog();
            MyDialog.AllowFullOpen = true;
            MyDialog.ShowHelp = true;

            hkgVector3CLR colorVec = m_graphicsCtrl.m_windowHKG.getClearColor();
            MyDialog.Color = colorVec.toColor();

            if (MyDialog.ShowDialog() == DialogResult.OK)
            {
                colorVec.fromColor(MyDialog.Color);
                m_graphicsCtrl.m_windowHKG.setClearColor(colorVec);
            }
        }

        private void displayNormalsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            ToolStripMenuItem mi = (ToolStripMenuItem)sender;
            mi.Checked = !mi.Checked;
            int vi = m_graphicsCtrl.m_windowHKG.getCurrentViewportIndex();
            m_graphicsCtrl.m_viewportOptions[vi].m_displayNormals = mi.Checked;
        }

        private void displayTangentsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            ToolStripMenuItem mi = (ToolStripMenuItem)sender;
            mi.Checked = !mi.Checked;
            int vi = m_graphicsCtrl.m_windowHKG.getCurrentViewportIndex();
            m_graphicsCtrl.m_viewportOptions[vi].m_displayTangents = mi.Checked;
        }

        private void displayBiTangentsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            ToolStripMenuItem mi = (ToolStripMenuItem)sender;
            mi.Checked = !mi.Checked;
            int vi = m_graphicsCtrl.m_windowHKG.getCurrentViewportIndex();
            m_graphicsCtrl.m_viewportOptions[vi].m_displayBiTangents = mi.Checked;
        }

        //
        // Navigation
        //

        private void mayaTrackballModeToolStripMenuItem_Click(object sender, EventArgs e)
        {
            using (hkgViewportCLR v = m_graphicsCtrl.m_windowHKG.getCurrentViewport())
            {
                v.setNavigationMode(hkgViewportCLR.CameraNavigationMode.TRACKBALL);
                v.setMouseConvention(hkgViewportCLR.MouseConvention.MAYA);

                toolStripFlyModeButton.Checked = false;
                toolStripFirstPersonButton.Checked = false;
                toolStripTrackBallButton.Checked = true;

                mayaTrackballModeToolStripMenuItem.Checked = true;
                maxTrackballModeToolStripMenuItem.Checked = false;
                flyModeToolStripMenuItem.Checked = false;
                firstPersonModeToolStripMenuItem.Checked = false;

                m_plugins.DeleteFirstPersonViewer();
            }
        }

        private void maxTrackballModeToolStripMenuItem_Click(object sender, EventArgs e)
        {
            using (hkgViewportCLR v = m_graphicsCtrl.m_windowHKG.getCurrentViewport())
            {
                v.setNavigationMode(hkgViewportCLR.CameraNavigationMode.TRACKBALL);
                v.setMouseConvention(hkgViewportCLR.MouseConvention.MAX);

                toolStripFlyModeButton.Checked = false;
                toolStripFirstPersonButton.Checked = false;
                toolStripTrackBallButton.Checked = true;

                mayaTrackballModeToolStripMenuItem.Checked = false;
                maxTrackballModeToolStripMenuItem.Checked = true;
                flyModeToolStripMenuItem.Checked = false;
                firstPersonModeToolStripMenuItem.Checked = false;

                m_plugins.DeleteFirstPersonViewer();
            }
        }

        private void flyModeToolStripMenuItem_Click(object sender, EventArgs e)
        {
            using (hkgViewportCLR v = m_graphicsCtrl.m_windowHKG.getCurrentViewport())
            {
                // Based on current camera at time of switch, pick a up
                hkgCameraCLR c = v.getCamera();

                hkgVector3CLR vUp = new hkgVector3CLR();

                if (m_flyModeUpVectorExplicit)
                {
                    if (flyModePosXToolStripMenuItem.Checked)
                    {
                        vUp.set(1.0f, 0.0f, 0.0f);
                    }
                    else if (flyModePosYToolStripMenuItem.Checked)
                    {
                        vUp.set(0.0f, 1.0f, 0.0f);
                    }
                    else if (flyModePosZToolStripMenuItem.Checked)
                    {
                        vUp.set(0.0f, 0.0f, 1.0f);
                    }
                    else if (flyModeNegXToolStripMenuItem.Checked)
                    {
                        vUp.set(-1.0f, 0.0f, 0.0f);
                    }
                    else if (flyModeNegYToolStripMenuItem.Checked)
                    {
                        vUp.set(0.0f, -1.0f, 0.0f);
                    }
                    else if (flyModeNegZToolStripMenuItem.Checked)
                    {
                        vUp.set(0.0f, 0.0f, -1.0f);
                    }
                }
                else
                {
                    c.getBestAlignedUpVector(ref vUp);
                }
                setWorldUp(vUp.X, vUp.Y, vUp.Z);
                v.setNavigationMode(hkgViewportCLR.CameraNavigationMode.FLY);
                v.setMouseConvention(hkgViewportCLR.MouseConvention.DEFAULT);
                c.Dispose();

                
                toolStripFlyModeButton.Checked = true;
                toolStripFirstPersonButton.Checked = false;
                toolStripTrackBallButton.Checked = false;

                mayaTrackballModeToolStripMenuItem.Checked = false;
                maxTrackballModeToolStripMenuItem.Checked = false;
                flyModeToolStripMenuItem.Checked = true;
                firstPersonModeToolStripMenuItem.Checked = false;

                m_plugins.DeleteFirstPersonViewer();
            }
        }

        private void firstPersonModeToolStripMenuItem_Click(object sender, EventArgs e)
        {
            using (hkgViewportCLR v = m_graphicsCtrl.m_windowHKG.getCurrentViewport())
            {
                toolStripFlyModeButton.Checked = false;
                toolStripFirstPersonButton.Checked = true;
                toolStripTrackBallButton.Checked = false;

                mayaTrackballModeToolStripMenuItem.Checked = false;
                maxTrackballModeToolStripMenuItem.Checked = false;
                flyModeToolStripMenuItem.Checked = false;
                firstPersonModeToolStripMenuItem.Checked = true;

                // create first person character controller
                hkgCameraCLR c = v.getCamera();
                hkgVector3CLR bestUp = new hkgVector3CLR();
                hkgVector3CLR position = new hkgVector3CLR();
                hkgVector3CLR direction = new hkgVector3CLR();

                bestUp = getUp();
                c.getFrom(ref position);
                c.getDir(ref direction);
                c.Dispose();

                // fly mode is the natural fallback when it gets disabled
                v.setWorldUp(bestUp);
                v.setNavigationMode(hkgViewportCLR.CameraNavigationMode.FLY);

                m_plugins.CreateFirstPersonViewer(position, direction, bestUp);

                m_graphicsCtrl.Focus();
            }
        }

        private void toolStripFlyModeButton_Click(object sender, EventArgs e)
        {
            flyModeToolStripMenuItem_Click(sender, e);
        }

        private void toolStripTrackBallButton_Click(object sender, EventArgs e)
        {
            maxTrackballModeToolStripMenuItem_Click(sender, e);
        }

        private void toolStripFirstPersonButton_Click(object sender, EventArgs e)
        {
            firstPersonModeToolStripMenuItem_Click(sender, e);
        }

        private void toolStripFirstPersonButton_EnabledChanged(object sender, EventArgs e)
        {
            firstPersonModeToolStripMenuItem.Enabled = toolStripFirstPersonButton.Enabled;
        }

        private void gridToolStripMenuItem_Click(object sender, EventArgs e)
        {
            m_gridForm.ShowDialog(this);
        }

        private void gridToolStripButton_Click(object sender, EventArgs e)
        {
            gridToolStripMenuItem_Click(sender, e);
        }

        //
        // Camera
        //
        private void editCameraItem_Click(object sender, EventArgs e)
        {
            using (EditCameraForm cf = new EditCameraForm())
            {
                cf.SetGraphicsControl(m_graphicsCtrl);
                if (cf.ShowDialog(this) == DialogResult.OK)
                {
                    // already applied to cur camera at this stage.
                }
            }
        }

        private void viewAllToolStripMenuItem_Click(object sender, EventArgs e)
        {
            m_graphicsCtrl.FitCameraToWorld();
        }

        private void zoomSelectedToolStripMenuItem_Click(object sender, EventArgs e)
        {
            hkgDisplayObjectCLR obj = getSelectedObject();
            m_graphicsCtrl.FitCameraToObject(obj);
        }

        private void focusSelectedToolStripMenuItem_Click(object sender, EventArgs e)
        {
            hkgDisplayObjectCLR obj = getSelectedObject();
            m_graphicsCtrl.FocusCameraOnObject(obj);
        }

        private void followCamToolStripMenuItem_Click(object sender, EventArgs e)
        {
            toggleFollowCam(followCamToolStripMenuItem.Checked);
        }

        private void leftHandedSystemToolStripMenuItem_Click(object sender, EventArgs e)
        {
            toggleLeftHandedCoords(leftHandedSystemToolStripMenuItem.Checked);
        }

        private void focusSelectedToolStripButton_Click(object sender, EventArgs e)
        {
            focusSelectedToolStripMenuItem_Click(sender, e);
        }

        private void zoomSelectedToolStripButton_Click(object sender, EventArgs e)
        {
            zoomSelectedToolStripMenuItem_Click(sender, e);
        }

        private void zoomAllToolStripButton_Click(object sender, EventArgs e)
        {
            m_graphicsCtrl.FitCameraToWorld();
        }

        private void followCamToolStripButton_Click(object sender, EventArgs e)
        {
            toggleFollowCam(followCamToolStripButton.Checked);
        }

        private void camPerspectiveToolStripMenuItem_Click(object sender, EventArgs e)
        {
            using (hkgViewportCLR v = m_graphicsCtrl.m_windowHKG.getCurrentViewport())
            {
                using (hkgCameraCLR c = v.getCamera())
                {
                    if (c.getProjectionMode() != hkgCameraCLR.ProjectionMode.PERSPECTIVE)
                    {
                        c.setProjectionMode(hkgCameraCLR.ProjectionMode.PERSPECTIVE);
                    }

                    m_graphicsCtrl.m_viewportOptions[m_graphicsCtrl.m_windowHKG.getCurrentViewportIndex()].m_cameraType = GraphicsControl.ViewportOptions.CameraType.Perspective;
                }
            }
        }

        private int getMajorUpAxis()
        {
            using (hkgViewportCLR v = m_graphicsCtrl.m_windowHKG.getCurrentViewport())
            {
                hkgVector3CLR flyUp = v.getWorldUp();
                float fx = Math.Abs( flyUp.X );
                float fy = Math.Abs( flyUp.Y );
                float fz = Math.Abs( flyUp.Z );
                if (fx > fy)
                {
                    if (fx > fz)
                        return 0;
                    else
                        return 2;
                }
                else if (fy > fz)
                {
                    return 1;
                }
                else return 2;
            }
        }

        private hkgVector3CLR getUp()
        {
            using (hkgViewportCLR v = m_graphicsCtrl.m_windowHKG.getCurrentViewport())
            {
                int ui = getMajorUpAxis();
                hkgVector3CLR ret = new hkgVector3CLR();
                ret.set(ui == 0 ? 1 : 0, ui == 1 ? 1 : 0, ui == 2 ? 1 : 0);
                return ret;
            }
        }

        private hkgVector3CLR getFront()
        {
            using (hkgViewportCLR v = m_graphicsCtrl.m_windowHKG.getCurrentViewport())
            {
                int ui = getMajorUpAxis();
                hkgVector3CLR ret = new hkgVector3CLR();
                switch (ui)
                {
                    case 0: // X up/down, so Z front/back
                    case 1: // Y up/down, so use Z too
                        ret.set(0, 0, -1); break;
                    case 2: //Z
                    default:
                        ret.set(0, 1, 0); break; 
                }

                return ret;
            }
        }

        private hkgVector3CLR getRight()
        {
            using (hkgViewportCLR v = m_graphicsCtrl.m_windowHKG.getCurrentViewport())
            {
                int ui = getMajorUpAxis();
                hkgVector3CLR ret = new hkgVector3CLR();
                switch (ui)
                {
                    case 0: // X up/down, so Z front/back, -Y right 
                        ret.set(0, -1, 0); break;
                    
                    case 1: // Z or Y up/down, so use X right
                    default:
                        ret.set(1, 0, 0); break; 
                }
                return ret;
            }
        }

        private void camFrontToolStripMenuItem_Click(object sender, EventArgs e)
        {
            using (hkgViewportCLR v = m_graphicsCtrl.m_windowHKG.getCurrentViewport())
            {
                using (hkgCameraCLR c = v.getCamera())
                {
                    if (c.getProjectionMode() == hkgCameraCLR.ProjectionMode.PERSPECTIVE)
                    {
                        c.setProjectionMode(hkgCameraCLR.ProjectionMode.COMPUTE_ORTHOGRAPHIC);
                    }

                    hkgVector3CLR fr = getFront();
                    hkgVector3CLR t = new hkgVector3CLR();
                    c.getTo(ref t);
                    hkgVector3CLR f = new hkgVector3CLR();
                    c.getFrom(ref f);
                    hkgVector3CLR d = new hkgVector3CLR();
                    d.setSub(t, f);
                    float dist = d.len();
                    fr.mult(-dist); // Front
                    fr.add(t);
                    c.setFrom(fr);
                    c.setUp(v.getWorldUp());
                    c.computeModelView(false);
                    c.computeProjection();

                    m_graphicsCtrl.m_viewportOptions[m_graphicsCtrl.m_windowHKG.getCurrentViewportIndex()].m_cameraType = GraphicsControl.ViewportOptions.CameraType.OrthoFront;
                }
            }
        }

        private void camBackToolStripMenuItem_Click(object sender, EventArgs e)
        {
            using (hkgViewportCLR v = m_graphicsCtrl.m_windowHKG.getCurrentViewport())
            {
                using (hkgCameraCLR c = v.getCamera())
                {
                    if (c.getProjectionMode() == hkgCameraCLR.ProjectionMode.PERSPECTIVE)
                    {
                        c.setProjectionMode(hkgCameraCLR.ProjectionMode.COMPUTE_ORTHOGRAPHIC);
                    }

                    hkgVector3CLR fr = getFront();
                    hkgVector3CLR t = new hkgVector3CLR();
                    c.getTo(ref t);
                    hkgVector3CLR f = new hkgVector3CLR();
                    c.getFrom(ref f);
                    hkgVector3CLR d = new hkgVector3CLR();
                    d.setSub(t, f);
                    float dist = d.len();
                    fr.mult(dist); // Back
                    fr.add(t);
                    c.setFrom(fr);
                    c.setUp(v.getWorldUp());
                    c.computeModelView(false);
                    c.computeProjection();

                    m_graphicsCtrl.m_viewportOptions[m_graphicsCtrl.m_windowHKG.getCurrentViewportIndex()].m_cameraType = GraphicsControl.ViewportOptions.CameraType.OrthoBack;
                }
            }
        }

        private void camLeftToolStripMenuItem_Click(object sender, EventArgs e)
        {
            using (hkgViewportCLR v = m_graphicsCtrl.m_windowHKG.getCurrentViewport())
            {
                using (hkgCameraCLR c = v.getCamera())
                {
                    if (c.getProjectionMode() == hkgCameraCLR.ProjectionMode.PERSPECTIVE)
                    {
                        c.setProjectionMode(hkgCameraCLR.ProjectionMode.COMPUTE_ORTHOGRAPHIC);
                    }

                    hkgVector3CLR fr = getRight();
                    hkgVector3CLR t = new hkgVector3CLR();
                    c.getTo(ref t);
                    hkgVector3CLR f = new hkgVector3CLR();
                    c.getFrom(ref f);
                    hkgVector3CLR d = new hkgVector3CLR();
                    d.setSub(t, f);
                    float dist = d.len();
                    fr.mult(-dist); // Left
                    fr.add(t);
                    c.setFrom(fr);
                    c.setUp(v.getWorldUp());
                    c.computeModelView(false);
                    c.computeProjection();

                    m_graphicsCtrl.m_viewportOptions[m_graphicsCtrl.m_windowHKG.getCurrentViewportIndex()].m_cameraType = GraphicsControl.ViewportOptions.CameraType.OrthoLeft;
                }
            }
        }

        private void camRightToolStripMenuItem_Click(object sender, EventArgs e)
        {
            using (hkgViewportCLR v = m_graphicsCtrl.m_windowHKG.getCurrentViewport())
            {
                using (hkgCameraCLR c = v.getCamera())
                {
                    if (c.getProjectionMode() == hkgCameraCLR.ProjectionMode.PERSPECTIVE)
                    {
                        c.setProjectionMode(hkgCameraCLR.ProjectionMode.COMPUTE_ORTHOGRAPHIC);
                    }

                    hkgVector3CLR fr = getRight();
                    hkgVector3CLR t = new hkgVector3CLR();
                    c.getTo(ref t);
                    hkgVector3CLR f = new hkgVector3CLR();
                    c.getFrom(ref f);
                    hkgVector3CLR d = new hkgVector3CLR();
                    d.setSub(t, f);
                    float dist = d.len();
                    fr.mult(dist); // Right
                    fr.add(t);
                    c.setFrom(fr);
                    c.setUp(v.getWorldUp());
                    c.computeModelView(false);
                    c.computeProjection();

                    m_graphicsCtrl.m_viewportOptions[m_graphicsCtrl.m_windowHKG.getCurrentViewportIndex()].m_cameraType = GraphicsControl.ViewportOptions.CameraType.OrthoRight;
                }
            }
        }

        private void camTopToolStripMenuItem_Click(object sender, EventArgs e)
        {
            using (hkgViewportCLR v = m_graphicsCtrl.m_windowHKG.getCurrentViewport())
            {
                using (hkgCameraCLR c = v.getCamera())
                {
                    if (c.getProjectionMode() == hkgCameraCLR.ProjectionMode.PERSPECTIVE)
                    {
                        c.setProjectionMode(hkgCameraCLR.ProjectionMode.COMPUTE_ORTHOGRAPHIC);
                    }

                    hkgVector3CLR fr = getUp();
                    hkgVector3CLR t = new hkgVector3CLR();
                    c.getTo(ref t);
                    hkgVector3CLR f = new hkgVector3CLR();
                    c.getFrom(ref f);
                    hkgVector3CLR d = new hkgVector3CLR();
                    d.setSub(t, f);
                    float dist = d.len();
                    fr.mult(dist); // Up
                    fr.add(t);
                    c.setFrom(fr);
                    c.setUp(getFront());
                    c.computeModelView(false);
                    c.computeProjection();
   
                    m_graphicsCtrl.m_viewportOptions[m_graphicsCtrl.m_windowHKG.getCurrentViewportIndex()].m_cameraType = GraphicsControl.ViewportOptions.CameraType.OrthoTop;
                }
            }
        }

        private void camBottomToolStripMenuItem_Click(object sender, EventArgs e)
        {
            using (hkgViewportCLR v = m_graphicsCtrl.m_windowHKG.getCurrentViewport())
            {
                using (hkgCameraCLR c = v.getCamera())
                {
                    if (c.getProjectionMode() == hkgCameraCLR.ProjectionMode.PERSPECTIVE)
                    {
                        c.setProjectionMode(hkgCameraCLR.ProjectionMode.COMPUTE_ORTHOGRAPHIC);
                    }

                    hkgVector3CLR fr = getUp();
                    hkgVector3CLR t = new hkgVector3CLR();
                    c.getTo(ref t);
                    hkgVector3CLR f = new hkgVector3CLR();
                    c.getFrom(ref f);
                    hkgVector3CLR d = new hkgVector3CLR();
                    d.setSub(t, f);
                    float dist = d.len();
                    fr.mult(-dist); // Right
                    fr.add(t);
                    c.setFrom(fr);
                    c.setUp(getFront());
                    c.computeModelView(false);
                    c.computeProjection();

                    m_graphicsCtrl.m_viewportOptions[m_graphicsCtrl.m_windowHKG.getCurrentViewportIndex()].m_cameraType = GraphicsControl.ViewportOptions.CameraType.OrthoBottom;
                }
            }
        }

        public void setCameraMode( GraphicsControl.ViewportOptions.CameraType c )
        {
            switch (c)
            {
                case GraphicsControl.ViewportOptions.CameraType.Perspective: 
                    camPerspectiveToolStripMenuItem_Click(null, null); break;
                case GraphicsControl.ViewportOptions.CameraType.OrthoBack: 
                    camBackToolStripMenuItem_Click(null, null); break;  
                case GraphicsControl.ViewportOptions.CameraType.OrthoFront: 
                    camFrontToolStripMenuItem_Click(null, null); break;  
                case GraphicsControl.ViewportOptions.CameraType.OrthoLeft: 
                    camLeftToolStripMenuItem_Click(null, null); break;  
                case GraphicsControl.ViewportOptions.CameraType.OrthoRight: 
                    camRightToolStripMenuItem_Click(null, null); break;  
                case GraphicsControl.ViewportOptions.CameraType.OrthoTop: 
                    camTopToolStripMenuItem_Click(null, null); break;  
                case GraphicsControl.ViewportOptions.CameraType.OrthoBottom: 
                    camBottomToolStripMenuItem_Click(null, null); break;  
           }
        }
 
        //
        // Lights
        //

        private void useSceneLightsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (m_graphicsCtrl.SceneHasLighting())
            {
                useSceneLightsToolStripMenuItem.Checked = true;
                sceneLightsToolStripButton.Checked = true;

                singleLightToolStripMenuItem.Checked = false;
                singleDirLightToolStripButton.Checked = false;

                singleLightTrackCameraToolStripMenuItem.Checked = false;
                singleDirLightTrackToolStripButton.Checked = false;

                m_graphicsCtrl.SetSceneLighting(true);
                m_graphicsCtrl.SetCameraLightTracking(false);
            }
            else
            {
                singleLightToolStripMenuItem_Click(sender, e);
            }
        }

        private void lightsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            ToolStripMenuItem mi = (ToolStripMenuItem)sender;
            mi.Checked = !mi.Checked;
            m_graphicsCtrl.SetState(hkgDisplayContextCLR.EnabledState.LIGHTING, mi.Checked);
        }


        private void singleLightToolStripMenuItem_Click(object sender, EventArgs e)
        {
            useSceneLightsToolStripMenuItem.Checked = false;
            sceneLightsToolStripButton.Checked = false;

            singleLightToolStripMenuItem.Checked = true;
            singleDirLightToolStripButton.Checked = true;

            singleLightTrackCameraToolStripMenuItem.Checked = false;
            singleDirLightTrackToolStripButton.Checked = false;

            m_graphicsCtrl.SetSceneLighting(false);
            m_graphicsCtrl.SetCameraLightTracking(false);
        }

        private void singleLightTrackCameraToolStripMenuItem_Click(object sender, EventArgs e)
        {
            useSceneLightsToolStripMenuItem.Checked = false;
            sceneLightsToolStripButton.Checked = false;

            singleLightToolStripMenuItem.Checked = false;
            singleDirLightToolStripButton.Checked = false;

            singleLightTrackCameraToolStripMenuItem.Checked = true;
            singleDirLightTrackToolStripButton.Checked = true;

            m_graphicsCtrl.SetSceneLighting(false);
            m_graphicsCtrl.SetCameraLightTracking(true);
        }

        private void reflectDesiredLightState()
        {
            if (useSceneLightsToolStripMenuItem.Checked)
            {
                useSceneLightsToolStripMenuItem_Click(null, null);
            }
            else if (singleLightToolStripMenuItem.Checked)
            {
                singleLightToolStripMenuItem_Click(null, null);
            }
            else //singleLightTrackCameraToolStripMenuItem
            {
                singleLightTrackCameraToolStripMenuItem_Click(null, null);
            }
        }

        private void sceneLightsToolStripButton_Click(object sender, EventArgs e)
        {
            useSceneLightsToolStripMenuItem_Click(sender, e);
        }

        private void singleDirLightToolStripButton_Click(object sender, EventArgs e)
        {
            singleLightToolStripMenuItem_Click(sender, e);

        }

        private void singleDirLightTrackToolStripButton_Click(object sender, EventArgs e)
        {
            singleLightTrackCameraToolStripMenuItem_Click(sender, e);
        }

        private void setWorldUp(float x, float y, float z)
        {
            using (hkgViewportCLR v = m_graphicsCtrl.m_windowHKG.getCurrentViewport())
            {
                using (hkgCameraCLR c = v.getCamera())
                {
                    hkgVector3CLR upV = new hkgVector3CLR();
                    upV.set(x, y, z);

                    hkgVector3CLR dirV = c.getDir();

                    hkgVector3CLR rightV = new hkgVector3CLR();
                    rightV.setCross(dirV, upV);

                    if (rightV.lenSqrd() < 0.05f)
                    {
                        // need to move dirV a bit
                        hkgVector3CLR addV = new hkgVector3CLR();
                        addV.set(0.1f, 0.1f, 0.1f);
                        dirV.add(addV);

                        // Find new To
                        dirV.add(c.getFrom());
                        c.setTo(dirV);
                    }
                    
                    v.setWorldUp(upV);
                    c.setUp(upV);
                    c.computeModelView(false);
                    c.computeProjection();
                }
            }
            m_flyModeUpVectorExplicit = true;
        }

        private void uncheckFlyModeUpVectors()
        {
            flyModePosXToolStripMenuItem.Checked = false;
            flyModePosYToolStripMenuItem.Checked = false;
            flyModePosZToolStripMenuItem.Checked = false;
            flyModeNegXToolStripMenuItem.Checked = false;
            flyModeNegYToolStripMenuItem.Checked = false;
            flyModeNegZToolStripMenuItem.Checked = false;
        }

        private void flyModePosXToolStripMenuItem_Click(object sender, EventArgs e)
        {
            // +X
            setWorldUp(1.0f, 0.0f, 0.0f);
            uncheckFlyModeUpVectors();
            flyModePosXToolStripMenuItem.Checked = true;
        }

        private void flyModePosYToolStripMenuItem_Click(object sender, EventArgs e)
        {
            // +Y
            setWorldUp(0.0f, 1.0f, 0.0f);
            uncheckFlyModeUpVectors();
            flyModePosYToolStripMenuItem.Checked = true;
        }

        private void flyModePosZToolStripMenuItem_Click(object sender, EventArgs e)
        {
            // +Z
            setWorldUp(0.0f, 0.0f, 1.0f);
            uncheckFlyModeUpVectors();
            flyModePosZToolStripMenuItem.Checked = true;
        }

        private void flyModeNegXToolStripMenuItem_Click(object sender, EventArgs e)
        {
            // -X
            setWorldUp(-1.0f, 0.0f, 0.0f);
            uncheckFlyModeUpVectors();
            flyModeNegXToolStripMenuItem.Checked = true;
        }

        private void flyModeNegYToolStripMenuItem_Click(object sender, EventArgs e)
        {
            // -Y
            setWorldUp(0.0f, -1.0f, 0.0f);
            uncheckFlyModeUpVectors();
            flyModeNegYToolStripMenuItem.Checked = true;
        }

        private void flyModeNegZToolStripMenuItem_Click(object sender, EventArgs e)
        {
            // -Z
            setWorldUp(0.0f, 0.0f, -1.0f);
            uncheckFlyModeUpVectors();
            flyModeNegZToolStripMenuItem.Checked = true;
        }
    }
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
