// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Havok.Tool
{
    delegate void progressStringDelegate( string str );
    delegate void progressFloatDelegate( float v );
    delegate void progressVoidDelegate( );

    public partial class SplashScreen : Form
    {

        public SplashScreen()
        {
          
        }

        public SplashScreen(bool doInit)
        {
            if (doInit)
            {
                InitializeComponent();
            }
        }

        System.Diagnostics.Stopwatch m_startTimer;
        System.Threading.Thread m_splashThread;
        SplashThread m_splashThreadData;

        public void start()
        {
            m_startTimer = System.Diagnostics.Stopwatch.StartNew();
            m_splashThreadData = new SplashThread();

            System.Threading.ThreadStart theThreadStarter = new System.Threading.ThreadStart(m_splashThreadData.Exec);
            m_splashThread = new System.Threading.Thread(theThreadStarter);
            m_splashThread.SetApartmentState(System.Threading.ApartmentState.STA);
            m_splashThread.Start();
        }

        public void end(float secs)
        {
            if (secs > 0)
            {
                float curSec = m_startTimer.ElapsedTicks / (float)System.Diagnostics.Stopwatch.Frequency;
                while (curSec < secs)
                {
                    System.Threading.Thread.Sleep(1);
                    curSec = m_startTimer.ElapsedTicks / (float)System.Diagnostics.Stopwatch.Frequency;
                }
            }

            while ( (m_splashThreadData == null) || (m_splashThreadData.m_splashForm == null) && !m_splashThreadData.m_splashForm.Created )
	        {
                System.Threading.Thread.Sleep(0);
	        }

            m_splashThreadData.m_splashForm.Invoke(new progressVoidDelegate(m_splashThreadData.Close));

            while (m_splashThread.IsAlive)
            {
                System.Threading.Thread.Sleep(1);
            }
        }

        public void setMessage(string msg)
        {
            if ((m_splashThreadData != null) && (m_splashThreadData.m_splashForm != null))
            {
                if (m_splashThreadData.m_splashForm.Created)
                    m_splashThreadData.m_splashForm.Invoke(new progressStringDelegate(m_splashThreadData.SetMessage), msg);
            }
        }

        public void setProgress(float percent)
        {
            if ((m_splashThreadData != null) && (m_splashThreadData.m_splashForm != null))
            {
                if (m_splashThreadData.m_splashForm.Created)
                    m_splashThreadData.m_splashForm.Invoke(new progressFloatDelegate(m_splashThreadData.SetProgress), percent);
            }
        }

        public void setMessageAndProgress(string msg, float progress)
        {
            setMessage(msg);
            setProgress(progress);
        }

        public void showSplash ()
        {
            if ((m_splashThreadData != null) && (m_splashThreadData.m_splashForm != null))
            {
                if (m_splashThreadData.m_splashForm.Created)
                    m_splashThreadData.m_splashForm.Invoke((MethodInvoker) delegate { m_splashThreadData.m_splashForm.Visible = true; });
            }
        }

        public void hideSplash()
        {
            if ((m_splashThreadData != null) && (m_splashThreadData.m_splashForm != null))
            {
                if (m_splashThreadData.m_splashForm.Created)
                    m_splashThreadData.m_splashForm.Invoke((MethodInvoker) delegate { m_splashThreadData.m_splashForm.Visible = false; });
            }

        }
    };

    class SplashThread
    {
   	    public SplashThread( )
	    {
            m_splashForm = null;
	    }

	    public void Exec()
	    {
		    m_splashForm = new SplashScreen(true);
            Application.Run(m_splashForm);
	    }

        public void Close()
	    {
		    m_splashForm.Close();
	    }

        public void SetMessage(string str)
	    {
		    m_splashForm.statusLabel.Text = str;
		    m_splashForm.Update();
	    }

        public void SetProgress(float v)
	    {
		    m_splashForm.progressBar.Value = (int)( v * 100 );
		    m_splashForm.Update();
	    }

	    public SplashScreen m_splashForm;
    };


}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
