// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Havok.Tool.UI
{
    public partial class ServerForm : Form
    {
        public ServerForm(Plugins plugins)
        {
            InitializeComponent();

            m_plugins = plugins;
            m_selectedHost = "localhost";
            m_hostList = new System.Collections.ArrayList();

            portTextBox.Clear();
            portTextBox.AppendText("25011");

            if (!m_hostList.Contains(m_selectedHost)) m_hostList.Add(m_selectedHost);
        }


        private void repopulateIPCombo()
        {
            IPcomboBox.Items.Clear();
            for (int i = 0; i < m_hostList.Count; ++i)
            {
                IPcomboBox.Items.Add(m_hostList[i]);
            }
        }


        private void ServerForm_Load(object sender, EventArgs e)
        {
            repopulateIPCombo();

            connectionStatusLabel.Text = "";

            IPcomboBox.SelectedItem = m_selectedHost;
        }


        private void IPcomboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            ComboBox comboBox = (ComboBox)sender;
            m_selectedHost = (string)comboBox.SelectedItem;
        }


        private void IPcomboBox_SelectedValueChanged(object sender, EventArgs e)
        {
            ComboBox comboBox = (ComboBox)sender;

            if (comboBox.SelectedIndex != -1)
            {
                m_selectedHost = (string)comboBox.SelectedItem;
                if (!m_hostList.Contains(m_selectedHost)) m_hostList.Add(m_selectedHost);
            }
        }


        private void IPcomboBox_keyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.Enter)
            {
                string newHost = IPcomboBox.Text;

                if (!m_hostList.Contains(newHost))
                {
                    m_hostList.Add(newHost);
                    repopulateIPCombo();

                    m_selectedHost = newHost;
                    IPcomboBox.SelectedItem = m_selectedHost;
                }
            }
        }


        private void IPcomboBox_leave(object sender, EventArgs e)
        {
            string newHost = IPcomboBox.Text;

            if (!m_hostList.Contains(newHost))
            {
                m_hostList.Add(newHost);
                repopulateIPCombo();

                m_selectedHost = newHost;
                IPcomboBox.SelectedItem = m_selectedHost;
            }
        }


        private void connectButton_clicked(object sender, MouseEventArgs e)
        {
            int port = Int32.Parse(portTextBox.Text);
            connectionStatusLabel.Text = "";
            if (m_ownListener != null)
            {
                m_ownListener.Stop();
            }

            m_plugins.ServeContentsToHost(m_selectedHost, port, connectionStatusLabel, this);

            if (m_ownListener != null)
            {
                m_ownListener.Start();
            }
        }


        private void portTextBox_validating(object sender, CancelEventArgs e)
        {
            int port;
            if (!Int32.TryParse(portTextBox.Text, out port))
            {
                e.Cancel = true;
                portTextBox.SelectionStart = 0;
                portTextBox.SelectionLength = portTextBox.Text.Length;

                // May want to pop up a dialog reminding user to enter only integers in the port field
            }
        }


        private void formClosing(object sender, FormClosingEventArgs e)
        {
            if (e.CloseReason == CloseReason.UserClosing)
            {
                e.Cancel = true;
                this.Hide();
            }
        }


        Plugins m_plugins;
        public System.Net.Sockets.TcpListener m_ownListener;
        String m_selectedHost;

        System.Collections.ArrayList m_hostList;

    }
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
