// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Havok.Tool.UI
{
	public partial class SaveSceneForm : Form
	{
		public SaveSceneForm()
		{
			InitializeComponent();

			formatComboBox.Items.Add( "XML (Cross Platform Text)" );
			formatComboBox.Items.Add( "HKT (Cross Platform Binary)" );

			// todo.rt should use the list in TypeCopier, but does not link hkBase
			formatComboBox.Items.Add("MSVC x86 (32m)");
			formatComboBox.Items.Add("Arm32, PsVita (32a)");
			formatComboBox.Items.Add("WiiU (32b)");
			formatComboBox.Items.Add("Generic x86 (32g)");
			formatComboBox.Items.Add("MSVC x64, XBoxOne (64m)");
			formatComboBox.Items.Add("Generic x64, Arm64, PS4 (64g)");
	
			formatComboBox.SelectedIndex = 1; //HKT
		}

		public IPlugin.ExportFormat getFormat()
		{
			if (formatComboBox.SelectedIndex == 0)
				return IPlugin.ExportFormat.XML;
			if (formatComboBox.SelectedIndex == 1)
				return IPlugin.ExportFormat.HKT;
			return IPlugin.ExportFormat.HKX;
		}

		public String getLayout()
		{
			if (formatComboBox.SelectedIndex >= 2)
			{
				String item = (String)formatComboBox.SelectedItem;
				return item.Substring(item.IndexOf('(') + 1, 3);
			}
			return null;
		}

		private void browseButton_Click(object sender, EventArgs e)
		{
			SaveFileDialog sfd = new SaveFileDialog();
			sfd.Filter = "Havok Files (*.hkx;*.hkt;*.xml)|*.HKX;*.HKT;*.XML;|XML files (*.xml)|*.xml|Binary Tag files (*.hkt)|*.hkt|Binary HKX files (*.hkx)|*.hkx";
			sfd.FilterIndex = 3;
			sfd.RestoreDirectory = true;
			if (sfd.ShowDialog() == DialogResult.OK)
			{
				filenameTextBox.Text = sfd.FileName;
			}
		}

		private void okButton_Click(object sender, EventArgs e)
		{
			this.DialogResult = DialogResult.OK;
		}

		private void cancelButton_Click(object sender, EventArgs e)
		{
			this.DialogResult = DialogResult.Cancel;
		}
	}
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
