// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Havok.Tool.UI
{
    public partial class GridForm : Form
    {
        public GridForm(GraphicsControl graphicsControl)
        {
            InitializeComponent();

            m_graphicsControl = graphicsControl;
        }

        private void GridForm_Load(object sender, EventArgs e)
        {
            gridEnabledCheckBox.Checked = m_graphicsControl.getCurrentViewportOptions().m_gridEnabled;

            gridXYradioButton.Checked = (m_graphicsControl.m_gridOrientation == GraphicsControl.GridOrientation.GRID_XY);
            gridXZradioButton.Checked = (m_graphicsControl.m_gridOrientation == GraphicsControl.GridOrientation.GRID_XZ);
            gridYZradioButton.Checked = (m_graphicsControl.m_gridOrientation == GraphicsControl.GridOrientation.GRID_YZ);
            gridCellSizeNumericUpDown.Value = Convert.ToDecimal( m_graphicsControl.m_gridCellSize );
        }

        private void gridEnabledCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            m_graphicsControl.getCurrentViewportOptions().m_gridEnabled = gridEnabledCheckBox.Checked;
        }

        private void gridXYradioButton_CheckedChanged(object sender, EventArgs e)
        {
            if (gridXYradioButton.Checked)
	        {
                m_graphicsControl.m_gridOrientation = GraphicsControl.GridOrientation.GRID_XY;
	        }

        }

        private void gridXZradioButton_CheckedChanged(object sender, EventArgs e)
        {
            if (gridXZradioButton.Checked)
            {
                m_graphicsControl.m_gridOrientation = GraphicsControl.GridOrientation.GRID_XZ;
            }
        }

        private void gridYZradioButton_CheckedChanged(object sender, EventArgs e)
        {
            if (gridYZradioButton.Checked)
            {
                m_graphicsControl.m_gridOrientation = GraphicsControl.GridOrientation.GRID_YZ;
            }
        }

        private void gridCellSizeNumericUpDown_ValueChanged(object sender, EventArgs e)
        {
            System.Decimal cellsize = gridCellSizeNumericUpDown.Value;
            m_graphicsControl.m_gridCellSize = System.Decimal.ToSingle(cellsize);
        }


        GraphicsControl m_graphicsControl;

    }
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
