﻿// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0
   
using System;
using System.Collections.Generic;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
using Havok.Graphics;
using Microsoft.Win32;
   
namespace Havok.Tool
{
    partial class GraphicsControl
    {
        protected override void OnInvalidated(InvalidateEventArgs e)
        {
            // may be due to a step request
            float sec = m_pluginStepTimer.ElapsedTicks / (float)Stopwatch.Frequency;

            if (!hkgBaseSystemCLR.inErrorState() && !m_invalidOrUnknownDevice)
            {
                if (m_plugins != null)
                {
                    m_lastStep = sec;
                    for (int pi = 0; pi < m_plugins.GetNumPlugins(); ++pi)
                    {
                        m_plugins.GetPlugin(pi).step(sec);
                    }
                }
            }

            m_pluginStepTimer.Reset();
            m_pluginStepTimer.Start();
            base.OnInvalidated(e);
        }


        // Given the past N position vectors (in a time ordered list with equal time increment), extrapolate to the next position by a linear fit
        public void fit(System.Collections.ArrayList positions, ref hkgVector3CLR next)
        {
            const float epsilon = 1.0e-8f;
            int N = positions.Count;

            hkgVector3CLR sx = new hkgVector3CLR();
            hkgVector3CLR sy = new hkgVector3CLR();
            hkgVector3CLR x = new hkgVector3CLR();
            sx.setZero();
            sy.setZero();

            for (int i = 0; i < N; ++i)
            {
                hkgVector3CLR p = (hkgVector3CLR)positions[i];

                float t = -(N - 1 - i); // time origin at last frame (earlier frames at negative integer times)        

                x.set(t, t, t);
                sx.add(x);
                sy.add(p);
            }

            hkgVector3CLR a = new hkgVector3CLR();
            hkgVector3CLR b = new hkgVector3CLR();
            hkgVector3CLR st2 = new hkgVector3CLR();
            hkgVector3CLR sxoss = new hkgVector3CLR();
            hkgVector3CLR tmp = new hkgVector3CLR();

            b.setZero();
            st2.setZero();
            sxoss = sx;
            sxoss.mult(1.0f / (N + epsilon));

            for (int i = 0; i < N; ++i)
            {
                hkgVector3CLR p = (hkgVector3CLR)positions[i];

                float t = -(N - 1 - i); // take time origin at last frame (so earlier frames at negative integer times)        

                x.set(t, t, t);
                tmp.setSub(x, sxoss);

                st2.X += tmp.X * tmp.X;
                st2.Y += tmp.Y * tmp.Y;
                st2.Z += tmp.Z * tmp.Z;

                b.X += tmp.X * p.X;
                b.Y += tmp.Y * p.Y;
                b.Z += tmp.Z * p.Z;
            }

            b.X /= st2.X + epsilon;
            b.Y /= st2.Y + epsilon;
            b.Z /= st2.Z + epsilon;

            a.X = (sy.X - sx.X * b.X) / (N + epsilon);
            a.Y = (sy.Y - sx.Y * b.Y) / (N + epsilon);
            a.Z = (sy.Z - sx.Z * b.Z) / (N + epsilon);

            // Fit at next frame is y(t) = a + bt at t=1, i.e. y = a + b.
            next.setAdd(a, b);
        }

        public void _gridLine(float x0, float y0, float x1, float y1, float oX, float oY,
                              float gridEdgeLength, ref hkgDisplayContextCLR context, int localXaxis, int localYaxis,
                              ref hkgVector3CLR p, ref hkgVector4CLR color0, ref hkgVector4CLR color1, float alpha)
        {
            float r0 = 4.2f * ((x0 / gridEdgeLength) * (x0 / gridEdgeLength) + (y0 / gridEdgeLength) * (y0 / gridEdgeLength));
            float r1 = 4.2f * ((x1 / gridEdgeLength) * (x1 / gridEdgeLength) + (y1 / gridEdgeLength) * (y1 / gridEdgeLength));

            color0.set(1.0f, 1.0f, 1.0f, alpha);
            color1.set(1.0f, 1.0f, 1.0f, alpha);
            p.setZero();

            p[localXaxis] = x0 + oX;
            p[localYaxis] = y0 + oY;

            context.setCurrentColor4(color0);
            context.setCurrentPosition(p);

            p[localXaxis] = x1 + oX;
            p[localYaxis] = y1 + oY;
            context.setCurrentColor4(color1);
            context.setCurrentPosition(p);
        }


        public void drawGrid(ref hkgDisplayContextCLR context, ref hkgCameraCLR camera)
        {
            context.lockContext();

            int localXaxis = 0;
            int localYaxis = 0;

            switch (m_gridOrientation)
            {
                case GridOrientation.GRID_XY: localXaxis = 0; localYaxis = 1; break;
                case GridOrientation.GRID_XZ: localXaxis = 0; localYaxis = 2; break;
                case GridOrientation.GRID_YZ: localXaxis = 1; localYaxis = 2; break;
            }

            // Number of grid squares to render in each direction
            const int nSquares = 100;
            float gridEdgeLength = nSquares * m_gridCellSize;

            // Take grid origin (oX, oY) at world origin.
            float oX = 0.0f;
            float oY = 0.0f;

            hkgDisplayContextCLR.EnabledState restoreState = context.getEnabledState();
            hkgDisplayContextCLR.CullFaceMode restoreCM = context.getCullfaceMode();
            hkgDisplayContextCLR.BlendMode restoreBM = context.getBlendMode();

            context.matchState(hkgDisplayContextCLR.EnabledState.ALPHABLEND | hkgDisplayContextCLR.EnabledState.ZREAD,
                               hkgDisplayContextCLR.CullFaceMode.CCW,
                               hkgDisplayContextCLR.BlendMode.ADD);
            context.beginGroup(hkgDisplayContextCLR.ImmGroup.LINES);

            hkgVector3CLR p = new hkgVector3CLR();
            hkgVector4CLR color0 = new hkgVector4CLR();
            hkgVector4CLR color1 = new hkgVector4CLR();

            for (int i = 0; i <= nSquares; ++i)
            {
                float x = -0.5f * gridEdgeLength + i * m_gridCellSize;
                float alpha = (i % 10) == 0 ? 1.0f : 0.15f;
                _gridLine(x, 0.0f, x, 0.5f * gridEdgeLength, oX, oY, gridEdgeLength, ref context, localXaxis, localYaxis, ref p, ref color0, ref color1, alpha);
                _gridLine(x, 0.0f, x, -0.5f * gridEdgeLength, oX, oY, gridEdgeLength, ref context, localXaxis, localYaxis, ref p, ref color0, ref color1, alpha);
            }

            for (int i = 0; i <= nSquares; ++i)
            {
                float y = -0.5f * gridEdgeLength + i * m_gridCellSize;
                float alpha = (i % 10) == 0 ? 1.0f : 0.15f;
                _gridLine(0.0f, y, 0.5f * gridEdgeLength, y, oX, oY, gridEdgeLength, ref context, localXaxis, localYaxis, ref p, ref color0, ref color1, alpha);
                _gridLine(0.0f, y, -0.5f * gridEdgeLength, y, oX, oY, gridEdgeLength, ref context, localXaxis, localYaxis, ref p, ref color0, ref color1, alpha);
            }

            context.endGroup(false);

            context.matchState(restoreState, restoreCM, restoreBM);

            context.unlockContext();
        }

       

        void drawAxis(hkgDisplayContextCLR ctx, float scale)
        {
	        uint color = 0xff0000;
        	float[] unitAxisLines = new float[ (5 + 6 + 6) * 6]
            {
	            // -, >, X (5 Lines)
	            0,0,0,1,0,0,  
	            1,0,0,0.85f,0.1f,0, 
	            1,0,0,0.85f,-0.1f,0,   
	            1.1f,0.1f,0,1.2f,-0.1f,0, 
	            1.2f,0.1f,0,1.1f,-0.1f,0,

	            // -, >, Y (6 lines)
	            0,0,0,0,1,0,  
	            0,1,0,0.1f,0.85f,0, 
	            0,1,0,-0.1f,0.85f,0, 
	            0.1f,1.1f,0,0,1.15f,0,
	            0.1f,1.2f,0,0,1.15f,0,
	            0,1.15f,0,-0.1f,1.15f,0,

	            // -, >, Z (6 lines)
	            0,0,0,0,0,1,
	            0,0,1,0.1f,0,0.85f,
	            0,0,1,-0.1f,0,0.85f,
	            0.1f,0,1.1f,0.1f,0,1.2f,
	            0.1f,0,1.2f,-0.1f,0,1.1f,
	            -0.1f,0,1.1f,-0.1f,0,1.2f,
            };	

	        ctx.beginGroup( hkgDisplayContextCLR.ImmGroup.LINES );
            {
		        int cp = 0;
                hkgVector3CLR vs = new hkgVector3CLR();
                hkgVector3CLR cpv = new hkgVector3CLR();
		        int i;
		        for(i = 0; i < 5; i++)
		        {
			        ctx.setCurrentColorPacked(color | 0xff000000);
                    cpv.set( unitAxisLines[cp++],unitAxisLines[cp++],unitAxisLines[cp++]);
                    vs.setMult(cpv, scale);
			        ctx.setCurrentPosition(vs);
                    cpv.set( unitAxisLines[cp++],unitAxisLines[cp++],unitAxisLines[cp++]);
			        vs.setMult(cpv, scale);
			        ctx.setCurrentColorPacked(color | 0xff000000);
			        ctx.setCurrentPosition(vs);
		        }
		        color = (color >> 8);
		        for(i = 0; i < 6; i++)
		        {
			        ctx.setCurrentColorPacked(color | 0xff000000);
			        cpv.set( unitAxisLines[cp++],unitAxisLines[cp++],unitAxisLines[cp++]);
                    vs.setMult(cpv, scale);
			        ctx.setCurrentPosition(vs);
			        ctx.setCurrentColorPacked(color | 0xff000000);
			        cpv.set( unitAxisLines[cp++],unitAxisLines[cp++],unitAxisLines[cp++]);
                    vs.setMult(cpv, scale);	
			        ctx.setCurrentPosition(vs);
		        }
		        color = (color >> 8);
		        for(i = 0; i < 6; i++)
		        {
			        ctx.setCurrentColorPacked(color | 0xff000000);
			        cpv.set( unitAxisLines[cp++],unitAxisLines[cp++],unitAxisLines[cp++]);
                    vs.setMult(cpv, scale);
			        ctx.setCurrentPosition(vs);
			        ctx.setCurrentColorPacked(color | 0xff000000);
			        cpv.set( unitAxisLines[cp++],unitAxisLines[cp++],unitAxisLines[cp++]);
                    vs.setMult(cpv, scale);
			        ctx.setCurrentPosition(vs);
		        }
            }
	        ctx.endGroup(false);
        }

        protected override void OnPaint(PaintEventArgs e)
        {
            if (!hkgBaseSystemCLR.inErrorState() && (m_windowHKG != null))
            {
                hkgDisplayContextCLR context = m_windowHKG.getContext();
                context.lockContext();

                if (!m_windowHKG.inViewportResize())
                {
                    if (m_currentViewportSettings != m_windowHKG.getCurrentViewportIndex())
                    {
                        m_currentViewportSettings = m_windowHKG.getCurrentViewportIndex();
                        m_toolUI.reflectViewportSettings();
                    }

                    // Clear the buffers
                    if (m_windowHKG.clearBuffers())
                    {
                        m_invalidOrUnknownDevice = false;

                        for (int vi = 0; vi < m_windowHKG.getNumViewports(); ++vi)
                        {
                            hkgViewportCLR viewport = m_windowHKG.getViewport(vi);
                            // Set the camera and state if needed
                            viewport.setAsCurrent(context);

                            ViewportOptions viewOptions = m_viewportOptions[vi];

                            hkgLightManagerCLR lightManager = m_displayWorldHKG.getLightManager();
                            hkgCameraCLR camera = viewport.getCamera();

                            // Follow-cam mode
                            if (m_followCamActive)
                            {
                                hkgDisplayObjectCLR obj = m_toolUI.getSelectedObject();

                                if (obj != null)
                                {
                                    // Get the current cameras direction, as we want this to remain constant
                                    hkgVector3CLR direction = camera.getFrom();
                                    direction.sub(camera.getTo());

                                    // Get the target to for the camera
                                    hkgVector3CLR targetTo = new hkgVector3CLR();
                                    {
                                        hkgVector3CLR aabbMin = new hkgVector3CLR();
                                        hkgVector3CLR aabbMax = new hkgVector3CLR();
                                        obj.getAABB(ref aabbMin, ref aabbMax);

                                        targetTo.setSub(aabbMax, aabbMin);
                                        targetTo.setMult(targetTo, 0.5f);
                                        targetTo.setAdd(targetTo, aabbMin);
                                    }

                                    // Now we know the target to, we know the cameras current to, so we can damp between them
                                    targetTo.sub(camera.getTo());
                                    targetTo.mult(m_followCamSmoothness);
                                    targetTo.add(camera.getTo());

                                    // Set the new to and from
                                    camera.setTo(targetTo);
                                    direction.add(targetTo);
                                    camera.setFrom(direction);

                                    // Update
                                    camera.computeModelView(false);
                                    camera.setAsCurrent(context);
                                }
                            }

                            // different flash per camera
                            if (m_defaultLightTrackCamera)
                            {
                                hkgVector3CLR camUp = new hkgVector3CLR();
                                camera.getUp(ref camUp);
                                hkgVector3CLR upOffset = new hkgVector3CLR();
                                upOffset.setMult(camUp, -0.1f);

                                camera.getRight(ref camUp);
                                hkgVector3CLR rightOffset = new hkgVector3CLR();
                                rightOffset.setMult(camUp, -0.1f);

                                camera.getDir(ref camUp);

                                hkgVector3CLR dirOffset = new hkgVector3CLR();
                                dirOffset.setAdd(camUp, upOffset);
                                dirOffset.setAdd(dirOffset, rightOffset);

                                m_defaultLight.setDirection(dirOffset);
                            }

                            m_plugins.FirePreWorldRender(viewport);

                            if (viewOptions.m_shadowsEnabled && (lightManager.getActiveSetSize() > 0))
                            {
                                hkgAabbCLR worldBounds = new hkgAabbCLR();
                                m_displayWorldHKG.getShadowWorldBounds(worldBounds, camera);
                                hkgLightCLR light = lightManager.getActiveSetLight(0);
                                hkgCameraCLR lightCam = hkgCameraCLR.createFixedShadowFrustumCamera(light, worldBounds, true, 0, 0);
                                m_windowHKG.setShadowMapMode(hkgWindowCLR.ShadowMapMode.FIXED, lightCam);
                                light.Dispose();
                                lightCam.Dispose();
                                worldBounds.Dispose();
                            }

                            // Render all objs in the world
                            try
                            {
                                m_displayWorldHKG.render(context, m_frustumCullEnabled, viewOptions.m_shadowsEnabled, false);
                            }
                            catch (Exception)
                            {
                                Console.WriteLine("HKG: m_displayWorldHKG.render() failed with an exception!");

                            }

                            context.setCurrentMaterial(null, null);

                            // Tangent space display
                            if (viewOptions.m_displayNormals || viewOptions.m_displayTangents || viewOptions.m_displayBiTangents)
                            {
                                for (int i = 0; i < m_displayWorldHKG.getNumDisplayObjects(); ++i)
                                {
                                    hkgDisplayObjectCLR dobj = m_displayWorldHKG.getDisplayObject(i);
                                    dobj.drawTangentSpace(viewOptions.m_displayNormals, viewOptions.m_displayTangents, viewOptions.m_displayBiTangents, context);
                                    dobj.Dispose();
                                }
                            }

                            // Edged faces display
                            if (viewOptions.m_displayEdgedFaces)
                            {
                                hkgDisplayContextCLR.EnabledState origEnabledState = context.getEnabledState();
                                hkgDisplayContextCLR.EnabledState wireframeEnabled = (origEnabledState & hkgDisplayContextCLR.EnabledState.WIREFRAME);

                                if (wireframeEnabled == 0)
                                {
                                    // Render wireframe, unlit, with the camera very slightly closer (polygon offset not available in HKG at the moment)
                                    hkgDisplayContextCLR.ColorMode origColorMode = context.getColorMode();
                                    hkgDisplayContextCLR.BlendMode origBlendMode = context.getBlendMode();

                                    context.setWireframeState(true);
                                    context.setDepthReadState(true);
                                    context.setDepthWriteState(false);
                                    context.setLightingState(false);
                                    context.setTexture2DState(false);
                                    context.setBlendState(true);

                                    // Most assets will be loaded using the ShaderLib
                                    // Currently that lib only supports lit senarios
                                    // wheras here we want the wireframe to be unlit etc.
                                    // So we will enforce no shader

                                    // Render white wireframe with low alpha
                                    hkgVector4CLR wireColor = new hkgVector4CLR();
                                    wireColor.set(1, 1, 1, 0.1f);
                                    hkgMaterialCLR globalWireMaterial = new hkgMaterialCLR();
                                    globalWireMaterial.setDiffuseColor(wireColor);
                                    context.setCurrentMaterial(globalWireMaterial, null); // Global mat
                                    globalWireMaterial.Dispose();

                                    context.setColorMode(hkgDisplayContextCLR.ColorMode.GLOBAL | hkgDisplayContextCLR.ColorMode.GLOBAL_SHADER_COLLECTION);

                                    hkgVector3CLR origFrom, currentTo;
                                    origFrom = camera.getFrom();
                                    currentTo = camera.getTo();

                                    hkgVector3CLR newFrom = new hkgVector3CLR();
                                    newFrom.setSub(currentTo, origFrom);
                                    newFrom.mult(1.0e-3f);
                                    newFrom.add(origFrom);
                                    camera.setFrom(newFrom);
                                    camera.computeModelView(false);
                                    camera.setAsCurrent(context);

                                    // Render from this shifted POV
                                    m_displayWorldHKG.render(context, m_frustumCullEnabled, false, false);

                                    // Reset context mode
                                    context.setColorMode(origColorMode);
                                    context.matchState(origEnabledState, context.getCullfaceMode(), origBlendMode);
                                    camera.setFrom(origFrom);
                                    camera.computeModelView(false);
                                    camera.setAsCurrent(context);
                                }
                            }

                            if (viewOptions.m_gridEnabled)
                            {
                                drawGrid(ref context, ref camera);
                            }

                            // Axis icon
                            {
                                hkgDisplayContextCLR.EnabledState origEnabledState = context.getEnabledState();
                                context.matchState(0, context.getCullfaceMode(), context.getBlendMode());

                                // un project the point which is 10 up from the lower right
                                hkgMatrix4CLR m = new hkgMatrix4CLR();
                                hkgVector3CLR res = new hkgVector3CLR();
                                hkgVector3CLR ad = new hkgVector3CLR();
                                m.setIdentity();
                                camera.unProject(40, 40, 0.2f, viewport.getWidth(), viewport.getHeight(), ref res);
                                ad.setSub(camera.getFrom(), res);
                                float dist = ad.len();
                                float drawSize = camera.computeIconVerticalDrawSize(dist, 32, viewport.getHeight());
                                context.pushMatrix();
                                m.m03 = res.X;
                                m.m13 = res.Y;
                                m.m23 = res.Z;
                                context.multMatrix(m);
                                drawAxis(context, drawSize);
                                context.popMatrix();
                                context.matchState(origEnabledState, context.getCullfaceMode(), context.getBlendMode());
                            }

                            m_plugins.FirePostWorldRender(viewport);

                            viewport.Dispose();
                            lightManager.Dispose();
                            camera.Dispose();
                        }

                        m_windowHKG.applyPostEffects();

                        // Draw any extra text info (after post effects)
                    /*
                        using (hkgViewportCLR orthoView = m_windowHKG.getWindowOrthoView())
                        {
                            hkgViewportCLR activeView = m_windowHKG.getCurrentViewport();
                            orthoView.setAsCurrent(context);
                            m_displayFont.setDrawState(context);
                            hkgVector4CLR black = new hkgVector4CLR(); black.set(0,0,0,0.5f);
                            hkgVector4CLR white = new hkgVector4CLR(); white.set(1.0f, 1.0f, 1.0f, 0.5f);

                            int urX = 0;
                            int urY = 0;
                            int llX = 0;
                            int llY = 0;
                            activeView.getUpperRightCoord(ref urX, ref urY);
                            activeView.getLowerLeftCoord(ref llX, ref llY);

                            m_displayFont.render(context, "Some Text", llX + 11, urY - 21, black);
                            m_displayFont.render(context, "Some Text", llX + 10, urY - 20, white);

                            activeView.Dispose();
                        }
                    */


                        //m_displayWorldHKG.finalRender(ctx, true /* frustum cull */);

                        m_windowHKG.stepInput();

                        // Swap the back buf to the front so we can see what we have drawn
                        m_windowHKG.swapBuffers();

                        // Tick world (rewuired for Motion Blur effects etc)
                        {
                            int frameNum = context.advanceFrame();
                            if (m_displayWorldHKG != null)
                            {
                                // assumes shared world between all views (otherwise, step others too)
                                m_displayWorldHKG.advanceToFrame(frameNum, true, m_windowHKG);
                            }

                            for (int tvi = 0; tvi < m_windowHKG.getNumViewports(); ++tvi)
                            {
                                hkgViewportCLR viewport = m_windowHKG.getViewport(tvi);
                                hkgCameraCLR vcam = viewport.getCamera();
                                vcam.advanceToFrame(frameNum);
                                vcam.Dispose();
                                viewport.Dispose();
                            }
                        }

                    }
                    else
                    {
                        m_invalidOrUnknownDevice = true;

                        this.Invalidate(); // Paint again (as we will need to get the window context back at some stage and redtaw).
                    }
                }
                else // viewport resize (no draw)
                {
                    m_windowHKG.doViewportResizeDraw();
                }
                context.unlockContext();
                context.Dispose();
            }
        }
    }
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
