// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Havok.Graphics;

namespace Havok.Tool
{
    public partial class ErrorConsoleForm : Form, Havok.Tool.IConsole
    {
        public ErrorConsoleForm()
        {
            InitializeComponent();

            errorReportDelegate = new hkgErrorReportDelegate(this.havokErrorMessage);
            hkgBaseSystemCLR.addReportDelegate( this, errorReportDelegate );
        }

        public void havokErrorMessage( String message )
        {
            IConsole.MessageType t = IConsole.MessageType.REPORT;
            if ( message.StartsWith("Warning:", System.StringComparison.InvariantCultureIgnoreCase ) )
            {
	            t = IConsole.MessageType.WARNING;
            }
            else if ( message.StartsWith("Error:", System.StringComparison.InvariantCultureIgnoreCase ) )
            {
                t = IConsole.MessageType.ERROR;
            }
        
            addMessage(t, message);
        }
      
        //IConsole i/f
        public void addMessage(IConsole.MessageType t, String message)
        {
            textBox.SelectionStart = textBox.MaxLength;

            message.Replace("\n", "\r\n");
            message += "\r\n";

	        switch (t)
            {
                case IConsole.MessageType.ERROR:
                    textBox.SelectionColor = Color.Red; // Errors should not normally get here as thete is a Assert handler before this
                    break;

                case IConsole.MessageType.WARNING:
                    textBox.SelectionColor = Color.Red;
                    break;

                default:
                case IConsole.MessageType.REPORT:
                    textBox.SelectionColor = Color.GreenYellow;
                    break;
            }

            textBox.SelectedText = message;
                        
            Refresh();
        }

        private void ErrorConsoleForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (e.CloseReason == CloseReason.UserClosing)
            {
                e.Cancel = true;
                this.WindowState = FormWindowState.Minimized;// as no show in task bar, this is actually hidden
            }
        }

        private void ErrorConsoleForm_Resize(object sender, EventArgs e)
        {
            if (this.WindowState == FormWindowState.Minimized)
            {
                this.Hide();
            }
        }

        hkgErrorReportDelegate errorReportDelegate;
    }
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
