// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Havok.Graphics;

namespace Havok.Tool
{
    public partial class EditCameraForm : Form
    {
        public EditCameraForm()
        {
            InitializeComponent();
        }

        public void SetGraphicsControl( GraphicsControl c )
        {
            hkgViewportCLR view = c.m_windowHKG.getCurrentViewport();
            m_graphicsCtrl = c;
            m_camera = view.getCamera();

            hkgVector3CLR v = new hkgVector3CLR();
            m_camera.getFrom(ref v);
            fromX.Text = ((Single)v.X).ToString();
            fromY.Text = ((Single)v.Y).ToString();
            fromZ.Text = ((Single)v.Z).ToString();

            m_camera.getTo(ref v);
            toX.Text = ((Single)v.X).ToString();
            toY.Text = ((Single)v.Y).ToString();
            toZ.Text = ((Single)v.Z).ToString();

            m_camera.getUp(ref v);
            upX.Text = ((Single)v.X).ToString();
            upY.Text = ((Single)v.Y).ToString();
            upZ.Text = ((Single)v.Z).ToString();

            nearVal.Text = ((Single)m_camera.getNear()).ToString();
            farVal.Text = ((Single)m_camera.getFar()).ToString();
            fovVal.Text = ((Single)m_camera.getFOV()).ToString();

            smoothnessVal.Text = ((Single)m_graphicsCtrl.m_followCamSmoothness).ToString();

            perspRadioButton.Checked = m_camera.getProjectionMode() == hkgCameraCLR.ProjectionMode.PERSPECTIVE;
            orthoRadioButton.Checked = !perspRadioButton.Checked;
        }

        private void ApplySettings()
        {
            if (m_camera != null)
            {
                hkgVector3CLR fromV = new hkgVector3CLR();
                hkgVector3CLR toV = new hkgVector3CLR();
                hkgVector3CLR upV = new hkgVector3CLR();
                Single val;

                bool ok = Single.TryParse(fromX.Text, out fromV.X);
                ok &= Single.TryParse(fromY.Text, out fromV.Y);
                ok &= Single.TryParse(fromZ.Text, out fromV.Z);

                ok &= Single.TryParse(toX.Text, out toV.X);
                ok &= Single.TryParse(toY.Text, out toV.Y);
                ok &= Single.TryParse(toZ.Text, out toV.Z);

                ok &= Single.TryParse(upX.Text, out upV.X);
                ok &= Single.TryParse(upY.Text, out upV.Y);
                ok &= Single.TryParse(upZ.Text, out upV.Z);
                
                // Make sure the vectors are valid and that they are not the same
                if (ok && !fromV.equals(toV, 0.00001f))
                {
                    m_camera.setFrom(fromV);
                    m_camera.setTo(toV);
                    m_camera.setUp(upV);
                }

                if (Single.TryParse(nearVal.Text, out val)) { m_camera.setNear(val); }
                if (Single.TryParse(farVal.Text, out val)) { m_camera.setFar(val); }
                if (Single.TryParse(fovVal.Text, out val)) { m_camera.setFOV(val); }

                if (Single.TryParse(smoothnessVal.Text, out val) && val >= 0.0f && val <= 1.0f)
                {
                    m_graphicsCtrl.m_followCamSmoothness = val;
                }

                m_camera.computeModelView(false);
                m_camera.setProjectionMode(perspRadioButton.Checked ? hkgCameraCLR.ProjectionMode.PERSPECTIVE : hkgCameraCLR.ProjectionMode.COMPUTE_ORTHOGRAPHIC);
                m_camera.computeProjection();
            }
        }


        private void okButton_Click(object sender, EventArgs e)
        {
            ApplySettings();

            DialogResult = DialogResult.OK;
        }

        private void cancelButton_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
        }

        GraphicsControl m_graphicsCtrl;
        hkgCameraCLR m_camera;
    }
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
