// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

using System;
using Havok.Graphics;
using Havok.Tool;
   
namespace Havok.Tool
{

    public partial class GraphicsControl
    {

        public PickInfo pick(ref float depth)
        {
            hkgViewportCLR v = m_windowHKG.getCurrentViewport();
            hkgCameraCLR c = v.getCamera();
            int vx = 0;
            int vy = 0;
            v.getLowerLeftCoord(ref vx, ref vy);

            hkgViewportPickDataCLR pd = new hkgViewportPickDataCLR();

            int x = m_windowHKG.getMouse().getPosX() - vx;
            int y = m_windowHKG.getMouse().getPosY() - vy;

            PickInfo pickObj = null;
            depth = -1;
            if (v.pick(x, y, m_displayWorldHKG, pd))
            {
                hkgVector3CLR mousePosWorldSpace = pd.getClosestObjectWorldPos();
                hkgVector3CLR result = new hkgVector3CLR();
                c.project(mousePosWorldSpace[0], mousePosWorldSpace[1], mousePosWorldSpace[2], v.getWidth(), v.getHeight(), ref result);
                depth = result[2];	// remember the z value

                // find out if there is a (the first one) demo that has a rigid body attached
                // to this display object
                pickObj = new PickInfo();
                pickObj.m_object = m_displayWorldHKG.getDisplayObject( pd.getClosestObjectIndex() );
                pickObj.m_faceSetIndex = 0;
                
                hkgGeometryCLR pickedGeom = null;

                pickObj.m_geomIndex = pd.getClosestGeometryIndex();
                if ((pickObj.m_object.getStatusFlags() & hkgDisplayObjectCLR.ObjectStatus.INSTANCED) != 0)
                {
                    // XXX proper fix this, for now dont let it crash on instanced geometries
                    pickedGeom = pickObj.m_object.getGeometry(0);
                }
                else
                {
                    pickedGeom = pickObj.m_object.getGeometry(pd.getClosestGeometryIndex());

                    // Flatten the indexes so that it is easier to understand:	                	                
                    for (int g = 0; g < pd.getClosestGeometryIndex(); ++g)
                    {
                        hkgGeometryCLR geom = pickObj.m_object.getGeometry(g);
                        int mfs = geom.getNumMaterialFaceSets();
                        for (int mi = 0; mi < mfs; ++mi)
                        {
                            hkgMaterialFaceSetCLR mfss = geom.getMaterialFaceSet(mi);
                            pickObj.m_faceSetIndex += mfss.getNumFaceSets();
                            mfss.Dispose();
                        }

                        geom.Dispose();
                    }
                 }

                {
                    hkgDisplayObjectPickDataCLR displayObjectPickData = pd.getObjectPickData(0);
                    hkgGeometryPickDataCLR geomPickData = displayObjectPickData.getGeomPickData(0);
                    hkgFaceSetPickDataCLR fpd = geomPickData.getFacePickData(0);
                    for (int msi = 0; msi < fpd.getMatFaceSetIndex(); ++msi)
                    {
                        hkgMaterialFaceSetCLR mfss = pickedGeom.getMaterialFaceSet(msi);
                        pickObj.m_faceSetIndex += mfss.getNumFaceSets();
                        mfss.Dispose();
                    }

                    hkgMaterialFaceSetCLR mfs = pickedGeom.getMaterialFaceSet(fpd.getMatFaceSetIndex());
                    pickObj.m_faceSetIndex += fpd.getMatFaceSetSubIndex();
                    pickObj.m_facePrimIndex = fpd.getPrimIndex();
                    pickObj.m_faceIndex = fpd.getPrimTriIndex();

                    int v0 = 0;
                    int v1 = 0;
                    int v2 = 0;
                    fpd.getVertexIndices(ref v0, ref v1, ref v2);

                    pickObj.m_vertexIndices[0] = v0;
                    pickObj.m_vertexIndices[1] = v1;
                    pickObj.m_vertexIndices[2] = v2;

                    pickObj.m_localPos = pd.getClosestGeometryLocalPos();
                    pickObj.m_closestVert = -1;// todo

                    pickedGeom.Dispose();
                    mfs.Dispose();
                    fpd.Dispose();
                    geomPickData.Dispose();
                    displayObjectPickData.Dispose();
                }                
 	        }

            pd.Dispose();
            v.Dispose();
            c.Dispose();
            return pickObj;
        }

        public hkgVector3CLR getMouseInWorld(float depth)
        {
            hkgViewportCLR v = m_windowHKG.getCurrentViewport();
            hkgCameraCLR c = v.getCamera();
            int vx = 0;
            int vy = 0;
            v.getLowerLeftCoord(ref vx, ref vy);

            int x = m_windowHKG.getMouse().getPosX() - vx;
            int y = m_windowHKG.getMouse().getPosY() - vy;

            hkgVector3CLR res = new hkgVector3CLR();
            c.unProject(x, y, depth, v.getWidth(), v.getHeight(), ref res);

            v.Dispose();
            c.Dispose();
            return res;   
        }

        public void SetNearFarClipping(float dl)
        {
            hkgViewportCLR view = m_windowHKG.getCurrentViewport();
            hkgCameraCLR cam = view.getCamera();

            if (cam.getFar() < (dl * 20))
                cam.setFar(dl * 20);
            else if (cam.getFar() > (dl * 200))
                cam.setFar(dl * 200);

            if (cam.getNear() < (dl * 0.001f))
                cam.setNear(dl * 0.001f);
            else if (cam.getNear() > (dl * 0.01f))
                cam.setNear(dl * 0.01f);
        }
        
        public void FitCameraToWorld()
        {
	        int ndo = m_displayWorldHKG.getNumDisplayObjects();
	        if (ndo < 1)
	        {
		        return;
	        }

	        hkgVector3CLR minP = new hkgVector3CLR();
	        hkgVector3CLR maxP = new hkgVector3CLR();
             
            hkgVector3CLR minO = new hkgVector3CLR();
            hkgVector3CLR maxO = new hkgVector3CLR();
		        

	        minP.set(float.MaxValue, float.MaxValue, float.MaxValue);
            maxP.set(-float.MaxValue, -float.MaxValue, -float.MaxValue);

	        for (int i = 0; i < ndo; ++i)
	        {
		        hkgDisplayObjectCLR o = m_displayWorldHKG.getDisplayObject(i);
		        if (!o.hasAABB())
			        o.computeAABB();

                o.getAABB( ref minO, ref maxO );

		        for( int j =0; j < 3; ++j)
		        {
                    if (minO[j] < minP[j])
                        minP[j] = minO[j];

			        if ( maxO[j] > maxP[j])
				        maxP[j] = maxO[j];
		        }

                o.Dispose();
	        }

	        FitCameraToAABB( minP, maxP );
        }

        public void FitCameraToObject(hkgDisplayObjectCLR obj)
        {
	        if (obj==null)
	        {
		        FitCameraToWorld();
		        return;
	        }
   
	        hkgVector3CLR minP = new hkgVector3CLR();
            hkgVector3CLR maxP = new hkgVector3CLR();
             
            minP.set(float.MaxValue, float.MaxValue, float.MaxValue);
            maxP.set(-float.MaxValue, -float.MaxValue, -float.MaxValue);

	        if (!obj.hasAABB())
                obj.computeAABB();

            obj.getAABB(ref minP, ref maxP);
            FitCameraToAABB( minP, maxP );
        }

        public void NormaliseCameraUp()
        {
            hkgViewportCLR view = m_windowHKG.getCurrentViewport();
            hkgCameraCLR cam = view.getCamera();

            hkgVector3CLR worldUp = view.getWorldUp();
            if (cam.getUp().dot(view.getWorldUp()) > 0)
                cam.setUp(worldUp);
            else
            {
                worldUp.mult(-1.0f);
                cam.setUp(worldUp);
            }
        }

        public void FocusCameraOnObject(hkgDisplayObjectCLR obj)
        {
            if (obj == null)
            {
                FitCameraToWorld();
                return;
            }

            hkgViewportCLR view = m_windowHKG.getCurrentViewport();
            hkgCameraCLR cam = view.getCamera();

            // Find AABB
            if (!obj.hasAABB())
                obj.computeAABB();
            hkgVector3CLR minP = new hkgVector3CLR();
            hkgVector3CLR maxP = new hkgVector3CLR();
            obj.getAABB(ref minP, ref maxP);

            // Calculate center of AABB for look at vector
            hkgVector3CLR to = new hkgVector3CLR();
            to.setSub(maxP, minP);
            to.setMult(to, 0.5f);
            to.setAdd(to, minP);
            cam.setTo(to);

            hkgVector3CLR from = cam.getFrom();
            hkgVector3CLR dist = new hkgVector3CLR(); 
            dist.setSub(to, from);
            float dl = dist.len();

            SetNearFarClipping(dl);
            NormaliseCameraUp();

            cam.computeModelView(false);
            cam.computeProjection();

            view.Dispose();
            cam.Dispose();
        }

        public void FitCameraToAABB(hkgVector3CLR minP, hkgVector3CLR maxP)
        {
            hkgViewportCLR view = m_windowHKG.getCurrentViewport();
	        hkgCameraCLR cam = view.getCamera();

            cam.setFOV(45);

            // Now all we need is to figure out how far away we need to be
            float fov = 45.0f * ((float)Math.PI) / 180.0f;
            float factor = 2.0f * ((float)Math.Tan(fov * 0.5f));
            hkgVector3CLR diagonal = new hkgVector3CLR();
            diagonal.setSub(maxP, minP);
            float distance = diagonal.len() / (factor * cam.getAspect());
            distance *= 1.5f;

            // Calculate to
            hkgVector3CLR to = new hkgVector3CLR();
            to.setSub(maxP, minP);
            to.setMult(to, 0.5f);
            to.setAdd(to, minP);

            // Set camera from
            hkgVector3CLR from = cam.getDir();
            from.setMult(from, distance);
            from.setSub(to, from);
            cam.setTo(to);
            cam.setFrom(from);

            SetNearFarClipping(distance);
            NormaliseCameraUp();

	        cam.computeModelView(false);
	        cam.computeProjection();

            view.Dispose();
            cam.Dispose();
        }

    }; // Impl

} //Namespace

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
