// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;
using System.Reflection;
using Microsoft.Win32;

namespace Havok.Tool.UI
{
    partial class AboutForm : Form
    {
        public AboutForm()
        {
            InitializeComponent();

            //  Initialize the AboutBox to display the product information from the assembly information.
            //  Change assembly information settings for your application through either:
            //  - Project->Properties->Application->Assembly Information
            //  - AssemblyInfo.cs
            this.Text = String.Format("About Havok Preview Tool");
            this.labelProductName.Text = AssemblyProduct;
            this.labelVersion.Text = String.Format("Version {0}", AssemblyVersion);
            this.labelCopyright.Text = AssemblyCopyright;
            this.labelCompanyName.Text = AssemblyCompany;
            this.textBoxDescription.Text = EnvVars + "\r\n\r\n";
        }

        #region Assembly Attribute Accessors

        public string AssemblyTitle
        {
            get
            {
                // Get all Title attributes on this assembly
                object[] attributes = Assembly.GetExecutingAssembly().GetCustomAttributes(typeof(AssemblyTitleAttribute), false);
                // If there is at least one Title attribute
                if (attributes.Length > 0)
                {
                    // Select the first one
                    AssemblyTitleAttribute titleAttribute = (AssemblyTitleAttribute)attributes[0];
                    // If it is not an empty string, return it
                    if (titleAttribute.Title != "")
                        return titleAttribute.Title;
                }
                // If there was no Title attribute, or if the Title attribute was the empty string, return the .exe name
                return System.IO.Path.GetFileNameWithoutExtension(Assembly.GetExecutingAssembly().CodeBase);
            }
        }

        public string AssemblyVersion
        {
            get
            {
                bool x64 = IntPtr.Size > 4;
                return Assembly.GetExecutingAssembly().GetName().Version.ToString() + (x64? " (64bit)" : " (32bit)");
            }
        }

        public string AssemblyDescription
        {
            get
            {
                // Get all Description attributes on this assembly
                object[] attributes = Assembly.GetExecutingAssembly().GetCustomAttributes(typeof(AssemblyDescriptionAttribute), false);
                // If there aren't any Description attributes, return an empty string
                if (attributes.Length == 0)
                    return "";
                // If there is a Description attribute, return its value
                return ((AssemblyDescriptionAttribute)attributes[0]).Description;
            }
        }

        public string AssemblyProduct
        {
            get
            {
                // Get all Product attributes on this assembly
                object[] attributes = Assembly.GetExecutingAssembly().GetCustomAttributes(typeof(AssemblyProductAttribute), false);
                // If there aren't any Product attributes, return an empty string
                if (attributes.Length == 0)
                    return "";
                // If there is a Product attribute, return its value
                return ((AssemblyProductAttribute)attributes[0]).Product;
            }
        }

        public string AssemblyCopyright
        {
            get
            {
                // Get all Copyright attributes on this assembly
                object[] attributes = Assembly.GetExecutingAssembly().GetCustomAttributes(typeof(AssemblyCopyrightAttribute), false);
                // If there aren't any Copyright attributes, return an empty string
                if (attributes.Length == 0)
                    return "";
                // If there is a Copyright attribute, return its value
                return ((AssemblyCopyrightAttribute)attributes[0]).Copyright;
            }
        }

        public string AssemblyCompany
        {
            get
            {
                // Get all Company attributes on this assembly
                object[] attributes = Assembly.GetExecutingAssembly().GetCustomAttributes(typeof(AssemblyCompanyAttribute), false);
                // If there aren't any Company attributes, return an empty string
                if (attributes.Length == 0)
                    return "";
                // If there is a Company attribute, return its value
                return ((AssemblyCompanyAttribute)attributes[0]).Company;
            }
        }

        public string EnvVars
        {
            get
            {
                String envVar64 = Environment.GetEnvironmentVariable("HAVOK_TOOLS_ROOT_X64");
                String envVar = Environment.GetEnvironmentVariable("HAVOK_TOOLS_ROOT");

                String regToolPath64 = (String)Registry.GetValue("HKEY_CURRENT_USER\\Software\\Havok\\ManagedTools_x64", "ToolsDir", "");
                String regToolPath = (String)Registry.GetValue("HKEY_CURRENT_USER\\Software\\Havok\\ManagedTools", "ToolsDir", "");

                String shaderLib64 = (String)Registry.GetValue("HKEY_CURRENT_USER\\Software\\Havok\\ManagedTools_x64", "ShaderLibDir", "");
                String shaderLib = (String)Registry.GetValue("HKEY_CURRENT_USER\\Software\\Havok\\ManagedTools", "ShaderLibDir", "");

                String filterDir64 = (String)Registry.GetValue("HKEY_CURRENT_USER\\Software\\Havok\\hkFilters_x64", "FilterPath", "");
                String filterDir = (String)Registry.GetValue("HKEY_CURRENT_USER\\Software\\Havok\\hkFilters", "FilterPath", "");

                String text = "\r\nEnvironment Vars (used first if set)";
                text += "\r\n HAVOK_TOOLS_ROOT_X64 : [" + ((envVar64 != null) && (envVar64.Length > 0) ? envVar64 + (!System.IO.Directory.Exists(envVar64) ? " <not found!>" : "") : "<not set>") + "]";
                text += "\r\n HAVOK_TOOLS_ROOT     : [" + ((envVar != null) && (envVar.Length > 0) ? envVar + (!System.IO.Directory.Exists(envVar) ? " <not found!>" : "") : "<not set>") + "]";
                text += "\r\n\r\nIf above not set, then will look in registry:";
                text += "\r\n HKCU\\Software\\Havok\\ManagedTools_x64\\ToolsDir : [" + ((regToolPath64 != null) && (regToolPath64.Length > 0) ? regToolPath64 + (!System.IO.Directory.Exists(regToolPath64) ? " <not found!>" : "") : "<not set>") + "]";
                text += "\r\n HKCU\\Software\\Havok\\ManagedTools_x64\\ShaderLibDir : [" + ((shaderLib64 != null) && (shaderLib64.Length > 0) ? shaderLib64 + (!System.IO.Directory.Exists(shaderLib64) ? " <not found!>" : "") : "<not set>") + "]"; 
                text += "\r\n HKCU\\Software\\Havok\\hkFilters_x64\\FilterPath : [" + ((filterDir64 != null) && (filterDir64.Length > 0) ? filterDir64 + (!System.IO.Directory.Exists(filterDir64) ? " <not found!>" : "") : "<not set>") + "]";
                text += "\r\n HKCU\\Software\\Havok\\ManagedTools\\ToolsDir : [" + ((regToolPath != null) && (regToolPath.Length > 0) ? regToolPath + (!System.IO.Directory.Exists(regToolPath) ? " <not found!>" : "") : "<not set>") + "]";
                text += "\r\n HKCU\\Software\\Havok\\ManagedTools\\ShaderLibDir : [" + ((shaderLib != null) && (shaderLib.Length > 0) ? shaderLib + (!System.IO.Directory.Exists(shaderLib) ? " <not found!>" : "") : "<not set>") + "]";
                text += "\r\n HKCU\\Software\\Havok\\hkFilters\\FilterPath : [" + ((filterDir != null) && (filterDir.Length > 0) ? filterDir + (!System.IO.Directory.Exists(filterDir) ? " <not found!>" : "") : "<not set>") + "]";
                return text;
            }
        }
        #endregion

        private void textBoxDescription_TextChanged(object sender, EventArgs e)
        {

        }

        private void button2_Click(object sender, EventArgs e)
        {
            String text = String.Format("Assembly Title : {0}\r\n" +
                                        "Assembly Product : {1}\r\n" +
                                        "Assembly Version : {2}\r\n" +
                                        "Assembly Description : {3}\r\n\r\n",
                                        AssemblyTitle, AssemblyProduct, AssemblyVersion, AssemblyDescription);

            text += textBoxDescription.Text;

            Clipboard.SetText(text);
        }
    }
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
