// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0


#include <Tool/ToolInterfaces/ToolInterfaces.h>

#include <Tool/ToolInterfaces/ToolInterfacesVersion.h>
#include <Common/Base/Config/hkConfigVersion.h>

using namespace Havok::Tool;
using namespace Havok::Graphics;

void VersionCheck::getVersionInfo(System::String^% interfaceVersion, System::String^% havokSdkVersion )
{
    interfaceVersion = HCT_TOOL_INTERFACE_VERSION;
    havokSdkVersion = HAVOK_SDK_VERSION_STRING;
}

PickInfo::PickInfo()
:   m_object(nullptr),
    m_faceSetIndex(-1), // which face set
    m_geomIndex(-1),
    m_facePrimIndex(-1), // which strip / list
    m_faceIndex(-1), // which tri
    m_localPos(nullptr),
    m_closestVert(-1)
{
    m_vertexIndices = gcnew array<int,1>(3);
    m_localPos = gcnew hkgVector3CLR();
}

hkgFaceSetCLR^ PickInfo::getPickedFaceSet()
{
    if ((m_object!= nullptr) && (m_faceSetIndex >= 0))
    {
        int curMaxIndex  = 0;
        int numGeoms = m_object->getNumGeometry();
        for (int gi = 0; gi < numGeoms; ++gi)
        {
            hkgGeometryCLR^ geom = m_object->getGeometry(gi);
            int numMats = geom->getNumMaterialFaceSets();
            for (int mfsi = 0; mfsi < numMats; ++mfsi)
            {
                hkgMaterialFaceSetCLR^ mfs = geom->getMaterialFaceSet(mfsi);
                int nfs = mfs->getNumFaceSets();
                if (m_faceSetIndex < (curMaxIndex + nfs))
                {
                    return mfs->getFaceSet( m_faceSetIndex - curMaxIndex );
                }

                curMaxIndex += nfs;
            }
        }
    }

    return nullptr;
}

hkgFaceSetPrimitiveCLR^ PickInfo::getPickedPrimitive()
{
    hkgFaceSetCLR^ faceSet = getPickedFaceSet();
    if (faceSet != nullptr)
    {
        hkgFaceSetPrimitiveCLR^ prim = faceSet->getPrimitive(m_facePrimIndex);
        return prim;
    }

    return nullptr;

}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
