// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#pragma managed(push, off)

#include <Common/Base/hkBase.h>
#include <Common/Base/System/hkBaseSystem.h>
#include <Common/Base/Memory/System/Util/hkMemoryInitUtil.h>
#include <Common/Base/Memory/Allocator/Malloc/hkMallocAllocator.h>

#include <Common/Base/DebugUtil/MultiThreadCheck/hkMultiThreadCheck.h>

#define HAVOK_TOOLS_BASE_SYSTEM_DLL_MAIN_DECL_COMMON_PRE(SYNCINFO) \
    static void ASSERT_WRAPPER(bool v, const char* str) \
    { \
    HK_ASSERT(0x1d9a16fa, v, "{}", str); \
    } \
    static hkUint32 __g_numThreads = 0; \
    static HK_THREAD_LOCAL(hkUint32) __g_perThreadInfo; \
    static CRITICAL_SECTION __g_systemCriticalSection; \
    static hkError* __g_pushedError = HK_NULL;\
    BOOL WINAPI DllMain(HINSTANCE hinstDLL, ULONG fdwReason, LPVOID lpvReserved) \
    { \
    switch ( fdwReason ) \
        { \
    case DLL_PROCESS_ATTACH: \
            { \
            InitializeCriticalSectionAndSpinCount( &__g_systemCriticalSection, 1000 ); \
            break; \
            } \
    case DLL_PROCESS_DETACH: \
            { \
            DeleteCriticalSection( &__g_systemCriticalSection ); \
            break;\
            } \
    case DLL_THREAD_ATTACH:\
    case DLL_THREAD_DETACH:\
    break;\
        }       \
        return TRUE; \
    } \
    static void HAVOK_TOOLS_BASE_SYSTEM_LOCK()  \
    {   EnterCriticalSection(&__g_systemCriticalSection); } \
    static void HAVOK_TOOLS_BASE_SYSTEM_UNLOCK()  \
    {   LeaveCriticalSection(&__g_systemCriticalSection); } \
    static void HAVOK_TOOLS_BASE_SYSTEM_INIT(hkMemoryInitUtil::SyncInfo* info) \
    { \
    extern hkBool hkBaseSystemIsInitialized; \
    if (!hkBaseSystemIsInitialized && info->m_memoryRouter) \
        { \
        hkMemoryInitUtil::SyncInfo::syncLocalInitNodes(*info, SYNCINFO);

#define HAVOK_TOOLS_BASE_SYSTEM_DLL_MAIN_DECL_COMMON_MID  \
    hkMonitorStream::init(); \
    hkMultiThreadCheck::staticInit(hkMallocAllocator::m_defaultMallocAllocator); \
    hkBaseSystem::initNodes(&hkBaseSystem::InitNode::s_listHead); \
    hkProductFeatures::initialize(); \
    hkBaseSystemIsInitialized = true;
#define HAVOK_TOOLS_BASE_SYSTEM_DLL_MAIN_DECL_COMMON_POST(SYNCINFO) __g_numThreads = 1; \
    HK_THREAD_LOCAL_SET(__g_perThreadInfo, 1); \
        } \
        else if (info->m_memoryRouter) /* may be thread init */ \
        {  \
        if ( HK_THREAD_LOCAL_GET(__g_perThreadInfo) == 0) \
            { \
            ASSERT_WRAPPER(hkMemoryRouter::getInstancePtr() == HK_NULL, "Thread mem router not null"); \
            /*ASSERT_WRAPPER(&hkMemory::getInstance() == info->m_memory, "Memory base does not match");*/ \
            hkMemoryRouter::replaceInstance(info->m_memoryRouter); \
            hkMonitorStream::init(); \
            HK_THREAD_LOCAL_SET(__g_perThreadInfo, 1); \
            __g_numThreads++; \
            } \
            else /* calling init twice: can happen now due to base init from both cloth and preview */ \
            {} \
        } \
    } \
    static void HAVOK_TOOLS_BASE_SYSTEM_UPDATE(hkMemoryInitUtil::SyncInfo* info) \
    { \
    if (info->m_memoryRouter) \
        { \
        HAVOK_TOOLS_BASE_SYSTEM_INIT(info); \
        } \
        else \
        { \
        HAVOK_TOOLS_BASE_SYSTEM_QUIT(); \
        } \
    }

// Don't sync or register
#define HAVOK_TOOLS_BASE_SYSTEM_DLL_MAIN_DECL HAVOK_TOOLS_BASE_SYSTEM_DLL_MAIN_DECL_COMMON_PRE(hkMemoryInitUtil::SyncInfo::EXCLUDE_VERSION_REGISTRY) \
        HAVOK_TOOLS_BASE_SYSTEM_DLL_MAIN_DECL_COMMON_MID \
        HAVOK_TOOLS_BASE_SYSTEM_DLL_MAIN_DECL_COMMON_POST(hkMemoryInitUtil::SyncInfo::EXCLUDE_VERSION_REGISTRY)

// Sync patch registry
#define HAVOK_TOOLS_BASE_SYSTEM_DLL_MAIN_DECL_WITH_PATCHES HAVOK_TOOLS_BASE_SYSTEM_DLL_MAIN_DECL_COMMON_PRE(hkMemoryInitUtil::SyncInfo::EXCLUDE_NONE) \
    info->m_patchRegistry->addReference(); \
    hkReflect::Version::PatchRegistry::replaceInstance(info->m_patchRegistry); \
    HAVOK_TOOLS_BASE_SYSTEM_DLL_MAIN_DECL_COMMON_MID \
    HAVOK_TOOLS_BASE_SYSTEM_DLL_MAIN_DECL_COMMON_POST(hkMemoryInitUtil::SyncInfo::EXCLUDE_NONE)

#if defined(HK_COMPILER_HAS_INTRINSICS_IA32) && HK_CONFIG_SIMD == HK_CONFIG_SIMD_ENABLED
#define HAVOK_TOOLS_FLUSH_DENORMALS_TO_ZERO_DECL \
    static void HAVOK_TOOLS_FLUSH_DENORMALS_TO_ZERO() \
    { \
        _MM_SET_FLUSH_ZERO_MODE(_MM_FLUSH_ZERO_ON); \
    }
#else
#define HAVOK_TOOLS_FLUSH_DENORMALS_TO_ZERO_DECL \
    static void HAVOK_TOOLS_FLUSH_DENORMALS_TO_ZERO() \
    {}
#endif

#define HAVOK_TOOLS_BASE_SYSTEM_QUIT() \
    do { \
        extern hkBool hkBaseSystemIsInitialized; \
        if ( hkBaseSystemIsInitialized ) \
        { \
            --__g_numThreads; \
            int threadInit = HK_THREAD_LOCAL_GET(__g_perThreadInfo); \
            if ( threadInit ) \
            { \
                if (__g_numThreads == 0)  \
                { \
                    hkBaseSystem::quit(); \
                } \
                else if (__g_numThreads < 0) \
                { \
                    ASSERT_WRAPPER(false, "Thread num error in a tool plug" ); \
                } \
                else \
                { \
                    if (hkMonitorStream::getInstancePtr()) \
                    { hkMonitorStream::getInstance().quit(); } \
                    hkMemoryRouter::replaceInstance(HK_NULL); \
                } \
                HK_THREAD_LOCAL_SET(__g_perThreadInfo, 0); \
            } \
            else \
            { \
                ASSERT_WRAPPER(false, "Calling quit from a thread which has no init call / quit has already been called." ); \
            } \
        } \
    } while(0)
#define HAVOK_TOOLS_BASE_SYSTEM_GET_INFO(x) \
    do { \
        extern hkBool hkBaseSystemIsInitialized; \
        static hkMemoryInitUtil::SyncInfo g_curRet; \
        if ( hkBaseSystemIsInitialized ) \
        { \
            hkMemoryInitUtil::SyncInfo::getLocalInfo(g_curRet); \
        } \
        else \
        { \
            hkString::memSet(&g_curRet, 0, sizeof(hkMemoryInitUtil::SyncInfo) ); \
        } \
        x = System::IntPtr((void*)&g_curRet); \
    } while(0)
#define HAVOK_TOOLS_BASE_SYSTEM_GET_INFO_NO_SLIST(x) \
    do { \
    extern hkBool hkBaseSystemIsInitialized; \
    static hkMemoryInitUtil::SyncInfo g_curRet; \
    if ( hkBaseSystemIsInitialized ) \
        { \
            hkMemoryInitUtil::SyncInfo::getLocalInfo(g_curRet); \
            g_curRet.m_systemInitNodes = HK_NULL; \
        } \
        else \
        { \
            hkString::memSet(&g_curRet, 0, sizeof(hkMemoryInitUtil::SyncInfo) ); \
        } \
        x = System::IntPtr((void*)&g_curRet); \
    } while(0)

#define HAVOK_TOOLS_BASE_SYSTEM_PUSH_ERROR(x) \
    do { \
        extern hkBool hkBaseSystemIsInitialized; \
        if ( hkBaseSystemIsInitialized ) \
        { \
            ASSERT_WRAPPER( __g_pushedError == HK_NULL, "Only one push allowed at the moment");\
            __g_pushedError = &hkError::getInstance();\
            __g_pushedError->addReference();\
            hkError* newErr = (hkError*)x.ToPointer();\
            if (newErr) { newErr->addReference(); } \
            hkError::replaceInstance(newErr ); \
        } \
    } while(0)

#define HAVOK_TOOLS_BASE_SYSTEM_POP_ERROR(x) \
    do { \
        extern hkBool hkBaseSystemIsInitialized; \
        if ( hkBaseSystemIsInitialized ) \
        { \
            ASSERT_WRAPPER( __g_pushedError != HK_NULL, "No error on stack to pop"); \
            hkError::replaceInstance( __g_pushedError ); \
            __g_pushedError = HK_NULL; \
        } \
    } while(0)

#pragma managed(pop)

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
