// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

using System;

using System.Collections.Generic;
using System.Windows.Forms;
using Microsoft.Win32;

namespace PreviewTool
{
    static class Program
    {
        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        static void Main(string[] Args)
        {
            Application.EnableVisualStyles();
            Application.SetCompatibleTextRenderingDefault(false);

            List<string> filenames = new List<string>();
            string renderer = null;
            for (int ai = 0; ai < Args.Length; ++ai)
            {
                string arg = Args[ai];
                if (arg.StartsWith("-")) // then a flag
                {
                    if (arg.Length > 1)
                    {
                        switch (arg[1])
                        {
                            case 'r': // renderer
                            {
                                ++ai;
                                if ( (ai < Args.Length) && (Args[ai].Length > 0) )
                                {
                                    renderer = Args[ai];
                                }
                                break;
                            }
                            case 'h': // help
                            case '?': // help
                            {
                                MessageBox.Show("Command Line options:\n -r {d3d9s, d3d9, ogls, ogl, d3d10}   :to chose the renderer, eg   -r d3d9s\n -h  or  -?   :to show this help message\n {filename0} {filename1} {...)   :any arg with no - is assumed to be a filename\n", "Havok Tool Standalone", MessageBoxButtons.OK, MessageBoxIcon.Information );
                                return;
                            }
                        }
                    }
                }
                else // assume filename 
                {
                    filenames.Add(arg);
                }
           
            }

            MainForm form = new MainForm(renderer);
          
            foreach (string f in filenames)
            {
                if ( (f.Length > 0) && (System.IO.File.Exists(f)) )
                 {
                    form.havokUI.SetContentsFromFile(f);
                }
            }

            Application.Run(form);
        }
      
    }
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
