// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace PreviewTool
{
    public partial class MainForm : Form
    {
        public MainForm(string renderer)
        {
            InitializeComponent();
            InitializeHavokCtrl(renderer);
        }
                
        private void InitializeHavokCtrl(string renderer)
        {
            SuspendLayout();

           havokUI = new Havok.Tool.ToolUI(renderer, System.IntPtr.Zero);

            havokUI.Dock = System.Windows.Forms.DockStyle.Fill;
            havokUI.Location = new System.Drawing.Point(0, 0);
            havokUI.Name = "ui";
            havokUI.Size = new System.Drawing.Size(1079, 654);
            havokUI.TabIndex = 0;

            Controls.Add(havokUI);

            ResumeLayout(true);
        }

        protected override void OnClosed(EventArgs e)
        {
            havokUI.Dispose();
        }         

  
        public Havok.Tool.ToolUI havokUI = null;

        private void MainForm_Shown(object sender, EventArgs e)
        {
            havokUI.CloseSplashScreen();
        }

        private void formClosing(object sender, FormClosingEventArgs e)
        {
            e.Cancel = false;
        }
 
    }
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
