// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64 !REFLECT
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

using namespace System;
using namespace System::ComponentModel;
using namespace System::Collections;
using namespace System::Windows::Forms;
using namespace System::Data;
using namespace System::Drawing;
using namespace Havok;
using namespace Havok::Tool;

#include "Reflection/hctClassReflection.h"

namespace Havok {
namespace Tool {



    /// <summary>
    /// Summary for TweakerControl
    /// </summary>
    ///
    /// WARNING: If you change the name of this class, you will need to change the
    ///          'Resource File Name' property for the managed resource compiler tool
    ///          associated with all .resx files this class depends on.  Otherwise,
    ///          the designers will not be able to interact properly with localized
    ///          resources associated with this form.
    public ref class TweakerControl : public System::Windows::Forms::UserControl,
        Havok::Tool::IBaseSystem, Havok::Tool::IDataEditor, Havok::Tool::IPluginUI
    {
    public:

        TweakerControl(void)
        {
            InitializeComponent();
            Init();
        }

        virtual String^ getName() { return "Tweaker"; }
        virtual int getPriority() { return 90; }

        virtual void initBaseSystem(System::IntPtr baseInfo, System::IntPtr graphicsInfo); // this is rarely null, usually the base system the Tool is using. Just call normally
        virtual void pushErrorHandler(System::IntPtr error);
        virtual void popErrorHandler();
        virtual void getVersionInfo( String^% interfaceVersion, String^% havokSdkVersion );
        virtual void quitBaseSystem(); // just call hkBaseSystem::quit normally
        virtual void setDataSource( IDataSource^ dataSource );
        virtual void editData( HavokReflectedObject obj, String^ name ); // should copy the data, edit the values in it, and if ok by user, use commit in the datasource
        virtual void setParentControl( System::Windows::Forms::Control^ parent, IConsole^ errorConsole );
        virtual void setParentMenu( System::Windows::Forms::MenuStrip^ parent );
        virtual void setNavigationToolBar( System::Windows::Forms::ToolStrip^ navigationToolBar );

        virtual void restoreDefaultProperties() {}

        virtual void setPluginOwner( IPluginOwner^ owner ){}


    protected:
        /// <summary>
        /// Clean up any resources being used.
        /// </summary>
        ~TweakerControl()
        {
            Quit();

            if (components)
            {
                delete components;
            }
        }

    public: void subObjectSelectionEvent( );

    private:

        void Init();
        void Quit();

        void setObject( IntPtr inst, IntPtr klass, String^ name );
        void constructUI();

        IDataSource^ m_currentDataSource;
        ReflectionManager^ m_reflectionManager;
        IConsole^ m_errorConsole;

        void* m_object;
        const hkReflect::RecordType* m_objectKlass;
        String^ m_objectName;

    private: System::Windows::Forms::PropertyGrid^  propertyGrid1;
    private: System::Windows::Forms::Button^  buttonExpand;
    private: System::Windows::Forms::Label^  nameLabel;


        /// <summary>
        /// Required designer variable.
        /// </summary>
        System::ComponentModel::Container^ components;

#pragma region Windows Form Designer generated code
        /// <summary>
        /// Required method for Designer support - do not modify
        /// the contents of this method with the code editor.
        /// </summary>
        void InitializeComponent(void)
        {
            this->propertyGrid1 = (gcnew System::Windows::Forms::PropertyGrid());
            this->buttonExpand = (gcnew System::Windows::Forms::Button());
            this->nameLabel = (gcnew System::Windows::Forms::Label());
            this->SuspendLayout();
            //
            // propertyGrid1
            //
            this->propertyGrid1->Anchor = static_cast<System::Windows::Forms::AnchorStyles>((((System::Windows::Forms::AnchorStyles::Top | System::Windows::Forms::AnchorStyles::Bottom)
                | System::Windows::Forms::AnchorStyles::Left)
                | System::Windows::Forms::AnchorStyles::Right));
            this->propertyGrid1->Location = System::Drawing::Point(1, 51);
            this->propertyGrid1->Name = L"propertyGrid1";
            this->propertyGrid1->Size = System::Drawing::Size(282, 384);
            this->propertyGrid1->TabIndex = 0;
            //
            // buttonExpand
            //
            this->buttonExpand->Location = System::Drawing::Point(1, 19);
            this->buttonExpand->Name = L"buttonExpand";
            this->buttonExpand->Size = System::Drawing::Size(105, 26);
            this->buttonExpand->TabIndex = 1;
            this->buttonExpand->Text = L"Expand Current";
            this->buttonExpand->UseVisualStyleBackColor = true;
            this->buttonExpand->Click += gcnew System::EventHandler(this, &TweakerControl::buttonExpand_Click);
            //
            // nameLabel
            //
            this->nameLabel->AutoSize = true;
            this->nameLabel->Location = System::Drawing::Point(3, 3);
            this->nameLabel->Name = L"nameLabel";
            this->nameLabel->Size = System::Drawing::Size(60, 13);
            this->nameLabel->TabIndex = 2;
            this->nameLabel->Text = L"<no name>";
            //
            // TweakerControl
            //
            this->AutoScaleDimensions = System::Drawing::SizeF(6, 13);
            this->AutoScaleMode = System::Windows::Forms::AutoScaleMode::Font;
            this->AutoScroll = true;
            this->AutoSizeMode = System::Windows::Forms::AutoSizeMode::GrowAndShrink;
            this->Controls->Add(this->nameLabel);
            this->Controls->Add(this->buttonExpand);
            this->Controls->Add(this->propertyGrid1);
            this->Name = L"TweakerControl";
            this->Size = System::Drawing::Size(284, 436);
            this->ResumeLayout(false);
            this->PerformLayout();

        }
#pragma endregion
    private: System::Void buttonExpand_Click(System::Object^  sender, System::EventArgs^  e)
             {
                 subObjectSelectionEvent();
             }
};
} // Tools
} // Havok

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
