// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0
// Havok.Tools.Tweaker.cpp : main project file.

#include "hctTweakerPlugin.h"
#include "hctTweakerControl.h"

using namespace Havok::Tool;

#pragma unmanaged

#include <ToolInterfaces/ToolInterfaceMacros.h>
#include <ToolInterfaces/ToolInterfacesVersion.h>
#include <Common/Base/Fwd/hkwindows.h>

#include <Common/Base/System/Io/Writer/Array/hkArrayStreamWriter.h>
#include <Common/Base/Config/hkConfigVersion.h>
#include <Common/Base/Thread/CriticalSection/hkCriticalSection.h>

#define HK_EXCLUDE_FEATURE_RegisterReflectedClasses
#define HK_EXCLUDE_FEATURE_DestructionRuntime
#define HK_EXCLUDE_FEATURE_hkndAssetProcessing
#define HK_EXCLUDE_FEATURE_hkndDebrisFracture_execute
#define HK_EXCLUDE_FEATURE_hkndParticleEffectFracture_execute
#define HK_EXCLUDE_FEATURE_NewDestructionRuntime
#include <Common/Base/Config/hkProductFeaturesNoPatchesOrCompat.h>
#include <Common/Base/Config/hkProductFeatures.cxx>

HAVOK_TOOLS_BASE_SYSTEM_DLL_MAIN_DECL

#pragma managed
void TweakerControl::initBaseSystem(System::IntPtr baseInfo, System::IntPtr graphicsInfo)
{
    HAVOK_TOOLS_BASE_SYSTEM_LOCK();

    HAVOK_TOOLS_BASE_SYSTEM_INIT( (hkMemoryInitUtil::SyncInfo*)baseInfo.ToPointer() );

    HAVOK_TOOLS_BASE_SYSTEM_UNLOCK();
}

void TweakerControl::pushErrorHandler(System::IntPtr error)
{
    HAVOK_TOOLS_BASE_SYSTEM_LOCK();
    HAVOK_TOOLS_BASE_SYSTEM_PUSH_ERROR(error);
    HAVOK_TOOLS_BASE_SYSTEM_UNLOCK();
}

void TweakerControl::popErrorHandler()
{
    HAVOK_TOOLS_BASE_SYSTEM_LOCK();
    HAVOK_TOOLS_BASE_SYSTEM_POP_ERROR(error);
    HAVOK_TOOLS_BASE_SYSTEM_UNLOCK();
}

void TweakerControl::getVersionInfo( String^% interfaceVersion, String^% havokSdkVersion )
{
    interfaceVersion = HCT_TOOL_INTERFACE_VERSION;
    havokSdkVersion = HAVOK_SDK_VERSION_STRING;
}

void TweakerControl::quitBaseSystem()
{
    HAVOK_TOOLS_BASE_SYSTEM_LOCK();

    HAVOK_TOOLS_BASE_SYSTEM_QUIT();

    HAVOK_TOOLS_BASE_SYSTEM_UNLOCK();
}

void TweakerControl::setParentControl( System::Windows::Forms::Control^ parent, IConsole^ errorConsole )
{
    m_errorConsole = errorConsole;

    System::Windows::Forms::Control::ControlCollection^ ctrls = parent->Controls;
    this->Dock = DockStyle::Fill;
    ctrls->Add(this);
}

void TweakerControl::subObjectSelectionEvent( )
{
    GridItem^ gi = propertyGrid1->SelectedGridItem;
    if (gi != nullptr)
    {
        Object^ val = gi->Value;
        if (val != nullptr)
        {
            // Array?
            const hkReflect::Type* klass = HK_NULL;
            void* data = HK_NULL;
            if (val->GetType() == ArrayList::typeid )
            {
                ArrayList^ a = (ArrayList^)val;
                if (a->Count > 0)
                {
                    val = a[0];
                }
                else
                {
                    return;
                }
            }

            m_reflectionManager->GetReflectedSource(val, klass, data);

            if (data && klass)
            {
                IntPtr klassPtr( (void*) klass);
                IntPtr dataPtr( (void*) data);
                String^ namePath = m_objectName + "/" + gi->Label;
                setObject(dataPtr, klassPtr, namePath);
                constructUI();
            }
        }
    }

}

void TweakerControl::setParentMenu( System::Windows::Forms::MenuStrip^ parent )
{

}


void TweakerControl::setNavigationToolBar( System::Windows::Forms::ToolStrip^ navigationToolBar )
{

}


void TweakerControl::Init()
{
    m_object = HK_NULL;
    m_objectKlass = HK_NULL;
    m_currentDataSource = nullptr;
    m_reflectionManager = gcnew ReflectionManager(false);
}

void TweakerControl::Quit()
{
    m_object = HK_NULL;
    m_objectKlass = HK_NULL;
    m_reflectionManager = nullptr;
    m_currentDataSource = nullptr;
}

void TweakerControl::setDataSource( IDataSource^ dataSource )
{
    m_currentDataSource = dataSource;

    if (m_currentDataSource == nullptr)
    {
        if (m_object)
        {
            m_object = HK_NULL;
            m_objectKlass = HK_NULL;

        }
    }
}



void TweakerControl::setObject( IntPtr inst, IntPtr klass, String^ name)
{
    m_object = inst.ToPointer();
    m_objectKlass = static_cast<const hkReflect::Type*>(klass.ToPointer())->asRecord();

    String^ info = gcnew String("Class [");
    info += gcnew String(m_objectKlass->getName());
    info += "] Name[";
    info += name;
    info += "]";

    this->nameLabel->Text = info;

    m_objectName = name;
}

void TweakerControl::constructUI()
{
    if (m_objectKlass)
    {
        Object^ reflectedObj = m_reflectionManager->ReflectInstance( m_objectKlass, m_object );
        propertyGrid1->SelectedObject = reflectedObj;
    }
}

void TweakerControl::editData( HavokReflectedObject obj, String^ name )
{
    m_objectName = name;

    // 1. copy the data to a local buffer
    setObject( obj.instance,  obj.klass, name );

    // 2. construct a UI for what we find (just a PropertyGrid for now)
    constructUI();
}

#pragma unmanaged

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
