// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64 !REFLECT
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

// This include guard is needed in hctClassReflectionBase.cpp, do not replace by #pragma once
#ifndef HCT_TWEAKER_CLASS_REFLECTION_TYPES_H
#define HCT_TWEAKER_CLASS_REFLECTION_TYPES_H

using namespace System;
using namespace System::ComponentModel;
using namespace System::Globalization;

namespace Havok
{
    ref class ExpandableConverter;
    ref class VectorConverter;
    ref class QuaternionConverter;


    [TypeConverter(Havok::VectorConverter::typeid)]
    public value struct Vector4
    {
        Vector4(float xx, float yy, float zz, float ww)
            : m_x(xx), m_y(yy), m_z(zz), m_w(ww) { }

        property float x {
            float get() { return m_x; }
            void set(float x) { m_x = x; }
        }

        property float y {
            float get() { return m_y; }
            void set(float y) { m_y = y; }
        }

        property float z {
            float get() { return m_z; }
            void set(float z) { m_z = z; }
        }

        property float w {
            float get() { return m_w; }
            void set(float w) { m_w = w; }
        }

    protected:

        float m_x;
        float m_y;
        float m_z;
        float m_w;
    };


    [TypeConverter(Havok::QuaternionConverter::typeid)]
    public value struct Quaternion
    {
        Quaternion(float xx, float yy, float zz, float ww)
            : m_x(xx), m_y(yy), m_z(zz), m_w(ww) { }

        property float x {
            float get() { return m_x; }
            void set(float x) { m_x = x; }
        }

        property float y {
            float get() { return m_y; }
            void set(float y) { m_y = y; }
        }

        property float z {
            float get() { return m_z; }
            void set(float z) { m_z = z; }
        }

        property float w {
            float get() { return m_w; }
            void set(float w) { m_w = w; }
        }

    protected:

        float m_x;
        float m_y;
        float m_z;
        float m_w;
    };

    [TypeConverter(Havok::ExpandableConverter::typeid)]
    public value struct Matrix3
    {
        Matrix3(Vector4 c0, Vector4 c1, Vector4 c2)
            : m_col0(c0), m_col1(c1), m_col2(c2) { }

        property Vector4 col0 {
            Vector4 get() { return m_col0; }
            void set(Vector4 x) { m_col0 = x; }
        }

        property Vector4 col1 {
            Vector4 get() { return m_col1; }
            void set(Vector4 x) { m_col1 = x; }
        }

        property Vector4 col2 {
            Vector4 get() { return m_col2; }
            void set(Vector4 x) { m_col2 = x; }
        }

    public:

        Vector4 m_col0;
        Vector4 m_col1;
        Vector4 m_col2;
    };

    [TypeConverter(Havok::ExpandableConverter::typeid)]
    public value struct  Matrix4
    {
        Matrix4(Vector4 c0, Vector4 c1, Vector4 c2, Vector4 c3)
            : m_col0(c0), m_col1(c1), m_col2(c2), m_col3(c3) { }

        property Vector4 col0 {
            Vector4 get() { return m_col0; }
            void set(Vector4 x) { m_col0 = x; }
        }

        property Vector4 col1 {
            Vector4 get() { return m_col1; }
            void set(Vector4 x) { m_col1 = x; }
        }

        property Vector4 col2 {
            Vector4 get() { return m_col2; }
            void set(Vector4 x) { m_col2 = x; }
        }

        property Vector4 col3 {
            Vector4 get() { return m_col3; }
            void set(Vector4 x) { m_col3 = x; }
        }

    public:

        Vector4 m_col0;
        Vector4 m_col1;
        Vector4 m_col2;
        Vector4 m_col3;
    };


    [TypeConverter(Havok::ExpandableConverter::typeid)]
    public value struct Transform
    {
        Matrix3 m_rot;
        Vector4 m_trans;
    };

    [TypeConverter(Havok::ExpandableConverter::typeid)]
    public value struct QsTransform
    {
        Vector4 m_trans;
        Quaternion m_rot;
        Vector4 m_scale;
    };



    //
    // Converters
    //
    public ref class ExpandableConverter : public TypeConverter
    {
    public:

        virtual PropertyDescriptorCollection^ GetProperties( ITypeDescriptorContext^ context, Object^ value, array<Attribute^>^ filter ) override
        {
            return TypeDescriptor::GetProperties(value, filter);
        }

        virtual bool GetPropertiesSupported( ITypeDescriptorContext^ context)  override
        {
            return true;
        }
    };

    public ref class StringExpandableConverter : public ExpandableConverter
    {
    public:
        virtual bool CanConvertFrom( ITypeDescriptorContext^ context, Type^ t )  override
        {
            if ( t == String::typeid )
            {
                return true;
            }
            return TypeConverter::CanConvertFrom(context, t);
        }

        bool parseCommaSeperatedFour(String^ s, array<String^>^ fvalue )
        {
            int startComma = 0;
            int endComma = s->IndexOf(',');
            int curValue = 0;
            if (fvalue->Length == 4)
            {
                while ( endComma != -1 ) //x,y,z,
                {
                    fvalue[curValue++] = s->Substring(startComma, endComma-startComma);
                    startComma = endComma + 1;
                    endComma = s->IndexOf(',', startComma);
                }
                if (curValue==3)
                {
                    fvalue[3] = s->Substring(startComma);
                    return true;
                }
            }
            return false;
        }
    };


    public ref class VectorConverter : public StringExpandableConverter
    {
    public:

        virtual Object^ ConvertFrom( ITypeDescriptorContext^ context, CultureInfo^ info, Object^ v)  override
        {
            if ( v->GetType() == String::typeid)
            {
                try
                {
                    String^ s = (String^)v;
                    array<String^>^ fvalue = gcnew array<String^>(4);
                    if ( parseCommaSeperatedFour(s, fvalue) )
                    {
                        // success.. if they are numbers..
                        Vector4 v4;
                        v4.x = Convert::ToSingle(fvalue[0]);
                        v4.y = Convert::ToSingle(fvalue[1]);
                        v4.z = Convert::ToSingle(fvalue[2]);
                        v4.w = Convert::ToSingle(fvalue[3]);
                        return v4;
                    }
                }
                catch ( Exception^ )
                {
                    return nullptr;
                }
            }
            return TypeConverter::ConvertFrom(context, info, v);
        }

        virtual Object^ ConvertTo( ITypeDescriptorContext^ context, CultureInfo^ culture, Object^ v, Type^ destType)  override
        {
            if ( (destType == String::typeid) && (v->GetType() == Havok::Vector4::typeid) )
            {
                Vector4^ vec = (Vector4^)v;
                return String::Format("{0}, {1}, {2}, {3}",  vec->x, vec->y, vec->z, vec->w );
            }
            return TypeConverter::ConvertTo(context, culture, v, destType);
        }
    };



    public ref class QuaternionConverter : public StringExpandableConverter
    {
    public:

        virtual Object^ ConvertFrom( ITypeDescriptorContext^ context, CultureInfo^ info, Object^ v)  override
        {
            if ( v->GetType() == String::typeid )
            {
                try
                {
                    String^ s = (String^)v;
                    array<String^>^ fvalue = gcnew array<String^>(4);
                    if ( parseCommaSeperatedFour(s, fvalue) )
                    {
                        // success.. if they are numbers..
                        Quaternion q;
                        q.x = Convert::ToSingle(fvalue[0]);
                        q.y = Convert::ToSingle(fvalue[1]);
                        q.z = Convert::ToSingle(fvalue[2]);
                        q.w = Convert::ToSingle(fvalue[3]);
                        return q;
                    }
                }
                catch ( Exception^ )
                {
                    return nullptr;
                }
            }
            return TypeConverter::ConvertFrom(context, info, v);
        }

        virtual Object^ ConvertTo( ITypeDescriptorContext^ context, CultureInfo^ culture, Object^ v, Type^ destType)  override
        {
            if ( (destType == String::typeid) && (v->GetType() == Havok::Vector4::typeid) )
            {
                Quaternion^ vec = (Quaternion^)v;
                return String::Format("{0}, {1}, {2}, {3}", vec->x, vec->y, vec->z, vec->w);
            }
            return TypeConverter::ConvertTo(context, culture, v, destType);
        }
    };


}

#endif

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
