// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64 !REFLECT
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

using namespace System;
using namespace System::Reflection;
using namespace System::Reflection::Emit;
using namespace System::Collections;

namespace Havok
{
    // forward decl
    ref class ReflectionManager;

    /// Internal structure used to store the Havok reflection information
    public ref class ReflectionInfo
    {
        public:

            const hkReflect::RecordType* klass;
            char* data;
            ReflectionManager^ manager;
    };

    public ref class TypePair
    {
        public:

            const hkReflect::Type* klass;
            Type^ type;
    };


    public ref class ReflectionManager
    {
        public:

            ReflectionManager(bool canModify);
            ReflectionManager(bool canModify, bool makeModuleBuilder);
            ~ReflectionManager();

        public:

                /// Internal generic get and set functions. Called by individual Property get/set calls.
            static void genericSetHelper( ReflectionInfo^ info, int memberIndex, Object^ data );
            static void genericGetHelper( ReflectionInfo^ info, int memberIndex, Object^% data );

            virtual Type^ ConvertMemberToType(const hkReflect::Type* type);
            virtual void genericSet(const hkReflect::Var& field, Object^ data);
            virtual Object^ genericGet(const hkReflect::Var& field);

            
            Object^ ReflectInstance(const hkReflect::RecordType* klass, void* data);
            void GetReflectedSource(Object^ obj, const hkReflect::Type*& klass, void*& data);

            void RememberAlloc( IntPtr ptr );

                /// Internal.
            Type^ GetBuiltinType(const hkReflect::Type* type);
            Type^ DefineEnum(const hkReflect::IntType* type);
            Type^ CreateType(const hkReflect::RecordType* klass);

        protected:
            void init(bool canModify, bool makeModuleBuilder);

            void MakeModuleBuilder();

            void CleanupAllocs();

            bool m_canModify;

            AssemblyBuilder^ m_asmBuilder;
            ModuleBuilder^ m_moduleBuilder;

            ArrayList^ m_classTypes;
            ArrayList^ m_memberTypes;
            ArrayList^ m_loadValueOpcodes;
            ArrayList^ m_enumTypes;

            bool GetLoadOpcode(Type^ t, OpCode% code);

            ArrayList^ m_unmanagedAllocs;
    };
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
