// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Common/Tool/Plugins/Tweaker/hctTweakerPlugin.h>

#include <ContentTools/Common/Tool/Plugins/Tweaker/Reflection/hctClassReflection.h>
#include <ContentTools/Common/Tool/Plugins/Tweaker/Reflection/hctClassReflectionTypes.h>

using namespace System;
using namespace System::Threading;
using namespace Havok;

ReflectionManager::ReflectionManager(bool canModify)
{
    init(canModify, true);
}

ReflectionManager::ReflectionManager(bool canModify, bool makeModuleBuilder)
{
    init(canModify, makeModuleBuilder);
}

void ReflectionManager::init(bool canModify, bool makeModuleBuilder)
{
    m_canModify = canModify;

    m_asmBuilder = nullptr;
    m_moduleBuilder = nullptr;

    m_memberTypes = gcnew ArrayList();
    m_classTypes = gcnew ArrayList();
    m_loadValueOpcodes = gcnew ArrayList();
    m_unmanagedAllocs = gcnew ArrayList();

    // Simple types
    m_memberTypes->Add( Int32::typeid ); // dummy, Void type
    m_loadValueOpcodes->Add( OpCodes::Ldind_I4 ); // dummy

    m_memberTypes->Add( Boolean::typeid);//             [hkClassMember::TYPE_BOOL]
    m_loadValueOpcodes->Add( OpCodes::Ldind_U1 ); // load as unsigned byte (C# boolean == 1 byte always, Win32/Marhsalled BOOL = 4 bytes)

    m_memberTypes->Add( UInt16::typeid);//             [hkClassMember::TYPE_CHAR]
    m_loadValueOpcodes->Add( OpCodes::Ldind_U2 ); // unicode, so 2 bytes

    m_memberTypes->Add( SByte::typeid);//             [hkClassMember::TYPE_INT8]
    m_loadValueOpcodes->Add( OpCodes::Ldind_I1 );

    m_memberTypes->Add( Byte::typeid);//          [hkClassMember::TYPE_UINT8]
    m_loadValueOpcodes->Add( OpCodes::Ldind_U1 );

    m_memberTypes->Add( Int16::typeid );//             [hkClassMember::TYPE_INT16]
    m_loadValueOpcodes->Add( OpCodes::Ldind_I2 );

    m_memberTypes->Add( UInt16::typeid );//     [hkClassMember::TYPE_UINT16]
    m_loadValueOpcodes->Add( OpCodes::Ldind_U2 );

    m_memberTypes->Add( Int32::typeid);//             [hkClassMember::TYPE_INT32]
    m_loadValueOpcodes->Add( OpCodes::Ldind_I4 );

    m_memberTypes->Add( UInt32::typeid );//     [hkClassMember::TYPE_UINT32]
    m_loadValueOpcodes->Add( OpCodes::Ldind_U4 );

    m_memberTypes->Add( Int64::typeid );//         [hkClassMember::TYPE_INT64]
    m_loadValueOpcodes->Add( OpCodes::Ldind_I8 ); // no u8

    m_memberTypes->Add( UInt64::typeid );// [hkClassMember::TYPE_UINT64]
    m_loadValueOpcodes->Add( OpCodes::Ldind_I8 );

    m_memberTypes->Add( Single::typeid );//             [hkClassMember::TYPE_REAL]
    m_loadValueOpcodes->Add( OpCodes::Ldind_R4 );

    // Value types
    m_memberTypes->Add( Havok::Vector4::typeid );       // TYPE_VECTOR4,
    m_memberTypes->Add( Havok::Quaternion::typeid );    // TYPE_QUATERNION,
    m_memberTypes->Add( Havok::Matrix3::typeid );       // TYPE_MATRIX3,
    m_memberTypes->Add( Havok::Matrix3::typeid );       // TYPE_ROTATION,
    m_memberTypes->Add( Havok::QsTransform::typeid ); // TYPE_QSTRANSFORM,
    m_memberTypes->Add( Havok::Matrix4::typeid );       // TYPE_MATRIX4,
    m_memberTypes->Add( Havok::Transform::typeid ); // TYPE_TRANSFORM,

    if (makeModuleBuilder)
    {
        MakeModuleBuilder();
    }
}

ReflectionManager::~ReflectionManager()
{
    CleanupAllocs();
}

void ReflectionManager::CleanupAllocs()
{
    if (m_unmanagedAllocs->Count > 0)
    {
        for (int i = 0; i < m_unmanagedAllocs->Count; ++i)
        {
            hkDeallocate<char>((char*)(((IntPtr)m_unmanagedAllocs[i]).ToPointer()));
        }
        m_unmanagedAllocs->RemoveRange(0, m_unmanagedAllocs->Count);
    }
}

void ReflectionManager::RememberAlloc(IntPtr ptr)
{
    m_unmanagedAllocs->Add(ptr);
}

void ReflectionManager::MakeModuleBuilder()
{
    AppDomain^ myDomain = Thread::GetDomain();

    // Assembly
    AssemblyName^ myAsmName = gcnew AssemblyName();
    myAsmName->Name = "HavokDynamicAssembly";
    m_asmBuilder = myDomain->DefineDynamicAssembly(myAsmName, AssemblyBuilderAccess::Run);

    // Module
    m_moduleBuilder = m_asmBuilder->DefineDynamicModule("HavokDynamicModule");
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
