// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

class hkaAnimatedSkeleton;
class hkaAnimationContainer;
class hkaSkeleton;
class hkaPose;

class hkgSceneDataConverter;
class hkgDisplayContext;
class hkgFont;
class hkgDisplayHandler;
class hkgDisplayWorld;
class hkgDisplayContext;
class hkgFont;
class hkpMouseSpringAction;

class hkCommonProcessContext;
class hkpPhysicsContext;
class hknpProcessContext;
class hclClothContext;
class hkndProcessContext;

class hkJobQueue;
class hkThreadPool;

namespace PreviewPlugin
{
    class PreviewAssetManager;
}

// The various sub products
// so that the project can compile in different product configs
// The UI etc are created assuming all products, and if certain products
// are disabled, those UI elems are removed in code at runtime
class PreviewPluginProductImpl
{
    public:

        PreviewPluginProductImpl(struct PreviewPluginImpl* c) : m_commonCore(c) { }

        virtual ~PreviewPluginProductImpl() { }

        virtual void step(float dt) = 0;
        virtual void render( ) { }

        virtual void startPlay() { }
        virtual void stopPlay()  { }

        virtual bool ownsDisplayObject( class hkgDisplayObject* obj ) { return false; }

        struct ObjectPickInfo
        {
            class hkgDisplayObject* m_object;
            int m_faceSetIndex;
            int m_geomIndex;
            class hkgFaceSet* getPickedFaceSet() const;
            int m_facePrimIndex;
            int m_faceIndex;
            int m_vertexIndices[3];
            float m_localPos[3];
            int m_closestVert;
        };

        virtual void notifyAssetAddedOrRemoved() { }
        virtual void objectPicked( const ObjectPickInfo& obj, float* worldPos ) { }
        virtual void objectMoved( float* worldPos ) { }
        virtual void objectReleased( ) { }
        virtual bool objectAllowTransformInsteadOfMove( ) { return false; }
        virtual void objectTransform( float* newTransform ) { }

        // Tweaking support. Will only be asked for objects it owns. Note that pickInfo gives per vertex info etc so
        // can edit sub obj props
        virtual void tweakGetDataAndClass( const ObjectPickInfo& objectToTweak, void*& dataPtr, const hkReflect::Type*& klassPtr ) { }
        virtual void tweakVerifyClass( const hkReflect::Type* klassPtr ) { } 
        virtual void tweakCommit( void* origData, const hkReflect::Type* origPtr , void* newData ) { }


        struct PreviewPluginImpl* m_commonCore;
};


struct PreviewPluginImpl
{
public:

    PreviewPluginImpl();
    ~PreviewPluginImpl();

    void step(float dt);
    void waitForStepCompletion();

    void renderExtra();
    void createFont();
    void updatePostEffects(const hkArray<const char*>& effectNames );
    void getCurrentPostEffects(hkArray<const char*>& effectNames );

    hkgDisplayHandler* m_displayHandler;
    hkgDisplayWorld* m_displayWorld;
    hkgDisplayContext* m_displayContext;
    hkgFont* m_displayFont;

    PreviewPlugin::PreviewAssetManager* m_assetManager;

    hkJobQueue* m_jobQueue;
    hkThreadPool* m_threadPool;

    PreviewPluginProductImpl* m_physicsImpl;
    PreviewPluginProductImpl* m_newPhysicsImpl;

    hkCommonProcessContext* m_commonVdbContext;

#ifdef HK_ENABLE_PHYSICS_2012
    hkpPhysicsContext* m_physicsVdbContext;
#endif
#ifdef HK_ENABLE_PHYSICS
    hknpProcessContext* m_newPhysicsVdbContext;
#endif
#ifdef HK_ENABLE_CLOTH_PREVIEW
    hclClothContext* m_clothVdbContext;
#endif
#ifdef HK_ENABLE_DESTRUCTION
    hkndProcessContext* m_ndVdbContext;
#endif

    PreviewPluginProductImpl* m_animImpl;
    PreviewPluginProductImpl* m_completeImpl; // anim + physics glue
    PreviewPluginProductImpl* m_clothImpl;
    PreviewPluginProductImpl* m_destructionImpl;
    PreviewPluginProductImpl* m_newDestructionImpl;
    hkArray<PreviewPluginProductImpl*> m_allImpls; // so we can iterate easier

    PreviewPluginProductImpl* m_currentTweakOwner;
    PreviewPluginProductImpl* m_currentPickOwner;
    hkgDisplayObject* m_currentPickedObject;
    hkgDisplayObject* m_currentSelectedObject; // changes on pick, but does not go to null on mouse up
    float m_currentPickedObjectLocalPoint[3];

    void notifyAssetAddedOrRemoved();
};

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
