// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <Plugins/Preview/hctPreviewPlugin.h> //PCH

#pragma unmanaged

#include <Common/Base/hkBase.h>
#include <Common/Base/Thread/JobQueue/hkJobQueue.h>
#include <Common/Base/Thread/Pool/hkCpuThreadPool.h>
#include <Common/Base/System/Hardware/hkHardwareInfo.h>
#include <Common/Visualize/hkCommonProcessContext.h>

#include <Plugins/Preview/hctPreviewUnmanaged.h>
#include <Plugins/Preview/hctPreviewAsset.h>
#include <Common/Base/Fwd/hkwindows.h>

#ifdef HK_ENABLE_PHYSICS_2012
#include <Physics2012/Dynamics/World/hkpWorld.h>
#include <Physics2012/Utilities/VisualDebugger/hkpPhysicsContext.h>
#endif

#ifdef HK_ENABLE_PHYSICS
#include <Physics/Physics/Dynamics/World/hknpWorld.h>
#include <Physics/Physics/Extensions/Viewers/hknpProcessContext.h>
#endif

#ifdef HK_ENABLE_DESTRUCTION
#   include <Destruction/Destruction/hkndDestruction.h>                         
#   include <Destruction/Destruction/Extensions/Viewers/hkndProcessContext.h>       
#endif

#ifdef HK_ENABLE_CLOTH_PREVIEW
#include <Cloth/Cloth/Cloth/hclClothInstance.h>
#endif

using namespace PreviewPlugin;

PreviewPluginImpl::PreviewPluginImpl() :
    m_displayHandler(HK_NULL),
    m_displayWorld(HK_NULL),
    m_displayContext(HK_NULL),
    m_displayFont(HK_NULL),
    m_assetManager(HK_NULL),
    m_commonVdbContext(HK_NULL),
#ifdef HK_ENABLE_PHYSICS_2012
    m_physicsVdbContext(HK_NULL),
#endif
#ifdef HK_ENABLE_PHYSICS
    m_newPhysicsVdbContext(HK_NULL),
#endif
#ifdef HK_ENABLE_CLOTH_PREVIEW
    m_clothVdbContext(HK_NULL),
#endif
#ifdef HK_ENABLE_DESTRUCTION
    m_ndVdbContext(HK_NULL),
#endif
    m_physicsImpl(HK_NULL),
    m_newPhysicsImpl(HK_NULL),
    m_animImpl(HK_NULL),
    m_completeImpl(HK_NULL),
    m_clothImpl(HK_NULL),
    m_destructionImpl(HK_NULL),
    m_newDestructionImpl(HK_NULL),
    m_currentTweakOwner(HK_NULL),
    m_currentPickOwner(HK_NULL),
    m_currentPickedObject(HK_NULL),
    m_currentSelectedObject(HK_NULL)
{
    hkJobQueueCinfo jobCinfo;
    m_jobQueue = new hkJobQueue( jobCinfo );
    m_threadPool = HK_NULL;


    SYSTEM_INFO sysInfo;
    GetSystemInfo(&sysInfo);

    hkCpuThreadPoolCinfo info;
    info.m_numThreads = hkMath::min2<int>( 4, hkHardwareInfo::getNumHardwareThreads() - 1);
    info.m_timerBufferPerThreadAllocation = 2000000;

    m_threadPool = new hkCpuThreadPool(info);

    m_assetManager = new PreviewAssetManager();
    m_assetManager->m_jobQueue      = m_jobQueue;

#ifdef HK_ENABLE_PHYSICS
    m_assetManager->m_npVdbContext  = &m_newPhysicsVdbContext;
#endif

#ifdef HK_ENABLE_CLOTH_PREVIEW
    m_assetManager->m_clothVdbContext = m_clothVdbContext;
#endif

    hkMonitorStream::getInstance().resize(info.m_timerBufferPerThreadAllocation);

    m_commonVdbContext = new hkCommonProcessContext();
}

PreviewPluginImpl::~PreviewPluginImpl()
{
    waitForStepCompletion();

    for (int i=0; i < m_allImpls.getSize(); ++i)
    {
        delete m_allImpls[i];
    }
    m_allImpls.clear();
    if (m_assetManager) m_assetManager->removeReference();

    if (m_jobQueue) delete m_jobQueue;
    if (m_threadPool) delete m_threadPool;

    if(m_commonVdbContext) m_commonVdbContext->removeReference();
}


void PreviewPluginImpl::notifyAssetAddedOrRemoved()
{
    // To reset stuff if necessary
    for (int i=0; i<m_allImpls.getSize(); i++)
    {
        if (m_allImpls[i])
        {
            m_allImpls[i]->notifyAssetAddedOrRemoved();
        }
    }
}

void PreviewPluginImpl::waitForStepCompletion()
{
#ifdef HK_ENABLE_PHYSICS_2012
    if( m_assetManager && m_assetManager->m_currentWorld )
    {
        hkpWorld* world = m_assetManager->m_currentWorld;
        if (world->m_simulationType == hkpWorldCinfo::SIMULATION_TYPE_MULTITHREADED && m_threadPool != HK_NULL )
        {
            world->checkUnmarked();
            m_jobQueue->processAllJobs();
            m_threadPool->waitForCompletion();
            world->finishMtStep( m_jobQueue, m_threadPool );
        }
    }
#endif
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
