// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

// Names of the icons, in the order in which they come in the sceneTreeView image collection.
// The name here should match the name of the class represented by the icon (apart from the
// generic "unknown" icon, used to represent an unknown class). If new icons are added to the
// tree view image collection, make sure this list matches with the icon order in the image collection.
struct IconName
{
    const char* m_name;
};
static IconName orderedIconNames[] =
{
    { "hclBendLinkConstraintSet" },
    { "hclBlendSomeVerticesOperator" },
    { "hclBonePlanesConstraintSet" },
    { "hclBoxShape" },
    { "hclBufferDefinition" },
    { "hclCapsuleHeightField" },
    { "hclCapsuleShape" },
    { "hclClothContainer" },
    { "hclClothData" },
    { "hclClothState" },
    { "hclCollidable" },
    { "hclConstraintSet" },
    { "hclGatherAllVerticesOperator" },
    { "hclHingeConstraintSet" },
    { "hclLocalRangeConstraintSet" },
    { "hclMeshMeshDeformOperator" },
    { "hclOperator" },
    { "hclPlane" },
    { "hclRecalculateAllNormalsOperator" },
    { "hclSimClothData" },
    { "hclSimClothDataParticleData" },
    { "hclSimClothPose" },
    { "hclSimulateOperator" },
    { "hclSkinOperator" },
    { "hclSphereShape" },
    { "hclStandardLinkConstraintSet" },
    { "hclStretchLinkConstraintSet" },
    { "hclTransformSetDefinition" },
    { "hclTransitionConstraintSet" },
    { "hclVolumeConstraintSet" },
    { "hkaAnimationContainer" },
    { "hkaBone" },
    { "hkaBoneAttachment" },
    { "hkaMeshBinding" },
    { "hkaSkeleton" },
    { "hkpPhysicsData" },
    { "hkpRigidBody" },
    { "hkRootLevelContainer" },
    { "hkxAttributeGroup" },
    { "hkxCamera" },
    { "hkxEnvironmentData" },
    { "hkxLight" },
    { "hkxMaterial" },
    { "hkxMesh" },
    { "hkxMeshSection" },
    { "hkxNode" },
    { "hkxScene" },
    { "unknown" }
};

// Some classes have an icon with the same name as the class, as above (except "unknown").
// Some others, below, correspond to icons with different names, since you may want more than one class to be represented by the same icon.
// The names in the second column below MUST appear in the list above.
struct IconPair
{
    const char* m_className;
    const char* m_iconName;
};
static IconPair iconPairs [] =
{
    { "hkxSkinBinding",                       "hkaMeshBinding" },
    { "hclGatherSomeVerticesOperator",        "hclGatherAllVerticesOperator" },
    { "hclCopyVerticesOperator",              "hclGatherAllVerticesOperator" },
    { "hclRecalculateSomeNormalsOperator",    "hclRecalculateAllNormalsOperator" }
};

class hkStringOld;
class hkgDisplayObject;
// Stores association between tree node indices and hkVariants

class hctPreviewTreeViewManager
{

public:

    hctPreviewTreeViewManager() {}

    void init() { m_treeViewVariantMap.clear(); }

    static int getUnknownIconIndex();
    static int getIconIndex(const hkStringOld& className);
    static int getIconIndexForVariant(const hkVariant& var);
    static void getItemData( const hkVariant& var, hkStringOld& name, hkArray< hkVariant >& children, int& imageIndex );

    int getVariantIndex( const hkVariant& var );

    hkArray<hkVariant> m_treeViewVariantMap;

    hkArray<hkgDisplayObject*> m_displayObjectMap;
};

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
