// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <Plugins/Preview/hctPreviewPlugin.h> //PCH

#pragma unmanaged

#include <Common/Base/hkBase.h>
#include <Common/Base/Reflect/Visitor/hkReflectVisitor.h>
#include <Common/SceneData/Scene/hkxScene.h>
#include <Common/SceneData/Graph/hkxNode.h>
#include <Common/Serialize/Util/hkRootLevelContainer.h>
#include <Common/Base/System/Io/Writer/Array/hkArrayStreamWriter.h>
#include <Common/Base/Container/String/Deprecated/hkStringOld.h>

#include <Plugins/Preview/hctPreviewTreeViewManager.h>
#include <Common/Base/Container/RelArray/hkRelArray.h>
#include <Common/Base/Container/String/hkStringBuf.h>


int hctPreviewTreeViewManager::getUnknownIconIndex()
{
    static int numIconNames = sizeof(orderedIconNames) / sizeof(IconName);
    for (int i=0; i<numIconNames; ++i)
    {
        const char* name = orderedIconNames[i].m_name;
        if ( hkString::strCmp(name, "unknown")==0 ) return i;
    }
    return -1;
}

int hctPreviewTreeViewManager::getIconIndex(const hkStringOld& className)
{
    static int numIconNames = sizeof(orderedIconNames) / sizeof(IconName);

    for (int i=0; i<numIconNames; ++i)
    {
        const char* name = orderedIconNames[i].m_name;

        if (className.compareTo(name)==0)
        {
            return i;
        }
    }

    static int numIconPairs = sizeof(iconPairs) / sizeof(IconPair);
    for (int i=0; i<numIconPairs; ++i)
    {
        if ( className.compareTo(iconPairs[i].m_className)==0 )
        {
            return getIconIndex(iconPairs[i].m_iconName);
        }
    }

    return -1;
}

int hctPreviewTreeViewManager::getIconIndexForVariant(const hkVariant& varIn)
{
    bool doAnotherTry = true;
    bool iconFound = false;

    const hkReflect::Type* currentClass = varIn.getType();
    const void* currentObj = varIn.getData();

    // We repeat the process each time we go up the hierarchy of classes
    while (doAnotherTry)
    {
        doAnotherTry = false;
        const char* className = currentClass->getName();

        int iconIndex = getIconIndex(className);
        if (iconIndex >= 0)
        {
            return iconIndex;
        }

        if (const hkRootLevelContainer::NamedVariant* object = hkReflect::upCast<hkRootLevelContainer::NamedVariant>(currentObj, currentClass))
        {
            if (const hkReflect::Type* subClass = object->getType())
            {
                currentClass = subClass;
                currentObj = object->getObject();
                doAnotherTry = true;
            }
        }

        if (const hkReflect::RecordType* rec = currentClass->asRecord())
        {
            if (const hkReflect::Type* parent = rec->getParent())
            {
                // Check the parent class
                currentClass = parent;
                doAnotherTry = true;
            }
        }
    }

    // No icon found - use generic one
    return getUnknownIconIndex();
}

template <typename T>
struct _DummyArray
{
    T* data;
    int size;
};

namespace
{
    
    struct TreeViewVisitor : public hkReflect::VarVisitor<TreeViewVisitor, void, hkStringOld&, hkArray< hkVariant >&>
    {
        void visit(const hkReflect::VoidVar&, hkStringOld&, hkArray<hkVariant>&) { HK_UNREACHABLE(0x497cfa70, "Void field found" ); }
        void visit(const hkReflect::OpaqueVar&, hkStringOld&, hkArray<hkVariant>&) { /* do nothing */ }
        void visit(const hkReflect::ValueVar&, hkStringOld&, hkArray<hkVariant>&) { /* do nothing */ }

        void visit(const hkReflect::PointerVar& ptrVar, hkStringOld& name, hkArray<hkVariant>& children)
        {
            if(hkReflect::Var tgt = ptrVar.getValue())
            {
                dispatch(tgt, name, children);
            }
        }

        void visit(const hkReflect::RecordVar& recVar, hkStringOld& name, hkArray<hkVariant>& children)
        {
            children.pushBack(recVar);
        }

        void visit(const hkReflect::StringVar& strVar, hkStringOld& name, hkArray<hkVariant>& children)
        {
            if (hkReflect::FieldDecl asField = strVar.getType()->isField())
            {
                if (hkString::strCmp(asField.getName(), "name") == 0)
                {
                    name = strVar.getValue();
                }
            }
        }

        void visit(const hkReflect::ArrayVar& conVar, hkStringOld& name, hkArray<hkVariant>& children)
        {
            for (hkReflect::VarIter varIt = conVar.begin(); varIt != conVar.end(); ++varIt)
            {
                hkStringOld dummy;
                dispatch(*varIt, dummy, children);
            }
        }
    };
}

void hctPreviewTreeViewManager::getItemData( const hkVariant& var, hkStringOld& name, hkArray< hkVariant >& children, int& imageIndex )
{
    name = "";
    children.clear();
    imageIndex = -1;

    for (hkReflect::DeclIter<hkReflect::FieldDecl> recIt(var.getType()); recIt.advance();)
    {
        TreeViewVisitor().dispatch(var[recIt.current()], name, children);
    }

    // Use class name if object not named
    if( name.getLength() < 1 )
    {
        name.printf("%s", var.getType()->getName());
    }

    imageIndex = getIconIndexForVariant(var);
}


int hctPreviewTreeViewManager::getVariantIndex( const hkVariant& var )
{
    int numVars = m_treeViewVariantMap.getSize();
    for( int vi=0; vi < numVars; ++vi )
    {
        if( m_treeViewVariantMap[vi] == var )
        {
            return vi;
        }
    }

    hkVariant& newVar = m_treeViewVariantMap.expandOne();
    newVar = var;
    return numVars;
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
