// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <Plugins/Preview/hctPreviewPlugin.h> //PCH

#pragma unmanaged

#include <Common/Base/hkBase.h>
#include <Common/Serialize/Util/hkRootLevelContainer.h>

#include <Plugins/Preview/hctPreviewUnmanaged.h>
#include <Plugins/Preview/hctPreviewAsset.h>

using namespace PreviewPlugin;

void PreviewPluginImpl::step(float dt)
{
    if (m_assetManager) // do we have anything to step
    {
        if (m_destructionImpl)
        {
            m_destructionImpl->step(dt);
        }

        if (m_completeImpl)
        {
            m_completeImpl->step(dt);
        }
        else
        {
            if (m_animImpl)
            {
                m_animImpl->step(dt);
            }

            if (m_physicsImpl)
            {
                m_physicsImpl->step(dt);
            }

            if (m_newPhysicsImpl)
            {
            m_newPhysicsImpl->step(dt);
            }

        }

        if ( m_newDestructionImpl )
        {
            m_newDestructionImpl->step(dt);
        }

        // cloth reacts to what is moving, so can just be stepped after phys/anim etc
        if (m_clothImpl)
        {
            m_clothImpl->step(dt);
        }
    }
}

#pragma managed

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
