// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <Plugins/Preview/hctPreviewPlugin.h> //PCH
#include <Plugins/Preview/hctPreviewControl.h>

#pragma unmanaged

#include <Common/Base/hkBase.h>
#include <Common/SceneData/Scene/hkxScene.h>
#include <Common/SceneData/Graph/hkxNode.h>
#include <Common/SceneData/Scene/hkxSceneUtils.h>
#include <Common/Serialize/Util/hkRootLevelContainer.h>
#include <Common/Base/System/Io/Writer/Array/hkArrayStreamWriter.h>
#include <Common/Base/Serialize/Core/hkSerializeCore.h>
#include <Common/Base/Serialize/Format/Xml/hkXmlWriteFormat.h>

#include <Plugins/Preview/hctPreviewUnmanaged.h>
#include <Plugins/Preview/hctPreviewAsset.h>
#include <Plugins/Preview/hctPreviewTreeViewManager.h>

#include <Graphics/Common/hkGraphics.h>
#include <Graphics/Common/DisplayObject/hkgDisplayObject.h>
#include <Graphics/Common/DisplayWorld/hkgDisplayWorld.h>

#ifdef HK_ENABLE_DESTRUCTION_2012
#   include <Destruction2012/Destruction/World/hkdWorld.h>                  
#endif
#ifdef HK_ENABLE_DESTRUCTION
#   include <Destruction/Destruction/hkndDestruction.h>         
#endif

#pragma  managed

using namespace PreviewPlugin;

ref class TreeNodeTag
{
public:
    int m_index;
};

static void RecursiveSetForeColorNode(TreeNode^ node, System::Drawing::Color c)
{
    if (node != nullptr)
    {
        node->ForeColor = c;
        TreeNodeCollection^ nodes = node->Nodes;
        for (int ci=0; ci < nodes->Count; ++ci )
        {
            RecursiveSetForeColorNode( nodes[ci], c );
        }
    }
}


// todo.rt duplicate in View XML filter
namespace
{
    class DummyTypeWriter : public hkSerialize::TypeWriter
    {
    public:
        virtual hkSerialize::TypeAndId writeType(const hkReflect::Type* type) HK_OVERRIDE
        {
            return hkTupleT::make(type, 0);
        }
        virtual hkSerialize::TypeId getHighestWrittenId() const HK_OVERRIDE
        {
            return 0;
        }
    };

    void s_erasePointed(const hkReflect::Var& var, hkSerialize::BundleBuilder& bb, void* root)
    {
        if (var.getAddress() != root)
        {
            bb.addEmpty(var);
        }
    }
}


TreeNode^ hctPreviewControl::addVariantNode(const hkVariant& variant, TreeNode^ parentTreeNode)
{
    int varIndex = m_treeViewManager->getVariantIndex(variant);

    hkStringOld objectName;
    hkArray< hkVariant > children;
    int imageIndex;
    m_treeViewManager->getItemData( variant, objectName, children, imageIndex );

    TreeNode^ node = gcnew TreeNode( gcnew String(objectName.cString()) );
    node->ForeColor = parentTreeNode->ForeColor;

    TreeNodeTag^ tag = gcnew TreeNodeTag;
    tag->m_index = varIndex;
    node->Tag = tag;

    if (imageIndex>=0)
    {
        node->ImageIndex = imageIndex;
        node->SelectedImageIndex = imageIndex;
    }

    parentTreeNode->Nodes->Add( node );

    // Make a tooltip for the node, containing the XML of the variant
    hkStringOld tooltipStr;
    {
        tooltipStr.printf("<!-- %s @ 0x%x -->\n", variant.getType()->getName(), variant.getData() );

        hkArray<char> buf;
        hkArrayStreamWriter asw(&buf, hkArrayStreamWriter::ARRAY_BORROW);
        DummyTypeWriter tw;
        hkSerialize::Save().withFormat<hkSerialize::XmlWriteFormat>().withCallbacks(variant.getAddress(), &s_erasePointed, HK_NULL).contentsVar(variant, &buf);
        buf.pushBack(0); 

        // Restrict number of chars in the tooltip, otherwise the tooltip may be huge (and annoying).
        const int TOOLTIP_MAX_CHARS = 1024;

        if (buf.getSize()>TOOLTIP_MAX_CHARS)
        {
            buf[TOOLTIP_MAX_CHARS] = 0;
        }

        tooltipStr += buf.begin();

        if (buf.getSize()>TOOLTIP_MAX_CHARS)
        {
            tooltipStr += " ... (continued)";
        }
    }

    node->ToolTipText = gcnew String(tooltipStr.cString());

    return node;
}


void hctPreviewControl::addGrandchildNodes(TreeNode^ parentNode, const hkVariant& parentVar)
{
    for (int ci=0; ci<parentNode->GetNodeCount(false); ++ci)
    {
        TreeNode^ childNode = parentNode->Nodes[ci];

        // Don't re-add grandchildren if they have already been added
        if (childNode->GetNodeCount(false)>0) continue;

        TreeNodeTag^ tag = static_cast<TreeNodeTag^>( childNode->Tag );
        int varIndex = tag->m_index;

        if( ( varIndex >= 0 ) && ( varIndex < m_treeViewManager->m_treeViewVariantMap.getSize() ) )
        {
            hkVariant& childVar = m_treeViewManager->m_treeViewVariantMap[varIndex];

            hkStringOld grandchildName;
            hkArray< hkVariant > grandchildren;
            int imageIndex;
            m_treeViewManager->getItemData( childVar, grandchildName, grandchildren, imageIndex );

            for (int gi=0; gi<grandchildren.getSize(); ++gi)
            {
                TreeNode^ grandchildNode = addVariantNode( grandchildren[gi], childNode );
            }
        }
    }
}


System::Void hctPreviewControl::sceneTreeView_NodeMouseClick(System::Object^  sender, System::Windows::Forms::TreeNodeMouseClickEventArgs^  e)
{
    TreeNode^ node = e->Node;
    TreeNodeTag^ tag = static_cast<TreeNodeTag^>( node->Tag );

    int varIndex = tag->m_index;

    if( ( varIndex >= 0 ) && ( varIndex < m_treeViewManager->m_treeViewVariantMap.getSize() ) )
    {
        hkVariant& var = m_treeViewManager->m_treeViewVariantMap[varIndex];

        if ( const hkxNode* node = hkDynCast<hkxNode>(var) )
        {
            if (m_si && m_si->m_displayWorld && node->m_name)
            {
                hkgDisplayWorld* displayWorld = m_si->m_displayWorld;

                for (int i=0; i<displayWorld->getNumDisplayObjects(); ++i)
                {
                    hkgDisplayObject* dObj = displayWorld->getDisplayObject(i);

                    if ( dObj && dObj->getName() && node->m_name && (hkString::strCmp( dObj->getName(), node->m_name)==0) )
                    {
                        m_si->m_currentSelectedObject = dObj;
                        displayObjectNameLabel->Text = gcnew String(dObj->m_name.cString());

                        // update Display props UI:
                        shadowCasterCheckBox->Checked = (dObj->getStatusFlags() & HKG_DISPLAY_OBJECT_SHADOWCASTER) != 0;
                        shadowRecvCheckBox->Checked = (dObj->getStatusFlags() & HKG_DISPLAY_OBJECT_SHADOWRECEIVER) != 0;
                        litCheckBox->Checked = (dObj->getStatusFlags() & HKG_DISPLAY_OBJECT_UNLIT) == 0;
                        break;
                    }
                }
            }
        }
    }
}


System::Void hctPreviewControl::sceneTreeViewNodeExpand(System::Object^  sender, System::Windows::Forms::TreeViewEventArgs^  e)
{
     TreeNode^ node = e->Node;
     TreeNodeTag^ tag = static_cast<TreeNodeTag^>( node->Tag );

     int varIndex = tag->m_index;

     if( ( varIndex >= 0 ) && ( varIndex < m_treeViewManager->m_treeViewVariantMap.getSize() ) )
     {
        hkVariant& var = m_treeViewManager->m_treeViewVariantMap[varIndex];
        addGrandchildNodes(node, var);
     }
}


void hctPreviewControl::RefreshSceneTreeView()
{
    RefreshDisplayTreeView();

    TreeNodeCollection^ nodes = sceneTreeView->Nodes;

    nodes->Clear();

    // Association between tree node indices and hkVariants must be refreshed
    m_treeViewManager->init();

    if (m_si->m_assetManager)
    {
        for (int ai=0; ai < m_si->m_assetManager->m_allAssets.getSize(); ++ai)
        {
            PreviewAsset* asset = m_si->m_assetManager->m_allAssets[ai];
            hkRootLevelContainer* root = asset->m_container;
            if (root)
            {
                TreeNode^ rootNode;

                if (asset->m_filename.getLength()>0)
                {
                    String^ path = gcnew String(asset->m_filename.cString());
                    String^ result = System::IO::Path::GetFileName(path);
                    rootNode = gcnew TreeNode( result );
                }
                else
                {
                    String^ assetName = gcnew String("Asset[") + IntPtr(ai).ToString() + gcnew String("]");
                    rootNode = gcnew TreeNode( assetName );
                }

                int imageIndex = m_treeViewManager->getIconIndex("hkRootLevelContainer");
                if (imageIndex>=0)
                {
                    rootNode->ImageIndex = imageIndex;
                    rootNode->SelectedImageIndex = imageIndex;
                }

                hkVariant rootVariant(root, hkReflect::getType<hkRootLevelContainer>());
                int rootVarIndex = m_treeViewManager->getVariantIndex( rootVariant );

                for (int vi=0; vi<root->m_namedVariants.getSize(); ++vi)
                {
                     const hkRootLevelContainer::NamedVariant& namedVariant = root->m_namedVariants[vi];

                     if ( hkVariant var = namedVariant.getRefVariant() )
                     {
                         TreeNode^ childNode = addVariantNode( var, rootNode );
                     }
                }

                TreeNodeTag^ tag = gcnew TreeNodeTag;
                tag->m_index = rootVarIndex;
                rootNode->Tag = tag;

                bool enabled = m_si->m_assetManager->isEnabled(asset);
                rootNode->ForeColor = enabled? SystemColors::WindowText : SystemColors::InactiveCaptionText;

                nodes->Add( rootNode );
            }
        }
    }
}

System::Void hctPreviewControl::displayTreeView_AfterSelect(System::Object^  sender, System::Windows::Forms::TreeViewEventArgs^  e)
{
    TreeNode^ node = e->Node;
    TreeNodeTag^ tag = static_cast<TreeNodeTag^>( node->Tag );

    int displayObjectIndex = tag->m_index;

    if( ( displayObjectIndex >= 0 ) && ( displayObjectIndex < m_treeViewManager->m_displayObjectMap.getSize() ) )
    {
        hkgDisplayObject* dObj = m_treeViewManager->m_displayObjectMap[displayObjectIndex];

        if( m_si->m_displayWorld->containsDisplayObject(dObj) )
        {
            m_si->m_currentSelectedObject = dObj;
            displayObjectNameLabel->Text = gcnew String(dObj->m_name.cString());

            // update Display props UI:
            shadowCasterCheckBox->Checked = (dObj->getStatusFlags() & HKG_DISPLAY_OBJECT_SHADOWCASTER) != 0;
            shadowRecvCheckBox->Checked = (dObj->getStatusFlags() & HKG_DISPLAY_OBJECT_SHADOWRECEIVER) != 0;
            litCheckBox->Checked = (dObj->getStatusFlags() & HKG_DISPLAY_OBJECT_UNLIT) == 0;
        }
    }
}

void hctPreviewControl::RefreshDisplayTreeView()
{
    TreeNodeCollection^ nodes = displayTreeView->Nodes;
    displayTreeView->Sorted = true;

    displayTreeView->BeginUpdate();

    nodes->Clear();
    m_treeViewManager->m_displayObjectMap.clear();

    if ((m_si && m_si->m_displayWorld))
    {
        hkgDisplayWorld* displayWorld = m_si->m_displayWorld;

        for (int i=0; i< displayWorld->getNumDisplayObjects(); ++i)
        {
            hkgDisplayObject* dObj = displayWorld->getDisplayObject(i);

            if (dObj->getName() != HK_NULL && hkString::strLen(dObj->getName()) > 0)
            {
                TreeNode^ node = gcnew TreeNode( gcnew String(dObj->getName()) );
                node->ForeColor = SystemColors::WindowText;

                TreeNodeTag^ tag = gcnew TreeNodeTag;
                tag->m_index = m_treeViewManager->m_displayObjectMap.getSize();
                m_treeViewManager->m_displayObjectMap.pushBack(dObj);
                node->Tag = tag;

                nodes->Add(node);
            }
        }
    }

    displayTreeView->EndUpdate();
}

System::Void hctPreviewControl::clearSceneButton_Click(System::Object^  sender, System::EventArgs^  e)
{
    if (m_si && m_si->m_assetManager)
    {
        m_si->waitForStepCompletion();

        savePreferences();

        m_si->m_assetManager->removeReference();
        m_si->m_assetManager = new PreviewAssetManager();

        loadPreferences();

        m_si->m_assetManager->m_jobQueue        = m_si->m_jobQueue;
        m_si->m_assetManager->m_displayHandler  = (hkgDisplayHandler*)m_display->getInternalPtr().ToPointer();
        m_si->m_assetManager->m_displayWorld    = (hkgDisplayWorld*)m_display->m_world->getInternalPtr().ToPointer();
        m_si->m_assetManager->m_displayContext  = (hkgDisplayContext*)m_display->m_context->getInternalPtr().ToPointer();

#ifdef HK_ENABLE_PHYSICS
        m_si->m_assetManager->m_npVdbContext    = &m_si->m_newPhysicsVdbContext;
#endif

#ifdef HK_ENABLE_CLOTH_PREVIEW
        m_si->m_assetManager->m_clothVdbContext = m_si->m_clothVdbContext;
#endif

        configureProductsFromUI();

        RefreshSceneTreeView();
        RefreshCameraLists();
    }
}

static PreviewAsset* _getAssetForCurrentNode( TreeView^ tree, PreviewAssetManager* manager, TreeNode^& parentNode)
{
    // Top level node index == allAssets index at the momemt:
    parentNode = tree->SelectedNode;
    if (parentNode != nullptr)
    {
        while (parentNode->Parent != nullptr)
        {
            parentNode= parentNode->Parent;
        }

        TreeNodeCollection^ toplevelNodes = tree->Nodes;
        int idx = toplevelNodes->IndexOf(parentNode);
        if ((idx >= 0) && (idx < manager->m_allAssets.getSize()) )
        {
            return manager->m_allAssets[idx];
        }
    }

    return HK_NULL;
}

System::Void hctPreviewControl::enableToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e)
{
    if (m_si && m_si->m_assetManager)
    {
        TreeNode^ parentNode = nullptr;
        PreviewAsset* asset = _getAssetForCurrentNode( sceneTreeView, m_si->m_assetManager, parentNode);
        if (asset)
        {
            m_si->m_assetManager->enableAsset( asset );
            m_si->notifyAssetAddedOrRemoved();

            bool firstPersonCameraEnabled = false;

#ifdef HK_ENABLE_DESTRUCTION_2012
            if (m_si->m_assetManager->m_destructionWorld && m_si->m_assetManager->m_destructionWorld->m_breakableBodies.getSize())
            {
                restartButton->Enabled = false;
            }
            if ( m_si->m_assetManager->m_demoConfig )
            {
                firstPersonCameraEnabled = true;
            }
#endif
#ifdef HK_ENABLE_DESTRUCTION
            if ( m_si->m_assetManager->m_ndDemoCfg )
            {
                firstPersonCameraEnabled = true;
            }
#endif

            enableFirstPersonCamera(firstPersonCameraEnabled);

            RepopulateMeshChannelMenu();
            EnableAssetMeshChannels(m_si->m_assetManager->m_allAssets.indexOf(asset));
            RepopulateClothTransitionForm();
            RefreshDisplayTreeView();
        }

        if (parentNode != nullptr)
        {
            RecursiveSetForeColorNode(parentNode, SystemColors::WindowText);
        }
    }
}

System::Void hctPreviewControl::disableToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e)
{
    if (m_si && m_si->m_assetManager)
    {
        TreeNode^ parentNode = nullptr;
        PreviewAsset* asset = _getAssetForCurrentNode( sceneTreeView, m_si->m_assetManager, parentNode);
        if (asset)
        {
            m_si->m_assetManager->disableAsset( asset );
            m_si->notifyAssetAddedOrRemoved();
            RepopulateMeshChannelMenu();
            DisableAssetMeshChannels(m_si->m_assetManager->m_allAssets.indexOf(asset));
            RepopulateClothTransitionForm();
            RefreshDisplayTreeView();
        }

        if (parentNode != nullptr)
        {
            RecursiveSetForeColorNode(parentNode, SystemColors::InactiveCaptionText);
        }
    }
}

System::Void hctPreviewControl::removeToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e)
{
    if (m_si && m_si->m_assetManager)
    {
        TreeNode^ parentNode = nullptr;
        PreviewAsset* asset = _getAssetForCurrentNode( sceneTreeView, m_si->m_assetManager, parentNode);
        if (asset)
        {
            m_si->m_assetManager->removeAsset( asset );
            m_si->notifyAssetAddedOrRemoved();
            RepopulateMeshChannelMenu();
            RepopulateClothTransitionForm();
            RefreshDisplayTreeView();
        }

        if (parentNode != nullptr)
        {
            TreeNodeCollection^ nodes = sceneTreeView->Nodes;
            nodes->Remove( parentNode );
        }
    }
}

System::Void hctPreviewControl::sceneViewMenuStrip_Opening(System::Object^  sender, System::ComponentModel::CancelEventArgs^  e)
{
    // Change selection to be the node under the mouse, not the 'current sel' as that is may be null etc anyway
    System::Drawing::Point mousePos = Control::MousePosition;
    mousePos = sceneTreeView->PointToClient(mousePos);
    TreeViewHitTestInfo^ info = sceneTreeView->HitTest(mousePos);
    TreeNode^ node = info->Node;

    if (node != nullptr)
    {
        sceneTreeView->SelectedNode = node;
    }
    else if (sceneTreeView->SelectedNode == nullptr)
    {
        e->Cancel = true;
    }
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
