// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <Plugins/Preview/hctPreviewPlugin.h> //PCH
#include <Plugins/Preview/hctPreviewControl.h>

#pragma unmanaged

#include <Common/Base/Fwd/hkwindows.h>
#include <WinSock2.h>

#include <Common/Base/hkBase.h>
#include <Common/Base/Algorithm/Sort/hkSort.h>
#include <Common/Base/System/Stopwatch/hkStopwatch.h>
#include <Common/Base/System/Io/Socket/hkSocket.h>
#include <Common/Base/System/Io/IArchive/hkIArchive.h>
#include <Common/Base/System/Io/IStream/hkIStream.h>
#include <Common/Base/System/Io/Reader/hkStreamReader.h>
#include <Common/Base/System/Io/OArchive/hkOArchive.h>
#include <Common/Base/System/Io/OStream/hkOStream.h>
#include <Common/Base/System/Io/Reader/Memory/hkMemoryStreamReader.h>
#include <Common/Base/System/Io/Writer/Array/hkArrayStreamWriter.h>
#include <Common/Base/Container/String/hkUtf8.h>
#include <Common/Base/Serialize/hkSerialize.h>

#include <Common/Serialize/Util/hkSerializeUtil.h>
#include <Common/Serialize/Util/hkRootLevelContainer.h>
#include <Common/Base/Serialize/Resource/hkResource.h>

#include <Common/SceneData/hkSceneData.h>
#include <Common/SceneData/Scene/hkxScene.h>
#include <Common/SceneData/Scene/hkxSceneUtils.h>
#include <Common/SceneData/Graph/hkxNode.h>
#include <Common/SceneData/Camera/hkxCamera.h>
#include <Common/SceneData/Light/hkxLight.h>
#include <Common/SceneData/Mesh/hkxVertexBuffer.h>
#include <Common/SceneData/Mesh/hkxIndexBuffer.h>
#include <Common/SceneData/Mesh/hkxMesh.h>
#include <Common/SceneData/Skin/hkxSkinBinding.h>
#include <Common/SceneData/Material/hkxMaterial.h>
#include <Common/SceneData/Material/hkxTextureFile.h>
#include <Common/SceneData/Material/hkxTextureInplace.h>
#include <Common/SceneData/Selection/hkxNodeSelectionSet.h>
#include <Common/SceneData/Environment/hkxEnvironment.h>

#include <Plugins/Preview/hctPreviewAsset.h>
#include <Plugins/Preview/hctPreviewUnmanaged.h>
#include <Common/Base/KeyCode.h>

#ifdef HK_ENABLE_ANIMATION
#include <Animation/Animation/hkaAnimationContainer.h>
#include <Animation/Animation/Animation/hkaAnimationBinding.h>
#include <Animation/Animation/Animation/hkaAnnotationTrack.h>
#include <Animation/Animation/Animation/hkaAnimation.h>
#include <Animation/Animation/Animation/Interleaved/hkaInterleavedUncompressedAnimation.h>
#include <Animation/Animation/Motion/Default/hkaDefaultAnimatedReferenceFrame.h>
#include <Animation/Animation/Motion/hkaAnimatedReferenceFrame.h>

#include <Common/GeometryUtilities/Skeleton/hkaBone.h>
#include <Common/GeometryUtilities/Skeleton/hkaSkeleton.h>
#include <Animation/Animation/Rig/hkaBoneAttachment.h>
#include <Common/GeometryUtilities/Skeleton/hkaSkeletonUtils.h>
#include <Animation/Animation/Deform/Skinning/hkaMeshBinding.h>
#endif

#ifdef HK_ENABLE_CLOTH_PREVIEW
#include <Cloth/Cloth/hclCloth.h>
#include <Cloth/Cloth/Container/hclClothContainer.h>
#include <Cloth/Cloth/Cloth/hclClothData.h>
#include <Cloth/Cloth/Collide/hclCollidable.h>
#include <Cloth/Setup/Container/hclClothSetupContainer.h>
#endif
#include <Common/Base/Serialize/Format/Xml/hkXmlWriteFormat.h>

#define DEBUG_LOG_DEFAULT_LEVEL Info
#define DEBUG_LOG_IDENTIFIER "hct.previewtool"
#include <Common/Base/System/Log/hkLog.hxx>


#pragma managed

using namespace PreviewPlugin;
using namespace System::Runtime::InteropServices;
using namespace Microsoft::Win32;
using namespace System::IO;
using namespace System::Windows::Forms;


struct TempBuffer
{
    TempBuffer(bool calcBufferSizeOnly) : m_numAllocated(0), m_calcBufferSizeOnly(calcBufferSizeOnly) { }

    void setSize(int n)
    {
        m_buffer.setSize(n);
    }

    char* allocateBytes(int n)
    {
        int oldNumAlloc = m_numAllocated;
        m_numAllocated += n;

        if (!m_calcBufferSizeOnly)
        {
            return m_buffer.begin() + oldNumAlloc;
        }
        return HK_NULL;
    }

    ~TempBuffer()
    {
        m_buffer.clearAndDeallocate();
    }

    int bufferSize()
    {
        return m_numAllocated;
    }

    hkArray<char> m_buffer;
    int m_numAllocated;
    bool m_calcBufferSizeOnly;
};


template< typename T >
void _mergeSimpleArrays( T*& masterArray, int& numMaster, T* otherArray, int numOther, TempBuffer& tempBuffer )
{
    if (!masterArray)
    {
        if (!tempBuffer.m_calcBufferSizeOnly)
        {
            masterArray = otherArray;
            numMaster = numOther;
        }
        return;
    }
    else if (!otherArray)
    {
        return;
    }

    // have stuff in both, have to reallocate the master array
    int totalElems = numMaster + numOther;

    T* newData = (T*) tempBuffer.allocateBytes( sizeof(T) * totalElems );

    if (newData)
    {
        hkString::memCpy( newData, masterArray, numMaster*sizeof(T) );
        hkString::memCpy( newData + numMaster, otherArray, numOther*sizeof(T) );
        masterArray = newData;
        numMaster = totalElems;
    }
}


#ifdef HK_ENABLE_ANIMATION

hkaAnimationContainer* _mergeAnims(hkaAnimationContainer* master, hkaAnimationContainer* other, TempBuffer& tempBuffer)
{
    if ( other->m_skeletons.getSize())
    {
        master->m_skeletons.insertAt( master->m_skeletons.getSize(), other->m_skeletons.begin(), other->m_skeletons.getSize() );
    }

    if ( other->m_animations.getSize())
    {
        master->m_animations.insertAt( master->m_animations.getSize(), other->m_animations.begin(), other->m_animations.getSize() );
    }

    if ( other->m_bindings.getSize())
    {
        master->m_bindings.insertAt( master->m_bindings.getSize(), other->m_bindings.begin(), other->m_bindings.getSize() );
    }

    if ( other->m_attachments.getSize())
    {
        master->m_attachments.insertAt( master->m_attachments.getSize(), other->m_attachments.begin(), other->m_attachments.getSize() );
    }

    if ( other->m_skins.getSize())
    {
        master->m_skins.insertAt( master->m_skins.getSize(), other->m_skins.begin(), other->m_skins.getSize() );
    }

    return master;
}

#endif


#ifdef HK_ENABLE_CLOTH_PREVIEW

hclClothContainer* _mergeCloth(hclClothContainer* master, const hclClothContainer* other)
{
    for (int i=0; i<other->m_clothDatas.getSize(); ++i)
    {
        master->m_clothDatas.pushBack(other->m_clothDatas[i]);
    }
    for (int i=0; i<other->m_collidables.getSize(); ++i)
    {
        master->m_collidables.pushBack(other->m_collidables[i]);
    }
    return master;
}

hclClothSetupContainer* _mergeSetupCloth(hclClothSetupContainer* master, const hclClothSetupContainer* other)
{
    for (int i=0; i<other->m_clothSetupDatas.getSize(); ++i)
    {
        master->m_clothSetupDatas.pushBack(other->m_clothSetupDatas[i]);
    }
    for (int ii=0; ii<other->m_namedSetupMeshWrappers.getSize(); ++ii)
    {
        master->m_namedSetupMeshWrappers.pushBack(other->m_namedSetupMeshWrappers[ii]);
    }
    for (int iii=0; iii<other->m_namedTransformSetWrappers.getSize(); ++iii)
    {
        master->m_namedTransformSetWrappers.pushBack(other->m_namedTransformSetWrappers[iii]);
    }
    return master;
}

#endif


hkxScene* _mergeScene( hkxScene* master, hkxScene* other, TempBuffer& tempBuffer )
{
    if (other->m_asset) master->m_asset = other->m_asset;

    if (other->m_sceneLength > master->m_sceneLength) master->m_sceneLength = other->m_sceneLength;

    if (other->m_rootNode)
    {
        if (!master->m_rootNode)
        {
            master->m_rootNode = other->m_rootNode;
        }
        else // two root nodes.. add children in as root (root never animated etc anyway)
        {
            master->m_rootNode->m_children.insertAt( master->m_rootNode->m_children.getSize(), other->m_rootNode->m_children.begin(), other->m_rootNode->m_children.getSize() );
        }
    }

    if ( other->m_cameras.getSize())
    {
        master->m_cameras.insertAt( master->m_cameras.getSize(), other->m_cameras.begin(), other->m_cameras.getSize() );
    }

    if ( other->m_lights.getSize())
    {
        master->m_lights.insertAt( master->m_lights.getSize(), other->m_lights.begin(), other->m_lights.getSize() );
    }

    if ( other->m_meshes.getSize())
    {
        master->m_meshes.insertAt( master->m_meshes.getSize(), other->m_meshes.begin(), other->m_meshes.getSize() );
    }

    if ( other->m_materials.getSize())
    {
        master->m_materials.insertAt( master->m_materials.getSize(), other->m_materials.begin(), other->m_materials.getSize() );
    }

    if ( other->m_inplaceTextures.getSize())
    {
        master->m_inplaceTextures.insertAt( master->m_inplaceTextures.getSize(), other->m_inplaceTextures.begin(), other->m_inplaceTextures.getSize() );
    }

    if ( other->m_externalTextures.getSize())
    {
        master->m_externalTextures.insertAt( master->m_externalTextures.getSize(), other->m_externalTextures.begin(), other->m_externalTextures.getSize() );
    }

    if ( other->m_skinBindings.getSize())
    {
        master->m_skinBindings.insertAt( master->m_skinBindings.getSize(), other->m_skinBindings.begin(), other->m_skinBindings.getSize() );
    }

    return master;
}

void _mergeEnvironment (hkxEnvironment* master,class hkxEnvironment* other)
{
    if (!other) return;

    for (int v=0; v<other->getNumVariables(); v++)
    {
        const char* name = other->getVariableName(v);
        const char* value = other->getVariableValue(v);

        // We don't want to override new values - we only set non-existing variables
        if (master && master->getVariableValue(name)==HK_NULL)
        {
            master->setVariable(name, value);
        }
    }
}


// If we pass in a TempBuffer with tempBuffer.m_calcBufferSizeOnly = true, we're just computing the total size
// of the buffer needed to perform the merge. The masterContainer is only actually modified if tempBuffer.m_calcBufferSizeOnly = true.
void _mergeContainers( hkRootLevelContainer* masterContainer, hkRootLevelContainer* otherContainer, TempBuffer& tempBuffer )
{
    hkStringMap<hkBool32> knownContainers;


    // Check for the scene containers
    {
        hkxScene* masterScene = masterContainer->findObject<hkxScene>();
        hkxScene* otherScene = otherContainer->findObject<hkxScene>();

        if (otherScene && masterScene)
        {
            do
            {
                _mergeScene(masterScene, otherScene, tempBuffer);
            }
            while ( (otherScene = otherContainer->findObject<hkxScene>(otherScene)) != HK_NULL );

            // Add hkxScene to the knownContainers
            knownContainers.insert( hkReflect::getName<hkxScene>(), true );
        }
    }

    // Check for environment containers
    {
        hkxEnvironment* masterEnvironment = masterContainer->findObject<hkxEnvironment>();
        hkxEnvironment* otherEnvironment = otherContainer->findObject<hkxEnvironment>();

        if (otherEnvironment)
        {
            do
            {
                _mergeEnvironment(masterEnvironment, otherEnvironment);
            }
            while ( (otherEnvironment = otherContainer->findObject<hkxEnvironment>(otherEnvironment)) != HK_NULL );

            // Add hkxEnvironment to the knownContainers
            knownContainers.insert( hkReflect::getName<hkxEnvironment>(), true );
        }
    }

    int totalVars = masterContainer->m_namedVariants.getSize() + otherContainer->m_namedVariants.getSize();
    if( totalVars > masterContainer->m_namedVariants.getCapacity() )
    {
        hkArray<hkRootLevelContainer::NamedVariant> containerCopy; // copy of master
        containerCopy = masterContainer->m_namedVariants;

        // Allocate new master buffer
        hkRootLevelContainer::NamedVariant* mergedVariants = (hkRootLevelContainer::NamedVariant*)(tempBuffer.allocateBytes( sizeof(hkRootLevelContainer::NamedVariant) * totalVars ));
        if (mergedVariants)
        {
            masterContainer->m_namedVariants._setDataUnchecked(mergedVariants, 0, totalVars | masterContainer->m_namedVariants.DONT_DEALLOCATE_FLAG);
            masterContainer->m_namedVariants = containerCopy; // copy to new master buffer
        }
    }


#ifdef HK_ENABLE_ANIMATION

    // Check for the anim containers
    {
        hkaAnimationContainer* masterAnim = masterContainer->findObject<hkaAnimationContainer>();

        hkaAnimationContainer* otherAnim = HK_NULL;
        while ((otherAnim = otherContainer->findObject<hkaAnimationContainer>(otherAnim))!=HK_NULL)
        {
            if (masterAnim == HK_NULL)
            {
                // Add a new animation container
                char* buff = tempBuffer.allocateBytes(sizeof(hkaAnimationContainer));
                if (buff)
                {
                    masterAnim = new (buff) hkaAnimationContainer;
                    hkString::memSet( masterAnim, 0, sizeof(hkaAnimationContainer));
                }
                masterContainer->m_namedVariants.expandOne().set( "Merged Animation Container", masterAnim );
            }

            if (masterAnim && otherAnim)
            {
                _mergeAnims(masterAnim, otherAnim, tempBuffer);
            }
        }
    }

    // Add hkaAnimationContainer to the knownContainers
    knownContainers.insert( hkReflect::getName<hkaAnimationContainer>(), true );

#endif


#ifdef HK_ENABLE_CLOTH_PREVIEW

    // Check for the cloth containers
    {
        hclClothContainer* masterCloth = masterContainer->findObject<hclClothContainer>();

        hclClothContainer* otherCloth = HK_NULL;
        while ((otherCloth = otherContainer->findObject<hclClothContainer>(otherCloth))!=HK_NULL)
        {
            if (masterCloth == HK_NULL)
            {
                // Add a new cloth container
                char* buff = tempBuffer.allocateBytes(sizeof(hclClothContainer));
                if (buff)
                {
                    masterCloth = new (buff) hclClothContainer;
                }

                masterContainer->m_namedVariants.expandOne().set( "Merged Cloth Container", masterCloth );
            }

            if (masterCloth && otherCloth && !tempBuffer.m_calcBufferSizeOnly)
            {
                _mergeCloth(masterCloth, otherCloth);
            }
        }
    }

    // Add hclClothContainer to the knownContainers
    knownContainers.insert( hkReflect::getName<hclClothContainer>(), true );


    // Check for the cloth setup containers
    {
        hclClothSetupContainer* masterSetupCloth = masterContainer->findObject<hclClothSetupContainer>();

        hclClothSetupContainer* otherSetupCloth = HK_NULL;
        while ((otherSetupCloth = otherContainer->findObject<hclClothSetupContainer>(otherSetupCloth))!=HK_NULL)
        {
            if (masterSetupCloth == HK_NULL)
            {
                // Add a new cloth container
                char* buff = tempBuffer.allocateBytes(sizeof(hclClothSetupContainer));
                if (buff)
                {
                    masterSetupCloth = new (buff) hclClothSetupContainer;
                }

                masterContainer->m_namedVariants.expandOne().set( "Merged Cloth Setup Container", masterSetupCloth);
            }

            if (masterSetupCloth && otherSetupCloth && !tempBuffer.m_calcBufferSizeOnly)
            {
                _mergeSetupCloth(masterSetupCloth, otherSetupCloth);
            }
        }
    }
#endif

    // Iterate through the rest and append.
    {
        for (int v=0; v < otherContainer->m_namedVariants.getSize(); ++v)
        {
            const char* nvName = otherContainer->m_namedVariants[v].getTypeName();
            if( !knownContainers.getWithDefault(nvName, false) )
            {
                // Add a new container
                masterContainer->m_namedVariants.expandOne() = otherContainer->m_namedVariants[v];
            }
        }
    }
}


/* static */ bool _isExportable( const hkRootLevelContainer::NamedVariant& a )
{
    // Null-terminated array of names of non-exportable classes
    // Add any new non-exportable class names here
    static char* nonExportables[] = { "hkaFootstepAnalysisInfoContainer", "hkaAnimationPreviewColorContainer", "hkAlignSceneToNodeOptions", 0 };

    // For each (non-null) entry of the array...
    for ( int i = 0; nonExportables[ i ] != 0; i++ )
    {
        if ( hkString::strCmp( a.getTypeName(), nonExportables[ i ] ) == 0 )
        {
            // A match was found.  This class is not exportable.
            return false;
        }
    }

    // No matches were found.  This class is exportable.
    return true;
}


/* static */ bool _compareExportableLess( const hkRootLevelContainer::NamedVariant& a, const hkRootLevelContainer::NamedVariant& b )
{
    // Enforce that non-exportables are greater than exportables
    if ( _isExportable( a ) && !_isExportable( b ) )
    {
        return true;
    }
    return false;
}

void* _deepCopyObject( const void* obj, const hkReflect::Type* klass, hkArray<char>& storage )
{
    // todo.rt discard type data some way?
    hkSerialize::Save().withTarget(HK_NULL).contentsVar(hkReflect::Var(obj, klass), &storage);
    return hkSerialize::InplaceLoad().toVar(storage.begin(), storage.getSize()).getAddress();
}

System::Void _status(const char* msg, System::Windows::Forms::Label^ statusField, System::Windows::Forms::Form^ form)
{
    statusField->Text = gcnew String(msg);
    form->Refresh();
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////
//////                                 Wii-connection only                                          //////
//////////////////////////////////////////////////////////////////////////////////////////////////////////
HINSTANCE hGetProcIDDLL;
FARPROC dllFuncID_main;
typedef void (__stdcall * DLLFUNC_main)();
DLLFUNC_main  mainWiiInterfaceFunction;

HANDLE hInterfaceThread[1];
DWORD dwThreadId[1];

bool m_wiiInterfaceLoaded  = FALSE;
bool m_wiiInterfaceRunning = FALSE;

DWORD WINAPI ThreadProc( LPVOID lpParam )
{
    mainWiiInterfaceFunction();

    // if interface has terminated, there must have been an error.
    // We restart the interface on the next connection attempt.
    m_wiiInterfaceRunning = FALSE;
    return 0;
}

static bool loadWiiInterfaceDLL()
{
    // Look for Wii-Preview interface DLL in the folder containing the Preview application
    hGetProcIDDLL = LoadLibrary(L"WiiPreviewInterface.dll");
    if ( !hGetProcIDDLL ) return false;

    dllFuncID_main = GetProcAddress( HMODULE(hGetProcIDDLL), "interfaceFunc" );
    if ( !dllFuncID_main )
    {
        FreeLibrary(hGetProcIDDLL);
        return false;
    }

    mainWiiInterfaceFunction = DLLFUNC_main(dllFuncID_main);
    m_wiiInterfaceLoaded = true;
    return true;
}

static void handleWiiConnection()
{
    // Check if the Wii interface DLL is available. If it is, a new thread is created which runs
    // the interface. Note that if a customer has the Wii DLL in place, the interface will run
    // even if the customer is connecting to a different platform. There's no harm in this - the
    // interface will just never get an HIO2 connection.

    if ( !m_wiiInterfaceRunning )
    {
        // Load the interface DLL if it hasn't already been
        if ( !m_wiiInterfaceLoaded )
        {
            if ( !loadWiiInterfaceDLL() ) return;
        }

        // Spawn a new thread which runs the interface
        hInterfaceThread[0] = CreateThread( NULL,              // default security attributes
                                            0,                // use default stack size
                                            ThreadProc,       // thread function
                                            NULL,             // argument to thread function
                                            0,                // use default creation flags
                                            &dwThreadId[0] );  // returns the thread identifier

        m_wiiInterfaceRunning = (hInterfaceThread[0] != NULL);
    }
}

/////////////////////////////////// Wii-connection only (end) ////////////////////////////////////////////


#       if defined(HK_PLATFORM_WIN64)
typedef unsigned __int64 socket_t;
#       elif defined(HK_PLATFORM_WIN32)
typedef unsigned socket_t;
#       endif


hkRootLevelContainer* _mergeToSingleRoot( PreviewAssetManager* assetManager, hkArray< hkArray<char>* >& sceneCopyStorageArrays, TempBuffer* containerBuffer )
{

    hkRootLevelContainer* allAssetsContainer = HK_NULL;

    if ( assetManager->m_enabledAssets.getSize() > 1 )
    {
        hkArray<hkRootLevelContainer*> containerCopies;

        // Make deep copies of the asset root level containers, in order to do a merge
        for (int a=0; a < assetManager->m_enabledAssets.getSize(); ++a)
        {
            hkRootLevelContainer* originalContainer = assetManager->m_enabledAssets[a]->m_container;

            hkArray<char>* sceneCopyStorageArray = new hkArray<char>();
            sceneCopyStorageArrays.pushBack(sceneCopyStorageArray);

            hkRootLevelContainer* copiedContainer = (hkRootLevelContainer*)_deepCopyObject(originalContainer, hkReflect::getType<hkRootLevelContainer>(), *sceneCopyStorageArray);
            containerCopies.pushBack(copiedContainer);
        }

        // We will merge all the copied containers into the first
        allAssetsContainer = containerCopies[0];

        // First compute required buffer size.
        TempBuffer* tempBuffer = new TempBuffer(true);
        for (int a=1; a<containerCopies.getSize(); ++a)
        {
            _mergeContainers(allAssetsContainer, containerCopies[a], *tempBuffer);
        }

        // Allocate space for the buffer which will store our merged container
        containerBuffer->setSize(tempBuffer->bufferSize());
        delete tempBuffer;

        for (int a=1; a<containerCopies.getSize(); ++a)
        {
            _mergeContainers(allAssetsContainer, containerCopies[a], *containerBuffer);
        }
    }
    else if ( assetManager->m_enabledAssets.getSize() == 1)
    {
        // Only one asset, so just send the existing container
        allAssetsContainer = assetManager->m_enabledAssets[0]->m_container;
    }

    return allAssetsContainer;
}


System::Void hctPreviewControl::serveContentsToHost(System::String^ hostName, int port, System::Windows::Forms::Label^ statusField, System::Windows::Forms::Form^ form)
{
    if ( m_si->m_assetManager->m_enabledAssets.getSize()==0 )
    {
        // warn that there is no asset to send
        _status("No assets loaded.", statusField, form);
        return;
    }
    if (String::IsNullOrEmpty(hostName))
    {
        // warn that hostname is empty
        _status("Hostname is empty!", statusField, form);
        return;
    }

    hkStringOld msg;

    // Try to send our current set of assets down the pipe to wherever.
    //CustomSocket* s = new CustomSocket();
    hkSocket* s = hkSocket::create();

    if (s)
    {
        const char* hostname = (char*)Marshal::StringToHGlobalAnsi(hostName).ToPointer();

        hkResult conn = HK_FAILURE;

        // Try to get a connection to specified host
        const hkReal CONNECT_TIMEOUT = 2.0f; // seconds
        hkStopwatch connectTimer;
        connectTimer.start();

        // check if Wii interface is available
        handleWiiConnection();

        _status("Trying to connect...", statusField, form);
        conn = s->connect( hostname, port );

        if ( conn.isSuccess() && s->isOk() )
        {
            _status("Got connection, preparing assets...", statusField, form);

            hkArray< hkArray<char>* > sceneCopyStorageArrays;
            TempBuffer* containerBuffer = new TempBuffer(false);
            hkRootLevelContainer* allAssetsContainer = _mergeToSingleRoot( m_si->m_assetManager, sceneCopyStorageArrays, containerBuffer);

            _status("Serializing assets...", statusField, form);

            hkArray<char> buff;
            hkArrayStreamWriter asw(&buff, hkArrayStreamWriter::ARRAY_BORROW);
            hkResult res = hkSerializeUtil::saveTagfile(allAssetsContainer, hkReflect::getType<hkRootLevelContainer>(), &asw);

            if (res.isSuccess())
            {
                _status("Sending data to host...", statusField, form);

                hkOArchive a((hkStreamWriter*)&s->getWriter());
                res = HK_FAILURE;
                a.write32(buff.getSize());
                if (a.isOk())
                {
                    a.writeRaw(buff.begin(), buff.getSize());
                    if (a.isOk())
                    {
                        res = HK_SUCCESS;
                    }
                }
            }
            else
            {
                _status("Error while serializing assets!", statusField, form);
            }

            // Re-include non-exportable classes
        //  allAssetsContainer->m_numNamedVariants += numNonExportable;

            if (res.isSuccess())
            {
                _status("Asset sent successfully.", statusField, form);
            }
            else
            {
                _status("Failed to send asset.", statusField, form);
            }

            for (int i=0; i<sceneCopyStorageArrays.getSize(); ++i)
            {
                delete sceneCopyStorageArrays[i];
            }

            // Deallocate buffer used in merge
            delete containerBuffer;

        }

        else // if ( !( (conn.isSuccess()) && (s->isOk()) ) )
        {
            _status("Could not open connection after several attempts.", statusField, form);
        }

        s->removeReference();

        Marshal::FreeHGlobal( IntPtr((void*) hostname ) );
    }
}

void hctPreviewControl::saveContentsToFile(System::String^ fileName, IPlugin::ExportFormat format, System::String^ target, System::Boolean writeMeta )
{
    //[EXP-2854] Preview Tool (ToolStandAlone) can not correctly handle, Korean or Chinese Character in filename
    hkStringPtr filename = (char*)hkUtf8::Utf8FromWide(fileName).cString();

    hkArray< hkArray<char>* > sceneCopyStorageArrays;
    TempBuffer* containerBuffer = new TempBuffer(false);
    hkRootLevelContainer* allAssetsContainer = _mergeToSingleRoot( m_si->m_assetManager, sceneCopyStorageArrays, containerBuffer );
    if (allAssetsContainer != HK_NULL)
    {
        hkOstream f(filename.cString());
        if (f.isOk())
        {
            hkResult res = HK_FAILURE;
            if (format == IPlugin::ExportFormat::HKT)
            {
                // Defaults to binary
                //bool binFile = true;
                res = hkSerializeUtil::saveTagfile(allAssetsContainer, f.getStreamWriter());

                Log_Info( "Wrote portable file to {}", filename );
            }
            else if (format == IPlugin::ExportFormat::XML)
            {
                res = hkSerialize::Save().withFormat<hkSerialize::XmlWriteFormat>().contentsPtr(allAssetsContainer, f.getStreamWriter());
                Log_Info( "Wrote XML file to {}", filename );
            }
            else
            {
                res = hkSerialize::Save().withTarget(hkUtf8::Utf8FromWide(target)).contentsPtr(allAssetsContainer, f.getStreamWriter());
                Log_Info( "Wrote native file to {}", filename );
            }
        }
        else
        {
            HK_WARN_ALWAYS(0xabba0010, "Could not open file for write :" << filename.cString() );
            String^ err = "Could not open file for write :";
            err += fileName;
            MessageBox::Show( this, err, "Havok Tool", MessageBoxButtons::OK, MessageBoxIcon::Error);
        }
    }
    else
    {
        HK_WARN_ALWAYS(0xabba0010, "Could not merge assets, is the scene empty? Nothing written to file." );
        MessageBox::Show( this, "Could not merge assets, is the scene empty? Nothing written to file.", "Havok Tool", MessageBoxButtons::OK, MessageBoxIcon::Error);
    }

    for (int i=0; i<sceneCopyStorageArrays.getSize(); ++i)
    {
        delete sceneCopyStorageArrays[i];
    }

    delete containerBuffer;
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
