// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <Plugins/Preview/hctPreviewPlugin.h> //PCH
#include <Plugins/Preview/hctPreviewPostEffectSelect.h>

#pragma unmanaged

#include <Common/Base/hkBase.h>
#include <Graphics/Common/hkGraphics.h>
#include <Graphics/Common/DisplayContext/hkgDisplayContext.h>
#include <Graphics/Common/Shader/hkgPostEffect.h>

#pragma managed

using namespace PreviewPlugin;

System::Void hctPreviewPostEffectSelect::SelectEffects( ::cli::array<String^>^ filenames )
{
    for (int f = 0; f < filenames->Length; ++f)
    {
        String^ lowerCase = filenames[f]->ToLower();
        int idx = Math::Max( lowerCase->LastIndexOf( "\\" ), lowerCase->LastIndexOf( "/" ) );
        int e = effectCheckedListBox->FindStringExact( filenames[f]->Substring( idx + 1) );
        if ( e >= 0)
        {
              effectCheckedListBox->SetItemChecked(e, true);
        }
    }
}

System::Boolean hctPreviewPostEffectSelect::IsEffectBlacklisted(String^ effectName)
{
    // This array holds the (file)names of all post-processing effects that we need/want to hide from the user.
    static char* effectsBlacklist[] =
    {
        "post_motionblur.fx", 
        "post_colorcorrect.fx" 
    };

    for each (char* blacklistedEffect in effectsBlacklist)
    {
        if (effectName->EndsWith(gcnew String(blacklistedEffect)))
        {
            return true;
        }
    }

    return false;
}

System::Boolean hctPreviewPostEffectSelect::Populate( String^ effectsDir, IntPtr ctx )
{
    cli::array< String^ >^ files = System::IO::Directory::GetFiles(effectsDir);
    bool found = false;
    effectPathNames = nullptr;
    if ( files != nullptr )
    {
        hkgPostEffect* dummy = hkgPostEffect::create( ((hkgDisplayContext*)ctx.ToPointer())->getOwner() );
        if (dummy )
        {
            String^ fileending = gcnew String( dummy->getDefaultFileNameExtension() );
            dummy->removeReference();

            hkArray<int> added;
            for (int f = 0; f < files->Length; ++f)
            {
                String^ lowerCase = files[f]->ToLower();
                if ( lowerCase->EndsWith( fileending ) && !IsEffectBlacklisted(lowerCase) )
                {
                    found = true;

                    int idx = Math::Max( lowerCase->LastIndexOf( "\\" ), lowerCase->LastIndexOf( "/" ) );
                    effectCheckedListBox->Items->Add( files[f]->Substring( idx + 1), false );
                    added.pushBack(f);
                }
            }

            if (found)
            {
                effectPathNames = gcnew ::cli::array<String^>( added.getSize() );
                for (int ai = 0; ai < added.getSize(); ++ai)
                {
                    effectPathNames[ai] = files[ added[ai] ];
                }
            }
        }
        // else does not support Post Effects at all
    }

    return found;
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
