// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <Plugins/Preview/hctPreviewPlugin.h> //PCH
#include <Plugins/Preview/hctPreviewPostEffectAdjust.h>

#pragma unmanaged

#include <Common/Base/hkBase.h>
#include <Graphics/Common/hkGraphics.h>
#include <Graphics/Common/DisplayContext/hkgDisplayContext.h>
#include <Graphics/Common/Window/hkgWindow.h>
#include <Graphics/Common/Shader/hkgPostEffect.h>

#pragma managed

using namespace PreviewPlugin;
using namespace System;
using namespace System::Windows;
using namespace System::Windows::Forms;

private ref class EffectTag
{
public:

    System::Int32 m_effectIndex;
    System::Int32 m_paramIndex;
    System::Int32 m_valIndex;

    hkgPostEffect* m_effect;
};

System::Void hctPreviewPostEffectAdjust::Populate( IntPtr ctx )
{
    m_context = (hkgDisplayContext*) ctx.ToPointer();

    hkgWindow* window = m_context->getOwner();
    int ne = window->getNumPostEffects();

    SuspendLayout();

    int tabIndex = 0;
    int Yloc = 10;
    System::Drawing::Size windowSize = this->Size;

    for (int ni = 0; ni < ne; ++ni )
    {
        hkgPostEffect* effect = window->getPostEffects(ni);

        Label^ l = gcnew Label();
        l->AutoSize = false;
        l->Location = System::Drawing::Point(10, Yloc);
        l->Name = gcnew String( effect->getName() );
        l->Size = System::Drawing::Size(500, 15);
        l->TabIndex = tabIndex;
        l->Text = l->Name;
        l->ForeColor = Color::Red;
        Yloc += 20; ++tabIndex;
        Controls->Add( l );

        int np = effect->getNumFloatInputs();
        for (int fi = 0; fi < np; ++fi)
        {
            const char* name = effect->getFloatInputName(fi);
            int numFloats = effect->getFloatInputSize(fi);

            if (numFloats > 0)
            {
                Label^ ln = gcnew Label();
                ln->AutoSize = false;
                ln->Location = System::Drawing::Point(20, Yloc);
                ln->Name = gcnew String( name ); //+ " (" + ((Int32)numFloats).ToString() + " floats)";
                ln->TextAlign = System::Drawing::ContentAlignment::TopRight;
                ln->Size = System::Drawing::Size(250, 15);
                ln->TabIndex = tabIndex++;
                ln->Text = ln->Name;

                Controls->Add( ln );

                float* val = hkAllocateStack<float>(numFloats, "floats");
                effect->getFloatInputValue( fi, val, numFloats );

                for (int fc=0; fc < numFloats; ++fc)
                {
                    NumericUpDown^ valUpDown = gcnew NumericUpDown();
                    valUpDown->AutoSize = false;
                    valUpDown->Location = System::Drawing::Point(270 + (fc * 70), Yloc);
                    valUpDown->Maximum = System::Decimal( 5000000.0f );
                    valUpDown->Minimum = System::Decimal( -5000000.0f );
                    valUpDown->DecimalPlaces = 4;
                    valUpDown->Increment = System::Decimal( 0.05f );
                    valUpDown->Name = gcnew String(name) + gcnew String("V") + ((Int32)fc).ToString();
                    valUpDown->Size = System::Drawing::Size(65, 30);
                    valUpDown->TabIndex = tabIndex++;
                    valUpDown->Value = System::Decimal(val[fc]);

                    windowSize.Width = Math::Min(1280, valUpDown->Location.X + valUpDown->Size.Width );
                    windowSize.Height = Math::Min(1024, valUpDown->Location.Y + valUpDown->Size.Height );

                    EffectTag^ tag = gcnew EffectTag();
                    tag->m_effect = effect;
                    tag->m_effectIndex = ni;
                    tag->m_paramIndex = fi;
                    tag->m_valIndex = fc;

                    valUpDown->Tag = tag;

                    valUpDown->ValueChanged += gcnew System::EventHandler(this, &hctPreviewPostEffectAdjust::valueChanged);

                    Controls->Add( valUpDown );

                }
                hkDeallocateStack<float>(val, numFloats);

                Yloc += 20;
            }
        }
    }

    windowSize.Width += 30;
    windowSize.Height += 50;
    this->Size = windowSize;

    ResumeLayout(false);
    PerformLayout();
}

System::Void hctPreviewPostEffectAdjust::valueChanged(System::Object^  sender, System::EventArgs^  e)
{
    NumericUpDown^ nd = (NumericUpDown^) sender;
    EffectTag^ details = (EffectTag^) nd->Tag;

    m_context->lock();

    const char* name = details->m_effect->getFloatInputName(details->m_paramIndex);
    if (name )
    {
        float vX = Single( nd->Value );
        int numFloats = details->m_effect->getFloatInputSize(details->m_paramIndex);
        float* val = hkAllocateStack<float>(numFloats, "floats");
        details->m_effect->getFloatInputValue( details->m_paramIndex, val, numFloats );
        val[ details->m_valIndex ] = vX;
        details->m_effect->setFloatInputByName( name, val, numFloats );
        hkDeallocateStack<float>(val, numFloats);
    }

    m_context->unlock();

}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
