// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0
#include <Plugins/Preview/hctPreviewPlugin.h>
#include <Plugins/Preview/hctPreviewLoadingForm.h>

using namespace Havok::Tool;
using namespace PreviewPlugin;

using namespace System;
using namespace System::Windows::Forms;

using namespace System::Diagnostics;

hctPreviewLoadingForm::hctPreviewLoadingForm()
{

}

hctPreviewLoadingForm::hctPreviewLoadingForm(bool doInit)
{
    if (doInit)
    {
        InitializeComponent();
    }
}

delegate void progressStringDelegate( String^ str );
delegate void progressFloatDelegate( float v );
delegate void progressFormDelegate( Form^ f );
delegate void progressVoidDelegate( );

ref class PreviewPlugin::PreviewLoadingThread
{
public:

    PreviewLoadingThread(Point l)
    {
        m_location = l;
    }

    void Exec()
    {
        m_previewLoadingForm = gcnew hctPreviewLoadingForm(true);
        m_previewLoadingForm->Location = m_location;
        Application::Run(m_previewLoadingForm);
    }

    void Close()
    {
        m_previewLoadingForm->Close();
    }

    void SetMessage(String^ str)
    {
        m_previewLoadingForm->textBox->Text = str;
        m_previewLoadingForm->Update();
    }

    void SetProgress(float v)
    {
        m_previewLoadingForm->progressBar->Value = (int)( v * 100 );
        m_previewLoadingForm->Update();
    }

    hctPreviewLoadingForm^ m_previewLoadingForm;
    Point m_location;
};

void hctPreviewLoadingForm::start(Point l)
{
    m_previewLoadingThreadData = gcnew PreviewLoadingThread(l);

    System::Threading::ThreadStart^ theThreadStarter = gcnew System::Threading::ThreadStart(m_previewLoadingThreadData, &PreviewLoadingThread::Exec);
    m_previewLoadingThread = gcnew System::Threading::Thread(theThreadStarter);
    m_previewLoadingThread->SetApartmentState( System::Threading::ApartmentState::MTA );
    m_previewLoadingThread->Start();
}

void hctPreviewLoadingForm::end()
{
    while ( (m_previewLoadingThreadData == nullptr) || (m_previewLoadingThreadData->m_previewLoadingForm == nullptr) && !m_previewLoadingThreadData->m_previewLoadingForm->Created )
    {
        System::Threading::Thread::CurrentThread->Sleep(0);
    }

    m_previewLoadingThreadData->m_previewLoadingForm->Invoke(gcnew progressVoidDelegate(m_previewLoadingThreadData, &PreviewLoadingThread::Close) );
}

void hctPreviewLoadingForm::setMessage( String^ msg )
{
    if ((m_previewLoadingThreadData != nullptr) && (m_previewLoadingThreadData->m_previewLoadingForm != nullptr))
    {
        if (m_previewLoadingThreadData->m_previewLoadingForm->Created)
            m_previewLoadingThreadData->m_previewLoadingForm->Invoke(gcnew progressStringDelegate(m_previewLoadingThreadData, &PreviewLoadingThread::SetMessage ), msg);
    }
}

void hctPreviewLoadingForm::setProgress( float percent )
{
    if ((m_previewLoadingThreadData != nullptr) && (m_previewLoadingThreadData->m_previewLoadingForm != nullptr))
    {
        if (m_previewLoadingThreadData->m_previewLoadingForm->Created)
            m_previewLoadingThreadData->m_previewLoadingForm->Invoke(gcnew progressFloatDelegate(m_previewLoadingThreadData, &PreviewLoadingThread::SetProgress ), percent);
    }
}

void hctPreviewLoadingForm::setMessageAndProgress(String^ msg, float progress, bool wait )
{
    // Thread started
    if (wait)
    {
        while ( (m_previewLoadingThreadData == nullptr) || (m_previewLoadingThreadData->m_previewLoadingForm == nullptr) )
        {
            System::Threading::Thread::CurrentThread->Sleep(0);
        }

        // Thread form up and running
        while ( !m_previewLoadingThreadData->m_previewLoadingForm->Created )
        {
            System::Threading::Thread::CurrentThread->Sleep(0);
        }
    }

    setMessage(msg);
    setProgress(progress);
}

void hctPreviewLoadingForm::show( bool visible )
{
    if (visible)
    {
        Point p(200, 200);
        start(p);
    }
    else
    {
        end();
    }
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
