// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS PHYSICS_2012
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <Plugins/Preview/hctPreviewPlugin.h> //PCH
#include <Plugins/Preview/hctPreviewControl.h>

#pragma unmanaged

#include <Common/Base/hkBase.h>

#include <Graphics/Common/Window/hkgWindow.h>

#ifdef HK_ENABLE_PHYSICS_2012
#   include <Physics2012/Utilities/Weapons/hkpFirstPersonGun.h>                                             
#   include <Physics2012/Utilities/CharacterControl/CharacterRigidBody/hkpCharacterRigidBody.h>             
#   include <Physics2012/Utilities/CharacterControl/FirstPersonCharacter/hkpFirstPersonCharacter.h>         
#endif

#ifdef HK_ENABLE_PHYSICS
#   include <Physics/Physics/Extensions/CharacterControl/RigidBody/hknpCharacterRigidBody.h>                
#   include <Physics/Physics/Extensions/CharacterControl/Examples/FirstPerson/hknpFirstPersonCharacter.h>   
#   include <Physics/Physics/Extensions/CharacterControl/Examples/FirstPerson/Guns/hknpFirstPersonGun.h>    
#endif

#pragma  managed

using namespace PreviewPlugin;

static void _deadzone(float* stickX, float* stickY)
{
    hkReal INPUT_DEADZONE = 0.15f; // PS2 style .. large

    const float deadzoneScale = 1.0f/(1.0f-INPUT_DEADZONE);

    *stickX = ( *stickX < -INPUT_DEADZONE) ? (*stickX + INPUT_DEADZONE) * deadzoneScale : ( ( *stickX > INPUT_DEADZONE ) ? (*stickX - INPUT_DEADZONE) * deadzoneScale : 0);
    *stickY = ( *stickY < -INPUT_DEADZONE) ? (*stickY + INPUT_DEADZONE) * deadzoneScale : ( ( *stickY > INPUT_DEADZONE ) ? (*stickY - INPUT_DEADZONE) * deadzoneScale : 0);
}

void hctPreviewControl::getUserInputForCharacter(float sensivity_mouseX, float sensivity_mouseY, float sensivity_padX, float sensivity_padY, float* deltaAngle, float* deltaElevation, float* posX, float* posY )
{
    // Mouse
    float dA = 0.0f;
    float dE = 0.0f;
    float pX = 0.0f;
    float pY = 0.0f;

    hkgPadCLR^ pad = m_display->m_window->getGamePad(0);
    hkgKeyboardCLR^ keyBoard = m_display->m_window->getKeyboard();
    hkgMouseCLR^ mouse = m_display->m_window->getMouse();
    hkgViewportCLR^ viewport = m_display->m_window->getCurrentViewport();

    if (pad->isConnected())
    {
        hkgPadCLR::Button buttonState = pad->getButtonState();

        if ((buttonState & hkgPadCLR::Button::BUTTON_L1) != hkgPadCLR::Button::NONE)
        {
            float stickX = pad->getStickPosX(1);
            float stickY = pad->getStickPosY(1);
            _deadzone(&stickX, &stickY);
            pX = -stickX; // strafe on stick1
            pY = -stickY;
        }

        {
            const hkReal PAD_SENSITIVITY = 0.02f;
            float stickX = pad->getStickPosX(0);
            float stickY = pad->getStickPosY(0);
            _deadzone(&stickX, &stickY);
            dA = 3.4f * -stickX * PAD_SENSITIVITY * sensivity_padX;
            dE = 3.4f * -stickY * PAD_SENSITIVITY * sensivity_padY;
        }

        // dpad == dir keys on PC
        {
            if ((buttonState & hkgPadCLR::Button::DPAD_UP)    != hkgPadCLR::Button::NONE) pY = -1.0f;
            if ((buttonState & hkgPadCLR::Button::DPAD_LEFT)  != hkgPadCLR::Button::NONE) pX =  1.0f;
            if ((buttonState & hkgPadCLR::Button::DPAD_RIGHT) != hkgPadCLR::Button::NONE) pX = -1.0f;
            if ((buttonState & hkgPadCLR::Button::DPAD_DOWN)  != hkgPadCLR::Button::NONE) pY =  1.0f;
        }

    }

    int lowerLeftX;
    int lowerLeftY;
    viewport->getLowerLeftCoord(lowerLeftX, lowerLeftY);

    // No gamepad (win32 and PlayStation(R)3 default at the mo)
    if( mouse->isConnected() )
    {
        hkReal mouseX = hkReal(mouse->getPosX() - lowerLeftX);
        hkReal halfWindowWidth = hkReal(viewport->getWidth() / 2);

        {
            hkReal inc  = (halfWindowWidth - mouseX) / halfWindowWidth;
            inc = (inc < -1.0f) ? -1.0f : inc;
            inc = (inc >  1.0f) ?  1.0f : inc;
            if ( inc != 0.0f )
            {
                dA = 3.4f * inc * sensivity_mouseX;
            }
        }

        hkReal mouseY = hkReal(mouse->getPosY() - lowerLeftY);
        hkReal halfWindowHeight = hkReal(viewport->getHeight() / 2);
        {
            hkReal inc  = (halfWindowHeight - mouseY) / halfWindowHeight;
            inc = (inc < -1.0f) ? -1.0f : inc;
            inc = (inc >  1.0f) ?  1.0f : inc;
            if ( inc != 0.0f )
            {
                dE = 3.4f * inc * sensivity_mouseY;
            }
        }

        if (keyBoard->getKeyState('A')) pX =  1.0f;
        if (keyBoard->getKeyState('D')) pX = -1.0f;
        if (keyBoard->getKeyState('W')) pY = -1.0f;
        if (keyBoard->getKeyState('S')) pY =  1.0f;
    }

    // Normalize the movement vector
    hkReal lenSqd = pY * pY + pX * pX;
    if (lenSqd > 1.0f)
    {
        lenSqd = hkMath::sqrt(lenSqd);
        pY /= lenSqd;
        pX /= lenSqd;
    }

    hkgCameraCLR^ cam = viewport->getCamera();
    if (cam->getHandednessMode() == hkgCameraCLR::HandednessMode::LEFT)
    {
        // horizontal flip in screen space, so can just invert X
        pX = -pX;
        dA = -dA;
    }
    delete cam;

    *posX = pX;
    *posY = pY;
    *deltaAngle = dA;
    *deltaElevation = dE;

    delete pad;
    delete mouse;
    delete keyBoard;
    delete viewport;
}

#pragma unmanaged

template <class CharacterType>
static void getCharacterPosition(CharacterType* c, float h, float* p)
{
    hkVector4 from;
    from = c->m_characterRb->getPosition();
    from.addMul(h, c->m_characterRb->m_up );
    from.store<3,HK_IO_NATIVE_ALIGNED>(p);
}

template <class CharacterType>
static void getCharacterForward(CharacterType* c, float* p)
{
    hkVector4 forward;
    c->getForwardDir( forward );
    forward.mul(4);
    forward.store<3,HK_IO_NATIVE_ALIGNED>(p);
}

template <class CharacterType>
static void getCharacterUp(CharacterType* c, float* p)
{
    hkVector4 up;
    up = c->m_characterRb->m_up;
    up.normalizeIfNotZero<3>();
    up.store<3,HK_IO_NATIVE_ALIGNED>(p);
}

#ifdef HK_ENABLE_PHYSICS_2012

static void setInputFromUserControls( hkpFirstPersonCharacter* character, bool tryJump, bool lmbPressed, bool rmbPressed, float dA, float dE, float pX, float pY, hkpFirstPersonCharacter::CharacterControls& controls )
{
    // Get user input data
    hkReal deltaAngle = dA;
    hkReal deltaElevation = dE;

    controls.m_straffeLeftRight = pX * character->m_leftRightSpeedModifier;
    controls.m_forwardBack      = pY * character->m_forwardBackwardSpeedModifier;

    if (! (character->m_flags & hkpFirstPersonCharacter::INVERT_UP_DOWN))
    {
        deltaElevation = -deltaElevation;
    }

    character->m_currentAngle += deltaAngle;
    character->m_currentElevation += deltaElevation;

    if (character->m_currentElevation < -character->m_maxUpDownAngle) character->m_currentElevation = -character->m_maxUpDownAngle;
    if (character->m_currentElevation > character->m_maxUpDownAngle)  character->m_currentElevation = character->m_maxUpDownAngle;

    hkQuaternion currentOrient; currentOrient.setAxisAngle(character->m_characterRb->m_up, character->m_currentAngle);

    controls.m_wantJump = tryJump;

    controls.m_forward._setRotatedDir( currentOrient, hkVector4::getConstant<HK_QUADREAL_1000>() );

    controls.m_fire = false;
    if (lmbPressed)
    {
        if ( character->m_gunCounter-- < 0 )
        {
            character->m_gunCounter = 10;
            controls.m_fire = true;
        }
    }
    else
    {
        character->m_gunCounter = 0;
    }

    controls.m_fireRmb = false;
    if (rmbPressed)
    {
        if ( character->m_gunCounterRmb-- < 0 )
        {
            character->m_gunCounterRmb = 20;
            controls.m_fireRmb = true;
        }
    }
    else
    {
        character->m_gunCounterRmb = 0;
    }
}

static void processCharacterControls(hkpFirstPersonCharacter* c, float timestep, bool tryJump, bool lmbPressed, bool rmbPressed, float dA, float dE, float pX, float pY)
{
    if ( c->m_flags & hkpFirstPersonCharacter::HAS_USER_CONTROL )
    {
        c->m_world->lock();
        hkpFirstPersonCharacter::CharacterControls controls;
        if ( c->m_flags & hkpFirstPersonCharacter::DISABLE_DPAD )
        {
            controls.m_disableDPad = true;
        }

        setInputFromUserControls( c, tryJump, lmbPressed, rmbPressed, dA, dE, pX, pY, controls );

        if ( c->m_flags & hkpFirstPersonCharacter::DISABLE_JUMP )
        {
            controls.m_wantJump = false;
        }

        hkTransform viewTransform; c->getViewTransform(viewTransform);

        if ( controls.m_fire && c->m_currentGun )
        {
            c->m_currentGun->fireGun( c->m_world, viewTransform );
        }

        c->update( timestep, controls, false );

        if (c->m_currentGun)
        {
            hkpRigidBody* body = c->m_characterRb->m_character;
            c->m_currentGun->stepGun( timestep, c->m_world, body, viewTransform, controls.m_fire, controls.m_fireRmb );
        }
        c->m_world->unlock();
    }
}

#endif

#ifdef HK_ENABLE_PHYSICS

static void setInputFromUserControlsNp(hknpFirstPersonCharacter* character, bool tryJump, bool lmbPressed, bool rmbPressed, float dA, float dE, float pX, float pY, hknpFirstPersonCharacter::CharacterControls& controls)
{
    // Get user input data
    hkReal deltaAngle = dA;
    hkReal deltaElevation = dE;

    controls.m_strafeLeftRight  = pX * character->m_leftRightSpeedModifier;
    controls.m_forwardBack      = pY * character->m_forwardBackwardSpeedModifier;

    if ( !(character->m_flags & hknpFirstPersonCharacter::INVERT_UP_DOWN) )
    {
        deltaElevation = -deltaElevation;
    }

    character->m_currentAngle += deltaAngle;
    character->m_currentElevation += deltaElevation;

    if (character->m_currentElevation < -character->m_maxUpDownAngle) character->m_currentElevation = -character->m_maxUpDownAngle;
    if (character->m_currentElevation > character->m_maxUpDownAngle)  character->m_currentElevation = character->m_maxUpDownAngle;

    hkQuaternion currentOrient; currentOrient.setAxisAngle(character->m_characterRb->m_up, character->m_currentAngle);

    controls.m_wantJump = tryJump;

    controls.m_forward._setRotatedDir( currentOrient, hkVector4::getConstant<HK_QUADREAL_1000>() );

    controls.m_fire = false;
    if ( lmbPressed )
    {
        if ( character->m_gunCounter-- < 0 )
        {
            character->m_gunCounter = 10;
            controls.m_fire = true;
        }
    }
    else
    {
        character->m_gunCounter = 0;
    }

    controls.m_fireRmb = false;
    if (rmbPressed)
    {
        if ( character->m_gunCounterRmb-- < 0 )
        {
            character->m_gunCounterRmb = 20;
            controls.m_fireRmb = true;
        }
    }
    else
    {
        character->m_gunCounterRmb = 0;
    }
}

static void processCharacterControlsNp(hknpFirstPersonCharacter* c, float timestep, bool tryJump, bool lmbPressed, bool rmbPressed, float dA, float dE, float pX, float pY)
{
    if ( c->m_flags & hknpFirstPersonCharacter::HAS_USER_CONTROL )
    {
        hknpFirstPersonCharacter::CharacterControls controls;
        if ( c->m_flags & hknpFirstPersonCharacter::DISABLE_DPAD )
        {
            controls.m_disableDPad = true;
        }

        setInputFromUserControlsNp(c, tryJump, lmbPressed, rmbPressed, dA, dE, pX, pY, controls);

        if ( c->m_flags & hknpFirstPersonCharacter::DISABLE_JUMP )
        {
            controls.m_wantJump = false;
        }

        hkTransform viewTransform;
        c->getViewTransform(viewTransform);

        if ( controls.m_fire && c->m_currentGun )
        {
            c->m_currentGun->fireGun(c->m_world, viewTransform);
        }

        c->update( timestep, controls, false );

        if ( c->m_currentGun )
        {
            hknpBodyId body = c->m_characterRb->m_bodyId;
            c->m_currentGun->stepGun(timestep, c->m_world, body, viewTransform, controls.m_fire, controls.m_fireRmb);
        }
    }
}

#endif

#pragma managed

void hctPreviewControl::updateCameraFromFirstPersonController()
{
    hkReal height;
    hkgVector3CLR from, forward, to, up;
    float f[3];

#ifdef HK_ENABLE_PHYSICS_2012
    if ( m_char )
    {
        height = m_char->m_eyeHeight;

        getCharacterPosition<hkpFirstPersonCharacter>(m_char, height, f);
        from.set(f[0], f[1], f[2]);
        getCharacterForward<hkpFirstPersonCharacter>(m_char, f);
        forward.set(f[0], f[1], f[2]);
        to.setAdd(from, forward);
        getCharacterUp<hkpFirstPersonCharacter>(m_char, f);
        up.set(f[0], f[1], f[2]);
    }
#endif

#ifdef HK_ENABLE_PHYSICS
    if ( m_npChar )
    {
        height = m_npChar->m_eyeHeight;

        getCharacterPosition<hknpFirstPersonCharacter>(m_npChar, height, f);
        from.set(f[0], f[1], f[2]);
        getCharacterForward<hknpFirstPersonCharacter>(m_npChar, f);
        forward.set(f[0], f[1], f[2]);
        to.setAdd(from, forward);
        getCharacterUp<hknpFirstPersonCharacter>(m_npChar, f);
        up.set(f[0], f[1], f[2]);
        hkgVector3CLR dir = forward;
        dir.normalize();
        dir.mult(0.5f);
        from.add(dir);
    }
#endif

    hkgViewportCLR^ viewport = m_display->m_window->getCurrentViewport();
    {
        hkgCameraCLR^ c = viewport->getCamera();

        // set up camera
        c->setFrom(from);
        c->setTo(to);
        c->setUp(up);
        c->orthogonalize();
        c->computeModelView(false);
        c->computeProjection();
        //c->setHandednessMode(HKG_CAMERA_HANDEDNESS_MODE( rightHanded ? HKG_CAMERA_HANDEDNESS_RIGHT : HKG_CAMERA_HANDEDNESS_LEFT) );
        viewport->setWorldUp(up);
        delete c;
    }

    // Snap mouse back to middle
    int lowerLeftX;
    int lowerLeftY;
    viewport->getLowerLeftCoord(lowerLeftX, lowerLeftY);
    m_display->m_window->setMousePosition( lowerLeftX + (viewport->getWidth()/2), lowerLeftY + (viewport->getHeight()/2));

    delete viewport;
}

#ifdef HK_ENABLE_PHYSICS_2012

void hctPreviewControl::stepFirstPersonController(float timestep)
{
    hkgPadCLR^ pad = m_display->m_window->getGamePad(0);
    hkgPadCLR::Button padButtonState = pad->getButtonState();
    hkgMouseCLR^ mouse = m_display->m_window->getMouse();
    hkgMouseCLR::Button mouseButtonState = mouse->getButtonState();
    hkgKeyboardCLR^ keyBoard = m_display->m_window->getKeyboard();

    bool tryJump = keyBoard->wasKeyPressed( HKG_VKEY_SPACE ) || ((padButtonState & hkgPadCLR::Button::BUTTON_1) != hkgPadCLR::Button::NONE);
    bool lmbPressed = ((mouseButtonState & hkgMouseCLR::Button::LEFT) != hkgMouseCLR::Button::NONE) || ((padButtonState & hkgPadCLR::Button::BUTTON_R1) != hkgPadCLR::Button::NONE);
    bool rmbPressed = ((mouseButtonState & hkgMouseCLR::Button::RIGHT) != hkgMouseCLR::Button::NONE) || ((padButtonState & hkgPadCLR::Button::BUTTON_R2) != hkgPadCLR::Button::NONE);

    float sensivity_mouseX = m_char->m_horizontalSensitivity;
    float sensivity_mouseY = m_char->m_verticalSensitivity;
    float sensivity_padX = m_char->m_sensivityPadX;
    float sensivity_padY = m_char->m_sensivityPadY;

    float deltaAngle, deltaElevation, posX, posY;
    getUserInputForCharacter(sensivity_mouseX, sensivity_mouseY, sensivity_padX, sensivity_padY, &deltaAngle, &deltaElevation, &posX, &posY );
    processCharacterControls(m_char, timestep, tryJump, lmbPressed, rmbPressed, deltaAngle, deltaElevation, posX, posY);
    updateCameraFromFirstPersonController();

    delete pad;
    delete mouse;
    delete keyBoard;
}

#endif

#ifdef HK_ENABLE_PHYSICS

void hctPreviewControl::stepFirstPersonControllerNp(float timestep)
{

    hkgPadCLR^ pad = m_display->m_window->getGamePad(0);
    hkgPadCLR::Button padButtonState = pad->getButtonState();
    hkgMouseCLR^ mouse = m_display->m_window->getMouse();
    hkgMouseCLR::Button mouseButtonState = mouse->getButtonState();
    hkgKeyboardCLR^ keyBoard = m_display->m_window->getKeyboard();

    bool tryJump = keyBoard->wasKeyPressed( HKG_VKEY_SPACE ) || ((padButtonState & hkgPadCLR::Button::BUTTON_1) != hkgPadCLR::Button::NONE);
    bool lmbPressed = ((mouseButtonState & hkgMouseCLR::Button::LEFT) != hkgMouseCLR::Button::NONE) || ((padButtonState & hkgPadCLR::Button::BUTTON_R1) != hkgPadCLR::Button::NONE);
    bool rmbPressed = ((mouseButtonState & hkgMouseCLR::Button::RIGHT) != hkgMouseCLR::Button::NONE) || ((padButtonState & hkgPadCLR::Button::BUTTON_R2) != hkgPadCLR::Button::NONE);

    float sensivity_mouseX = m_npChar->m_horizontalSensitivity;
    float sensivity_mouseY = m_npChar->m_verticalSensitivity;
    float sensivity_padX = m_npChar->m_sensivityPadX;
    float sensivity_padY = m_npChar->m_sensivityPadY;

    float deltaAngle, deltaElevation, posX, posY;
    getUserInputForCharacter(sensivity_mouseX, sensivity_mouseY, sensivity_padX, sensivity_padY, &deltaAngle, &deltaElevation, &posX, &posY );
    processCharacterControlsNp(m_npChar, timestep, tryJump, lmbPressed, rmbPressed, deltaAngle, deltaElevation, posX, posY);
    updateCameraFromFirstPersonController();

    delete pad;
    delete mouse;
    delete keyBoard;
}

#endif

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
