// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <Plugins/Preview/hctPreviewPlugin.h> //PCH

#pragma unmanaged

#include <Common/Base/hkBase.h>
#include <Common/Base/Algorithm/Sort/hkSort.h>

#include <Graphics/Common/hkGraphics.h>
#include <Graphics/Common/DisplayContext/hkgDisplayContext.h>
#include <Graphics/Common/Font/hkgFont.h>
#include <Graphics/Common/Geometry/VertexSet/hkgVertexSet.h>
#include <Graphics/Common/DisplayObject/hkgDisplayObject.h>
#include <Graphics/Common/Window/hkgWindow.h>
#include <Graphics/Common/Window/hkgViewport.h>
#include <Graphics/Common/Shader/hkgPostEffect.h>

#include <Graphics/Bridge/SceneData/hkgSceneDataConverter.h>

#include <Plugins/Preview/hctPreviewUnmanaged.h>
#include <Plugins/Preview/hctPreviewAsset.h>

using namespace PreviewPlugin;

void PreviewPluginImpl::createFont()
{
    if (m_displayContext)
    {
        m_displayFont = hkgFont::create();
        m_displayFont->loadFromBuiltin(m_displayContext, false );
    }
}

class EffectOrder
{
public:

    const char* shortName;
    int order; // 0 == first etc
};

static EffectOrder g_effectSortOrder[] =
{
    { "ssao.fx", 0 },
    { "bloom.fx", 1 },
    { "dof.fx", 2 },
    { "motionblur.fx", 3 }
};

void PreviewPluginImpl::getCurrentPostEffects(hkArray<const char*>& effectNames )
{
    effectNames.setSize(0);
    if (m_displayContext)
    {
        hkgWindow* window = m_displayContext->getOwner();
        if (window->getNumPostEffects() > 0)
        {
            effectNames.setSize(window->getNumPostEffects());
            for (int i=0; i < effectNames.getSize(); ++i)
            {
                effectNames[i] = window->getPostEffects(i)->getName();
            }
        }
    }
}

void PreviewPluginImpl::updatePostEffects(const hkArray<const char*>& effectNames )
{
    if (m_displayContext)
    {
        hkgWindow* window = m_displayContext->getOwner();

        hkArray< hkgPostEffect* > orderedEffects;
        if (window->getNumPostEffects() > 0)
        {
            orderedEffects.setSize(window->getNumPostEffects());
            for (int i=0; i < orderedEffects.getSize(); ++i)
            {
                orderedEffects[i] = window->getPostEffects(i);
                orderedEffects[i]->addReference();
            }

            for (int ii = orderedEffects.getSize() - 1; ii >= 0; --ii)
            {
                window->removePostEffect( orderedEffects[ii] );
            }
        }

        // Window at this point has no effects in it.
        hkArray<hkStringOld> shortNames; shortNames.setSize( effectNames.getSize() );
        for (int ei=0; ei < effectNames.getSize(); ++ei)
        {
            hkStringOld fullName = effectNames[ei];
            int idxB = fullName.lastIndexOf('\\');
            int idxF = fullName.lastIndexOf('/');
            int idx = hkMath::max2<int>(idxF, idxB);
            shortNames[ei] = fullName.substr(idx + 1).asLowerCase();
        }

        // see if we have these already
        hkArray< bool > created; created.setSize(effectNames.getSize(), false);
        for (int oi=orderedEffects.getSize() - 1; oi >= 0; --oi)
        {
            hkgPostEffect* eff = orderedEffects[oi];
            hkStringOld thisShortName;
            {
                hkStringOld fullEffName = eff->getName();
                int idxB = fullEffName.lastIndexOf('\\');
                int idxF = fullEffName.lastIndexOf('/');
                int idx = hkMath::max2<int>(idxF, idxB);
                thisShortName = fullEffName.substr(idx + 1).asLowerCase();
            }
            bool found = false;
            for (int oii=0; oii < shortNames.getSize(); ++oii)
            {
                if (hkString::strCasecmp( shortNames[oii].cString(), thisShortName.cString() ) == 0 )
                {
                    // found
                    created[oii] = true;
                    found = true;
                    break;
                }
            }

            if (!found) // disabled now or no longer listed etc
            {
                orderedEffects.removeAtAndCopy(oi);
                eff->removeReference();
            }
        }

        // do we have new ones?
        if (shortNames.getSize() > orderedEffects.getSize())
        {
            for (int oi = 0; oi < created.getSize(); ++oi)
            {
                if (!created[oi])
                {
                    hkgPostEffect* eff = hkgPostEffect::create( m_displayContext->getOwner() );
                    if ( eff->realizeFromFile( effectNames[oi] ) )
                    {
                        orderedEffects.pushBack(eff);
                        eff->setName( effectNames[oi] ); // long name (filename)
                    }
                }
            }
        }

        // find relative order info
        hkArray< int > relOrder; relOrder.setSize( orderedEffects.getSize(), 0 );
        for (int ii=0; ii < orderedEffects.getSize(); ++ii )
        {
            for (int j=0; j < (sizeof(g_effectSortOrder)/sizeof(EffectOrder)); ++j)
            {
                if (hkString::strCasecmp( g_effectSortOrder[j].shortName, orderedEffects[ii]->getName() ) == 0)
                {
                    relOrder[ii] =  g_effectSortOrder[j].order;
                }
            }
        }
        // bubble sort
        for ( int i = 1; i < orderedEffects.getSize(); i++ )
        {
            for ( int j = 0; j < orderedEffects.getSize() - i; j++ )
            {
                if ( relOrder[ j + 1 ] < relOrder[ j ]  )
                {
                    hkAlgorithm::swap( relOrder[ j + 1 ], relOrder[ j ] );
                    hkAlgorithm::swap( orderedEffects[ j + 1 ], orderedEffects[ j ] );
                }
            }
        }

        // add
        for (int efi=0; efi < orderedEffects.getSize(); ++efi)
        {
            window->addPostEffect( orderedEffects[efi] );
            orderedEffects[efi]->removeReference();
        }

        // done.
    }
}

hkgFaceSet* PreviewPluginProductImpl::ObjectPickInfo::getPickedFaceSet() const
{
    if ((m_object!= HK_NULL) && (m_faceSetIndex >= 0))
    {
        int curMaxIndex  = 0;
        int numGeoms = m_object->getNumGeometry();
        for (int gi = 0; gi < numGeoms; ++gi)
        {
            hkgGeometry* geom = m_object->getGeometry(gi);
            int numMats = geom->getNumMaterialFaceSets();
            for (int mfsi = 0; mfsi < numMats; ++mfsi)
            {
                hkgMaterialFaceSet* mfs = geom->getMaterialFaceSet(mfsi);
                int nfs = mfs->getNumFaceSets();
                if (m_faceSetIndex < (curMaxIndex + nfs))
                {
                    return mfs->getFaceSet( m_faceSetIndex - curMaxIndex );
                }

                curMaxIndex += nfs;
            }
        }
    }

    return nullptr;
}


#pragma managed

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
