// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL !REFLECT
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

using namespace System;
using namespace System::ComponentModel;
using namespace System::Collections;
using namespace System::Windows::Forms;
using namespace System::Data;
using namespace System::Drawing;

using namespace Havok::Graphics;
using namespace Havok::Tool;

class hkRootLevelContainer;
namespace hkReflect { struct Var; }

struct PreviewPluginImpl;
class hctPreviewTreeViewManager;
class hkpFirstPersonCharacter;
class hknpFirstPersonCharacter;

#ifdef HK_ENABLE_CLOTH_PREVIEW
#include <Plugins/Preview/hctPreviewClothWindForm.h>
#include <Plugins/Preview/hctPreviewClothTransitionForm.h>
#include <Plugins/Preview/hctPreviewClothCollidableForm.h>
#include <Plugins/Preview/hctPreviewClothDebugForm.h>
#endif

namespace PreviewPlugin
{
    /// <summary>
    /// Summary for PreviewPluginControl
    /// </summary>
    ///
    /// WARNING: If you change the name of this class, you will need to change the
    ///          'Resource File Name' property for the managed resource compiler tool
    ///          associated with all .resx files this class depends on.  Otherwise,
    ///          the designers will not be able to interact properly with localized
    ///          resources associated with this form.
    public ref class hctPreviewControl
    : public    System::Windows::Forms::UserControl,
                IBaseSystem,
                IPlugin,
                IPluginDisplay,
                IPluginUI,
                IDataSource
    {
    public:
        hctPreviewControl(void);
        ~hctPreviewControl(void);

        virtual String^ getName() { return "Preview"; }
        virtual int getPriority() { return 100; }

        void savePhysicsPreferences();
        void loadPhysicsPreferences();
        void saveAnimationPreferences();
        void loadAnimationPreferences();
        void saveClothPreferences();
        void loadClothPreferences();
        void saveDestructionPreferences();
        void loadDestructionPreferences();
        void saveGeneralPreferences();
        void loadGeneralPreferences();

        void savePreferences();
        void loadPreferences();

        void erasePhysicsProperties();
        void eraseAnimationProperties();
        void eraseClothProperties();
        void eraseDestructionProperties();
        void eraseGeneralProperties();

        virtual void restoreDefaultProperties();

        // Base Mem i/f
        virtual void initBaseSystem(System::IntPtr info, System::IntPtr graphicsInfo);
        virtual void pushErrorHandler(System::IntPtr error);
        virtual void popErrorHandler();
        virtual void getVersionInfo(System::String^% interfaceVersion, System::String^% havokSdkVersion );
        virtual void quitBaseSystem();

        // Engine i/f
        virtual void init();
        virtual bool step(float dt); // returns true if it did any actual step
        virtual void quit();
        virtual bool isPlaying();

        virtual void setContentsFromMemory(System::IntPtr root /* hkRootLevelContainer* */, System::IntPtr vtableReg, bool copy, bool allowInstances);
        virtual void setContentsFromFile(String^ path, bool dragIn, int x, int y, bool prompt);
        virtual void updateContentsFromPackfile(array< System::Byte >^ data);
        virtual void serveContentsToHost(String^ hostName, int port, System::Windows::Forms::Label^ statusField, System::Windows::Forms::Form^ form);
        virtual void saveContentsToFile(System::String^ fileName, IPlugin::ExportFormat format, System::String^ target, System::Boolean writeMeta );

        virtual void startDragDrop( System::String^ filename );
        virtual void endDragDrop();

        virtual void createFirstPersonController(hkgVector3CLR^ pos, hkgVector3CLR^ dir, hkgVector3CLR^ up);
        virtual void deleteFirstPersonController();

        // Display i/f
        virtual void preWorldRender( hkgViewportCLR^ v );
        virtual void postWorldRender( hkgViewportCLR^ v );
        virtual void setContext( hkgDisplayWorldCLR^ world, hkgDisplayContextCLR^ ctx, hkgWindowCLR^ window );

        virtual hkgDisplayObjectCLR^ getSelectedDisplayObject();
        virtual void objectPicked( PickInfo^ obj, hkgVector3CLR^ worldPos);
        virtual void objectMoved( hkgVector3CLR^ worldPos);
        virtual void objectReleased();

        // Supports the tweaker
        virtual void getDataAndClassForObject( PickInfo^ objectInfo, HavokReflectedObject% obj);
        virtual void verifyClass( System::IntPtr klass); // more for remote tweaking (recursion down to classes we don't know etc), make sure we load that klass.
        virtual void commit( HavokReflectedObject origObject, System::IntPtr newData );


        // UI i/f
        virtual void setParentControl( System::Windows::Forms::Control^ parent, Havok::Tool::IConsole^ errorConsole);
        virtual void setParentMenu( System::Windows::Forms::MenuStrip^ parent );
        virtual void setNavigationToolBar( System::Windows::Forms::ToolStrip^ navigationToolBar );

        void report( Havok::Tool::IConsole::MessageType t, String^ message );

        void reflectClothSettings();

        // Plugins data exchange
        virtual void setPluginOwner( IPluginOwner^ owner );
        virtual System::IntPtr getObjectOfType( System::IntPtr klass );

        // Mesh channels menu
        void RepopulateMeshChannelMenu();
        void EnableAssetMeshChannels(int assetIndex);
        void DisableAssetMeshChannels(int assetIndex);

        void RepopulateClothTransitionForm();



    private:
        void RefreshSceneTreeView();
        void RefreshDisplayTreeView();
        void RefreshCameraLists();
        void UpdateView( void* prevWorld );
        void RemoveWorldFromView(void* prevWorld);
        void PickDefaultCamera();

        void updateCameraFromFirstPersonController();
        void stepFirstPersonController(float dt);
        void stepFirstPersonControllerNp(float dt);
        void getUserInputForCharacter(float sensivity_mouseX, float sensivity_mouseY, float sensivity_padX, float sensivity_padY, float* deltaAngle, float* deltaElevation, float* posX, float* posY );

        void initPhysicsUI();
        void initNewPhysicsUI();
        void initAnimUI();
        void initCompleteUI();
        void initClothUI();
        void initDestructionUI();
        void initNewDestructionUI();

        void configureProductsFromUI();
        void configurePhysicsFromUI();
        void configureNewPhysicsFromUI();
        void configureAnimFromUI();
        void configureCompleteFromUI();
        void configureClothFromUI();
        void configureDestructionFromUI();
        void configureNewDestructionFromUI();

        void enableFirstPersonCamera(bool enable);

        TreeNode^ addVariantNode(const hkReflect::Var& variant, TreeNode^ parentTreeNode);
        void addGrandchildNodes(TreeNode^ parentNode, const hkReflect::Var& parentVar);

        enum struct AddAssetType
        {
            REPLACE_SCENE,
            REPLACE_ASSET_UNDER_DROP,
            ADD_ASSET_NO_ASSOCIATE,
            ADD_ASSET_AND_ASSOCIATE_UNDER_DROP
        };
        void addAssetsFromFile( System::Collections::ArrayList^ files, AddAssetType t );

    private:
        System::Collections::ArrayList^             m_delayedDropFiles;

        System::ComponentModel::IContainer^         components;

        System::Windows::Forms::Button^             adjustEffectsButton;
        System::Windows::Forms::Button^             chooseRendererButton;
        System::Windows::Forms::Button^             clearSceneButton;
        System::Windows::Forms::Button^             clothCollidableControlButton;
        System::Windows::Forms::Button^             clothTransitionsButton;
        System::Windows::Forms::Button^             clothWindControlButton;
        System::Windows::Forms::Button^             destructionResetButton;
        System::Windows::Forms::Button^             minusFrameButton;
        System::Windows::Forms::Button^             playPauseButton;
        System::Windows::Forms::Button^             plusFrameButton;
        System::Windows::Forms::Button^             postEffectsButton;
        System::Windows::Forms::Button^             restartButton;
        System::Windows::Forms::Button^             singleStepButton;
        System::Windows::Forms::Button^             stepSizeDoubleButton;
        System::Windows::Forms::Button^             stepSizeHalfButton;

        System::Windows::Forms::CheckBox^           accumMotionCheckBox;
        System::Windows::Forms::CheckBox^           animCheckBox;
        System::Windows::Forms::CheckBox^           boxPhysicsCheckBox;
        System::Windows::Forms::CheckBox^           clothCheckBox;
        System::Windows::Forms::CheckBox^           clothMultithreadCheckBox;
        System::Windows::Forms::CheckBox^           destructionExplodedStateCheckBox;
        System::Windows::Forms::CheckBox^           destructionGraphicsShapeNamesCheckBox;
        System::Windows::Forms::CheckBox^           displayAnnotationsCheckBox;
        System::Windows::Forms::CheckBox^           displayBoneNamesCheckBox;
        System::Windows::Forms::CheckBox^           displayMotionCheckBox;
        System::Windows::Forms::CheckBox^           displaySkeletonsCheckBox;
        System::Windows::Forms::CheckBox^           num1CheckBox;
        System::Windows::Forms::CheckBox^           floatTracksCheckBox;
        System::Windows::Forms::CheckBox^           litCheckBox;
        System::Windows::Forms::CheckBox^           realtimeCheckBox;
        System::Windows::Forms::CheckBox^           shadowCasterCheckBox;
        System::Windows::Forms::CheckBox^           shadowRecvCheckBox;
        System::Windows::Forms::CheckBox^           showBbCheckbox;
        System::Windows::Forms::CheckBox^           showBoundingBoxCheckbox;



        System::Windows::Forms::CheckBox^           showCollShapeCheckBox;
        System::Windows::Forms::CheckBox^           showDisplayMeshCheckBox;

        System::Windows::Forms::CheckBox^           thickBonesCheckBox;

        System::Windows::Forms::ComboBox^           footStepsComboBox;
        System::Windows::Forms::ComboBox^           gravityComboBox;
        System::Windows::Forms::ComboBox^           ragdollMappingCombo;

        System::Windows::Forms::ContextMenuStrip^   dragDropContextMenuStrip;
        System::Windows::Forms::ContextMenuStrip^   sceneViewMenuStrip;

        System::Windows::Forms::GroupBox^           completeGroupBox;
        System::Windows::Forms::GroupBox^           num1GroupBox;
        System::Windows::Forms::GroupBox^           num2GroupBox;

        System::Windows::Forms::GroupBox^           num5GroupBox;
        System::Windows::Forms::GroupBox^           stepSizeGroupBox;

        System::Windows::Forms::ImageList^          playButtonImageList;
        System::Windows::Forms::ImageList^          treeViewImageList;

        System::Windows::Forms::Label^              animFrameLabel;
        System::Windows::Forms::Label^              displayObjectNameLabel;
        System::Windows::Forms::Label^              num1Label;
        System::Windows::Forms::Label^              num2Label;
        System::Windows::Forms::Label^              num4Label;
        System::Windows::Forms::Label^              num5Label;
        System::Windows::Forms::Label^              num6Label;
        System::Windows::Forms::Label^              num7Label;
        System::Windows::Forms::Label^              num8Label;
        System::Windows::Forms::Label^              num9Label;
        System::Windows::Forms::Label^              labelAnimFrame;
        System::Windows::Forms::Label^              ragdollMappingLabel;
        System::Windows::Forms::Label^              rendererLabel;

        System::Windows::Forms::MenuStrip^          m_parentMenu;

        System::Windows::Forms::NumericUpDown^      playSpeedNumericUpDown;
        System::Windows::Forms::NumericUpDown^      stepSizeNumericUpDowm;

        System::Windows::Forms::TabControl^         productsTabControl;

        System::Windows::Forms::TabPage^            animTabPage;
        System::Windows::Forms::TabPage^            clothTabPage;
        System::Windows::Forms::TabPage^            destructionTabPage;
        System::Windows::Forms::TabPage^            displayTabPage;
        System::Windows::Forms::TabPage^            physicsTabPage;

        System::Windows::Forms::TextBox^            destructionAdditionalTexSearchPathTextBox;
        System::Windows::Forms::Button^  debugDisplayButton;
        System::Windows::Forms::TabControl^  treeViewTabControl;
        System::Windows::Forms::TabPage^  sceneTreeViewTab;
        System::Windows::Forms::TabPage^  displayTreeViewTab;
        System::Windows::Forms::TreeView^  displayTreeView;
        System::Windows::Forms::CheckBox^  clothDisplayNonClothMeshesCheckBox;

        System::Windows::Forms::ToolStrip^          m_navigationToolBar;

        System::Windows::Forms::ToolStripButton^    getFirstPersonCameraButton();
        System::Windows::Forms::ToolStripButton^    getFlyModeCameraButton();

        System::Windows::Forms::ToolStripMenuItem^  addToSceneMenuItem;
        System::Windows::Forms::ToolStripMenuItem^  addWrtAssetMenuItem;
        System::Windows::Forms::ToolStripMenuItem^  cameraMenuItem;
        System::Windows::Forms::ToolStripMenuItem^  cancelDragDropToolStripMenuItem;
        System::Windows::Forms::ToolStripMenuItem^  channelsMenuItem;
        System::Windows::Forms::ToolStripMenuItem^  disableToolStripMenuItem;
        System::Windows::Forms::ToolStripMenuItem^  enableToolStripMenuItem;
        System::Windows::Forms::ToolStripMenuItem^  removeToolStripMenuItem;
        System::Windows::Forms::ToolStripMenuItem^  replaceSceneMenuItem;
        System::Windows::Forms::ToolStripMenuItem^  replaceThisAssetMenuItem;

        System::Windows::Forms::ToolStripSeparator^ num1ToolStripSeparator;
        System::Windows::Forms::ToolStripSeparator^ num2ToolStripSeparator;

        System::Windows::Forms::TrackBar^           animFrameTrackBar;
        System::Windows::Forms::TrackBar^           playSpeedTrackBar;

        System::Windows::Forms::TreeView^           sceneTreeView;

#ifdef HK_ENABLE_CLOTH_PREVIEW
        hctPreviewClothWindForm^                    m_clothWindForm;
        hctPreviewClothTransitionForm^              m_clothTransitionForm;
        hctPreviewClothDebugForm^                   m_clothDebugForm;
        hctPreviewClothCollidableForm^              m_clothCollidableForm;
#endif

    private:
        System::Void physicsCheckBox_CheckedChanged(System::Object^  sender, System::EventArgs^  e);
        System::Void animCheckBox_CheckedChanged(System::Object^  sender, System::EventArgs^  e);
        System::Void accumMotionCheckBox_CheckedChanged(System::Object^  sender, System::EventArgs^  e);
        System::Void displaySkeletonsCheckBox_CheckedChanged(System::Object^  sender, System::EventArgs^  e);
        System::Void clothCheckBox_CheckedChanged(System::Object^  sender, System::EventArgs^  e);

        System::Void clearSceneButton_Click(System::Object^  sender, System::EventArgs^  e);
        System::Void enableToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e);
        System::Void disableToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e);
        System::Void removeToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e);

        System::Void sceneViewMenuStrip_Opening(System::Object^  sender, System::ComponentModel::CancelEventArgs^  e);
        System::Void litCheckBox_CheckedChanged(System::Object^  sender, System::EventArgs^  e);
        System::Void shadowCasterCheckBox_CheckedChanged(System::Object^  sender, System::EventArgs^  e);
        System::Void shadowRecvCheckBox_CheckedChanged(System::Object^  sender, System::EventArgs^  e);
        System::Void showBoundingBoxCheckbox_CheckedChanged(System::Object^  sender, System::EventArgs^  e);

        System::Void restartButton_Click(System::Object^  sender, System::EventArgs^  e);
        System::Void playPauseButton_Click(System::Object^  sender, System::EventArgs^  e);
        System::Void rendererLabel_Click(System::Object^  sender, System::EventArgs^  e);
        System::Void addWrtAssetMenuItem_Click(System::Object^  sender, System::EventArgs^  e);
        System::Void replaceThisAssetToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e);
        System::Void addToSceneMenuItem_Click(System::Object^  sender, System::EventArgs^  e);
        System::Void replaceSceneMenuItem_Click(System::Object^  sender, System::EventArgs^  e);
        System::Void cancelDragDropToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e);
        System::Void chooseRendererButton_Click(System::Object^  sender, System::EventArgs^  e) { rendererLabel_Click( sender, e ); }

        System::Void ragdollMappingCombo_SelectedIndexChanged(System::Object^  sender, System::EventArgs^  e);

        System::Void cameraSelectToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e);
        System::Void singleStepButton_Click(System::Object^  sender, System::EventArgs^  e);

        System::Void stepSizeNumericUpDowm_ValueChanged(System::Object^  sender, System::EventArgs^  e);

        System::Void stepSizeHalfButton_Click(System::Object^  sender, System::EventArgs^  e);
        System::Void stepSizeDoubleButton_Click(System::Object^  sender, System::EventArgs^  e);

        System::Void realtimeCheckBox_CheckedChanged(System::Object^  sender, System::EventArgs^  e);

        System::Void playSpeedTrackBar_Scroll(System::Object^  sender, System::EventArgs^  e);

        System::Void playSpeedNumericUpDown_ValueChanged(System::Object^  sender, System::EventArgs^  e);

        System::Void clothWindControlButton_Click(System::Object^  sender, System::EventArgs^  e);
        System::Void clothTransitionsButton_Click(System::Object^  sender, System::EventArgs^  e);
        System::Void clothCollidableControlButton_Click(System::Object^  sender, System::EventArgs^  e);
        System::Void clothDebugDisplayButton_Click(System::Object^  sender, System::EventArgs^  e);

        System::Void meshVertexChannelSelectToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e);
        System::Void meshTriangleChannelSelectToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e);
        System::Void meshEdgeChannelSelectToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e);
        System::Void resetMeshChannelsToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e);
        System::Void vtxSelEnableAllToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e);
        System::Void vtxSelDisableAllToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e);
        System::Void floatChannelEnableAllToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e);
        System::Void floatChannelDisableAllToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e);
        System::Void triSelEnableAllToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e);
        System::Void triSelDisableAllToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e);
        System::Void edgeSelEnableAllToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e);
        System::Void edgeSelDisableAllToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e);
        System::Void renderMeshGeometryToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e);

        System::Void sceneTreeViewNodeExpand(System::Object^  sender, System::Windows::Forms::TreeViewEventArgs^  e);

        System::Void sceneTreeView_NodeMouseClick(System::Object^  sender, System::Windows::Forms::TreeNodeMouseClickEventArgs^  e);

        System::Void displayTreeView_AfterSelect(System::Object^  sender, System::Windows::Forms::TreeViewEventArgs^  e);

        System::Void checkBoxDestructionExplodedState_CheckedChanged(System::Object^  sender, System::EventArgs^  e);
        System::Void checkBoxDestructionGraphicsShapeNames_CheckedChanged(System::Object^  sender, System::EventArgs^  e);
        System::Void showBbCheckbox_CheckedChanged(System::Object^  sender, System::EventArgs^  e);
        System::Void textBoxDestructionAdditionalTexSearchPath_TextChanged(System::Object^  sender, System::EventArgs^  e);
        System::Void displayBoneNamesCheckBox_CheckedChanged(System::Object^  sender, System::EventArgs^  e);
        System::Void displayAnnotationsCheckBox_CheckedChanged(System::Object^  sender, System::EventArgs^  e);
        System::Void displayMotionCheckBox_CheckedChanged(System::Object^  sender, System::EventArgs^  e);
        System::Void footStepsComboBox_SelectedIndexChanged(System::Object^  sender, System::EventArgs^  e);
        System::Void showCollShapeCheckBox_CheckedChanged(System::Object^  sender, System::EventArgs^  e);
        System::Void showDisplayMeshCheckBox_CheckedChanged(System::Object^  sender, System::EventArgs^  e);

        System::Void destructionResetButton_Click(System::Object^  sender, System::EventArgs^  e);

        System::Void comboBoxGravity_SelectedIndexChanged(System::Object^  sender, System::EventArgs^  e);
        System::Void floatTracksCheckBox_CheckedChanged(System::Object^  sender, System::EventArgs^  e);

        System::Void animFrameTrackBar_Scroll(System::Object^  sender, System::EventArgs^  e);

        System::Void minusFrameButton_Click(System::Object^  sender, System::EventArgs^  e);
        System::Void plusFrameButton_Click(System::Object^  sender, System::EventArgs^  e);

        System::Void thickBonesCheckBox_CheckedChanged(System::Object^  sender, System::EventArgs^  e);

        System::Void postEffectsButton_Click(System::Object^  sender, System::EventArgs^  e);
        System::Void adjustEffectsButton_Click(System::Object^  sender, System::EventArgs^  e);

        System::Void clothMultithreadCheckBox_CheckedChanged(System::Object^  sender, System::EventArgs^  e);
        System::Void clothDisplayNonClothMeshesCheckBox_CheckedChanged(System::Object^  sender, System::EventArgs^  e);

    private:
        // unmanaged and managed stuff can all go here
        // just some cases can't be mixed
        PreviewPluginImpl* m_si;
        GraphicsBridge^ m_display;
        GraphicsBridgeBaseSystem^ m_displayMem;
        Havok::Tool::IConsole^ m_errorConsole;

        // Tree view
        hctPreviewTreeViewManager* m_treeViewManager;
        bool m_displayBoundingBox;

        bool m_playState; // true for stepping
        bool m_singleStep;
        float m_totalUnusedStepDelta;
        float m_stepDelta;
        bool m_allowSubsteps;
        bool m_restart; // true for stepping
        float m_playbackSpeed; // as percent, so 1 == normal shown display speed
        bool m_displayDropTargets;
        bool m_inRealTimePlayback;
        float m_warnNonRealtimeCounter; //sec

#ifdef HK_ENABLE_PHYSICS_2012
        hkpFirstPersonCharacter* m_char;
#endif
#ifdef HK_ENABLE_PHYSICS
        hknpFirstPersonCharacter* m_npChar;
#endif

        // Grid properties
        bool m_gridEnabled;
        float m_gridCellSize;
        enum struct GridOrientation
        {
            GRID_XY,
            GRID_XZ,
            GRID_YZ
        };
        GridOrientation m_gridOrientation;

    private:
        /// <summary>
        /// Required designer variable.
        /// </summary>
#pragma region Windows Form Designer generated code
        /// <summary>
        /// Required method for Designer support - do not modify
        /// the contents of this method with the code editor.
        /// </summary>
        void InitializeComponent(void)
        {
            this->components = (gcnew System::ComponentModel::Container());
            System::ComponentModel::ComponentResourceManager^  resources = (gcnew System::ComponentModel::ComponentResourceManager(hctPreviewControl::typeid));
            this->accumMotionCheckBox = (gcnew System::Windows::Forms::CheckBox());
            this->animCheckBox = (gcnew System::Windows::Forms::CheckBox());
            this->boxPhysicsCheckBox = (gcnew System::Windows::Forms::CheckBox());
            this->clearSceneButton = (gcnew System::Windows::Forms::Button());
            this->sceneTreeView = (gcnew System::Windows::Forms::TreeView());
            this->sceneViewMenuStrip = (gcnew System::Windows::Forms::ContextMenuStrip(this->components));
            this->enableToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
            this->disableToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
            this->removeToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
            this->treeViewImageList = (gcnew System::Windows::Forms::ImageList(this->components));
            this->productsTabControl = (gcnew System::Windows::Forms::TabControl());
            this->physicsTabPage = (gcnew System::Windows::Forms::TabPage());
            this->showDisplayMeshCheckBox = (gcnew System::Windows::Forms::CheckBox());
            this->num9Label = (gcnew System::Windows::Forms::Label());
            this->gravityComboBox = (gcnew System::Windows::Forms::ComboBox());
            this->showCollShapeCheckBox = (gcnew System::Windows::Forms::CheckBox());
            this->completeGroupBox = (gcnew System::Windows::Forms::GroupBox());
            this->ragdollMappingCombo = (gcnew System::Windows::Forms::ComboBox());
            this->ragdollMappingLabel = (gcnew System::Windows::Forms::Label());
            this->animTabPage = (gcnew System::Windows::Forms::TabPage());
            this->num5GroupBox = (gcnew System::Windows::Forms::GroupBox());
            this->thickBonesCheckBox = (gcnew System::Windows::Forms::CheckBox());
            this->floatTracksCheckBox = (gcnew System::Windows::Forms::CheckBox());
            this->num8Label = (gcnew System::Windows::Forms::Label());
            this->footStepsComboBox = (gcnew System::Windows::Forms::ComboBox());
            this->displayAnnotationsCheckBox = (gcnew System::Windows::Forms::CheckBox());
            this->displayBoneNamesCheckBox = (gcnew System::Windows::Forms::CheckBox());
            this->displayMotionCheckBox = (gcnew System::Windows::Forms::CheckBox());
            this->displaySkeletonsCheckBox = (gcnew System::Windows::Forms::CheckBox());
            this->num1CheckBox = (gcnew System::Windows::Forms::CheckBox());
            this->clothTabPage = (gcnew System::Windows::Forms::TabPage());
            this->debugDisplayButton = (gcnew System::Windows::Forms::Button());
            this->clothCollidableControlButton = (gcnew System::Windows::Forms::Button());
            this->clothMultithreadCheckBox = (gcnew System::Windows::Forms::CheckBox());
            this->clothTransitionsButton = (gcnew System::Windows::Forms::Button());
            this->clothWindControlButton = (gcnew System::Windows::Forms::Button());
            this->clothCheckBox = (gcnew System::Windows::Forms::CheckBox());
            this->destructionTabPage = (gcnew System::Windows::Forms::TabPage());
            this->showBbCheckbox = (gcnew System::Windows::Forms::CheckBox());
            this->destructionResetButton = (gcnew System::Windows::Forms::Button());
            this->num7Label = (gcnew System::Windows::Forms::Label());
            this->destructionAdditionalTexSearchPathTextBox = (gcnew System::Windows::Forms::TextBox());
            this->destructionGraphicsShapeNamesCheckBox = (gcnew System::Windows::Forms::CheckBox());
            this->destructionExplodedStateCheckBox = (gcnew System::Windows::Forms::CheckBox());
            this->displayTabPage = (gcnew System::Windows::Forms::TabPage());
            this->adjustEffectsButton = (gcnew System::Windows::Forms::Button());
            this->postEffectsButton = (gcnew System::Windows::Forms::Button());
            this->num1GroupBox = (gcnew System::Windows::Forms::GroupBox());
            this->showBoundingBoxCheckbox = (gcnew System::Windows::Forms::CheckBox());
            this->shadowRecvCheckBox = (gcnew System::Windows::Forms::CheckBox());
            this->litCheckBox = (gcnew System::Windows::Forms::CheckBox());
            this->shadowCasterCheckBox = (gcnew System::Windows::Forms::CheckBox());
            this->chooseRendererButton = (gcnew System::Windows::Forms::Button());
            this->rendererLabel = (gcnew System::Windows::Forms::Label());
            this->displayObjectNameLabel = (gcnew System::Windows::Forms::Label());
            this->num2Label = (gcnew System::Windows::Forms::Label());
            this->num1Label = (gcnew System::Windows::Forms::Label());
            this->playPauseButton = (gcnew System::Windows::Forms::Button());
            this->playButtonImageList = (gcnew System::Windows::Forms::ImageList(this->components));
            this->restartButton = (gcnew System::Windows::Forms::Button());
            this->num2GroupBox = (gcnew System::Windows::Forms::GroupBox());
            this->num6Label = (gcnew System::Windows::Forms::Label());
            this->playSpeedNumericUpDown = (gcnew System::Windows::Forms::NumericUpDown());
            this->num4Label = (gcnew System::Windows::Forms::Label());
            this->playSpeedTrackBar = (gcnew System::Windows::Forms::TrackBar());
            this->singleStepButton = (gcnew System::Windows::Forms::Button());
            this->dragDropContextMenuStrip = (gcnew System::Windows::Forms::ContextMenuStrip(this->components));
            this->addWrtAssetMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
            this->replaceThisAssetMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
            this->num1ToolStripSeparator = (gcnew System::Windows::Forms::ToolStripSeparator());
            this->addToSceneMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
            this->replaceSceneMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
            this->num2ToolStripSeparator = (gcnew System::Windows::Forms::ToolStripSeparator());
            this->cancelDragDropToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
            this->stepSizeNumericUpDowm = (gcnew System::Windows::Forms::NumericUpDown());
            this->num5Label = (gcnew System::Windows::Forms::Label());
            this->stepSizeHalfButton = (gcnew System::Windows::Forms::Button());
            this->stepSizeGroupBox = (gcnew System::Windows::Forms::GroupBox());
            this->realtimeCheckBox = (gcnew System::Windows::Forms::CheckBox());
            this->stepSizeDoubleButton = (gcnew System::Windows::Forms::Button());
            this->animFrameTrackBar = (gcnew System::Windows::Forms::TrackBar());
            this->animFrameLabel = (gcnew System::Windows::Forms::Label());
            this->plusFrameButton = (gcnew System::Windows::Forms::Button());
            this->minusFrameButton = (gcnew System::Windows::Forms::Button());
            this->labelAnimFrame = (gcnew System::Windows::Forms::Label());
            this->treeViewTabControl = (gcnew System::Windows::Forms::TabControl());
            this->sceneTreeViewTab = (gcnew System::Windows::Forms::TabPage());
            this->displayTreeViewTab = (gcnew System::Windows::Forms::TabPage());
            this->displayTreeView = (gcnew System::Windows::Forms::TreeView());
            this->clothDisplayNonClothMeshesCheckBox = (gcnew System::Windows::Forms::CheckBox());
            this->sceneViewMenuStrip->SuspendLayout();
            this->productsTabControl->SuspendLayout();
            this->physicsTabPage->SuspendLayout();
            this->completeGroupBox->SuspendLayout();
            this->animTabPage->SuspendLayout();
            this->num5GroupBox->SuspendLayout();
            this->clothTabPage->SuspendLayout();
            this->destructionTabPage->SuspendLayout();
            this->displayTabPage->SuspendLayout();
            this->num1GroupBox->SuspendLayout();
            this->num2GroupBox->SuspendLayout();
            (cli::safe_cast<System::ComponentModel::ISupportInitialize^>(this->playSpeedNumericUpDown))->BeginInit();
            (cli::safe_cast<System::ComponentModel::ISupportInitialize^>(this->playSpeedTrackBar))->BeginInit();
            this->dragDropContextMenuStrip->SuspendLayout();
            (cli::safe_cast<System::ComponentModel::ISupportInitialize^>(this->stepSizeNumericUpDowm))->BeginInit();
            this->stepSizeGroupBox->SuspendLayout();
            (cli::safe_cast<System::ComponentModel::ISupportInitialize^>(this->animFrameTrackBar))->BeginInit();
            this->treeViewTabControl->SuspendLayout();
            this->sceneTreeViewTab->SuspendLayout();
            this->displayTreeViewTab->SuspendLayout();
            this->SuspendLayout();
            //
            // accumMotionCheckBox
            //
            this->accumMotionCheckBox->AutoSize = true;
            this->accumMotionCheckBox->Location = System::Drawing::Point(130, 12);
            this->accumMotionCheckBox->Name = L"accumMotionCheckBox";
            this->accumMotionCheckBox->Size = System::Drawing::Size(94, 17);
            this->accumMotionCheckBox->TabIndex = 3;
            this->accumMotionCheckBox->Text = L"Accum Motion";
            this->accumMotionCheckBox->UseVisualStyleBackColor = true;
            this->accumMotionCheckBox->CheckedChanged += gcnew System::EventHandler(this, &hctPreviewControl::accumMotionCheckBox_CheckedChanged);
            //
            // animCheckBox
            //
            this->animCheckBox->AutoSize = true;
            this->animCheckBox->Checked = true;
            this->animCheckBox->CheckState = System::Windows::Forms::CheckState::Checked;
            this->animCheckBox->Location = System::Drawing::Point(12, 12);
            this->animCheckBox->Name = L"animCheckBox";
            this->animCheckBox->Size = System::Drawing::Size(95, 17);
            this->animCheckBox->TabIndex = 2;
            this->animCheckBox->Text = L"Run Animation";
            this->animCheckBox->UseVisualStyleBackColor = true;
            this->animCheckBox->CheckedChanged += gcnew System::EventHandler(this, &hctPreviewControl::animCheckBox_CheckedChanged);
            //
            // boxPhysicsCheckBox
            //
            this->boxPhysicsCheckBox->AutoSize = true;
            this->boxPhysicsCheckBox->Checked = true;
            this->boxPhysicsCheckBox->CheckState = System::Windows::Forms::CheckState::Checked;
            this->boxPhysicsCheckBox->Location = System::Drawing::Point(12, 12);
            this->boxPhysicsCheckBox->Name = L"boxPhysicsCheckBox";
            this->boxPhysicsCheckBox->Size = System::Drawing::Size(85, 17);
            this->boxPhysicsCheckBox->TabIndex = 1;
            this->boxPhysicsCheckBox->Text = L"Run Physics";
            this->boxPhysicsCheckBox->UseVisualStyleBackColor = true;
            this->boxPhysicsCheckBox->CheckedChanged += gcnew System::EventHandler(this, &hctPreviewControl::physicsCheckBox_CheckedChanged);
            //
            // clearSceneButton
            //
            this->clearSceneButton->Anchor = static_cast<System::Windows::Forms::AnchorStyles>((System::Windows::Forms::AnchorStyles::Bottom | System::Windows::Forms::AnchorStyles::Left));
            this->clearSceneButton->Location = System::Drawing::Point(113, 579);
            this->clearSceneButton->Name = L"clearSceneButton";
            this->clearSceneButton->Size = System::Drawing::Size(82, 26);
            this->clearSceneButton->TabIndex = 3;
            this->clearSceneButton->Text = L"Clear Scene";
            this->clearSceneButton->UseVisualStyleBackColor = true;
            this->clearSceneButton->Click += gcnew System::EventHandler(this, &hctPreviewControl::clearSceneButton_Click);
            //
            // sceneTreeView
            //
            this->sceneTreeView->Anchor = static_cast<System::Windows::Forms::AnchorStyles>((((System::Windows::Forms::AnchorStyles::Top | System::Windows::Forms::AnchorStyles::Bottom)
                | System::Windows::Forms::AnchorStyles::Left)
                | System::Windows::Forms::AnchorStyles::Right));
            this->sceneTreeView->ContextMenuStrip = this->sceneViewMenuStrip;
            this->sceneTreeView->HotTracking = true;
            this->sceneTreeView->ImageIndex = 0;
            this->sceneTreeView->ImageList = this->treeViewImageList;
            this->sceneTreeView->Location = System::Drawing::Point(3, 6);
            this->sceneTreeView->Name = L"sceneTreeView";
            this->sceneTreeView->SelectedImageIndex = 0;
            this->sceneTreeView->ShowNodeToolTips = true;
            this->sceneTreeView->Size = System::Drawing::Size(290, 247);
            this->sceneTreeView->TabIndex = 2;
            this->sceneTreeView->AfterExpand += gcnew System::Windows::Forms::TreeViewEventHandler(this, &hctPreviewControl::sceneTreeViewNodeExpand);
            this->sceneTreeView->NodeMouseClick += gcnew System::Windows::Forms::TreeNodeMouseClickEventHandler(this, &hctPreviewControl::sceneTreeView_NodeMouseClick);
            //
            // sceneViewMenuStrip
            //
            this->sceneViewMenuStrip->Items->AddRange(gcnew cli::array< System::Windows::Forms::ToolStripItem^  >(3) {
                this->enableToolStripMenuItem,
                    this->disableToolStripMenuItem, this->removeToolStripMenuItem
            });
            this->sceneViewMenuStrip->Name = L"sceneViewMenuStrip";
            this->sceneViewMenuStrip->Size = System::Drawing::Size(118, 70);
            this->sceneViewMenuStrip->Opening += gcnew System::ComponentModel::CancelEventHandler(this, &hctPreviewControl::sceneViewMenuStrip_Opening);
            //
            // enableToolStripMenuItem
            //
            this->enableToolStripMenuItem->Name = L"enableToolStripMenuItem";
            this->enableToolStripMenuItem->Size = System::Drawing::Size(117, 22);
            this->enableToolStripMenuItem->Text = L"&Enable";
            this->enableToolStripMenuItem->Click += gcnew System::EventHandler(this, &hctPreviewControl::enableToolStripMenuItem_Click);
            //
            // disableToolStripMenuItem
            //
            this->disableToolStripMenuItem->Name = L"disableToolStripMenuItem";
            this->disableToolStripMenuItem->Size = System::Drawing::Size(117, 22);
            this->disableToolStripMenuItem->Text = L"&Disable";
            this->disableToolStripMenuItem->Click += gcnew System::EventHandler(this, &hctPreviewControl::disableToolStripMenuItem_Click);
            //
            // removeToolStripMenuItem
            //
            this->removeToolStripMenuItem->Name = L"removeToolStripMenuItem";
            this->removeToolStripMenuItem->Size = System::Drawing::Size(117, 22);
            this->removeToolStripMenuItem->Text = L"&Remove";
            this->removeToolStripMenuItem->Click += gcnew System::EventHandler(this, &hctPreviewControl::removeToolStripMenuItem_Click);
            //
            // treeViewImageList
            //
            this->treeViewImageList->ImageStream = (cli::safe_cast<System::Windows::Forms::ImageListStreamer^>(resources->GetObject(L"treeViewImageList.ImageStream")));
            this->treeViewImageList->TransparentColor = System::Drawing::Color::Transparent;
            this->treeViewImageList->Images->SetKeyName(0, L"hclBendLinkConstraintSet.bmp");
            this->treeViewImageList->Images->SetKeyName(1, L"hclBlendSomeVerticesOperator.bmp");
            this->treeViewImageList->Images->SetKeyName(2, L"hclBonePlanesConstraintSet.bmp");
            this->treeViewImageList->Images->SetKeyName(3, L"hclBoxShape.bmp");
            this->treeViewImageList->Images->SetKeyName(4, L"hclBufferDefinition.bmp");
            this->treeViewImageList->Images->SetKeyName(5, L"hclCapsuleHeightField.bmp");
            this->treeViewImageList->Images->SetKeyName(6, L"hclCapsuleShape.bmp");
            this->treeViewImageList->Images->SetKeyName(7, L"hclClothContainer.bmp");
            this->treeViewImageList->Images->SetKeyName(8, L"hclClothData.bmp");
            this->treeViewImageList->Images->SetKeyName(9, L"hclClothState.bmp");
            this->treeViewImageList->Images->SetKeyName(10, L"hclCollidable.bmp");
            this->treeViewImageList->Images->SetKeyName(11, L"hclConstraintSet.bmp");
            this->treeViewImageList->Images->SetKeyName(12, L"hclGatherAllVerticesOperator.bmp");
            this->treeViewImageList->Images->SetKeyName(13, L"hclHingeConstraintSet.bmp");
            this->treeViewImageList->Images->SetKeyName(14, L"hclLocalRangeConstraintSet.bmp");
            this->treeViewImageList->Images->SetKeyName(15, L"hclMeshMeshDeformOperator.bmp");
            this->treeViewImageList->Images->SetKeyName(16, L"hclOperator.bmp");
            this->treeViewImageList->Images->SetKeyName(17, L"hclPlane.bmp");
            this->treeViewImageList->Images->SetKeyName(18, L"hclRecalculateAllNormalsOperator.bmp");
            this->treeViewImageList->Images->SetKeyName(19, L"hclSimClothData.bmp");
            this->treeViewImageList->Images->SetKeyName(20, L"hclSimClothDataParticleData.bmp");
            this->treeViewImageList->Images->SetKeyName(21, L"hclSimClothPose.bmp");
            this->treeViewImageList->Images->SetKeyName(22, L"hclSimulateOperator.bmp");
            this->treeViewImageList->Images->SetKeyName(23, L"hclSkinOperator.bmp");
            this->treeViewImageList->Images->SetKeyName(24, L"hclSphereShape.bmp");
            this->treeViewImageList->Images->SetKeyName(25, L"hclStandardLinkConstraintSet.bmp");
            this->treeViewImageList->Images->SetKeyName(26, L"hclStretchLinkConstraintSet.bmp");
            this->treeViewImageList->Images->SetKeyName(27, L"hclTransformSetDefinition.bmp");
            this->treeViewImageList->Images->SetKeyName(28, L"hclTransitionConstraintSet.bmp");
            this->treeViewImageList->Images->SetKeyName(29, L"hclVolumeConstraintSet.bmp");
            this->treeViewImageList->Images->SetKeyName(30, L"hkaAnimationContainer.png");
            this->treeViewImageList->Images->SetKeyName(31, L"hkaBone.png");
            this->treeViewImageList->Images->SetKeyName(32, L"hkaBoneAttachment.png");
            this->treeViewImageList->Images->SetKeyName(33, L"hkaMeshBinding.png");
            this->treeViewImageList->Images->SetKeyName(34, L"hkaSkeleton.png");
            this->treeViewImageList->Images->SetKeyName(35, L"hkpPhysicsData.png");
            this->treeViewImageList->Images->SetKeyName(36, L"hkpRigidBody.png");
            this->treeViewImageList->Images->SetKeyName(37, L"hkRootLevelContainer.png");
            this->treeViewImageList->Images->SetKeyName(38, L"hkxAttributeGroup.png");
            this->treeViewImageList->Images->SetKeyName(39, L"hkxCamera.png");
            this->treeViewImageList->Images->SetKeyName(40, L"hkxEnvironmentData.png");
            this->treeViewImageList->Images->SetKeyName(41, L"hkxLight.png");
            this->treeViewImageList->Images->SetKeyName(42, L"hkxMaterial.png");
            this->treeViewImageList->Images->SetKeyName(43, L"hkxMesh.png");
            this->treeViewImageList->Images->SetKeyName(44, L"hkxMeshSection.png");
            this->treeViewImageList->Images->SetKeyName(45, L"hkxNode.png");
            this->treeViewImageList->Images->SetKeyName(46, L"hkxScene.png");
            this->treeViewImageList->Images->SetKeyName(47, L"unknown.png");
            //
            // productsTabControl
            //
            this->productsTabControl->Anchor = static_cast<System::Windows::Forms::AnchorStyles>(((System::Windows::Forms::AnchorStyles::Top | System::Windows::Forms::AnchorStyles::Left)
                | System::Windows::Forms::AnchorStyles::Right));
            this->productsTabControl->Controls->Add(this->physicsTabPage);
            this->productsTabControl->Controls->Add(this->animTabPage);
            this->productsTabControl->Controls->Add(this->clothTabPage);
            this->productsTabControl->Controls->Add(this->destructionTabPage);
            this->productsTabControl->Controls->Add(this->displayTabPage);
            this->productsTabControl->Location = System::Drawing::Point(7, 3);
            this->productsTabControl->Multiline = true;
            this->productsTabControl->Name = L"productsTabControl";
            this->productsTabControl->SelectedIndex = 0;
            this->productsTabControl->Size = System::Drawing::Size(307, 168);
            this->productsTabControl->TabIndex = 4;
            //
            // physicsTabPage
            //
            this->physicsTabPage->Controls->Add(this->showDisplayMeshCheckBox);
            this->physicsTabPage->Controls->Add(this->num9Label);
            this->physicsTabPage->Controls->Add(this->gravityComboBox);
            this->physicsTabPage->Controls->Add(this->showCollShapeCheckBox);
            this->physicsTabPage->Controls->Add(this->completeGroupBox);
            this->physicsTabPage->Controls->Add(this->boxPhysicsCheckBox);
            this->physicsTabPage->Location = System::Drawing::Point(4, 22);
            this->physicsTabPage->Name = L"physicsTabPage";
            this->physicsTabPage->Padding = System::Windows::Forms::Padding(3);
            this->physicsTabPage->Size = System::Drawing::Size(299, 142);
            this->physicsTabPage->TabIndex = 0;
            this->physicsTabPage->Text = L"Physics";
            this->physicsTabPage->UseVisualStyleBackColor = true;
            //
            // showDisplayMeshCheckBox
            //
            this->showDisplayMeshCheckBox->AutoSize = true;
            this->showDisplayMeshCheckBox->Location = System::Drawing::Point(12, 58);
            this->showDisplayMeshCheckBox->Name = L"showDisplayMeshCheckBox";
            this->showDisplayMeshCheckBox->Size = System::Drawing::Size(140, 17);
            this->showDisplayMeshCheckBox->TabIndex = 7;
            this->showDisplayMeshCheckBox->Text = L"Display Graphic Meshes";
            this->showDisplayMeshCheckBox->UseVisualStyleBackColor = true;
            this->showDisplayMeshCheckBox->CheckedChanged += gcnew System::EventHandler(this, &hctPreviewControl::showDisplayMeshCheckBox_CheckedChanged);
            //
            // num9Label
            //
            this->num9Label->AutoSize = true;
            this->num9Label->Location = System::Drawing::Point(149, 12);
            this->num9Label->Name = L"num9Label";
            this->num9Label->Size = System::Drawing::Size(43, 13);
            this->num9Label->TabIndex = 6;
            this->num9Label->Text = L"Gravity:";
            //
            // gravityComboBox
            //
            this->gravityComboBox->BackColor = System::Drawing::Color::White;
            this->gravityComboBox->ForeColor = System::Drawing::Color::Black;
            this->gravityComboBox->FormattingEnabled = true;
            this->gravityComboBox->Items->AddRange(gcnew cli::array< System::Object^  >(8) {
                L"FROM_FILE", L"NONE", L"+X", L"+Y", L"+Z",
                    L"-X", L"-Y", L"-Z"
            });
            this->gravityComboBox->Location = System::Drawing::Point(198, 10);
            this->gravityComboBox->Name = L"gravityComboBox";
            this->gravityComboBox->Size = System::Drawing::Size(86, 21);
            this->gravityComboBox->TabIndex = 4;
            this->gravityComboBox->SelectedIndexChanged += gcnew System::EventHandler(this, &hctPreviewControl::comboBoxGravity_SelectedIndexChanged);
            //
            // showCollShapeCheckBox
            //
            this->showCollShapeCheckBox->AutoSize = true;
            this->showCollShapeCheckBox->Location = System::Drawing::Point(12, 35);
            this->showCollShapeCheckBox->Name = L"showCollShapeCheckBox";
            this->showCollShapeCheckBox->Size = System::Drawing::Size(140, 17);
            this->showCollShapeCheckBox->TabIndex = 5;
            this->showCollShapeCheckBox->Text = L"Display Collision Shapes";
            this->showCollShapeCheckBox->UseVisualStyleBackColor = true;
            this->showCollShapeCheckBox->CheckedChanged += gcnew System::EventHandler(this, &hctPreviewControl::showCollShapeCheckBox_CheckedChanged);
            //
            // completeGroupBox
            //
            this->completeGroupBox->Controls->Add(this->ragdollMappingCombo);
            this->completeGroupBox->Controls->Add(this->ragdollMappingLabel);
            this->completeGroupBox->Location = System::Drawing::Point(11, 84);
            this->completeGroupBox->Name = L"completeGroupBox";
            this->completeGroupBox->Size = System::Drawing::Size(273, 52);
            this->completeGroupBox->TabIndex = 4;
            this->completeGroupBox->TabStop = false;
            this->completeGroupBox->Text = L"Havok Complete";
            //
            // ragdollMappingCombo
            //
            this->ragdollMappingCombo->BackColor = System::Drawing::Color::White;
            this->ragdollMappingCombo->ForeColor = System::Drawing::Color::Black;
            this->ragdollMappingCombo->FormattingEnabled = true;
            this->ragdollMappingCombo->Items->AddRange(gcnew cli::array< System::Object^  >(3) { L"None", L"Ragdoll->Animation", L"Animation->Ragdoll" });
            this->ragdollMappingCombo->Location = System::Drawing::Point(102, 19);
            this->ragdollMappingCombo->Name = L"ragdollMappingCombo";
            this->ragdollMappingCombo->Size = System::Drawing::Size(135, 21);
            this->ragdollMappingCombo->TabIndex = 2;
            this->ragdollMappingCombo->SelectedIndexChanged += gcnew System::EventHandler(this, &hctPreviewControl::ragdollMappingCombo_SelectedIndexChanged);
            //
            // ragdollMappingLabel
            //
            this->ragdollMappingLabel->AutoSize = true;
            this->ragdollMappingLabel->Location = System::Drawing::Point(6, 22);
            this->ragdollMappingLabel->Name = L"ragdollMappingLabel";
            this->ragdollMappingLabel->Size = System::Drawing::Size(90, 13);
            this->ragdollMappingLabel->TabIndex = 3;
            this->ragdollMappingLabel->Text = L"Ragdoll Mapping:";
            //
            // animTabPage
            //
            this->animTabPage->Controls->Add(this->num5GroupBox);
            this->animTabPage->Controls->Add(this->num1CheckBox);
            this->animTabPage->Controls->Add(this->accumMotionCheckBox);
            this->animTabPage->Controls->Add(this->animCheckBox);
            this->animTabPage->Location = System::Drawing::Point(4, 22);
            this->animTabPage->Name = L"animTabPage";
            this->animTabPage->Padding = System::Windows::Forms::Padding(3);
            this->animTabPage->Size = System::Drawing::Size(299, 142);
            this->animTabPage->TabIndex = 1;
            this->animTabPage->Text = L"Animation";
            this->animTabPage->UseVisualStyleBackColor = true;
            //
            // num5GroupBox
            //
            this->num5GroupBox->Controls->Add(this->thickBonesCheckBox);
            this->num5GroupBox->Controls->Add(this->floatTracksCheckBox);
            this->num5GroupBox->Controls->Add(this->num8Label);
            this->num5GroupBox->Controls->Add(this->footStepsComboBox);
            this->num5GroupBox->Controls->Add(this->displayAnnotationsCheckBox);
            this->num5GroupBox->Controls->Add(this->displayBoneNamesCheckBox);
            this->num5GroupBox->Controls->Add(this->displayMotionCheckBox);
            this->num5GroupBox->Controls->Add(this->displaySkeletonsCheckBox);
            this->num5GroupBox->Location = System::Drawing::Point(6, 35);
            this->num5GroupBox->Name = L"num5GroupBox";
            this->num5GroupBox->Size = System::Drawing::Size(264, 101);
            this->num5GroupBox->TabIndex = 7;
            this->num5GroupBox->TabStop = false;
            this->num5GroupBox->Text = L"Display";
            //
            // thickBonesCheckBox
            //
            this->thickBonesCheckBox->AutoSize = true;
            this->thickBonesCheckBox->Location = System::Drawing::Point(89, 20);
            this->thickBonesCheckBox->Name = L"thickBonesCheckBox";
            this->thickBonesCheckBox->Size = System::Drawing::Size(86, 17);
            this->thickBonesCheckBox->TabIndex = 11;
            this->thickBonesCheckBox->Text = L"Thick Bones";
            this->thickBonesCheckBox->UseVisualStyleBackColor = true;
            this->thickBonesCheckBox->CheckedChanged += gcnew System::EventHandler(this, &hctPreviewControl::thickBonesCheckBox_CheckedChanged);
            //
            // floatTracksCheckBox
            //
            this->floatTracksCheckBox->AutoSize = true;
            this->floatTracksCheckBox->Cursor = System::Windows::Forms::Cursors::Arrow;
            this->floatTracksCheckBox->Location = System::Drawing::Point(7, 79);
            this->floatTracksCheckBox->Name = L"floatTracksCheckBox";
            this->floatTracksCheckBox->Size = System::Drawing::Size(85, 17);
            this->floatTracksCheckBox->TabIndex = 10;
            this->floatTracksCheckBox->Text = L"Float Tracks";
            this->floatTracksCheckBox->UseVisualStyleBackColor = true;
            this->floatTracksCheckBox->CheckedChanged += gcnew System::EventHandler(this, &hctPreviewControl::floatTracksCheckBox_CheckedChanged);
            //
            // num8Label
            //
            this->num8Label->AutoSize = true;
            this->num8Label->Location = System::Drawing::Point(122, 53);
            this->num8Label->Name = L"num8Label";
            this->num8Label->Size = System::Drawing::Size(56, 13);
            this->num8Label->TabIndex = 9;
            this->num8Label->Text = L"Footsteps:";
            //
            // footStepsComboBox
            //
            this->footStepsComboBox->BackColor = System::Drawing::Color::White;
            this->footStepsComboBox->ForeColor = System::Drawing::Color::Black;
            this->footStepsComboBox->FormattingEnabled = true;
            this->footStepsComboBox->Items->AddRange(gcnew cli::array< System::Object^  >(7) {
                L"NONE", L"STRIKEPOS ", L"LOCKPOS ", L"STRIKEVEL ",
                    L"LOCKVEL ", L"STRIKE ", L"LOCK"
            });
            this->footStepsComboBox->Location = System::Drawing::Point(124, 68);
            this->footStepsComboBox->Name = L"footStepsComboBox";
            this->footStepsComboBox->Size = System::Drawing::Size(117, 21);
            this->footStepsComboBox->TabIndex = 8;
            this->footStepsComboBox->SelectedIndexChanged += gcnew System::EventHandler(this, &hctPreviewControl::footStepsComboBox_SelectedIndexChanged);
            //
            // displayAnnotationsCheckBox
            //
            this->displayAnnotationsCheckBox->AutoSize = true;
            this->displayAnnotationsCheckBox->Cursor = System::Windows::Forms::Cursors::Arrow;
            this->displayAnnotationsCheckBox->Location = System::Drawing::Point(7, 64);
            this->displayAnnotationsCheckBox->Name = L"displayAnnotationsCheckBox";
            this->displayAnnotationsCheckBox->Size = System::Drawing::Size(82, 17);
            this->displayAnnotationsCheckBox->TabIndex = 6;
            this->displayAnnotationsCheckBox->Text = L"Annotations";
            this->displayAnnotationsCheckBox->UseVisualStyleBackColor = true;
            this->displayAnnotationsCheckBox->CheckedChanged += gcnew System::EventHandler(this, &hctPreviewControl::displayAnnotationsCheckBox_CheckedChanged);
            //
            // displayBoneNamesCheckBox
            //
            this->displayBoneNamesCheckBox->AutoSize = true;
            this->displayBoneNamesCheckBox->Cursor = System::Windows::Forms::Cursors::Arrow;
            this->displayBoneNamesCheckBox->Location = System::Drawing::Point(7, 49);
            this->displayBoneNamesCheckBox->Name = L"displayBoneNamesCheckBox";
            this->displayBoneNamesCheckBox->Size = System::Drawing::Size(87, 17);
            this->displayBoneNamesCheckBox->TabIndex = 5;
            this->displayBoneNamesCheckBox->Text = L"Bone Names";
            this->displayBoneNamesCheckBox->UseVisualStyleBackColor = true;
            this->displayBoneNamesCheckBox->CheckedChanged += gcnew System::EventHandler(this, &hctPreviewControl::displayBoneNamesCheckBox_CheckedChanged);
            //
            // displayMotionCheckBox
            //
            this->displayMotionCheckBox->AutoSize = true;
            this->displayMotionCheckBox->Cursor = System::Windows::Forms::Cursors::Arrow;
            this->displayMotionCheckBox->Location = System::Drawing::Point(7, 34);
            this->displayMotionCheckBox->Name = L"displayMotionCheckBox";
            this->displayMotionCheckBox->Size = System::Drawing::Size(58, 17);
            this->displayMotionCheckBox->TabIndex = 7;
            this->displayMotionCheckBox->Text = L"Motion";
            this->displayMotionCheckBox->UseVisualStyleBackColor = true;
            this->displayMotionCheckBox->CheckedChanged += gcnew System::EventHandler(this, &hctPreviewControl::displayMotionCheckBox_CheckedChanged);
            //
            // displaySkeletonsCheckBox
            //
            this->displaySkeletonsCheckBox->AutoSize = true;
            this->displaySkeletonsCheckBox->Location = System::Drawing::Point(7, 19);
            this->displaySkeletonsCheckBox->Name = L"displaySkeletonsCheckBox";
            this->displaySkeletonsCheckBox->Size = System::Drawing::Size(85, 17);
            this->displaySkeletonsCheckBox->TabIndex = 4;
            this->displaySkeletonsCheckBox->Text = L"Skeletons ->";
            this->displaySkeletonsCheckBox->UseVisualStyleBackColor = true;
            this->displaySkeletonsCheckBox->CheckedChanged += gcnew System::EventHandler(this, &hctPreviewControl::displaySkeletonsCheckBox_CheckedChanged);
            //
            // num1CheckBox
            //
            this->num1CheckBox->AutoSize = true;
            this->num1CheckBox->Location = System::Drawing::Point(33, 113);
            this->num1CheckBox->Name = L"num1CheckBox";
            this->num1CheckBox->Size = System::Drawing::Size(110, 17);
            this->num1CheckBox->TabIndex = 6;
            this->num1CheckBox->Text = L"Display Skeletons";
            this->num1CheckBox->UseVisualStyleBackColor = true;
            //
            // clothTabPage
            //
            this->clothTabPage->Controls->Add(this->clothDisplayNonClothMeshesCheckBox);
            this->clothTabPage->Controls->Add(this->debugDisplayButton);
            this->clothTabPage->Controls->Add(this->clothCollidableControlButton);
            this->clothTabPage->Controls->Add(this->clothMultithreadCheckBox);
            this->clothTabPage->Controls->Add(this->clothTransitionsButton);
            this->clothTabPage->Controls->Add(this->clothWindControlButton);
            this->clothTabPage->Controls->Add(this->clothCheckBox);
            this->clothTabPage->Location = System::Drawing::Point(4, 22);
            this->clothTabPage->Name = L"clothTabPage";
            this->clothTabPage->Padding = System::Windows::Forms::Padding(3);
            this->clothTabPage->Size = System::Drawing::Size(299, 142);
            this->clothTabPage->TabIndex = 2;
            this->clothTabPage->Text = L"Cloth";
            this->clothTabPage->UseVisualStyleBackColor = true;
            //
            // debugDisplayButton
            //
            this->debugDisplayButton->Location = System::Drawing::Point(20, 80);
            this->debugDisplayButton->Name = L"debugDisplayButton";
            this->debugDisplayButton->Size = System::Drawing::Size(107, 23);
            this->debugDisplayButton->TabIndex = 16;
            this->debugDisplayButton->Text = L"Debug Display";
            this->debugDisplayButton->UseVisualStyleBackColor = true;
            this->debugDisplayButton->Click += gcnew System::EventHandler(this, &hctPreviewControl::clothDebugDisplayButton_Click);
            //
            // clothCollidableControlButton
            //
            this->clothCollidableControlButton->Location = System::Drawing::Point(20, 109);
            this->clothCollidableControlButton->Name = L"clothCollidableControlButton";
            this->clothCollidableControlButton->Size = System::Drawing::Size(107, 24);
            this->clothCollidableControlButton->TabIndex = 15;
            this->clothCollidableControlButton->Text = L"Collision Options";
            this->clothCollidableControlButton->UseVisualStyleBackColor = true;
            this->clothCollidableControlButton->Click += gcnew System::EventHandler(this, &hctPreviewControl::clothCollidableControlButton_Click);
            //
            // clothMultithreadCheckBox
            //
            this->clothMultithreadCheckBox->AutoSize = true;
            this->clothMultithreadCheckBox->Location = System::Drawing::Point(12, 32);
            this->clothMultithreadCheckBox->Name = L"clothMultithreadCheckBox";
            this->clothMultithreadCheckBox->Size = System::Drawing::Size(128, 17);
            this->clothMultithreadCheckBox->TabIndex = 11;
            this->clothMultithreadCheckBox->Text = L"Enable Multithreading";
            this->clothMultithreadCheckBox->UseVisualStyleBackColor = true;
            this->clothMultithreadCheckBox->CheckedChanged += gcnew System::EventHandler(this, &hctPreviewControl::clothMultithreadCheckBox_CheckedChanged);
            //
            // clothTransitionsButton
            //
            this->clothTransitionsButton->Location = System::Drawing::Point(166, 80);
            this->clothTransitionsButton->Name = L"clothTransitionsButton";
            this->clothTransitionsButton->Size = System::Drawing::Size(107, 23);
            this->clothTransitionsButton->TabIndex = 13;
            this->clothTransitionsButton->Text = L"Runtime Control";
            this->clothTransitionsButton->UseVisualStyleBackColor = true;
            this->clothTransitionsButton->Click += gcnew System::EventHandler(this, &hctPreviewControl::clothTransitionsButton_Click);
            //
            // clothWindControlButton
            //
            this->clothWindControlButton->Location = System::Drawing::Point(166, 109);
            this->clothWindControlButton->Name = L"clothWindControlButton";
            this->clothWindControlButton->Size = System::Drawing::Size(107, 24);
            this->clothWindControlButton->TabIndex = 14;
            this->clothWindControlButton->Text = L"Wind Control";
            this->clothWindControlButton->UseVisualStyleBackColor = true;
            this->clothWindControlButton->Click += gcnew System::EventHandler(this, &hctPreviewControl::clothWindControlButton_Click);
            //
            // clothCheckBox
            //
            this->clothCheckBox->AutoSize = true;
            this->clothCheckBox->Checked = true;
            this->clothCheckBox->CheckState = System::Windows::Forms::CheckState::Checked;
            this->clothCheckBox->Location = System::Drawing::Point(12, 12);
            this->clothCheckBox->Name = L"clothCheckBox";
            this->clothCheckBox->Size = System::Drawing::Size(73, 17);
            this->clothCheckBox->TabIndex = 10;
            this->clothCheckBox->Text = L"Run Cloth";
            this->clothCheckBox->UseVisualStyleBackColor = true;
            this->clothCheckBox->CheckedChanged += gcnew System::EventHandler(this, &hctPreviewControl::clothCheckBox_CheckedChanged);
            //
            // destructionTabPage
            //
            this->destructionTabPage->Controls->Add(this->showBbCheckbox);
            this->destructionTabPage->Controls->Add(this->destructionResetButton);
            this->destructionTabPage->Controls->Add(this->num7Label);
            this->destructionTabPage->Controls->Add(this->destructionAdditionalTexSearchPathTextBox);
            this->destructionTabPage->Controls->Add(this->destructionGraphicsShapeNamesCheckBox);
            this->destructionTabPage->Controls->Add(this->destructionExplodedStateCheckBox);
            this->destructionTabPage->Location = System::Drawing::Point(4, 22);
            this->destructionTabPage->Name = L"destructionTabPage";
            this->destructionTabPage->Padding = System::Windows::Forms::Padding(3);
            this->destructionTabPage->Size = System::Drawing::Size(299, 142);
            this->destructionTabPage->TabIndex = 4;
            this->destructionTabPage->Text = L"Destruction";
            this->destructionTabPage->UseVisualStyleBackColor = true;
            //
            // showBbCheckbox
            //
            this->showBbCheckbox->AutoSize = true;
            this->showBbCheckbox->Location = System::Drawing::Point(8, 52);
            this->showBbCheckbox->Name = L"showBbCheckbox";
            this->showBbCheckbox->Size = System::Drawing::Size(138, 17);
            this->showBbCheckbox->TabIndex = 7;
            this->showBbCheckbox->Text = L"Display bounding boxes";
            this->showBbCheckbox->UseVisualStyleBackColor = true;
            this->showBbCheckbox->Visible = false;
            this->showBbCheckbox->CheckedChanged += gcnew System::EventHandler(this, &hctPreviewControl::showBbCheckbox_CheckedChanged);
            //
            // destructionResetButton
            //
            this->destructionResetButton->AutoSize = true;
            this->destructionResetButton->AutoSizeMode = System::Windows::Forms::AutoSizeMode::GrowAndShrink;
            this->destructionResetButton->Location = System::Drawing::Point(8, 74);
            this->destructionResetButton->Name = L"destructionResetButton";
            this->destructionResetButton->Size = System::Drawing::Size(45, 23);
            this->destructionResetButton->TabIndex = 6;
            this->destructionResetButton->Text = L"Reset";
            this->destructionResetButton->UseVisualStyleBackColor = true;
            this->destructionResetButton->Click += gcnew System::EventHandler(this, &hctPreviewControl::destructionResetButton_Click);
            //
            // num7Label
            //
            this->num7Label->AutoSize = true;
            this->num7Label->Location = System::Drawing::Point(7, 100);
            this->num7Label->Name = L"num7Label";
            this->num7Label->Size = System::Drawing::Size(154, 13);
            this->num7Label->TabIndex = 5;
            this->num7Label->Text = L"Additional Texture Search Path";
            //
            // destructionAdditionalTexSearchPathTextBox
            //
            this->destructionAdditionalTexSearchPathTextBox->Location = System::Drawing::Point(8, 116);
            this->destructionAdditionalTexSearchPathTextBox->Name = L"destructionAdditionalTexSearchPathTextBox";
            this->destructionAdditionalTexSearchPathTextBox->Size = System::Drawing::Size(287, 20);
            this->destructionAdditionalTexSearchPathTextBox->TabIndex = 4;
            this->destructionAdditionalTexSearchPathTextBox->WordWrap = false;
            this->destructionAdditionalTexSearchPathTextBox->TextChanged += gcnew System::EventHandler(this, &hctPreviewControl::textBoxDestructionAdditionalTexSearchPath_TextChanged);
            //
            // destructionGraphicsShapeNamesCheckBox
            //
            this->destructionGraphicsShapeNamesCheckBox->AutoSize = true;
            this->destructionGraphicsShapeNamesCheckBox->Location = System::Drawing::Point(8, 29);
            this->destructionGraphicsShapeNamesCheckBox->Name = L"destructionGraphicsShapeNamesCheckBox";
            this->destructionGraphicsShapeNamesCheckBox->Size = System::Drawing::Size(138, 17);
            this->destructionGraphicsShapeNamesCheckBox->TabIndex = 3;
            this->destructionGraphicsShapeNamesCheckBox->Text = L"Graphics Shape Names";
            this->destructionGraphicsShapeNamesCheckBox->UseVisualStyleBackColor = true;
            this->destructionGraphicsShapeNamesCheckBox->CheckedChanged += gcnew System::EventHandler(this, &hctPreviewControl::checkBoxDestructionGraphicsShapeNames_CheckedChanged);
            //
            // destructionExplodedStateCheckBox
            //
            this->destructionExplodedStateCheckBox->AutoSize = true;
            this->destructionExplodedStateCheckBox->Location = System::Drawing::Point(8, 6);
            this->destructionExplodedStateCheckBox->Name = L"destructionExplodedStateCheckBox";
            this->destructionExplodedStateCheckBox->Size = System::Drawing::Size(96, 17);
            this->destructionExplodedStateCheckBox->TabIndex = 2;
            this->destructionExplodedStateCheckBox->Text = L"Exploded View";
            this->destructionExplodedStateCheckBox->UseVisualStyleBackColor = true;
            this->destructionExplodedStateCheckBox->CheckedChanged += gcnew System::EventHandler(this, &hctPreviewControl::checkBoxDestructionExplodedState_CheckedChanged);
            //
            // displayTabPage
            //
            this->displayTabPage->Controls->Add(this->adjustEffectsButton);
            this->displayTabPage->Controls->Add(this->postEffectsButton);
            this->displayTabPage->Controls->Add(this->num1GroupBox);
            this->displayTabPage->Controls->Add(this->chooseRendererButton);
            this->displayTabPage->Controls->Add(this->rendererLabel);
            this->displayTabPage->Controls->Add(this->displayObjectNameLabel);
            this->displayTabPage->Controls->Add(this->num2Label);
            this->displayTabPage->Location = System::Drawing::Point(4, 22);
            this->displayTabPage->Name = L"displayTabPage";
            this->displayTabPage->Size = System::Drawing::Size(299, 142);
            this->displayTabPage->TabIndex = 3;
            this->displayTabPage->Text = L"Display";
            this->displayTabPage->UseVisualStyleBackColor = true;
            //
            // adjustEffectsButton
            //
            this->adjustEffectsButton->Location = System::Drawing::Point(201, 98);
            this->adjustEffectsButton->Name = L"adjustEffectsButton";
            this->adjustEffectsButton->Size = System::Drawing::Size(89, 20);
            this->adjustEffectsButton->TabIndex = 13;
            this->adjustEffectsButton->Text = L"Adjust Effects..";
            this->adjustEffectsButton->UseVisualStyleBackColor = true;
            this->adjustEffectsButton->Click += gcnew System::EventHandler(this, &hctPreviewControl::adjustEffectsButton_Click);
            //
            // postEffectsButton
            //
            this->postEffectsButton->Location = System::Drawing::Point(106, 98);
            this->postEffectsButton->Name = L"postEffectsButton";
            this->postEffectsButton->Size = System::Drawing::Size(89, 20);
            this->postEffectsButton->TabIndex = 12;
            this->postEffectsButton->Text = L"Add Effects..";
            this->postEffectsButton->UseVisualStyleBackColor = true;
            this->postEffectsButton->Click += gcnew System::EventHandler(this, &hctPreviewControl::postEffectsButton_Click);
            //
            // num1GroupBox
            //
            this->num1GroupBox->Controls->Add(this->showBoundingBoxCheckbox);
            this->num1GroupBox->Controls->Add(this->shadowRecvCheckBox);
            this->num1GroupBox->Controls->Add(this->litCheckBox);
            this->num1GroupBox->Controls->Add(this->shadowCasterCheckBox);
            this->num1GroupBox->Location = System::Drawing::Point(18, 19);
            this->num1GroupBox->Name = L"num1GroupBox";
            this->num1GroupBox->Size = System::Drawing::Size(267, 75);
            this->num1GroupBox->TabIndex = 11;
            this->num1GroupBox->TabStop = false;
            //
            // showBoundingBoxCheckbox
            //
            this->showBoundingBoxCheckbox->AutoSize = true;
            this->showBoundingBoxCheckbox->Checked = true;
            this->showBoundingBoxCheckbox->CheckState = System::Windows::Forms::CheckState::Checked;
            this->showBoundingBoxCheckbox->Location = System::Drawing::Point(130, 13);
            this->showBoundingBoxCheckbox->Name = L"showBoundingBoxCheckbox";
            this->showBoundingBoxCheckbox->Size = System::Drawing::Size(92, 17);
            this->showBoundingBoxCheckbox->TabIndex = 14;
            this->showBoundingBoxCheckbox->Text = L"Bounding Box";
            this->showBoundingBoxCheckbox->UseVisualStyleBackColor = true;
            this->showBoundingBoxCheckbox->CheckedChanged += gcnew System::EventHandler(this, &hctPreviewControl::showBoundingBoxCheckbox_CheckedChanged);
            //
            // shadowRecvCheckBox
            //
            this->shadowRecvCheckBox->AutoSize = true;
            this->shadowRecvCheckBox->Location = System::Drawing::Point(10, 53);
            this->shadowRecvCheckBox->Name = L"shadowRecvCheckBox";
            this->shadowRecvCheckBox->Size = System::Drawing::Size(99, 17);
            this->shadowRecvCheckBox->TabIndex = 13;
            this->shadowRecvCheckBox->Text = L"Recv Shadows";
            this->shadowRecvCheckBox->UseVisualStyleBackColor = true;
            this->shadowRecvCheckBox->CheckedChanged += gcnew System::EventHandler(this, &hctPreviewControl::shadowRecvCheckBox_CheckedChanged);
            //
            // litCheckBox
            //
            this->litCheckBox->AutoSize = true;
            this->litCheckBox->Location = System::Drawing::Point(10, 13);
            this->litCheckBox->Name = L"litCheckBox";
            this->litCheckBox->Size = System::Drawing::Size(37, 17);
            this->litCheckBox->TabIndex = 12;
            this->litCheckBox->Text = L"Lit";
            this->litCheckBox->UseVisualStyleBackColor = true;
            this->litCheckBox->CheckedChanged += gcnew System::EventHandler(this, &hctPreviewControl::litCheckBox_CheckedChanged);
            //
            // shadowCasterCheckBox
            //
            this->shadowCasterCheckBox->AutoSize = true;
            this->shadowCasterCheckBox->Location = System::Drawing::Point(10, 33);
            this->shadowCasterCheckBox->Name = L"shadowCasterCheckBox";
            this->shadowCasterCheckBox->Size = System::Drawing::Size(94, 17);
            this->shadowCasterCheckBox->TabIndex = 11;
            this->shadowCasterCheckBox->Text = L"Cast Shadows";
            this->shadowCasterCheckBox->UseVisualStyleBackColor = true;
            this->shadowCasterCheckBox->CheckedChanged += gcnew System::EventHandler(this, &hctPreviewControl::shadowCasterCheckBox_CheckedChanged);
            //
            // chooseRendererButton
            //
            this->chooseRendererButton->Location = System::Drawing::Point(11, 98);
            this->chooseRendererButton->Name = L"chooseRendererButton";
            this->chooseRendererButton->Size = System::Drawing::Size(89, 20);
            this->chooseRendererButton->TabIndex = 6;
            this->chooseRendererButton->Text = L"Renderer..";
            this->chooseRendererButton->UseVisualStyleBackColor = true;
            this->chooseRendererButton->Click += gcnew System::EventHandler(this, &hctPreviewControl::chooseRendererButton_Click);
            //
            // rendererLabel
            //
            this->rendererLabel->AutoSize = true;
            this->rendererLabel->FlatStyle = System::Windows::Forms::FlatStyle::Popup;
            this->rendererLabel->Location = System::Drawing::Point(8, 121);
            this->rendererLabel->Name = L"rendererLabel";
            this->rendererLabel->Size = System::Drawing::Size(63, 13);
            this->rendererLabel->TabIndex = 5;
            this->rendererLabel->Text = L"<unknown>";
            this->rendererLabel->Click += gcnew System::EventHandler(this, &hctPreviewControl::rendererLabel_Click);
            //
            // displayObjectNameLabel
            //
            this->displayObjectNameLabel->AutoSize = true;
            this->displayObjectNameLabel->Location = System::Drawing::Point(114, 7);
            this->displayObjectNameLabel->Name = L"displayObjectNameLabel";
            this->displayObjectNameLabel->Size = System::Drawing::Size(43, 13);
            this->displayObjectNameLabel->TabIndex = 1;
            this->displayObjectNameLabel->Text = L"<none>";
            //
            // num2Label
            //
            this->num2Label->AutoSize = true;
            this->num2Label->Location = System::Drawing::Point(5, 7);
            this->num2Label->Name = L"num2Label";
            this->num2Label->Size = System::Drawing::Size(109, 13);
            this->num2Label->TabIndex = 0;
            this->num2Label->Text = L"Display Object Name:";
            //
            // num1Label
            //
            this->num1Label->AutoSize = true;
            this->num1Label->Location = System::Drawing::Point(5, 508);
            this->num1Label->Name = L"num1Label";
            this->num1Label->Size = System::Drawing::Size(75, 13);
            this->num1Label->TabIndex = 5;
            this->num1Label->Text = L"Current Assets";
            //
            // playPauseButton
            //
            this->playPauseButton->ImageIndex = 1;
            this->playPauseButton->ImageList = this->playButtonImageList;
            this->playPauseButton->Location = System::Drawing::Point(51, 18);
            this->playPauseButton->Name = L"playPauseButton";
            this->playPauseButton->Size = System::Drawing::Size(36, 26);
            this->playPauseButton->TabIndex = 6;
            this->playPauseButton->Text = L"    ";
            this->playPauseButton->UseVisualStyleBackColor = true;
            this->playPauseButton->Click += gcnew System::EventHandler(this, &hctPreviewControl::playPauseButton_Click);
            //
            // playButtonImageList
            //
            this->playButtonImageList->ImageStream = (cli::safe_cast<System::Windows::Forms::ImageListStreamer^>(resources->GetObject(L"playButtonImageList.ImageStream")));
            this->playButtonImageList->TransparentColor = System::Drawing::Color::Transparent;
            this->playButtonImageList->Images->SetKeyName(0, L"playButton.png");
            this->playButtonImageList->Images->SetKeyName(1, L"pauseButton.png");
            this->playButtonImageList->Images->SetKeyName(2, L"stopButton.png");
            this->playButtonImageList->Images->SetKeyName(3, L"restartButton.png");
            this->playButtonImageList->Images->SetKeyName(4, L"singleStepButton.png");
            //
            // restartButton
            //
            this->restartButton->ImageIndex = 3;
            this->restartButton->ImageList = this->playButtonImageList;
            this->restartButton->Location = System::Drawing::Point(12, 18);
            this->restartButton->Name = L"restartButton";
            this->restartButton->Size = System::Drawing::Size(36, 26);
            this->restartButton->TabIndex = 8;
            this->restartButton->UseVisualStyleBackColor = true;
            this->restartButton->Click += gcnew System::EventHandler(this, &hctPreviewControl::restartButton_Click);
            //
            // num2GroupBox
            //
            this->num2GroupBox->BackColor = System::Drawing::Color::Transparent;
            this->num2GroupBox->Controls->Add(this->num6Label);
            this->num2GroupBox->Controls->Add(this->playSpeedNumericUpDown);
            this->num2GroupBox->Controls->Add(this->num4Label);
            this->num2GroupBox->Controls->Add(this->playSpeedTrackBar);
            this->num2GroupBox->Controls->Add(this->singleStepButton);
            this->num2GroupBox->Controls->Add(this->restartButton);
            this->num2GroupBox->Controls->Add(this->playPauseButton);
            this->num2GroupBox->Location = System::Drawing::Point(7, 173);
            this->num2GroupBox->Name = L"num2GroupBox";
            this->num2GroupBox->Size = System::Drawing::Size(138, 106);
            this->num2GroupBox->TabIndex = 9;
            this->num2GroupBox->TabStop = false;
            this->num2GroupBox->Text = L"Playback";
            //
            // num6Label
            //
            this->num6Label->AutoSize = true;
            this->num6Label->Location = System::Drawing::Point(11, 78);
            this->num6Label->Name = L"num6Label";
            this->num6Label->Size = System::Drawing::Size(38, 13);
            this->num6Label->TabIndex = 18;
            this->num6Label->Text = L"Speed";
            //
            // playSpeedNumericUpDown
            //
            this->playSpeedNumericUpDown->Location = System::Drawing::Point(51, 76);
            this->playSpeedNumericUpDown->Maximum = System::Decimal(gcnew cli::array< System::Int32 >(4) { 400, 0, 0, 0 });
            this->playSpeedNumericUpDown->Minimum = System::Decimal(gcnew cli::array< System::Int32 >(4) { 20, 0, 0, 0 });
            this->playSpeedNumericUpDown->Name = L"playSpeedNumericUpDown";
            this->playSpeedNumericUpDown->Size = System::Drawing::Size(57, 20);
            this->playSpeedNumericUpDown->TabIndex = 16;
            this->playSpeedNumericUpDown->Value = System::Decimal(gcnew cli::array< System::Int32 >(4) { 100, 0, 0, 0 });
            this->playSpeedNumericUpDown->ValueChanged += gcnew System::EventHandler(this, &hctPreviewControl::playSpeedNumericUpDown_ValueChanged);
            //
            // num4Label
            //
            this->num4Label->AutoSize = true;
            this->num4Label->Location = System::Drawing::Point(114, 78);
            this->num4Label->Name = L"num4Label";
            this->num4Label->Size = System::Drawing::Size(15, 13);
            this->num4Label->TabIndex = 17;
            this->num4Label->Text = L"%";
            //
            // playSpeedTrackBar
            //
            this->playSpeedTrackBar->BackColor = System::Drawing::SystemColors::Control;
            this->playSpeedTrackBar->LargeChange = 20;
            this->playSpeedTrackBar->Location = System::Drawing::Point(11, 46);
            this->playSpeedTrackBar->Maximum = 400;
            this->playSpeedTrackBar->Minimum = 20;
            this->playSpeedTrackBar->Name = L"playSpeedTrackBar";
            this->playSpeedTrackBar->Size = System::Drawing::Size(120, 45);
            this->playSpeedTrackBar->TabIndex = 16;
            this->playSpeedTrackBar->TickFrequency = 20;
            this->playSpeedTrackBar->TickStyle = System::Windows::Forms::TickStyle::None;
            this->playSpeedTrackBar->Value = 100;
            this->playSpeedTrackBar->Scroll += gcnew System::EventHandler(this, &hctPreviewControl::playSpeedTrackBar_Scroll);
            //
            // singleStepButton
            //
            this->singleStepButton->ImageIndex = 4;
            this->singleStepButton->ImageList = this->playButtonImageList;
            this->singleStepButton->Location = System::Drawing::Point(90, 18);
            this->singleStepButton->Name = L"singleStepButton";
            this->singleStepButton->Size = System::Drawing::Size(36, 26);
            this->singleStepButton->TabIndex = 12;
            this->singleStepButton->UseVisualStyleBackColor = true;
            this->singleStepButton->Click += gcnew System::EventHandler(this, &hctPreviewControl::singleStepButton_Click);
            //
            // dragDropContextMenuStrip
            //
            this->dragDropContextMenuStrip->Items->AddRange(gcnew cli::array< System::Windows::Forms::ToolStripItem^  >(7) {
                this->addWrtAssetMenuItem,
                    this->replaceThisAssetMenuItem, this->num1ToolStripSeparator, this->addToSceneMenuItem, this->replaceSceneMenuItem, this->num2ToolStripSeparator,
                    this->cancelDragDropToolStripMenuItem
            });
            this->dragDropContextMenuStrip->Name = L"sceneViewMenuStrip";
            this->dragDropContextMenuStrip->Size = System::Drawing::Size(187, 126);
            //
            // addWrtAssetMenuItem
            //
            this->addWrtAssetMenuItem->Name = L"addWrtAssetMenuItem";
            this->addWrtAssetMenuItem->Size = System::Drawing::Size(186, 22);
            this->addWrtAssetMenuItem->Text = L"&Add for this Asset";
            this->addWrtAssetMenuItem->Click += gcnew System::EventHandler(this, &hctPreviewControl::addWrtAssetMenuItem_Click);
            //
            // replaceThisAssetMenuItem
            //
            this->replaceThisAssetMenuItem->Name = L"replaceThisAssetMenuItem";
            this->replaceThisAssetMenuItem->Size = System::Drawing::Size(186, 22);
            this->replaceThisAssetMenuItem->Text = L"&Replace this Asset";
            this->replaceThisAssetMenuItem->Click += gcnew System::EventHandler(this, &hctPreviewControl::replaceThisAssetToolStripMenuItem_Click);
            //
            // num1ToolStripSeparator
            //
            this->num1ToolStripSeparator->Name = L"num1ToolStripSeparator";
            this->num1ToolStripSeparator->Size = System::Drawing::Size(183, 6);
            //
            // addToSceneMenuItem
            //
            this->addToSceneMenuItem->Name = L"addToSceneMenuItem";
            this->addToSceneMenuItem->Size = System::Drawing::Size(186, 22);
            this->addToSceneMenuItem->Text = L"Just Add to &Scene";
            this->addToSceneMenuItem->Click += gcnew System::EventHandler(this, &hctPreviewControl::addToSceneMenuItem_Click);
            //
            // replaceSceneMenuItem
            //
            this->replaceSceneMenuItem->Name = L"replaceSceneMenuItem";
            this->replaceSceneMenuItem->Size = System::Drawing::Size(186, 22);
            this->replaceSceneMenuItem->Text = L"Re&place Whole Scene";
            this->replaceSceneMenuItem->Click += gcnew System::EventHandler(this, &hctPreviewControl::replaceSceneMenuItem_Click);
            //
            // num2ToolStripSeparator
            //
            this->num2ToolStripSeparator->Name = L"num2ToolStripSeparator";
            this->num2ToolStripSeparator->Size = System::Drawing::Size(183, 6);
            //
            // cancelDragDropToolStripMenuItem
            //
            this->cancelDragDropToolStripMenuItem->Name = L"cancelDragDropToolStripMenuItem";
            this->cancelDragDropToolStripMenuItem->Size = System::Drawing::Size(186, 22);
            this->cancelDragDropToolStripMenuItem->Text = L"&Cancel";
            this->cancelDragDropToolStripMenuItem->Click += gcnew System::EventHandler(this, &hctPreviewControl::cancelDragDropToolStripMenuItem_Click);
            //
            // stepSizeNumericUpDowm
            //
            this->stepSizeNumericUpDowm->Location = System::Drawing::Point(10, 21);
            this->stepSizeNumericUpDowm->Maximum = System::Decimal(gcnew cli::array< System::Int32 >(4) { 300, 0, 0, 0 });
            this->stepSizeNumericUpDowm->Minimum = System::Decimal(gcnew cli::array< System::Int32 >(4) { 1, 0, 0, 0 });
            this->stepSizeNumericUpDowm->Name = L"stepSizeNumericUpDowm";
            this->stepSizeNumericUpDowm->Size = System::Drawing::Size(49, 20);
            this->stepSizeNumericUpDowm->TabIndex = 9;
            this->stepSizeNumericUpDowm->Value = System::Decimal(gcnew cli::array< System::Int32 >(4) { 60, 0, 0, 0 });
            this->stepSizeNumericUpDowm->ValueChanged += gcnew System::EventHandler(this, &hctPreviewControl::stepSizeNumericUpDowm_ValueChanged);
            //
            // num5Label
            //
            this->num5Label->AutoSize = true;
            this->num5Label->Location = System::Drawing::Point(58, 25);
            this->num5Label->Name = L"num5Label";
            this->num5Label->Size = System::Drawing::Size(20, 13);
            this->num5Label->TabIndex = 11;
            this->num5Label->Text = L"Hz";
            //
            // stepSizeHalfButton
            //
            this->stepSizeHalfButton->Location = System::Drawing::Point(78, 18);
            this->stepSizeHalfButton->Name = L"stepSizeHalfButton";
            this->stepSizeHalfButton->Size = System::Drawing::Size(32, 26);
            this->stepSizeHalfButton->TabIndex = 13;
            this->stepSizeHalfButton->Text = L"/2";
            this->stepSizeHalfButton->UseVisualStyleBackColor = true;
            this->stepSizeHalfButton->Click += gcnew System::EventHandler(this, &hctPreviewControl::stepSizeHalfButton_Click);
            //
            // stepSizeGroupBox
            //
            this->stepSizeGroupBox->BackColor = System::Drawing::Color::Transparent;
            this->stepSizeGroupBox->Controls->Add(this->realtimeCheckBox);
            this->stepSizeGroupBox->Controls->Add(this->stepSizeDoubleButton);
            this->stepSizeGroupBox->Controls->Add(this->stepSizeHalfButton);
            this->stepSizeGroupBox->Controls->Add(this->stepSizeNumericUpDowm);
            this->stepSizeGroupBox->Controls->Add(this->num5Label);
            this->stepSizeGroupBox->Location = System::Drawing::Point(154, 173);
            this->stepSizeGroupBox->Name = L"stepSizeGroupBox";
            this->stepSizeGroupBox->Size = System::Drawing::Size(152, 67);
            this->stepSizeGroupBox->TabIndex = 14;
            this->stepSizeGroupBox->TabStop = false;
            this->stepSizeGroupBox->Text = L"Step Size";
            //
            // realtimeCheckBox
            //
            this->realtimeCheckBox->AutoSize = true;
            this->realtimeCheckBox->Checked = true;
            this->realtimeCheckBox->CheckState = System::Windows::Forms::CheckState::Checked;
            this->realtimeCheckBox->Location = System::Drawing::Point(10, 44);
            this->realtimeCheckBox->Name = L"realtimeCheckBox";
            this->realtimeCheckBox->Size = System::Drawing::Size(67, 17);
            this->realtimeCheckBox->TabIndex = 15;
            this->realtimeCheckBox->Text = L"Realtime";
            this->realtimeCheckBox->UseVisualStyleBackColor = true;
            this->realtimeCheckBox->CheckedChanged += gcnew System::EventHandler(this, &hctPreviewControl::realtimeCheckBox_CheckedChanged);
            //
            // stepSizeDoubleButton
            //
            this->stepSizeDoubleButton->Location = System::Drawing::Point(112, 18);
            this->stepSizeDoubleButton->Name = L"stepSizeDoubleButton";
            this->stepSizeDoubleButton->Size = System::Drawing::Size(32, 26);
            this->stepSizeDoubleButton->TabIndex = 14;
            this->stepSizeDoubleButton->Text = L"*2";
            this->stepSizeDoubleButton->UseVisualStyleBackColor = true;
            this->stepSizeDoubleButton->Click += gcnew System::EventHandler(this, &hctPreviewControl::stepSizeDoubleButton_Click);
            //
            // animFrameTrackBar
            //
            this->animFrameTrackBar->BackColor = System::Drawing::SystemColors::Control;
            this->animFrameTrackBar->LargeChange = 10;
            this->animFrameTrackBar->Location = System::Drawing::Point(159, 255);
            this->animFrameTrackBar->Maximum = 100;
            this->animFrameTrackBar->Name = L"animFrameTrackBar";
            this->animFrameTrackBar->Size = System::Drawing::Size(143, 45);
            this->animFrameTrackBar->TabIndex = 19;
            this->animFrameTrackBar->TickFrequency = 10;
            this->animFrameTrackBar->Scroll += gcnew System::EventHandler(this, &hctPreviewControl::animFrameTrackBar_Scroll);
            //
            // animFrameLabel
            //
            this->animFrameLabel->AutoSize = true;
            this->animFrameLabel->Location = System::Drawing::Point(162, 243);
            this->animFrameLabel->Name = L"animFrameLabel";
            this->animFrameLabel->Size = System::Drawing::Size(113, 13);
            this->animFrameLabel->TabIndex = 20;
            this->animFrameLabel->Text = L"Anim Frame (1st anim):";
            //
            // plusFrameButton
            //
            this->plusFrameButton->Location = System::Drawing::Point(297, 254);
            this->plusFrameButton->Name = L"plusFrameButton";
            this->plusFrameButton->Size = System::Drawing::Size(15, 28);
            this->plusFrameButton->TabIndex = 21;
            this->plusFrameButton->Text = L"+";
            this->plusFrameButton->UseVisualStyleBackColor = true;
            this->plusFrameButton->Click += gcnew System::EventHandler(this, &hctPreviewControl::plusFrameButton_Click);
            //
            // minusFrameButton
            //
            this->minusFrameButton->Location = System::Drawing::Point(149, 254);
            this->minusFrameButton->Name = L"minusFrameButton";
            this->minusFrameButton->Size = System::Drawing::Size(15, 28);
            this->minusFrameButton->TabIndex = 22;
            this->minusFrameButton->Text = L"-";
            this->minusFrameButton->UseVisualStyleBackColor = true;
            this->minusFrameButton->Click += gcnew System::EventHandler(this, &hctPreviewControl::minusFrameButton_Click);
            //
            // labelAnimFrame
            //
            this->labelAnimFrame->AutoSize = true;
            this->labelAnimFrame->Location = System::Drawing::Point(271, 243);
            this->labelAnimFrame->Name = L"labelAnimFrame";
            this->labelAnimFrame->Size = System::Drawing::Size(13, 13);
            this->labelAnimFrame->TabIndex = 23;
            this->labelAnimFrame->Text = L"0";
            //
            // treeViewTabControl
            //
            this->treeViewTabControl->Anchor = static_cast<System::Windows::Forms::AnchorStyles>((((System::Windows::Forms::AnchorStyles::Top | System::Windows::Forms::AnchorStyles::Bottom)
                | System::Windows::Forms::AnchorStyles::Left)
                | System::Windows::Forms::AnchorStyles::Right));
            this->treeViewTabControl->Controls->Add(this->sceneTreeViewTab);
            this->treeViewTabControl->Controls->Add(this->displayTreeViewTab);
            this->treeViewTabControl->Location = System::Drawing::Point(7, 288);
            this->treeViewTabControl->Name = L"treeViewTabControl";
            this->treeViewTabControl->SelectedIndex = 0;
            this->treeViewTabControl->Size = System::Drawing::Size(307, 285);
            this->treeViewTabControl->TabIndex = 24;
            //
            // sceneTreeViewTab
            //
            this->sceneTreeViewTab->Controls->Add(this->sceneTreeView);
            this->sceneTreeViewTab->Location = System::Drawing::Point(4, 22);
            this->sceneTreeViewTab->Name = L"sceneTreeViewTab";
            this->sceneTreeViewTab->Padding = System::Windows::Forms::Padding(3);
            this->sceneTreeViewTab->Size = System::Drawing::Size(299, 259);
            this->sceneTreeViewTab->TabIndex = 0;
            this->sceneTreeViewTab->Text = L"Scene Viewer";
            this->sceneTreeViewTab->UseVisualStyleBackColor = true;
            //
            // displayTreeViewTab
            //
            this->displayTreeViewTab->Controls->Add(this->displayTreeView);
            this->displayTreeViewTab->Location = System::Drawing::Point(4, 22);
            this->displayTreeViewTab->Name = L"displayTreeViewTab";
            this->displayTreeViewTab->Padding = System::Windows::Forms::Padding(3);
            this->displayTreeViewTab->Size = System::Drawing::Size(299, 259);
            this->displayTreeViewTab->TabIndex = 1;
            this->displayTreeViewTab->Text = L"Select By Name";
            this->displayTreeViewTab->ToolTipText = L"Select objects in the scene to focus on by name";
            this->displayTreeViewTab->UseVisualStyleBackColor = true;
            //
            // displayTreeView
            //
            this->displayTreeView->Anchor = static_cast<System::Windows::Forms::AnchorStyles>((((System::Windows::Forms::AnchorStyles::Top | System::Windows::Forms::AnchorStyles::Bottom)
                | System::Windows::Forms::AnchorStyles::Left)
                | System::Windows::Forms::AnchorStyles::Right));
            this->displayTreeView->HotTracking = true;
            this->displayTreeView->ImageIndex = 0;
            this->displayTreeView->ImageList = this->treeViewImageList;
            this->displayTreeView->Location = System::Drawing::Point(3, 6);
            this->displayTreeView->Name = L"displayTreeView";
            this->displayTreeView->SelectedImageIndex = 0;
            this->displayTreeView->ShowNodeToolTips = true;
            this->displayTreeView->Size = System::Drawing::Size(290, 247);
            this->displayTreeView->TabIndex = 3;
            this->displayTreeView->AfterSelect += gcnew System::Windows::Forms::TreeViewEventHandler(this, &hctPreviewControl::displayTreeView_AfterSelect);
            //
            // clothDisplayNonClothMeshesCheckBox
            //
            this->clothDisplayNonClothMeshesCheckBox->AutoSize = true;
            this->clothDisplayNonClothMeshesCheckBox->Checked = true;
            this->clothDisplayNonClothMeshesCheckBox->CheckState = System::Windows::Forms::CheckState::Checked;
            this->clothDisplayNonClothMeshesCheckBox->Location = System::Drawing::Point(12, 55);
            this->clothDisplayNonClothMeshesCheckBox->Name = L"clothDisplayNonClothMeshesCheckBox";
            this->clothDisplayNonClothMeshesCheckBox->Size = System::Drawing::Size(150, 17);
            this->clothDisplayNonClothMeshesCheckBox->TabIndex = 17;
            this->clothDisplayNonClothMeshesCheckBox->Text = L"Display Non-Cloth Graphic Meshes";
            this->clothDisplayNonClothMeshesCheckBox->UseVisualStyleBackColor = true;
            this->clothDisplayNonClothMeshesCheckBox->CheckedChanged += gcnew System::EventHandler(this, &hctPreviewControl::clothDisplayNonClothMeshesCheckBox_CheckedChanged);
            //
            // hctPreviewControl
            //
            this->AutoScaleDimensions = System::Drawing::SizeF(6, 13);
            this->AutoScaleMode = System::Windows::Forms::AutoScaleMode::Font;
            this->AutoScroll = true;
            this->BackColor = System::Drawing::SystemColors::Control;
            this->Controls->Add(this->treeViewTabControl);
            this->Controls->Add(this->labelAnimFrame);
            this->Controls->Add(this->minusFrameButton);
            this->Controls->Add(this->plusFrameButton);
            this->Controls->Add(this->stepSizeGroupBox);
            this->Controls->Add(this->num2GroupBox);
            this->Controls->Add(this->animFrameLabel);
            this->Controls->Add(this->productsTabControl);
            this->Controls->Add(this->clearSceneButton);
            this->Controls->Add(this->num1Label);
            this->Controls->Add(this->animFrameTrackBar);
            this->Name = L"hctPreviewControl";
            this->Size = System::Drawing::Size(317, 608);
            this->sceneViewMenuStrip->ResumeLayout(false);
            this->productsTabControl->ResumeLayout(false);
            this->physicsTabPage->ResumeLayout(false);
            this->physicsTabPage->PerformLayout();
            this->completeGroupBox->ResumeLayout(false);
            this->completeGroupBox->PerformLayout();
            this->animTabPage->ResumeLayout(false);
            this->animTabPage->PerformLayout();
            this->num5GroupBox->ResumeLayout(false);
            this->num5GroupBox->PerformLayout();
            this->clothTabPage->ResumeLayout(false);
            this->clothTabPage->PerformLayout();
            this->destructionTabPage->ResumeLayout(false);
            this->destructionTabPage->PerformLayout();
            this->displayTabPage->ResumeLayout(false);
            this->displayTabPage->PerformLayout();
            this->num1GroupBox->ResumeLayout(false);
            this->num1GroupBox->PerformLayout();
            this->num2GroupBox->ResumeLayout(false);
            this->num2GroupBox->PerformLayout();
            (cli::safe_cast<System::ComponentModel::ISupportInitialize^>(this->playSpeedNumericUpDown))->EndInit();
            (cli::safe_cast<System::ComponentModel::ISupportInitialize^>(this->playSpeedTrackBar))->EndInit();
            this->dragDropContextMenuStrip->ResumeLayout(false);
            (cli::safe_cast<System::ComponentModel::ISupportInitialize^>(this->stepSizeNumericUpDowm))->EndInit();
            this->stepSizeGroupBox->ResumeLayout(false);
            this->stepSizeGroupBox->PerformLayout();
            (cli::safe_cast<System::ComponentModel::ISupportInitialize^>(this->animFrameTrackBar))->EndInit();
            this->treeViewTabControl->ResumeLayout(false);
            this->sceneTreeViewTab->ResumeLayout(false);
            this->displayTreeViewTab->ResumeLayout(false);
            this->ResumeLayout(false);
            this->PerformLayout();

        }
#pragma endregion
};
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
