// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <Plugins/Preview/hctPreviewPlugin.h> //PCH
#include <Plugins/Preview/hctPreviewControl.h>
#include <Plugins/Preview/hctPreviewChooseRendererForm.h>
#include <Plugins/Preview/hctPreviewLoadingForm.h>
#include <Plugins/Preview/hctPreviewPostEffectSelect.h>
#include <Plugins/Preview/hctPreviewPostEffectAdjust.h>
#include <Plugins/Preview/Utilities/hctPreviewSettings.h>

#ifdef HK_ENABLE_CLOTH_PREVIEW
#include <Plugins/Preview/hctPreviewClothWindForm.h> 
#include <Plugins/Preview/hctPreviewClothCollidableForm.h> 
#include <Plugins/Preview/hctPreviewClothDebugForm.h> 
#endif

#pragma unmanaged

#include <Common/Base/Fwd/hkwindows.h>

#include <ToolInterfaces/ToolInterfaceMacros.h>
#include <ToolInterfaces/ToolInterfacesVersion.h>

#include <Common/Serialize/Util/hkRootLevelContainer.h>
#include <Common/Base/System/Io/IStream/hkIStream.h>
#include <Common/Base/System/Io/Reader/Memory/hkMemoryStreamReader.h>
#include <Common/Base/Container/String/hkStringBuf.h>
#include <Common/Base/Container/String/hkUtf8.h>
#include <Common/Base/Serialize/Detail/hkSerializeDetail.h>

#include <Common/Base/System/Io/Writer/Array/hkArrayStreamWriter.h>


#include <Common/Serialize/Util/hkSerializeUtil.h>

#include <Common/Base/Math/Matrix/hkMatrixDecomposition.h>

#include <Common/SceneData/Scene/hkxScene.h>
#include <Common/SceneData/Graph/hkxNode.h>

#include <Graphics/Bridge/SceneData/hkgSceneDataConverter.h>
#include <Graphics/Bridge/DisplayHandler/hkgDisplayHandler.h>

#include <Graphics/Common/hkGraphics.h>
#include <Graphics/Common/hkgSystemFunctions.h>
#include <Graphics/Common/DisplayObject/hkgDisplayObject.h>
#include <Graphics/Common/DisplayWorld/hkgDisplayWorld.h>
#include <Graphics/Common/Window/hkgWindow.h>
#include <Graphics/Common/Font/hkgFont.h>
#include <Graphics/Common/Shader/hkgPostEffect.h>


#ifdef HK_ENABLE_PHYSICS_2012
#include <Physics2012/Dynamics/World/hkpWorld.h>
#include <Physics2012/Utilities/Weapons/hkpFirstPersonGun.h>
#include <Physics2012/Utilities/CharacterControl/CharacterRigidBody/hkpCharacterRigidBody.h>
#include <Physics2012/Utilities/CharacterControl/FirstPersonCharacter/hkpFirstPersonCharacter.h>
#include <Physics2012/Utilities/VisualDebugger/hkpPhysicsContext.h>
#include <Physics2012/Utilities/VisualDebugger/Viewer/Dynamics/hkpPhantomDisplayViewer.h>
#include <Physics2012/Utilities/VisualDebugger/Viewer/Collide/hkpShapeDisplayViewer.h>
#endif

#ifdef HK_ENABLE_PHYSICS
#include <Physics/Physics/Dynamics/World/hknpWorld.h>
#include <Physics/Physics/Extensions/Viewers/hknpProcessContext.h>
#include <Physics/Physics/Extensions/Viewers/Shape/hknpShapeViewer.h>
#include <Physics/Physics/Extensions/CharacterControl/Examples/FirstPerson/hknpFirstPersonCharacter.h>
#include <Physics/Physics/Extensions/CharacterControl/Examples/FirstPerson/Guns/hknpFirstPersonGun.h>
#endif

#ifdef HK_ENABLE_CLOTH_PREVIEW
#include <Cloth/Cloth/Utilities/VisualDebugger/CollidableViewer/hclCollidableViewer.h>
#include <Cloth/Cloth/Utilities/VisualDebugger/ParticleRadiusViewer/hclParticleRadiusViewer.h>
#endif

#ifdef HK_ENABLE_DESTRUCTION_2012
class hkdBreakableShape;
#include <Destruction2012/Destruction/Utilities/BreakableShapeGraphicsNameViewer/hkdBreakableShapeGraphicsNameViewer.h>
#include <Destruction2012/Destruction/Utilities/Serialize/hkdDestructionDemoConfig.h>
#include <Destruction2012/Destruction/World/hkdWorld.h>
#endif

#ifdef HK_ENABLE_DESTRUCTION
#   include <Destruction/Destruction/hkndDestruction.h>                                                     
#   include <Destruction/Destruction/Runtime/World/hkndWorld.h>                                             
#   include <Destruction/Destruction/Extensions/Viewers/FracturePieceName/hkndFracturePieceNameViewer.h>    
#   include <Destruction/Destruction/Extensions/Viewers/Connection/hkndConnectionViewer.h>                  
#   include <Destruction/Destruction/Extensions/Viewers/Integrity/hkndIntegrityViewer.h>                    
#   include <Destruction/Destruction/Extensions/Viewers/DestructionTracker/hkndDestructionTrackerViewer.h>  
#   include <Destruction/Destruction/Utilities/Serialize/hkndDestructionDemoConfig.h>                       
#endif

#include <Common/Visualize/Process/hkDebugDisplayProcess.h>
#include <Common/Visualize/hkProcessFactory.h>
#include <Common/Visualize/hkDebugDisplay.h>

#include <Plugins/Preview/hctPreviewUnmanaged.h>
#include <Plugins/Preview/hctPreviewAsset.h>

#ifdef HK_ENABLE_ANIMATION
#include <Plugins/Preview/Animation/hctPreviewAnim.h>
#endif

#ifdef HK_ENABLE_CLOTH_PREVIEW
#include <Plugins/Preview/Cloth/hctPreviewCloth.h>
#endif

#include <Plugins/Preview/hctPreviewTreeViewManager.h>
#include <Common/Base/Thread/Pool/hkCpuThreadPool.h>
#include <Common/Visualize/hkProcessRegisterUtil.h>
#include <Common/Visualize/hkCommonProcessContext.h>
#include <Common/Base/Config/hkConfigVersion.h>
#include <Common/Base/Reflect/Util/hkReflectClone.h>
#include <Graphics/Common/hkgSystem.h>

#ifdef GetEnvironmentVariable
#undef GetEnvironmentVariable
#endif

#include <Common/Base/KeyCode.h>

#include <Common/Base/Config/hkProductFeatures.h>
#define HK_CLASSES_FILE <Common/Base/ClassLists/hkClassLists.cxx>
#define HK_EXCLUDE_FEATURE_MemoryTracker
#define HK_EXCLUDE_FEATURE_hkFormatYamlFile
#include <Common/Base/Config/hkProductFeatures.cxx>

HAVOK_TOOLS_BASE_SYSTEM_DLL_MAIN_DECL
HAVOK_TOOLS_FLUSH_DENORMALS_TO_ZERO_DECL

#pragma managed

using namespace PreviewPlugin;
using namespace System::Runtime::InteropServices;
using namespace Microsoft::Win32;
using namespace System::IO;
using namespace System::Windows::Forms;

// Have a non managed demo/ engine impl here:
//  - Array of unmanaged not allowed in managed type.
//  - Also aligned types can't be mixed in same func as managed types (eg. SIMD vector4..)
#define NUM_BODIES 5
#define NUM_FRAMES 100

#define HK_PIN_ENTIRE_VECTOR3_HANDLE(VECTOR, NATIVE_PTR) \
    pin_ptr<hkgVector3CLR> pinned##VECTOR = &*VECTOR; \
    float* NATIVE_PTR = &pinned##VECTOR->X;


void hctPreviewControl::initBaseSystem(System::IntPtr baseInfo, System::IntPtr graphicsInfo)
{
    HAVOK_TOOLS_BASE_SYSTEM_LOCK();

    HAVOK_TOOLS_BASE_SYSTEM_INIT( (hkMemoryInitUtil::SyncInfo*)baseInfo.ToPointer() );

    if (graphicsInfo.ToPointer())
    {
        // set our local HKG ptrs:
        hkgSystemSetCreateFunctions(*(hkgSystemCreateFuncs*)graphicsInfo.ToPointer());
        m_displayMem = gcnew GraphicsBridgeBaseSystem();

        //XXX ASSUMES ONLY THIS USER OF THE BRIDGE... or at least that all users are in agreement on the mem and static func ptrs
        // set the bridge dll ptrs:
        m_displayMem->initBaseSystem( baseInfo, graphicsInfo );
    }

    HAVOK_TOOLS_FLUSH_DENORMALS_TO_ZERO();
    HAVOK_TOOLS_BASE_SYSTEM_UNLOCK();

    if (!hkCompatFormats::getInstance().isLoaded())
    {
        String^ userToolPath = nullptr;
#ifdef HK_PLATFORM_WIN64
        userToolPath = Environment::GetEnvironmentVariable("HAVOK_TOOLS_ROOT_X64");
#else
        userToolPath = Environment::GetEnvironmentVariable("HAVOK_TOOLS_ROOT");
#endif

        if (userToolPath != nullptr && userToolPath->Length > 0 && System::IO::Directory::Exists(userToolPath))
        {
            String^ dllPath = userToolPath + "\\utils";
            hkCompatFormats::replaceInstance(new hkCompatFormats(hkUtf8::Utf8FromWide(dllPath).cString()));
        }
    }
}


void hctPreviewControl::pushErrorHandler(System::IntPtr error)
{
    HAVOK_TOOLS_BASE_SYSTEM_LOCK();
    HAVOK_TOOLS_BASE_SYSTEM_PUSH_ERROR(error);
    HAVOK_TOOLS_BASE_SYSTEM_UNLOCK();
}

void hctPreviewControl::popErrorHandler()
{
    HAVOK_TOOLS_BASE_SYSTEM_LOCK();
    HAVOK_TOOLS_BASE_SYSTEM_POP_ERROR(error);
    HAVOK_TOOLS_BASE_SYSTEM_UNLOCK();
}

void hctPreviewControl::getVersionInfo( String^% interfaceVersion, String^% havokSdkVersion )
{
    interfaceVersion = HCT_TOOL_INTERFACE_VERSION;
    havokSdkVersion = HAVOK_SDK_VERSION_STRING;
}

void hctPreviewControl::quitBaseSystem()
{
    quit();

    if (m_displayMem!=nullptr)
    {
        m_displayMem->quitBaseSystem();
        m_displayMem = nullptr;
    }

    HAVOK_TOOLS_BASE_SYSTEM_LOCK();

    HAVOK_TOOLS_BASE_SYSTEM_QUIT();

    HAVOK_TOOLS_BASE_SYSTEM_UNLOCK();
}

hctPreviewControl::hctPreviewControl()
{
    InitializeComponent();

    m_si = HK_NULL;
    m_display = nullptr;
    m_displayMem = nullptr;
    m_displayBoundingBox = true;
#ifdef HK_ENABLE_PHYSICS_2012
    m_char = HK_NULL;
#endif
#ifdef HK_ENABLE_PHYSICS
    m_npChar = HK_NULL;
#endif
    m_playState = true;
    m_singleStep = false;
    m_restart = true;
    m_totalUnusedStepDelta = 0;
    m_displayDropTargets = false;
    m_inRealTimePlayback = true;
    m_allowSubsteps = true;
    m_warnNonRealtimeCounter = 0;
    m_stepDelta = 0.016f; // 60Hz
    m_playbackSpeed = 1.0f;
    m_delayedDropFiles = gcnew System::Collections::ArrayList();

    m_gridEnabled = true;
    m_gridOrientation = GridOrientation::GRID_XY;
    m_gridCellSize = 1.0f;

    m_parentMenu = nullptr;

    m_treeViewManager = new hctPreviewTreeViewManager();
}

hctPreviewControl::~hctPreviewControl()
{
    savePreferences();
    if (components)
    {
        delete components;
    }

    deleteFirstPersonController();
    quit();

}

void hctPreviewControl::savePhysicsPreferences()
{
#if defined (HK_ENABLE_PHYSICS_2012) || defined(HK_ENABLE_PHYSICS)
    hctPreviewSettings::setFolder( "PhysicsSettings" );
    hctPreviewSettings::saveValue( "physicsGhosts", showCollShapeCheckBox->Checked );
    hctPreviewSettings::saveValue( "showDisplayMeshes", showDisplayMeshCheckBox->Checked );
    const int g = ( gravityComboBox->SelectedIndex >= 0 ) ? gravityComboBox->SelectedIndex : 0;
    hctPreviewSettings::saveValue( "physicsGravity", g );
    hctPreviewSettings::saveValue( "physicsRunPhysics", boxPhysicsCheckBox->Checked );
#endif

#ifdef HK_ENABLE_PHYSICS_2012
    const int mapping = ( ragdollMappingCombo->SelectedIndex >= 0 ) ? ragdollMappingCombo->SelectedIndex : 0;
    hctPreviewSettings::saveValue( "physicsRagdollMapping", mapping );
#endif
}

void hctPreviewControl::loadPhysicsPreferences()
{
#if defined (HK_ENABLE_PHYSICS_2012) || defined(HK_ENABLE_PHYSICS)
    hctPreviewSettings::setFolder( "PhysicsSettings" );
    showCollShapeCheckBox->Checked = Convert::ToBoolean( hctPreviewSettings::loadValue( "physicsGhosts", System::Boolean(false) ) );
    showDisplayMeshCheckBox->Checked = Convert::ToBoolean( hctPreviewSettings::loadValue( "showDisplayMeshes", System::Boolean(true) ) );
    gravityComboBox->SelectedIndex = Convert::ToUInt16( hctPreviewSettings::loadValue( "physicsGravity" ) );
    boxPhysicsCheckBox->Checked = Convert::ToBoolean( hctPreviewSettings::loadValue( "physicsRunPhysics", System::Boolean(true) ) );
#endif

#ifdef HK_ENABLE_PHYSICS_2012
    const int mapping = Convert::ToUInt16( hctPreviewSettings::loadValue( "physicsRagdollMapping", System::Int32(1) ) );
    ragdollMappingCombo->SelectedIndex = ( mapping >= 0 ) ? mapping : 0;
#endif
}

void hctPreviewControl::saveAnimationPreferences()
{
#ifdef HK_ENABLE_ANIMATION
    hctPreviewSettings::setFolder( "AnimationSettings" );

    // Animation
    hctPreviewSettings::saveValue( "animationRunAnimation", animCheckBox->Checked );
    hctPreviewSettings::saveValue( "animationAccumulateMotion", accumMotionCheckBox->Checked );
    hctPreviewSettings::saveValue( "animationDisplaySkeletons", displaySkeletonsCheckBox->Checked );
    hctPreviewSettings::saveValue( "animationDisplayThickBones", thickBonesCheckBox->Checked );
    hctPreviewSettings::saveValue( "animationDisplayBoneNames", displayBoneNamesCheckBox->Checked );
    hctPreviewSettings::saveValue( "animationDisplayMotion", displayMotionCheckBox->Checked );
    hctPreviewSettings::saveValue( "animationDisplayAnnotations", displayAnnotationsCheckBox->Checked );
    hctPreviewSettings::saveValue( "animationDisplayFloatTracks", floatTracksCheckBox->Checked );
    hctPreviewSettings::saveValue( "animationDisplayFootSteps", footStepsComboBox->SelectedIndex );
#endif
}

void hctPreviewControl::loadAnimationPreferences()
{
#ifdef HK_ENABLE_ANIMATION

    hctPreviewSettings::setFolder( "AnimationSettings" );

    // Animation
    animCheckBox->Checked = Convert::ToBoolean( hctPreviewSettings::loadValue( "animationRunAnimation", true ) );
    accumMotionCheckBox->Checked = Convert::ToBoolean( hctPreviewSettings::loadValue( "animationAccumulateMotion", false ) );
    displaySkeletonsCheckBox->Checked = Convert::ToBoolean( hctPreviewSettings::loadValue( "animationDisplaySkeletons", false ) );
    thickBonesCheckBox->Checked = Convert::ToBoolean( hctPreviewSettings::loadValue( "animationDisplayThickBones", true ) );
    displayBoneNamesCheckBox->Checked = Convert::ToBoolean( hctPreviewSettings::loadValue( "animationDisplayBoneNames", false ) );
    displayMotionCheckBox->Checked = Convert::ToBoolean( hctPreviewSettings::loadValue( "animationDisplayMotion", false ) );
    displayAnnotationsCheckBox->Checked = Convert::ToBoolean( hctPreviewSettings::loadValue( "animationDisplayAnnotations", false ) );
    floatTracksCheckBox->Checked = Convert::ToBoolean( hctPreviewSettings::loadValue( "animationDisplayFloatTracks", false ) );
    footStepsComboBox->SelectedIndex = Convert::ToInt32( hctPreviewSettings::loadValue( "animationDisplayFootSteps", false ) );

#endif
}

void hctPreviewControl::saveClothPreferences()
{
#ifdef HK_ENABLE_CLOTH_PREVIEW
    // -- Cloth
    hctPreviewSettings::setFolder( "ClothSettings\\Wind" );

    // Wind
    hctPreviewSettings::saveValue( "windEnabled", m_clothWindForm->getWindEnabled() );
    {
        float x, y, z;
        m_clothWindForm->getWindDirection( x, y, z );
        hctPreviewSettings::saveValue( "windDirectionX", x );
        hctPreviewSettings::saveValue( "windDirectionY", y );
        hctPreviewSettings::saveValue( "windDirectionZ", z );
    }
    hctPreviewSettings::saveValue( "windMinSpeed", m_clothWindForm->getWindMinSpeed() );
    hctPreviewSettings::saveValue( "windMaxSpeed", m_clothWindForm->getWindMaxSpeed() );
    hctPreviewSettings::saveValue( "windFrequency", m_clothWindForm->getWindFrequency() );
    hctPreviewSettings::saveValue( "windMaxDrag", m_clothWindForm->getWindMaxDrag() );

    // other settings
    hctPreviewSettings::setFolder( "ClothSettings" );

    hctPreviewSettings::saveValue( "clothClothRunCloth", clothCheckBox->Checked );
    hctPreviewSettings::saveValue( "clothClothRunClothMultithread", clothMultithreadCheckBox->Checked );
    hctPreviewSettings::saveValue("clothShowNonClothGraphicMeshes", clothDisplayNonClothMeshesCheckBox->Checked);

    hctPreviewSettings::saveValue( "clothClothEnableWorldCollidables", m_clothCollidableForm->getWorldCollidablesEnabled() );
    hctPreviewSettings::saveValue( "clothClothEnableRigidBodyCollidables", m_clothCollidableForm->getRigidBodyCollidablesEnabled() );

    hctPreviewSettings::saveValue( "clothShowSimGeometry", m_clothDebugForm->showClothSimGeometryCheckBox->Checked );
    hctPreviewSettings::saveValue( "clothShowSimParticlePositions", m_clothDebugForm->simParticlePosCheckbox->Checked);
    hctPreviewSettings::saveValue( "clothShowSimNormals", m_clothDebugForm->clothSimNormalsCheckbox->Checked );
    hctPreviewSettings::saveValue( "clothShowSimParticleVelocity", m_clothDebugForm->simParticleVelocityCheckbox->Checked );
    hctPreviewSettings::saveValue( "clothShowSimParticleIds", m_clothDebugForm->particleIdCheckbox->Checked);

    hctPreviewSettings::saveValue( "clothShowStandardLinks", m_clothDebugForm->standardLinksCheckBox->Checked );
    hctPreviewSettings::saveValue( "clothShowStretchLinks", m_clothDebugForm->stretchLinksCheckbox->Checked );
    hctPreviewSettings::saveValue( "clothShowCompressibleLinks", m_clothDebugForm->compressibleLinksCheckBox->Checked );
    hctPreviewSettings::saveValue( "clothShowBendStiffness", m_clothDebugForm->bendStiffnessCheckbox->Checked );
    hctPreviewSettings::saveValue( "clothShowBendLinks", m_clothDebugForm->bendLinksCheckbox->Checked );
    hctPreviewSettings::saveValue( "clothShowVolume", m_clothDebugForm->volumeCheckbox->Checked );
    hctPreviewSettings::saveValue( "clothShowLocalRange", m_clothDebugForm->localRangeCheckBox->Checked );
    hctPreviewSettings::saveValue( "clothShowBonePlanes", m_clothDebugForm->bonePlanesCheckBox->Checked );
    hctPreviewSettings::saveValue( "clothShowTransitions", m_clothDebugForm->transitionsCheckBox->Checked );

    hctPreviewSettings::saveValue("clothShowCollidables", m_clothDebugForm->showCollidablesCheckBox->Checked);
    hctPreviewSettings::saveValue("clothShowCollidableVelocity", m_clothDebugForm->collidableVelocityCheckbox->Checked);
    hctPreviewSettings::saveValue("clothShowParticleRadius", m_clothDebugForm->showParticleRadiusCheckBox->Checked);

    hctPreviewSettings::saveValue("clothShowDisplayBuffers", m_clothDebugForm->showDisplayBufferCheckBox->Checked);
    hctPreviewSettings::saveValue("clothShowNormals", m_clothDebugForm->clothDisplayNormalsCheckBox->Checked);

#endif
}

void hctPreviewControl::loadClothPreferences()
{
#ifdef HK_ENABLE_CLOTH_PREVIEW

    // -- Cloth
    hctPreviewSettings::setFolder( "ClothSettings\\Wind" );

    try
    {
        // Wind
        m_clothWindForm->setWindEnabled( Convert::ToBoolean( hctPreviewSettings::loadValue( "windEnabled", false ) ) );
        {
            const float x = System::Decimal::ToSingle( Convert::ToDecimal( hctPreviewSettings::loadValue( "windDirectionX", 1.0f ) ) );
            const float y = System::Decimal::ToSingle( Convert::ToDecimal( hctPreviewSettings::loadValue( "windDirectionY", 0.0f ) ) );
            const float z = System::Decimal::ToSingle( Convert::ToDecimal( hctPreviewSettings::loadValue( "windDirectionZ", 0.0f ) ) );

            m_clothWindForm->setWindDirection( x, y, z );
        }

        m_clothWindForm->setWindMinSpeed( System::Decimal::ToSingle( Convert::ToDecimal( hctPreviewSettings::loadValue( "windMinSpeed", -0.5f ) ) ) );
        m_clothWindForm->setWindMaxSpeed( System::Decimal::ToSingle( Convert::ToDecimal( hctPreviewSettings::loadValue( "windMaxSpeed", 0.5f ) ) ) );
        m_clothWindForm->setWindFrequency( System::Decimal::ToSingle( Convert::ToDecimal( hctPreviewSettings::loadValue( "windFrequency", .3f ) ) ) );
        m_clothWindForm->setWindMaxDrag( System::Decimal::ToSingle( Convert::ToDecimal( hctPreviewSettings::loadValue( "windMaxDrag", 3.0f ) ) ) );

        // other settings
        hctPreviewSettings::setFolder( "ClothSettings" );


        clothCheckBox->Checked = Convert::ToBoolean( hctPreviewSettings::loadValue( "clothClothRunCloth", true ) );
        clothMultithreadCheckBox->Checked = Convert::ToBoolean( hctPreviewSettings::loadValue( "clothClothRunClothMultithread", false ) );
        clothDisplayNonClothMeshesCheckBox->Checked = Convert::ToBoolean(hctPreviewSettings::loadValue("clothShowNonClothGraphicMeshes", true));

        m_clothCollidableForm->setWorldCollidablesEnabled( Convert::ToBoolean( hctPreviewSettings::loadValue( "clothClothEnableWorldCollidables", false ) ) );
        m_clothCollidableForm->setRigidBodyCollidablesEnabled( Convert::ToBoolean( hctPreviewSettings::loadValue( "clothClothEnableRigidBodyCollidables", true ) ) );

        m_clothDebugForm->showClothSimGeometryCheckBox->Checked = Convert::ToBoolean( hctPreviewSettings::loadValue( "clothShowSimGeometry", false ) );
        m_clothDebugForm->simParticlePosCheckbox->Checked = Convert::ToBoolean(hctPreviewSettings::loadValue("clothShowSimParticlePositions", false));
        m_clothDebugForm->clothSimNormalsCheckbox->Checked = Convert::ToBoolean(hctPreviewSettings::loadValue("clothShowSimNormals", false));
        m_clothDebugForm->simParticleVelocityCheckbox->Checked = Convert::ToBoolean(hctPreviewSettings::loadValue("clothShowSimParticleVelocity", false));
        m_clothDebugForm->particleIdCheckbox->Checked = Convert::ToBoolean(hctPreviewSettings::loadValue("clothShowSimParticleIds", false));

        m_clothDebugForm->standardLinksCheckBox->Checked = Convert::ToBoolean( hctPreviewSettings::loadValue( "clothShowStandardLinks", false ) );
        m_clothDebugForm->stretchLinksCheckbox->Checked = Convert::ToBoolean( hctPreviewSettings::loadValue( "clothShowStretchLinks", false ) );
        m_clothDebugForm->compressibleLinksCheckBox->Checked = Convert::ToBoolean( hctPreviewSettings::loadValue( "clothShowCompressibleLinks", false ) );
        m_clothDebugForm->bendStiffnessCheckbox->Checked = Convert::ToBoolean( hctPreviewSettings::loadValue( "clothShowBendStiffness", false ) );
        m_clothDebugForm->bendLinksCheckbox->Checked = Convert::ToBoolean( hctPreviewSettings::loadValue( "clothShowBendLinks", false ) );
        m_clothDebugForm->volumeCheckbox->Checked = Convert::ToBoolean( hctPreviewSettings::loadValue( "clothShowVolume", false ) );
        m_clothDebugForm->localRangeCheckBox->Checked = Convert::ToBoolean(hctPreviewSettings::loadValue("clothShowLocalRange", false));
        m_clothDebugForm->bonePlanesCheckBox->Checked = Convert::ToBoolean(hctPreviewSettings::loadValue("clothShowBonePlanes", false));
        m_clothDebugForm->transitionsCheckBox->Checked = Convert::ToBoolean(hctPreviewSettings::loadValue("clothShowTransitions", false));

        m_clothDebugForm->showCollidablesCheckBox->Checked = Convert::ToBoolean(hctPreviewSettings::loadValue("clothShowCollidables", false));
        m_clothDebugForm->collidableVelocityCheckbox->Checked = Convert::ToBoolean(hctPreviewSettings::loadValue("clothShowCollidableVelocity", false));
        m_clothDebugForm->showParticleRadiusCheckBox->Checked = Convert::ToBoolean(hctPreviewSettings::loadValue("clothShowParticleRadius", false));

        m_clothDebugForm->showDisplayBufferCheckBox->Checked = Convert::ToBoolean(hctPreviewSettings::loadValue("clothShowDisplayBuffers", true));
        m_clothDebugForm->clothDisplayNormalsCheckBox->Checked = Convert::ToBoolean(hctPreviewSettings::loadValue("clothShowNormals", false));
    }
    catch (...)
    {

    }

#endif
}

void hctPreviewControl::saveDestructionPreferences()
{
#ifdef HK_ENABLE_DESTRUCTION_2012
    hctPreviewSettings::setFolder( "DestructionSettings" );

    hctPreviewSettings::saveValue( "destructionAdditionalTexSearchPath", destructionAdditionalTexSearchPathTextBox->Text );
#endif
}

void hctPreviewControl::loadDestructionPreferences()
{
#ifdef HK_ENABLE_DESTRUCTION_2012
    hctPreviewSettings::setFolder( "DestructionSettings" );

    destructionAdditionalTexSearchPathTextBox->Text = Convert::ToString( hctPreviewSettings::loadValue( "destructionAdditionalTexSearchPath", "" ) );
#endif
}

void hctPreviewControl::saveGeneralPreferences()
{
    hctPreviewSettings::setFolder( "GeneralSettings" );

    hctPreviewSettings::saveValue( "displayBoundingBox", showBoundingBoxCheckbox->Checked );

    hctPreviewSettings::saveValue( "playbackSpeed", Convert::ToSingle( playSpeedNumericUpDown->Value ) );
    hctPreviewSettings::saveValue( "stepSizeFrequency", Convert::ToSingle( stepSizeNumericUpDowm->Value ) );
    hctPreviewSettings::saveValue( "stepSizeRealtime", realtimeCheckBox->Checked );
}

void hctPreviewControl::loadGeneralPreferences()
{
    hctPreviewSettings::setFolder( "GeneralSettings" );

    showBoundingBoxCheckbox->Checked = Convert::ToBoolean( hctPreviewSettings::loadValue( "displayBoundingBox", true ) );

    playSpeedNumericUpDown->Value = Convert::ToDecimal( hctPreviewSettings::loadValue( "playbackSpeed", 100.0f ) );
    stepSizeNumericUpDowm->Value = Convert::ToDecimal( hctPreviewSettings::loadValue( "stepSizeFrequency", 60.0f ) );
    realtimeCheckBox->Checked = Convert::ToBoolean( hctPreviewSettings::loadValue( "stepSizeRealtime", true ) );

}



void hctPreviewControl::savePreferences()
{
    savePhysicsPreferences();

    saveAnimationPreferences();

    saveClothPreferences();

    saveDestructionPreferences();

    saveGeneralPreferences();
}



void hctPreviewControl::loadPreferences()
{
    loadPhysicsPreferences();

    loadAnimationPreferences();

    loadClothPreferences();

    loadDestructionPreferences();

    loadGeneralPreferences();
}

void hctPreviewControl::erasePhysicsProperties()
{
    hctPreviewSettings::setFolder( "PhysicsSettings" );

    hctPreviewSettings::deleteCurrentFolder();
}

void hctPreviewControl::eraseAnimationProperties()
{
    hctPreviewSettings::setFolder( "AnimationSettings" );

    hctPreviewSettings::deleteCurrentFolder();
}

void hctPreviewControl::eraseClothProperties()
{
    hctPreviewSettings::setFolder( "ClothSettings" );

    hctPreviewSettings::deleteCurrentFolder();
}

void hctPreviewControl::eraseDestructionProperties()
{
    hctPreviewSettings::setFolder( "DestructionSettings" );

    hctPreviewSettings::deleteCurrentFolder();
}

void hctPreviewControl::eraseGeneralProperties()
{
    hctPreviewSettings::setFolder( "GeneralSettings" );

    hctPreviewSettings::deleteCurrentFolder();
}

void hctPreviewControl::restoreDefaultProperties()
{
    // erase all preferences
    erasePhysicsProperties();
    eraseAnimationProperties();
    eraseClothProperties();
    eraseDestructionProperties();
    eraseGeneralProperties();

    // and reload the defaults
    loadPreferences();

    // re-apply Wind and Landscape Settings
    reflectClothSettings();
}

void hctPreviewControl::report( Havok::Tool::IConsole::MessageType t, String^ message )
{
    if (m_errorConsole != nullptr)
    {
        m_errorConsole->addMessage( t, message );
    }

    // To normal consple aswell so that we never miss it
    Console::Write( t.ToString() );
    Console::Write( ": ");
    Console::WriteLine( message  );
}


#ifdef HK_ENABLE_PHYSICS_2012
#pragma unmanaged
static void _createPhysicsContext( PreviewPluginImpl* si )
{
    si->m_physicsVdbContext = new hkpPhysicsContext();
}
#pragma managed
#endif

#ifdef HK_ENABLE_PHYSICS
#pragma unmanaged
static void _createNewPhysicsContext( PreviewPluginImpl* si )
{
    si->m_newPhysicsVdbContext = new hknpProcessContext();
}
#pragma managed
#endif

#ifdef HK_ENABLE_DESTRUCTION
#pragma unmanaged
static void _createNewDestructionContext( PreviewPluginImpl* si )
{
    si->m_ndVdbContext = new hkndProcessContext();
}
#pragma managed
#endif


void hctPreviewControl::reflectClothSettings()
{
#ifdef HK_ENABLE_CLOTH_PREVIEW
    if (m_si->m_clothImpl)
    {
        ((PreviewPluginClothImpl*)m_si->m_clothImpl)->m_isWorldCollidablesActive = false;
    }
    m_clothWindForm->applyWindSettings();
    m_clothCollidableForm->applyCollidableSettings();
    m_clothDebugForm->applyDebugSettings();
#endif
}

#ifdef HK_ENABLE_CLOTH_PREVIEW
#pragma unmanaged
static void _createClothContext( PreviewPluginImpl* si )
{
    si->m_clothVdbContext = new hclClothContext();
}
#pragma managed
#endif

static void _createViewers( GraphicsBridge^ display, PreviewPluginImpl* si )
{
#if defined(HK_ENABLE_PHYSICS_2012) || defined(HK_ENABLE_CLOTH_PREVIEW ) || defined(HK_ENABLE_PHYSICS)
    #if defined(HK_ENABLE_PHYSICS)
        _createNewPhysicsContext( si );
    #endif

    #if defined(HK_ENABLE_DESTRUCTION)
        _createNewDestructionContext( si );
    #endif

    #if defined(HK_ENABLE_PHYSICS_2012)
        _createPhysicsContext( si );
    #endif

    #if defined(HK_ENABLE_CLOTH_PREVIEW )
        _createClothContext( si );
    #endif

    array< IntPtr >^ vdbContexts =
    {
        // cast to hkProcessContext explicitly so that the multiple inheritance works itself out
#if defined(HK_ENABLE_PHYSICS_2012)
        IntPtr( (void*) static_cast<hkProcessContext*>( si->m_physicsVdbContext ) ),
#endif
#if defined(HK_ENABLE_PHYSICS)
        IntPtr( (void*) static_cast<hkProcessContext*>( si->m_newPhysicsVdbContext ) ),
#endif
#if defined(HK_ENABLE_CLOTH_PREVIEW )
        IntPtr( (void*) static_cast<hkProcessContext*>( si->m_clothVdbContext ) ),
#endif
#if defined(HK_ENABLE_DESTRUCTION)
        IntPtr( (void*) static_cast<hkProcessContext*>( si->m_ndVdbContext ) )
#endif
    };

    array< String^ >^ viewers = {
        gcnew String(hkDebugDisplayProcess::getName()),
    #if defined(HK_ENABLE_PHYSICS)
        gcnew String(hknpShapeViewer::getName()),
    #endif
    #if defined(HK_ENABLE_PHYSICS_2012)
        gcnew String(hkpShapeDisplayViewer::getName()),
        gcnew String(hkpPhantomDisplayViewer::getName())
    #endif
    };

#else // none

    IntPtr vdbContexts(0);
    array< String^ >^ viewers = { gcnew String(hkDebugDisplayProcess::getName()) };

#endif

#if defined(HK_ENABLE_PHYSICS_2012)
    hkpPhysicsContext::registerAllPhysicsProcesses();
#endif
#if defined(HK_ENABLE_PHYSICS)
    hknpProcessContext::registerAllProcesses();
#endif

#if defined(HK_ENABLE_CLOTH_PREVIEW )
    hclClothContext::registerAllClothProcesses();
#endif

    display->init( vdbContexts, IntPtr( &hkProcessFactory::getInstance() ), true, viewers);

    // Register afterwards because it should not be on at start

#if defined(HK_ENABLE_DESTRUCTION_2012)
    hkdBreakableShapeGraphicsNameViewer::registerViewer();
#endif
#ifdef HK_ENABLE_DESTRUCTION
    hkndFracturePieceNameViewer::registerViewer(hkProcessFactory::getInstance());
    hkndConnectionViewer::registerViewer(hkProcessFactory::getInstance());
    hkndIntegrityViewer::registerViewer(hkProcessFactory::getInstance());
    hkndDestructionTrackerViewer::registerViewer(hkProcessFactory::getInstance());
#endif
}

void hctPreviewControl::init()
{
    // Safe to do whatever you like here really.

    m_si = new PreviewPluginImpl();

    initNewPhysicsUI();
    initPhysicsUI();
    initAnimUI();
    initCompleteUI();
    initClothUI();
    initDestructionUI();
    initNewDestructionUI();

    if ( m_display != nullptr)
    {
        setContext( m_display->m_world, m_display->m_context, m_display->m_window);
    }

#ifdef HK_ENABLE_CLOTH_PREVIEW
    if (m_si->m_clothImpl)
    {
        m_clothWindForm = gcnew hctPreviewClothWindForm( System::IntPtr((PreviewPluginClothImpl*)m_si->m_clothImpl) );
        m_clothTransitionForm = gcnew hctPreviewClothTransitionForm ( System::IntPtr((PreviewPluginClothImpl*)m_si->m_clothImpl) );
        m_clothDebugForm = gcnew hctPreviewClothDebugForm ( System::IntPtr(m_si) );
        m_clothCollidableForm = gcnew hctPreviewClothCollidableForm( System::IntPtr((PreviewPluginClothImpl*)m_si->m_clothImpl) );
    }
#endif

    loadPreferences();

    configureProductsFromUI();
}

void hctPreviewControl::setContext( hkgDisplayWorldCLR^ world, hkgDisplayContextCLR^ ctx, hkgWindowCLR^ window )
{
    if (m_display == nullptr)
    {
        m_display = gcnew GraphicsBridge( world, ctx, window );
    }

    if (m_si)
    {
        m_si->m_displayWorld = (hkgDisplayWorld*)world->getInternalPtr().ToPointer();
        m_si->m_displayContext = (hkgDisplayContext*)ctx->getInternalPtr().ToPointer();
        m_si->m_displayHandler = (hkgDisplayHandler*)m_display->getInternalPtr().ToPointer();

        if (m_si->m_assetManager)
        {
            m_si->m_assetManager->m_displayWorld = m_si->m_displayWorld;
            m_si->m_assetManager->m_displayContext = m_si->m_displayContext;
            m_si->m_assetManager->m_displayHandler = m_si->m_displayHandler;
        }
        m_si->m_displayContext->lock();

        // make sure any HK_DISPLAY_X calls end up in the proper handler
        if (m_si->m_displayHandler)
        {
            hkDebugDisplay::getInstance().addDebugDisplayHandler( m_si->m_displayHandler );
        }

        _createViewers( m_display, m_si );

        rendererLabel->Text = gcnew String("Renderer: ") + hkgSystemCLR::getRendererAsString(hkgSystemCLR::getCurrentRenderer()) + ( m_si->m_displayContext->getOwner()->msaaEnabled() ? " (MSAA)" : "");


        if (m_si->m_displayFont == HK_NULL)
        {
            m_si->createFont();
        }

        bool shadows = m_si->m_displayContext->getOwner()->getShadowMapSupport() > HKG_SHADOWMAP_NOSUPPORT;

        bool postEffects = m_si->m_displayContext->getRenderCaps().m_supportsPostEffects;
        if ( postEffects )
        {
            // test effect
            hkgPostEffect* testEffect = hkgPostEffect::create( m_si->m_displayContext->getOwner() );
            postEffects = testEffect && testEffect->getDefaultFileNameExtension() && ( hkString::strLen( testEffect->getDefaultFileNameExtension() ) > 0 );
            if (testEffect) { testEffect->removeReference(); }
        }

        m_si->m_displayContext->unlock();

        // Disable stuff that the render can't handle perhaps:
        shadowCasterCheckBox->Enabled = shadows;
        shadowRecvCheckBox->Enabled = shadows;
        postEffectsButton->Enabled = postEffects;
        adjustEffectsButton->Enabled = postEffects;
    }
}

bool hctPreviewControl::step(float graphicsDt)
{
    bool result = false;

    if (m_playState)
    {
        if(m_restart)
        {
            graphicsDt = m_stepDelta;
            m_restart = false;
        }

        graphicsDt *= m_playbackSpeed;

        // the graphics will step at a semi-random dt.
        // We like to step the physics, animation, and especially cloth at a fixed dt specified by the user
        // to both enhance the stability of the cloth sim but also to make the system more deterministic
        // and aid in sim behaviour debugging

        m_totalUnusedStepDelta += graphicsDt;

        float numStepsRequiredToMeetGraphicsStep = m_totalUnusedStepDelta / (m_stepDelta);
        int numWholeStepsRequiredToMeetGraphicsStep = hkMath::hkFloorToInt(numStepsRequiredToMeetGraphicsStep);

        int maxNumSteps = m_allowSubsteps? 10 : 1;
        int numWholeStepsAllowed = hkMath::min2<int>(numWholeStepsRequiredToMeetGraphicsStep, maxNumSteps);

        // To avoid immediate debug display flickering, we clear them before only if the simulation is being stepped.
        // Otherwise, they will only persist for a single frame if the stepping of the simulation is greater than a frame apart.
        // Note: GraphicsBridge::renderImmerdiate() no longers calls clearImmerdiate()
        if (numWholeStepsAllowed > 0)
        {
            if (m_display)
            {
                m_display->clearImmediate();
            }
        }
        hkStopwatch stepTimer;

        m_inRealTimePlayback = true;
        for (int s = 0; s < numWholeStepsAllowed; ++s)
        {
            stepTimer.reset();
            stepTimer.start();

            // Worlds
            if (m_si)
            {
                m_si->step( m_stepDelta );
            }

            if (m_allowSubsteps)
            {
                m_totalUnusedStepDelta -= m_stepDelta;
            }
            else // then we don't want to just keep accumulating used step, so pretend we did it all (will still accum the fraction)
            {
                m_totalUnusedStepDelta -= (numWholeStepsRequiredToMeetGraphicsStep * m_stepDelta);
            }

            if (m_singleStep)
            {
                m_playState = false;
                m_singleStep = false;
                m_totalUnusedStepDelta = 0;
                break;
            }

            float realtimeDuration = stepTimer.getElapsedSeconds();
            if (realtimeDuration > m_stepDelta)
            {
                m_inRealTimePlayback = false;
                m_warnNonRealtimeCounter = 3; // sec
                break; // not running in realtime, so do not continue the 'invisible' steps
            }
        }


        if (m_inRealTimePlayback)
        {
            m_warnNonRealtimeCounter -= (graphicsDt / m_playbackSpeed);
            m_warnNonRealtimeCounter = hkMath::max2<float>( m_warnNonRealtimeCounter, 0);
        }

        result = ( numWholeStepsRequiredToMeetGraphicsStep > 0);
    }

    if(m_si->m_commonVdbContext)
    {
        m_si->m_commonVdbContext->syncTimers(m_si->m_threadPool);
    }

    // Step VDB etc
    if (m_display != nullptr)
    {
        m_display->step( graphicsDt );
    }

    hkMonitorStream::getInstance().reset();
    if(m_si->m_threadPool)
    {
        m_si->m_threadPool->clearTimerData();
    }

#ifdef HK_ENABLE_ANIMATION
    if (m_si && m_si->m_animImpl)
    {
        PreviewPluginAnimImpl* anim = (PreviewPluginAnimImpl*)( m_si->m_animImpl ) ;
        animFrameTrackBar->Value = (int)(anim->getCurrentTime() * 100);

        labelAnimFrame->Text = Int32( anim->getCurrentFrame() ).ToString() ;
    }
#endif

    // First Person Controller
#ifdef HK_ENABLE_PHYSICS_2012
    if (m_char)
    {
        hkgKeyboardCLR^ keyBoard = m_display->m_window->getKeyboard();
        hkgPadCLR^ pad = m_display->m_window->getGamePad(0);

        if (keyBoard->wasKeyPressed(HKG_VKEY_ESCAPE))
        {
            deleteFirstPersonController();
            getFlyModeCameraButton()->PerformClick();
        }
        else
        {
            stepFirstPersonController(graphicsDt);

            // Handle gun keys
            hkArray<PreviewAsset*>& assets = m_si->m_assetManager->m_enabledAssets;
            for (int a=0; a<assets.getSize(); ++a)
            {
                PreviewAsset* asset = assets[a];
                for (int i=0; i<asset->m_guns.getSize(); ++i)
                {
                    hkpFirstPersonGun* gun = asset->m_guns[i];

                    if ( pad->isConnected() && (gun->m_keyboardKey >= HKG_VKEY_F2) && (gun->m_keyboardKey <= HKG_VKEY_F5) )
                    {
                        int button = HKG_PAD_BUTTON_0 << (gun->m_keyboardKey - HKG_VKEY_F2);
                        if (pad->wasButtonPressed((hkgPadCLR::Button)button))
                        {
                            m_char->setGun(gun);
                            break;
                        }
                    }


                    if( keyBoard->wasKeyPressed(gun->m_keyboardKey) )
                    {
                        m_char->setGun(gun);
                        break;
                    }
                }
            }
        }

        delete keyBoard;
        delete pad;
    }
#endif

#ifdef HK_ENABLE_PHYSICS
    if ( m_npChar )
    {
        hkgKeyboardCLR^ keyBoard = m_display->m_window->getKeyboard();
        hkgPadCLR^ pad = m_display->m_window->getGamePad(0);

        if ( keyBoard->wasKeyPressed(HKG_VKEY_ESCAPE) )
        {
            deleteFirstPersonController();
            getFlyModeCameraButton()->PerformClick();
        }
        else
        {
            stepFirstPersonControllerNp(graphicsDt);

            // Handle gun keys
            hkArray<PreviewAsset*>& assets = m_si->m_assetManager->m_enabledAssets;
            for (int a = 0; a < assets.getSize(); a++)
            {
                PreviewAsset* asset = assets[a];
                for (int i = 0; i < asset->m_npGuns.getSize(); i++)
                {
                    hknpFirstPersonGun* npGun = asset->m_npGuns[i];

                    if ( pad->isConnected() && (npGun->m_keyboardKey >= HKG_VKEY_F2) && (npGun->m_keyboardKey <= HKG_VKEY_F5) )
                    {
                        int button = HKG_PAD_BUTTON_0 << (npGun->m_keyboardKey - HKG_VKEY_F2);
                        if ( pad->wasButtonPressed((hkgPadCLR::Button)button) )
                        {
                            m_npChar->setGun(npGun);
                            break;
                        }
                    }


                    if( keyBoard->wasKeyPressed(npGun->m_keyboardKey) )
                    {
                        m_npChar->setGun(npGun);
                        break;
                    }
                }
            }
        }

        delete keyBoard;
        delete pad;
    }
#endif

    return result;
}

bool hctPreviewControl::isPlaying()
{
    return (m_si && m_playState && m_si->m_assetManager && (m_si->m_assetManager->m_enabledAssets.getSize() > 0) );
}

void hctPreviewControl::quit()
{
#ifdef HK_ENABLE_PHYSICS_2012
    hkpPhysicsContext* physicsVdbContext = m_si? m_si->m_physicsVdbContext : HK_NULL;
    if (physicsVdbContext)
    {
        physicsVdbContext->removeReference();
    }
#endif

#ifdef HK_ENABLE_PHYSICS
    hknpProcessContext* newPhysicsVdbContext = m_si? m_si->m_newPhysicsVdbContext : HK_NULL;
    if (newPhysicsVdbContext)
    {
        newPhysicsVdbContext->removeReference();
    }
#endif

#ifdef HK_ENABLE_CLOTH_PREVIEW
    hclClothContext* clothVdbContext = m_si? m_si->m_clothVdbContext : HK_NULL;
    if (clothVdbContext)
    {
        clothVdbContext->removeReference();
    }
#endif

#ifdef HK_ENABLE_DESTRUCTION
    hkndProcessContext* ndVdbContext = m_si ? m_si->m_ndVdbContext : HK_NULL;
    if ( ndVdbContext )
    {
        ndVdbContext->removeReference();
    }
#endif

    if (m_si)
    {

#ifdef HK_ENABLE_CLOTH_PREVIEW
        if (m_si->m_clothImpl)
        {
            if(m_clothWindForm)
                delete m_clothWindForm;
            if (m_clothTransitionForm)
                delete m_clothTransitionForm;
            if (m_clothDebugForm)
                delete m_clothDebugForm;
            if (m_clothCollidableForm)
                delete m_clothCollidableForm;
        }
#endif

        // make sure debug display isn't holding onto memory
        // this is because any memory being held onto after this function can crash on dealloc
        // (see EXP-2948).

        if (m_si->m_displayFont)
        {
            m_si->m_displayContext->lock();
                m_si->m_displayFont->removeReference();
            m_si->m_displayContext->unlock();
        }

        if ( m_si->m_displayHandler )
        {
            m_si->m_displayContext->lock();
                hkDebugDisplay::getInstance().removeDebugDisplayHandler( m_si->m_displayHandler );
            m_si->m_displayContext->unlock();
        }

        delete m_si; // will delete assets etc
        m_si = HK_NULL;
    }

    // Get rid of display handler
    if (m_display != nullptr)
    {
        delete m_display; // dispose, will kill vdb etc
        m_display = nullptr;
    }

    if (m_treeViewManager)
    {
        delete m_treeViewManager;
        m_treeViewManager = HK_NULL;
    }
}

void hctPreviewControl::RemoveWorldFromView( void* prevWorld )
{
    if ( !prevWorld || !m_si )
    {
        return;
    }

#ifdef HK_ENABLE_PHYSICS_2012
    if ( m_si->m_physicsVdbContext )
    {
        m_si->m_physicsVdbContext->removeWorld( (hkpWorld*)prevWorld  );
    }
#endif
#ifdef HK_ENABLE_PHYSICS
    if (m_si->m_newPhysicsVdbContext)
    {
        m_si->m_newPhysicsVdbContext->removeWorld( (hknpWorld*)prevWorld  );
    }
#endif
}

void hctPreviewControl::UpdateView( void* prevWorld )
{
    RefreshSceneTreeView();
    RefreshCameraLists();

    if (m_si)
    {

#ifdef HK_ENABLE_PHYSICS_2012
        if (m_si->m_physicsVdbContext && m_si->m_assetManager->m_currentWorld)
        {
            m_si->m_physicsVdbContext->addWorld( m_si->m_assetManager->m_currentWorld  );
        }
#endif
#ifdef HK_ENABLE_PHYSICS
        if (m_si->m_newPhysicsVdbContext && m_si->m_assetManager->m_currentNpWorld )
        {
            m_si->m_newPhysicsVdbContext->addWorld( m_si->m_assetManager->m_currentNpWorld  );
        }
#endif
#ifdef HK_ENABLE_DESTRUCTION
        if ( m_si->m_ndVdbContext && m_si->m_assetManager->m_ndWorld )
        {
            m_si->m_ndVdbContext->addWorld(m_si->m_assetManager->m_ndWorld);
        }
#endif

#ifdef HK_ENABLE_CLOTH_PREVIEW
        if (m_si->m_clothVdbContext && m_si->m_assetManager->m_currentClothWorld)
        {
            m_si->m_clothVdbContext->addWorld( m_si->m_assetManager->m_currentClothWorld );

            // XXX make sure that we disable picking for the particle spheres
            if ( m_si->m_clothImpl )
            {
                PreviewPluginClothImpl* cloth = (PreviewPluginClothImpl*) m_si->m_clothImpl;
                if ( cloth->m_debugParticleRadiusViewer )
                {
                    hclParticleRadiusViewer* pViewer = static_cast<hclParticleRadiusViewer*>(cloth->m_debugParticleRadiusViewer);
                    m_si->m_displayHandler->clearGeometryFlagBits( pViewer->getUnitSphereID(), hkDisplayGeometryFlags::PICKABLE );
                }
            }
        }
#endif

        // enable render post effects known to destruction demo config
#ifdef HK_ENABLE_DESTRUCTION_2012
        if ( !prevWorld && m_si->m_assetManager->m_demoConfig)
        {
            hkStringBuf ssaoEffect( m_si->m_assetManager->m_shaderLibDir.cString(), "\\posteffects\\post_ssao.fx");
            hkStringBuf bloomEffect( m_si->m_assetManager->m_shaderLibDir.cString(), "\\posteffects\\post_bloom.fx");
            hkArray<const char*> effectNames;
            if (m_si->m_assetManager->m_demoConfig->m_enableSSAO)  effectNames.pushBack(ssaoEffect.cString());
            if (m_si->m_assetManager->m_demoConfig->m_enableBloom) effectNames.pushBack(bloomEffect.cString());
            m_si->updatePostEffects(effectNames);
        }
#endif
    }
}


void hctPreviewControl::setContentsFromMemory(System::IntPtr root /* hkRootLevelContainer* */, System::IntPtr vtableReg, bool copy, bool allowInstances)
{
    if (m_si)
    {
        hkRootLevelContainer* r = (hkRootLevelContainer*)root.ToPointer();
        hkResource* rootMem = HK_NULL;
        if (copy && r)
        {
            // Hacky, needed to cleanup everything properly.
            hkReflect::Detail::CloneOnHeap cb;
            r = hkReflect::Cloner().clone(r, cb);
            rootMem = new hkSerialize::Detail::OwnedResource(cb.m_vars.m_vars);
        }

        if (r)
        {
            bool hadAssets = m_si->m_assetManager && m_si->m_assetManager->m_allAssets.getSize() > 0;
            hkRefPtr<hkReferencedObject> prevWorld = HK_NULL;

#ifdef HK_ENABLE_PHYSICS_2012
            if ( m_si->m_assetManager && m_si->m_assetManager->m_currentWorld )
            {
                prevWorld = m_si->m_assetManager->m_currentWorld;
            }
#endif
#ifdef HK_ENABLE_PHYSICS
            if ( m_si->m_assetManager && m_si->m_assetManager->m_currentNpWorld )
            {
                prevWorld = m_si->m_assetManager->m_currentNpWorld;
            }
#endif
            RemoveWorldFromView(prevWorld);

            PreviewAsset* newAsset = new PreviewAsset();
            newAsset->m_container = r;
            newAsset->m_rootMem = rootMem;

            // [HCL-541] // Take a copy of it
            newAsset->makeRewindPoint( HK_NULL );

            m_si->m_assetManager->addAsset(newAsset, allowInstances);
            m_si->m_assetManager->enableAsset(newAsset);
            m_si->notifyAssetAddedOrRemoved();

#ifdef HK_ENABLE_PHYSICS_2012
            if (m_si->m_assetManager->m_currentWorld)
            {
                // Save original gravity as loaded from asset file.
                m_si->m_assetManager->m_loadedGravity = m_si->m_assetManager->m_currentWorld->getGravity();
            }
#endif
#ifdef HK_ENABLE_PHYSICS
            if (m_si->m_assetManager->m_currentNpWorld)
            {
                // Save original gravity as loaded from asset file.
                m_si->m_assetManager->m_loadedGravity = m_si->m_assetManager->m_currentNpWorld->getGravity();
            }
#endif

            bool firstPersonCameraEnabled = false;

#ifdef HK_ENABLE_DESTRUCTION_2012
            if (m_si->m_assetManager->m_destructionWorld && m_si->m_assetManager->m_destructionWorld->m_breakableBodies.getSize())
            {
                restartButton->Enabled = false;
            }
            if ( m_si->m_assetManager->m_demoConfig )
            {
                firstPersonCameraEnabled = true;
            }
#endif
#ifdef HK_ENABLE_DESTRUCTION
            if ( m_si->m_assetManager->m_ndDemoCfg )
            {
                firstPersonCameraEnabled = true;
            }
#endif

            enableFirstPersonCamera(firstPersonCameraEnabled);

            newAsset->removeReference();

            RepopulateMeshChannelMenu();
            //RepopulateClothTransitionForm();

            UpdateView( prevWorld );
            // [HCL-488] on first asset, set camera
            if (!hadAssets)
            {
                PickDefaultCamera();
            }

            reflectClothSettings();

            configureProductsFromUI();
        }
    }
}

System::Void hctPreviewControl::addAssetsFromFile( System::Collections::ArrayList^ files, AddAssetType t )
{
    if (m_si && m_si->m_assetManager)
    {
        hctPreviewLoadingForm^ loadingForm = gcnew hctPreviewLoadingForm();

        Form^ pf = this->FindForm();
        Point p = pf->Location;
        {
            System::Drawing::Size c = pf->Size;
            c.Width /= 2;
            c.Height /= 2;
            c = c - System::Drawing::Size(200, 100);
            p.X += c.Width;
            p.Y += c.Height;
        }
        loadingForm->start(p);
        loadingForm->setMessageAndProgress( "Starting..", 0, true);

        hkRefPtr<hkReferencedObject> prevWorld = HK_NULL;
        if (t == AddAssetType::REPLACE_SCENE)
        {
            clearSceneButton_Click(nullptr, nullptr);
        }
        else
        {
#ifdef HK_ENABLE_PHYSICS_2012
            if ( m_si->m_assetManager && m_si->m_assetManager->m_currentWorld )
            {
                prevWorld = m_si->m_assetManager->m_currentWorld;
            }
#endif
#ifdef HK_ENABLE_PHYSICS
            if ( m_si->m_assetManager && m_si->m_assetManager->m_currentNpWorld )
            {
                prevWorld = m_si->m_assetManager->m_currentNpWorld;
            }
#endif
        }
        RemoveWorldFromView(prevWorld);

        bool hadAssets = m_si->m_assetManager && m_si->m_assetManager->m_allAssets.getSize() > 0;
        for (int c=0; c < files->Count; ++c)
        {
            PreviewAsset* newAsset = new PreviewAsset();
            String^ path = (String^)files[c];

            loadingForm->setMessageAndProgress( gcnew String("Loading [") + path, ( (float)c ) / ((float) files->Count ), false );

            //[EXP-2854] Preview Tool (ToolStandAlone) can not correctly handle, Korean or Chinese Character in filename
            const wchar_t* pathString = (wchar_t*)Marshal::StringToHGlobalUni(path).ToPointer();
            hkStringPtr filename = (char*)hkUtf8::Utf8FromWide(pathString).cString();
            newAsset->loadFromFile(filename);

            if (newAsset->m_container)
            {
                // [HCL-541] // Take a copy of it
                newAsset->makeRewindPoint(HK_NULL);

                bool allowInstance = t != AddAssetType::REPLACE_ASSET_UNDER_DROP;

                m_si->m_assetManager->addAsset(newAsset, allowInstance);
                m_si->m_assetManager->enableAsset(newAsset);
                m_si->notifyAssetAddedOrRemoved();

#ifdef HK_ENABLE_PHYSICS_2012
                if (m_si->m_assetManager->m_currentWorld)
                {
                    // Save original gravity as loaded from asset file.
                    m_si->m_assetManager->m_loadedGravity = m_si->m_assetManager->m_currentWorld->getGravity();
                }
#endif
#ifdef HK_ENABLE_PHYSICS
                if (m_si->m_assetManager->m_currentNpWorld)
                {
                    // Save original gravity as loaded from asset file.
                    m_si->m_assetManager->m_loadedGravity = m_si->m_assetManager->m_currentNpWorld->getGravity();
                }
#endif

                bool firstPersonCameraEnabled = false;

#ifdef HK_ENABLE_DESTRUCTION_2012
                if (m_si->m_assetManager->m_destructionWorld && m_si->m_assetManager->m_destructionWorld->m_breakableBodies.getSize())
                {
                    restartButton->Enabled = false;
                }
                if ( m_si->m_assetManager->m_demoConfig )
                {
                    firstPersonCameraEnabled = true;

                }
#endif
#ifdef HK_ENABLE_DESTRUCTION
                if ( m_si->m_assetManager->m_ndDemoCfg )
                {
                    firstPersonCameraEnabled = true;
                }
#endif

                enableFirstPersonCamera(firstPersonCameraEnabled);

                RepopulateMeshChannelMenu();
                //RepopulateClothTransitionForm();

                // [HCL-488] on first asset, set camera
                if (!hadAssets)
                {
                    PickDefaultCamera();
                }

                report( IConsole::MessageType::REPORT, gcnew String("Loaded data from file : ") + path);
            }
            newAsset->removeReference();
            Marshal::FreeHGlobal(IntPtr((void*)pathString));
        }

        loadingForm->setMessageAndProgress( gcnew String("Done!"), 1, false );

        reflectClothSettings();

        loadingForm->end();

        UpdateView( prevWorld );

        delete loadingForm;

        // Update destruction entities
#ifdef HK_ENABLE_DESTRUCTION
        if ( m_si->m_assetManager->m_ndWorld )
        {
            m_si->m_assetManager->m_ndWorld->updateBodiesArrays();
        }
#endif

        configureProductsFromUI();
    }
}

void hctPreviewControl::setContentsFromFile(String^ path, bool dragIn, int x, int y, bool prompt)
{
    if (path && (path->Length > 0) && m_si)
    {
        if (dragIn && prompt)
        {
            m_delayedDropFiles->Add( path );
            if (!dragDropContextMenuStrip->Visible)
                dragDropContextMenuStrip->Show( x, y );
        }
        else
        {
            // Contents from file, and not dragged in, must be from Open menu, so assume we want to clear scene too.

            Collections::ArrayList^ tl = gcnew Collections::ArrayList();
            tl->Add( path );
            addAssetsFromFile( tl, dragIn? AddAssetType::ADD_ASSET_NO_ASSOCIATE /* augment scene */ : AddAssetType::REPLACE_SCENE /* replace this asset / coming from other tool */);
        }
    }
}

System::Void hctPreviewControl::addWrtAssetMenuItem_Click(System::Object^  sender, System::EventArgs^  e)
{
    if (m_delayedDropFiles->Count > 0)
    {
        addAssetsFromFile( m_delayedDropFiles, AddAssetType::ADD_ASSET_AND_ASSOCIATE_UNDER_DROP);
        m_delayedDropFiles->Clear();

        reflectClothSettings();
    }
}

System::Void hctPreviewControl::replaceThisAssetToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e)
{
    if (m_delayedDropFiles->Count > 0)
    {
        addAssetsFromFile( m_delayedDropFiles, AddAssetType::REPLACE_ASSET_UNDER_DROP );
        m_delayedDropFiles->Clear();

        reflectClothSettings();
    }
}

System::Void hctPreviewControl::addToSceneMenuItem_Click(System::Object^  sender, System::EventArgs^  e)
{
    if (m_delayedDropFiles->Count > 0)
    {
        addAssetsFromFile( m_delayedDropFiles, AddAssetType::ADD_ASSET_NO_ASSOCIATE );
        m_delayedDropFiles->Clear();

        reflectClothSettings();
    }
}

System::Void hctPreviewControl::replaceSceneMenuItem_Click(System::Object^  sender, System::EventArgs^  e)
{
    if (m_delayedDropFiles->Count > 0)
    {
        addAssetsFromFile( m_delayedDropFiles, AddAssetType::REPLACE_SCENE );
        m_delayedDropFiles->Clear();

        reflectClothSettings();
    }
}

System::Void hctPreviewControl::cancelDragDropToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e)
{
    m_delayedDropFiles->Clear();
}

void hctPreviewControl::startDragDrop( System::String^ filename )
{
    // XX can inspect the top level of the file and see what is in it (anims, cloth, physics etc)
    //   in that way we can just displce the drop targets that mean something
    m_displayDropTargets = true;
}

void hctPreviewControl::endDragDrop()
{
    m_displayDropTargets = false;
}

void hctPreviewControl::createFirstPersonController(hkgVector3CLR^ pos, hkgVector3CLR^ dir, hkgVector3CLR^ up /* ignored param */)
{
    bool cursorHidden = false;

#ifdef HK_ENABLE_PHYSICS_2012
    if (m_si && (!m_char))
    {
        hkpWorld* world = m_si->m_assetManager->m_currentWorld;

        if (world)
        {
            world->markForWrite();
            {
                hkpFirstPersonCharacterCinfo* info = new hkpFirstPersonCharacterCinfo;
                HK_PIN_ENTIRE_VECTOR3_HANDLE(dir, dirPtr);
                info->m_direction.load3(dirPtr);
                info->m_direction.normalize3();
                info->m_world = world;
                HK_PIN_ENTIRE_VECTOR3_HANDLE(up, upPtr);
                info->m_up.load3(upPtr);

                // forces the view up vector to be in the opposite to gravity (ignores up arg)
                info->m_up.load4(&m_si->m_assetManager->m_loadedGravity(0));
                info->m_up(0) *= -1.0f;
                info->m_up(1) *= -1.0f;
                info->m_up(2) *= -1.0f;

                info->m_up.normalize3();
                info->m_maxUpDownAngle = HK_REAL_PI * 0.4f;
                info->m_flags = (hkpFirstPersonCharacter::ControlFlags)(info->m_flags | hkpFirstPersonCharacter::DISABLE_JUMP);
                HK_PIN_ENTIRE_VECTOR3_HANDLE(pos, posPtr);
                info->m_position.load3(posPtr);
                // set human proportions (8 head model)
                info->m_capsuleHeight = 1.8f;   // 1.8m size
                info->m_capsuleRadius = 0.25f;  // 50cm waist
                info->m_eyeHeight = 0.85f;      // eyes at 1.65m
                info->m_gravityStrength = 1.0f; // 75kg

                m_char = new hkpFirstPersonCharacter( *info );
                m_char->m_characterRb->getRigidBody()->setMass(75.0f);
                m_char->m_characterRb->getRigidBody()->addProperty(HK_PROPERTY_DISPLAY_SHAPE, 0);
                m_char->m_forwardBackwardSpeedModifier = 0.6f;
                m_char->m_leftRightSpeedModifier       = 0.6f;

                if (m_si->m_assetManager->m_enabledAssets.getSize() && m_si->m_assetManager->m_enabledAssets[0]->m_guns.getSize())
                {
                    m_char->setGun(m_si->m_assetManager->m_enabledAssets[0]->m_guns[0]);
                }
        #ifdef HK_ENABLE_DESTRUCTION_2012
                if (m_si->m_assetManager->m_demoConfig)
                {
                    m_char->getRigidBody()->setPosition(m_si->m_assetManager->m_demoConfig->m_initialCharacterPosition);
                }
        #endif

                world->addEntity( m_char->m_characterRb->getRigidBody() );
                delete info;
            }
            world->unmarkForWrite();

            updateCameraFromFirstPersonController();
        }

        // Hide cursor
        if ( !cursorHidden )
        {
            cursorHidden = true;
            Cursor->Hide();
        }
    }
#endif

#ifdef HK_ENABLE_PHYSICS
    if ( m_si && !m_npChar )
    {
        hknpWorld* npWorld = m_si->m_assetManager->m_currentNpWorld;

        if ( npWorld )
        {
            hknpFirstPersonCharacterCinfo* info = new hknpFirstPersonCharacterCinfo();

            // Set position and direction
            HK_PIN_ENTIRE_VECTOR3_HANDLE(pos, posPtr);
            HK_PIN_ENTIRE_VECTOR3_HANDLE(dir, dirPtr);
            info->m_position.load3(posPtr);
            info->m_direction.load3(dirPtr);
            info->m_direction.normalize<3>();

            // Override position and direction if required
#ifdef HK_ENABLE_DESTRUCTION
            if ( m_si->m_assetManager->m_ndDemoCfg )
            {
                info->m_position.load4(&m_si->m_assetManager->m_ndDemoCfg->m_initialCharacterPosition(0));
                info->m_direction.load4(&m_si->m_assetManager->m_ndDemoCfg->m_initialCharacterDirection(0));
            }
#endif

            // Set human proportions (8 head model)
            info->m_capsuleHeight   = 1.8f;     // 1.8m size
            info->m_capsuleRadius   = 0.25f;    // 50cm waist
            info->m_eyeHeight       = 0.85f;    // eyes at 1.65m
            info->m_gravityStrength = 1.0f;     // 75kg
            info->m_maxUpDownAngle  = HK_REAL_PI * 0.4f;
            info->m_flags           = (hknpFirstPersonCharacter::ControlFlags)(info->m_flags | hknpFirstPersonCharacter::DISABLE_JUMP);

            // Set world and up vector
            info->m_world = npWorld;
            HK_PIN_ENTIRE_VECTOR3_HANDLE(up, upPtr);
            info->m_up.load3(upPtr);

            // Force the view up vector to be in the opposite to gravity (ignores up arg)
            info->m_up.load<4>(&m_si->m_assetManager->m_loadedGravity(0));
            info->m_up(0) *= -1.0f;
            info->m_up(1) *= -1.0f;
            info->m_up(2) *= -1.0f;
            info->m_up.normalize3();

            // Create the character
            m_npChar = new hknpFirstPersonCharacter(*info);
            m_npChar->m_forwardBackwardSpeedModifier = 0.6f;
            m_npChar->m_leftRightSpeedModifier       = 0.6f;

            if ( m_si->m_assetManager->m_enabledAssets.getSize() && m_si->m_assetManager->m_enabledAssets[0]->m_npGuns.getSize() )
            {
                m_npChar->setGun(m_si->m_assetManager->m_enabledAssets[0]->m_npGuns[0]);
            }

            npWorld->commitAddBodies();
            delete info;

            updateCameraFromFirstPersonController();

#ifdef HK_ENABLE_DESTRUCTION
            if ( m_si->m_assetManager->m_ndDemoCfg )
            {
                m_npChar->m_currentAngle = -0.5f * HK_REAL_PI;
                m_npChar->setForwardDir(m_si->m_assetManager->m_ndDemoCfg->m_initialCharacterDirection);
            }
#endif
        }

        // Hide cursor
        if ( !cursorHidden )
        {
            cursorHidden = true;
            Cursor->Hide();
        }
    }
#endif
}

void hctPreviewControl::deleteFirstPersonController()
{
    bool cursorShown = false;

#ifdef HK_ENABLE_PHYSICS_2012
    if (m_si && m_char)
    {
        hkpWorld* world = m_si->m_assetManager->m_currentWorld;

        if (world)
        {
            world->markForWrite();

            world->removeEntity(m_char->m_characterRb->getRigidBody());
            m_char->removeReference();
            m_char = HK_NULL;

            world->unmarkForWrite();
        }

        if ( !cursorShown )
        {
            cursorShown = true;
            Cursor->Show();
        }
    }
#endif

#ifdef HK_ENABLE_PHYSICS
    if ( m_si && m_npChar )
    {
        hknpWorld* npWorld = m_si->m_assetManager->m_currentNpWorld;

        if ( npWorld )
        {
            m_npChar->removeReference();
            m_npChar = HK_NULL;
        }

        if ( !cursorShown )
        {
            cursorShown = true;
            Cursor->Show();
        }
    }
#endif
}

void hctPreviewControl::updateContentsFromPackfile(array< System::Byte >^ data)
{
    if (m_si)
    {
        bool hadAssets = m_si->m_assetManager && m_si->m_assetManager->m_allAssets.getSize() > 0;
        hkRefPtr<hkReferencedObject> prevWorld = HK_NULL;
#ifdef HK_ENABLE_PHYSICS_2012
        if ( m_si->m_assetManager && m_si->m_assetManager->m_currentWorld )
        {
            prevWorld = m_si->m_assetManager->m_currentWorld;
        }
#endif
#ifdef HK_ENABLE_PHYSICS
        if ( m_si->m_assetManager && m_si->m_assetManager->m_currentNpWorld )
        {
            prevWorld = m_si->m_assetManager->m_currentNpWorld;
        }
#endif
        RemoveWorldFromView(prevWorld);

        int packfileSize = data->Length;
        pin_ptr<unsigned char> packfileDataPtr = &data[0];
        hkMemoryStreamReader mem( packfileDataPtr, packfileSize, hkMemoryStreamReader::MEMORY_INPLACE);

        PreviewAsset* newAsset = new PreviewAsset();
        newAsset->loadFromStream( &mem );

        if (newAsset->m_container)
        {
            newAsset->makeRewindPoint(HK_NULL);

            m_si->m_assetManager->addAsset(newAsset, false);
            m_si->m_assetManager->enableAsset(newAsset);
            m_si->notifyAssetAddedOrRemoved();

#ifdef HK_ENABLE_PHYSICS_2012
            if (m_si->m_assetManager->m_currentWorld)
            {
                // Save original gravity as loaded from asset file.
                m_si->m_assetManager->m_loadedGravity = m_si->m_assetManager->m_currentWorld->getGravity();
            }
#endif
#ifdef HK_ENABLE_PHYSICS
            if (m_si->m_assetManager->m_currentNpWorld)
            {
                // Save original gravity as loaded from asset file.
                m_si->m_assetManager->m_loadedGravity = m_si->m_assetManager->m_currentNpWorld->getGravity();
            }
#endif

            bool firstPersonCameraEnabled = false;

        #ifdef HK_ENABLE_DESTRUCTION_2012
            if (m_si->m_assetManager->m_destructionWorld && m_si->m_assetManager->m_destructionWorld->m_breakableBodies.getSize())
            {
                restartButton->Enabled = false;
            }
            if ( m_si->m_assetManager->m_demoConfig )
            {
                firstPersonCameraEnabled = true;
            }
        #endif
#ifdef HK_ENABLE_DESTRUCTION
            if ( m_si->m_assetManager->m_ndDemoCfg )
            {
                firstPersonCameraEnabled = true;
            }
#endif

            enableFirstPersonCamera(firstPersonCameraEnabled);

            RepopulateMeshChannelMenu();
            RepopulateClothTransitionForm();

            UpdateView( prevWorld );

            // [HCL-488] on first asset, set camera
            if (!hadAssets)
            {
                PickDefaultCamera();
            }
            reflectClothSettings();

            configureProductsFromUI();
        }
        newAsset->removeReference();
    }
}



void hctPreviewControl::preWorldRender( hkgViewportCLR^ v )
{

}

void hctPreviewControl::postWorldRender( hkgViewportCLR^ v )
{
    for (int i=0; m_si && (i < m_si->m_allImpls.getSize()); ++i)
    {
        if (m_si->m_allImpls[i])
        {
            m_si->m_allImpls[i]->render( );
        }
    }

    hkgWindowCLR^ windowCLR = v->getOwnerWindow();
    hkgDisplayContextCLR^ contextCLR = windowCLR->getContext();
    IntPtr ctxPtr = contextCLR->getInternalPtr();
    hkgDisplayContext* context = (hkgDisplayContext*) ctxPtr.ToPointer();

    context->lock();

    if (m_si->m_currentSelectedObject)
    {
        if (!m_si->m_displayWorld->containsDisplayObject(m_si->m_currentSelectedObject))
        {
            m_si->m_currentSelectedObject = HK_NULL;
        }
        else
        {
            context->pushMatrix();
            context->multMatrix(m_si->m_currentSelectedObject->getTransform());

            float ext[3];
            float center[3];
            float p[3];
            hkgVec3Copy( ext, m_si->m_currentSelectedObject->getAABBExtPtr() );
            hkgVec3Copy( center, m_si->m_currentSelectedObject->getAABBCentPtr() );
            hkgVec3Scale( ext, 1.1f );

            context->matchState( HKG_ENABLED_ALPHABLEND | HKG_ENABLED_ZREAD | HKG_ENABLED_ZWRITE, context->getCullfaceMode(), HKG_BLEND_ADD, context->getAlphaSampleMode());
            context->setBlendState(true);

            // Draw some reference box around the picked object
            if (m_displayBoundingBox)
            {
                context->beginGroup(HKG_IMM_LINES);

                float v[8][3];
                unsigned int i,j;

                /*
                y
                |
                2----3     6----7
                | -z |     | +z |
                0----1-x   4----5
                */

                for (i = 0; i < 8; ++i)
                    for (j = 0; j < 3; ++j)
                        v[i][j] = center[j] + 2.0f * ext[j] * ( -0.5f + (float) ( (i >> j) & 1 ) );

                float boxColor[4] = {1.0f, 0.0f, 0.0f, 0.3f};
                context->setCurrentColor4(boxColor);

                const int cubeIdx[24] = {0,1,1,3,3,2,2,0,4,5,5,7,7,6,6,4,0,4,1,5,3,7,2,6};
                for (int i=0; i<24; ++i)
                {
                    context->setCurrentPosition( v[cubeIdx[i]] );
                }
                context->endGroup();
            }

            // local origin:
            float extMax = HKG_MAX( HKG_MAX( ext[0], ext[1] ), ext[2] );
            bool inDisplayMove = m_si->m_currentPickedObject && !m_si->m_currentPickOwner;
            bool inRotateMode = inDisplayMove && context->getOwner()->getInputManager()->getKeyboard().getKeyState( HKG_VKEY_CONTROL );
            float axisSize = inRotateMode? (extMax * 0.33f) : (inDisplayMove? extMax : (extMax * 0.33f));
            {
                context->beginGroup(HKG_IMM_LINES);

                context->setCurrentColor3(HKG_VEC3_X);
                context->setCurrentPosition( HKG_VEC3_ZERO );
                hkgVec3Set(p, axisSize, 0, 0);
                context->setCurrentPosition( p );

                context->setCurrentColor3(HKG_VEC3_Y);
                context->setCurrentPosition( HKG_VEC3_ZERO );
                hkgVec3Set(p, 0, axisSize, 0);
                context->setCurrentPosition( p );

                context->setCurrentColor3(HKG_VEC3_Z);
                context->setCurrentPosition( HKG_VEC3_ZERO );
                hkgVec3Set(p, 0, 0, axisSize);
                context->setCurrentPosition( p );

                if (inRotateMode)
                {
                    int numSeg = 40;
                    float twpPiDivSeg = (2*HKG_PI) / float(numSeg);
                    float prevcS = extMax;
                    float prevsS = 0;
                    for (int s=1; s < (numSeg + 1); ++s)
                    {
                        float v = twpPiDivSeg * s;
                        float cS = hkg_cos( v ) * extMax;
                        float sS = hkg_sin( v ) * extMax;

                        // X
                        context->setCurrentColor3(HKG_VEC3_X);
                        hkgVec3Set(p, prevsS, prevcS, 0);
                        context->setCurrentPosition( p);
                        hkgVec3Set(p, sS, cS, 0);
                        context->setCurrentPosition( p );

                        //Y
                        context->setCurrentColor3(HKG_VEC3_Y);
                        hkgVec3Set(p, 0, prevsS, prevcS);
                        context->setCurrentPosition( p);
                        hkgVec3Set(p, 0, sS, cS);
                        context->setCurrentPosition( p );

                        // Z
                        context->setCurrentColor3(HKG_VEC3_Z);
                        hkgVec3Set(p, prevcS, 0, prevsS);
                        context->setCurrentPosition( p);
                        hkgVec3Set(p, cS, 0, sS);
                        context->setCurrentPosition( p );

                        prevcS = cS;
                        prevsS = sS;
                    }
                }

                context->endGroup();
            }

            context->popMatrix();
        }
    }

    if (m_si && m_si->m_assetManager && m_displayDropTargets)
    {
        hkArray< PreviewAssetManager::DropTarget > targets;
        targets.reserve( 100 );
        m_si->m_assetManager->getDropTargets( targets );
        if (targets.getSize() > 0)
        {
            context->matchState( HKG_ENABLED_ALPHABLEND | HKG_ENABLED_ZREAD, HKG_CULLFACE_CCW, HKG_BLEND_ADD, context->getAlphaSampleMode() );
            for (int ti=0; ti < targets.getSize(); ++ti)
            {
                targets[ti].drawTriangles(context);
            }

        }
    }

    // On screen text info

    bool needText = m_warnNonRealtimeCounter > 0;
    if (m_si && m_si->m_displayFont && needText)
    {
        hkgWindow* win = (hkgWindow*) windowCLR->getInternalPtr().ToPointer();
        hkgViewport* curView = (hkgViewport*) v->getInternalPtr().ToPointer();
        hkgFont* font = m_si->m_displayFont;

        win->getWindowOrthoView()->setDesiredState( win->getWindowOrthoView()->getDesiredState() | HKG_ENABLED_TEXTURE2D );
        win->getWindowOrthoView()->setAsCurrent( context );
        font->setDrawState( context );

        float y = 10.0f;
        float x = 10.0f;
        if (m_warnNonRealtimeCounter > 0)
        {
            float alpha = (m_warnNonRealtimeCounter / 3); //1..0 over 3 secs
            float black[] = { 0,0,0, 0.85f * alpha };
            float red[] = { 0.8f,0.2f,0.2f, 0.85f * alpha };

            const char text[] = "Not in real-time, step taking too long compared to playback speed";
            font->render( context, text, x+2, y-1, black);
            font->render( context, text, x,y, red);
        }

        // reset
        curView->setAsCurrent( context );
    }


    if (m_display)
    {
        m_display->renderImmediate();
    }

    context->unlock();

    delete contextCLR;
    delete windowCLR;
}


//Managed to unmanaged
void convertPickInfo( Havok::Tool::PickInfo^ pi, PreviewPluginProductImpl::ObjectPickInfo& opi )
{
    opi.m_object = (hkgDisplayObject*) pi->m_object->getInternalPtr().ToPointer();
    opi.m_faceSetIndex = pi->m_faceSetIndex;
    opi.m_geomIndex = pi->m_geomIndex;
    opi.m_facePrimIndex = pi->m_faceSetIndex;
    opi.m_faceIndex = pi->m_faceSetIndex;
    opi.m_vertexIndices[0] = pi->m_vertexIndices[0];
    opi.m_vertexIndices[1] = pi->m_vertexIndices[1];
    opi.m_vertexIndices[2] = pi->m_vertexIndices[2];
    opi.m_localPos[0] = pi->m_localPos->X;
    opi.m_localPos[1] = pi->m_localPos->Y;
    opi.m_localPos[2] = pi->m_localPos->Z;
    opi.m_closestVert = pi->m_closestVert;
}



hkgDisplayObjectCLR^ hctPreviewControl::getSelectedDisplayObject()
{
    hkgDisplayObject* selected = m_si->m_currentSelectedObject;

    if ( selected && m_display != nullptr)
    {
        hkgDisplayWorldCLR^ world = m_display->m_world;

        for (int d=0; d<world->getNumDisplayObjects(); ++d)
        {
            hkgDisplayObjectCLR^ dObj = world->getDisplayObject(d);
            hkgDisplayObject* coreObj = (hkgDisplayObject*)( dObj->getInternalPtr().ToPointer() );

            if (coreObj == selected)
            {
                return dObj;
            }
            else
            {
                delete dObj;
            }
        }
    }

    return nullptr;
}


void hctPreviewControl::objectPicked(PickInfo^ obj, hkgVector3CLR^ worldPos)
{
    hkgDisplayObject* coreObj = (hkgDisplayObject*)( obj->m_object->getInternalPtr().ToPointer() );
    m_si->m_currentPickedObject = coreObj;
    m_si->m_currentSelectedObject = coreObj;
    m_si->m_currentPickOwner = HK_NULL;

    if (coreObj)
    {
        // update Display props UI:
        shadowCasterCheckBox->Checked = (coreObj->getStatusFlags() & HKG_DISPLAY_OBJECT_SHADOWCASTER) != 0;
        shadowRecvCheckBox->Checked = (coreObj->getStatusFlags() & HKG_DISPLAY_OBJECT_SHADOWRECEIVER) != 0;
        litCheckBox->Checked = (coreObj->getStatusFlags() & HKG_DISPLAY_OBJECT_UNLIT) == 0;
        displayObjectNameLabel->Text = gcnew String(coreObj->m_name.cString());

        // pick info
        float ti[16]; hkgMat4Invert(ti, coreObj->getTransform() );
        HK_PIN_ENTIRE_VECTOR3_HANDLE(worldPos, wp);
        hkgVec3Transform(m_si->m_currentPickedObjectLocalPoint, wp, ti);

        // see if it has an owner:
        for (int i=0; m_si && (i < m_si->m_allImpls.getSize()); ++i)
        {
            if (m_si->m_allImpls[i]->ownsDisplayObject(coreObj))
            {
                m_si->m_currentPickOwner = m_si->m_allImpls[i];
                PreviewPluginProductImpl::ObjectPickInfo opi;
                convertPickInfo( obj, opi);
                m_si->m_currentPickOwner->objectPicked(opi, wp);
                return;
            }
        }
    }
    else
    {
        displayObjectNameLabel->Text = "<none>";
    }
}
#pragma unmanaged
static void _rotate( float* tnew, const float* t, float* origLocalPoint, float* newLocalPoint)
{
    hkVector4 d0v; d0v.set( origLocalPoint[0], origLocalPoint[1], origLocalPoint[2]);
    hkVector4 d1v; d1v.set( newLocalPoint[0], newLocalPoint[1], newLocalPoint[2]);
    d0v.normalize3();
    d1v.normalize3();

    if (d0v.dot3(d1v) > 0.9999f)
    {
        hkgMat4Copy(tnew, t);
        return;
    }

    hkVector4 axis; axis.setCross(d0v, d1v);
    axis.normalize3();

    float cosAngle = d0v.dot3(d1v);
    float angle = hkMath::acos( cosAngle );

    hkRotation rot;
    rot.setAxisAngle( axis, angle );

    hkTransform tm; tm.set4x4ColumnMajor( t );
    tm.getRotation().mul( rot );
    tm.get4x4ColumnMajor( tnew );
}

static void _transform( PreviewPluginImpl* si, float* wp )
{
    // do either a rotate or a translate.
    // Decide based on key state of Ctrl
    bool rotateMode = si->m_displayContext->getOwner()->getInputManager()->getKeyboard().getKeyState( HKG_VKEY_CONTROL );

    const float* t = si->m_currentPickedObject->getTransform();
    HK_ALIGN16( float newTransform[16] );
    if (rotateMode)
    {
        float pointLocal[3];
        float tInv[16]; hkgMat4Invert(tInv, t);
        hkgVec3Transform( pointLocal, wp, tInv );

        _rotate( newTransform, t, si->m_currentPickedObjectLocalPoint, pointLocal );
    }
    else // translate
    {
        float diff[3];
        float curPickedPointWorld[3];
        hkgVec3Transform( curPickedPointWorld, si->m_currentPickedObjectLocalPoint, t );
        hkgVec3Sub( diff, wp, curPickedPointWorld );
        hkgMat4Copy( newTransform, t );
        hkgVec3Add( &newTransform[12], diff );
    }

    if (si->m_currentPickOwner)
        si->m_currentPickOwner->objectTransform( newTransform );
    si->m_currentPickedObject->setTransform( newTransform );
}

#pragma managed

void hctPreviewControl::objectMoved( hkgVector3CLR^ worldPos )
{
    if (m_si && m_si->m_currentPickedObject)
    {
        HK_PIN_ENTIRE_VECTOR3_HANDLE(worldPos, wp);
        if (m_playState && m_si->m_currentPickOwner && !m_si->m_currentPickOwner->objectAllowTransformInsteadOfMove())
        {
            m_si->m_currentPickOwner->objectMoved(wp);
        }
        else
        {
            _transform( m_si, wp );
        }
    }
}

void hctPreviewControl::objectReleased( )
{
    if (m_si)
    {
        if (m_si->m_currentPickOwner)
        {
            m_si->m_currentPickOwner->objectReleased();
        }
        m_si->m_currentPickOwner = HK_NULL;
        m_si->m_currentPickedObject = HK_NULL;
    }
}

void hctPreviewControl::getDataAndClassForObject( PickInfo^ objectDisplayInfo, HavokReflectedObject% obj)
{
    hkgDisplayObject* coreObj = (hkgDisplayObject*)( objectDisplayInfo->m_object->getInternalPtr().ToPointer() );
    for (int i=0; i < m_si->m_allImpls.getSize(); ++i)
    {
        if (m_si->m_allImpls[i]->ownsDisplayObject(coreObj))
        {
            m_si->m_currentTweakOwner = m_si->m_allImpls[i];

            PreviewPluginProductImpl::ObjectPickInfo opi;
            convertPickInfo( objectDisplayInfo, opi);

            void* dataPtr = HK_NULL;
            const hkReflect::Type* klassPtr = HK_NULL;
            m_si->m_currentTweakOwner->tweakGetDataAndClass( opi, dataPtr, klassPtr );

            obj.instance = IntPtr( dataPtr );
            obj.klass = IntPtr( (void*)klassPtr );

            return;
        }
    }
}

void hctPreviewControl::verifyClass( System::IntPtr klass)
{
    if (m_si && m_si->m_currentTweakOwner)
    {
        m_si->m_currentTweakOwner->tweakVerifyClass( (const hkReflect::Type*)klass.ToPointer() );
    }
}

void hctPreviewControl::commit( HavokReflectedObject origObject, System::IntPtr newData )
{
    if (m_si && m_si->m_currentTweakOwner)
    {
        m_si->m_currentTweakOwner->tweakCommit( (void*)origObject.instance.ToPointer(), (const hkReflect::Type*)origObject.klass.ToPointer(), (void*)newData.ToPointer() );
    }
}

void hctPreviewControl::setParentControl( System::Windows::Forms::Control^ parent, IConsole^ errorConsole )
{
    m_errorConsole = errorConsole;

    System::Windows::Forms::Control::ControlCollection^ ctrls = parent->Controls;
    this->Dock = DockStyle::Fill;
    ctrls->Add( this ); //.. simple as that
}


void hctPreviewControl::setPluginOwner( IPluginOwner^ owner )
{

}

System::IntPtr hctPreviewControl::getObjectOfType( System::IntPtr klass )
{
    // WARNING!
    // <ib.todo: getObjectOfType hkpWorld hardcoded in previewPlugin >
    // loop over everything in m_assetManager
#ifdef HK_ENABLE_PHYSICS_2012
    hkpWorld* world = m_si->m_assetManager->m_currentWorld;
    return System::IntPtr(m_si->m_assetManager->m_currentWorld);
#elif HK_ENABLE_PHYSICS
    hknpWorld* world = m_si->m_assetManager->m_currentNpWorld;
    return System::IntPtr(m_si->m_assetManager->m_currentNpWorld);
#else
    return System::IntPtr(0);
#endif
}

void hctPreviewControl::setParentMenu( System::Windows::Forms::MenuStrip^ parent )
{
    // can add a menu item drop down etc to the parent if you like here
    m_parentMenu = parent;
}


void hctPreviewControl::setNavigationToolBar( System::Windows::Forms::ToolStrip^ navigationToolBar )
{
    m_navigationToolBar = navigationToolBar;
}


System::Void hctPreviewControl::litCheckBox_CheckedChanged(System::Object^  sender, System::EventArgs^  e)
{
    if (m_si && m_si->m_currentSelectedObject)
    {
        if ( litCheckBox->Checked )
            m_si->m_currentSelectedObject->setStatusFlags( m_si->m_currentSelectedObject->getStatusFlags() & ~HKG_DISPLAY_OBJECT_UNLIT );
        else
            m_si->m_currentSelectedObject->setStatusFlags( m_si->m_currentSelectedObject->getStatusFlags() | HKG_DISPLAY_OBJECT_UNLIT );
    }
}

System::Void hctPreviewControl::shadowCasterCheckBox_CheckedChanged(System::Object^  sender, System::EventArgs^  e)
{
    if (m_si && m_si->m_currentSelectedObject)
    {
        if ( shadowCasterCheckBox->Checked )
            m_si->m_currentSelectedObject->setStatusFlags( m_si->m_currentSelectedObject->getStatusFlags() | HKG_DISPLAY_OBJECT_SHADOWCASTER );
        else
            m_si->m_currentSelectedObject->setStatusFlags( m_si->m_currentSelectedObject->getStatusFlags() & ~HKG_DISPLAY_OBJECT_SHADOWCASTER );
    }
}


System::Void hctPreviewControl::shadowRecvCheckBox_CheckedChanged(System::Object^  sender, System::EventArgs^  e)
{
    if (m_si && m_si->m_currentSelectedObject)
    {
        if ( shadowRecvCheckBox->Checked )
            m_si->m_currentSelectedObject->setStatusFlags( m_si->m_currentSelectedObject->getStatusFlags() | HKG_DISPLAY_OBJECT_SHADOWRECEIVER );
        else
            m_si->m_currentSelectedObject->setStatusFlags( m_si->m_currentSelectedObject->getStatusFlags() & ~HKG_DISPLAY_OBJECT_SHADOWRECEIVER );
    }
}


System::Void hctPreviewControl::showBoundingBoxCheckbox_CheckedChanged(System::Object^  sender, System::EventArgs^  e)
{
    m_displayBoundingBox = showBoundingBoxCheckbox->Checked;
}

System::Void hctPreviewControl::postEffectsButton_Click(System::Object^  sender, System::EventArgs^  e)
{
    String^ shaderLib = (m_si && m_si->m_assetManager)? gcnew String( m_si->m_assetManager->m_shaderLibDir.cString() ) : nullptr;
    if (shaderLib != nullptr && (shaderLib->Length > 0) )
    {
        String^ effectsLib = shaderLib + "\\posteffects";
        if (System::IO::Directory::Exists( effectsLib ))
        {
            hctPreviewPostEffectSelect^ effects = gcnew hctPreviewPostEffectSelect();
            if ( effects->Populate(effectsLib, IntPtr( (void*) m_si->m_displayContext ) ) )
            {
                // Select the ones we have already
                {
                    hkArray<const char*> prevEffectNames;
                    m_si->getCurrentPostEffects( prevEffectNames );
                    ::cli::array<String^>^ prevEffectNamesM = gcnew ::cli::array<String^>( prevEffectNames.getSize() );
                    for (int pi=0; pi <  prevEffectNames.getSize(); ++pi)
                    {
                        prevEffectNamesM[pi] = gcnew String( prevEffectNames[pi] );
                    }
                    effects->SelectEffects( prevEffectNamesM );
                }

                if ( effects->ShowDialog( this->FindForm() ) == ::DialogResult::OK )
                {
                    // Add them to the hkgWindow
                    CheckedListBox::CheckedIndexCollection^ checkedEffects = effects->effectCheckedListBox->CheckedIndices;
                    hkArray<const char*> effectFileNames;
                    for (int ei=0; ei < checkedEffects->Count; ++ei)
                    {
                        effectFileNames.pushBack( (char*)Marshal::StringToHGlobalAnsi( effects->effectPathNames[ checkedEffects[ei] ]  ).ToPointer() );
                    }

                    m_si->updatePostEffects( effectFileNames );

                    for (int eei=0; eei < effectFileNames.getSize(); ++eei)
                    {
                        Marshal::FreeHGlobal( System::IntPtr( (void*)effectFileNames[eei] ) );
                    }

                }
            }
            else
            {
                MessageBox::Show( this->FindForm(), "No posteffects found for current  in 'shaderlib/posteffect' dir found in HCT install.");
            }

            return;
        }
    }

    MessageBox::Show( this->FindForm(), "No 'shaderlib/posteffect' dir found in HCT install.");

}

System::Void hctPreviewControl::adjustEffectsButton_Click(System::Object^  sender, System::EventArgs^  e)
{
    if (m_si)
    {
        hkArray<const char*> curEffectNames;
        m_si->getCurrentPostEffects( curEffectNames );
        if ( curEffectNames.getSize() > 0)
        {
            hctPreviewPostEffectAdjust^ form = gcnew hctPreviewPostEffectAdjust(  );
            form->Populate( IntPtr( m_si->m_displayContext ) );
            form->Show(this); // non modal / tweak mode
        }
        else
        {
            MessageBox::Show( this->FindForm(), "No Current Post Effects to edit. Use Add Effects button to change current enabled effects.");
        }
    }
}


System::Void hctPreviewControl::restartButton_Click(System::Object^  sender, System::EventArgs^ e)
{
    // [HCL-528]
    // reload all assets (will only work for file based assets, ones that came from mem have already mucked up
    // thier source asset, so that needs a copy like the old preview so we can reset)
    // for now:
    if (m_si && m_si->m_assetManager)
    {
        m_restart = true;
        int memBasedAssets = 0;
        for (int a=0; a < m_si->m_assetManager->m_allAssets.getSize(); ++a )
        {
            PreviewAsset* asset = m_si->m_assetManager->m_allAssets[a];
            bool wasEnabled = m_si->m_assetManager->isEnabled(asset);

            // Remove
            if (asset->m_rewindPoint.getSize() > 0)
            {
                asset->addReference();
                m_si->m_assetManager->removeAsset(asset);

                // Was the asset removed (in which case assets with indices a < index < n were shunted down to  a <= index < n-1)?
                if (m_si->m_assetManager->m_allAssets.indexOf(asset) < 0)
                {
                    // If so, add a new one in its place
                    PreviewAsset* newAsset = new PreviewAsset();
                    hkIstream memStream(asset->m_rewindPoint.begin(), asset->m_rewindPoint.getSize());
                    newAsset->loadFromStream( memStream.getStreamReader() );
                    newAsset->m_rewindPoint.insertAt(0, asset->m_rewindPoint.begin(), asset->m_rewindPoint.getSize() );

                    // Might as well leave the asset filename intact (used in the tree view)
                    newAsset->m_filename = asset->m_filename;

                    // Add new asset at index a, shunting others up, thus preserving asset order
                    m_si->m_assetManager->m_allAssets.insertAt(a, newAsset);

                    if (wasEnabled)
                    {
                        m_si->m_assetManager->enableAsset(newAsset);
                    }

                    bool firstPersonCameraEnabled = false;

#ifdef HK_ENABLE_DESTRUCTION_2012
                    if (m_si->m_assetManager->m_destructionWorld && m_si->m_assetManager->m_destructionWorld->m_breakableBodies.getSize())
                    {
                        restartButton->Enabled = false;
                    }
                    if ( m_si->m_assetManager->m_demoConfig )
                    {
                        firstPersonCameraEnabled = true;
                    }
#endif
#ifdef HK_ENABLE_DESTRUCTION
                    if ( m_si->m_assetManager->m_ndDemoCfg )
                    {
                        firstPersonCameraEnabled = true;
                    }
#endif

                    enableFirstPersonCamera(firstPersonCameraEnabled);
                }

                asset->removeReference();
            }
            else
            {
                HK_WARN_ALWAYS(0xabbaeab0, "Zero size asset found, can't reset it");
            }

            m_si->notifyAssetAddedOrRemoved();
            RepopulateMeshChannelMenu();
            RepopulateClothTransitionForm();
        }

        // Refresh the treeview if any asset was reloaded, since then some variants in the tree
        // still contain pointers to objects in the old asset.
        RefreshSceneTreeView();

        reflectClothSettings();
    }
}

System::Void hctPreviewControl::playPauseButton_Click(System::Object^  sender, System::EventArgs^  e)
{
    if (playPauseButton->ImageIndex == 0) // Play
    {
        playPauseButton->ImageIndex = 1; // Pause
        m_playState = true;
    }
    else
    {
        playPauseButton->ImageIndex = 0;
        m_playState = false;
    }
}

System::Void hctPreviewControl::singleStepButton_Click(System::Object^  sender, System::EventArgs^  e)
{
    m_playState = true;
    m_singleStep = true;
    m_totalUnusedStepDelta = m_stepDelta + 0.1f;// make sure we get to step, no matter how soon it is
    playPauseButton->ImageIndex = 0; // change to Play icon
}

#define MIN_HZ 1.0f
#define MAX_HZ 300.0f

System::Void hctPreviewControl::stepSizeNumericUpDowm_ValueChanged(System::Object^  sender, System::EventArgs^  e)
{
    System::Decimal v = stepSizeNumericUpDowm->Value;
    float proposedHz = System::Decimal::ToSingle( v );
    if (proposedHz < MIN_HZ)
    {
        m_stepDelta = 1.0f / MIN_HZ;
    }
    else if (proposedHz > MAX_HZ)
    {
        m_stepDelta = 1.0f / MAX_HZ;
    }
    else
    {
        m_stepDelta = 1.0f / proposedHz;
    }
}

System::Void hctPreviewControl::stepSizeHalfButton_Click(System::Object^  sender, System::EventArgs^  e)
{
    float proposedDT = m_stepDelta * 2; // half hz == double delta
    float proposedHz = 1 / proposedDT;
    if (proposedHz < MIN_HZ)
    {
        proposedHz = MIN_HZ;
    }
    else if (proposedHz > MAX_HZ)
    {
        proposedHz = MAX_HZ;
    }

    proposedHz = hkMath::floor(proposedHz ); // clamp to no decimal places as no need.
    proposedDT = 1.0f / proposedHz;

    stepSizeNumericUpDowm->Value = System::Decimal( proposedHz );
    m_stepDelta = proposedDT;
}

System::Void hctPreviewControl::stepSizeDoubleButton_Click(System::Object^  sender, System::EventArgs^  e)
{
    float proposedDT = m_stepDelta / 2; // double hz == half delta
    float proposedHz = 1 / proposedDT;
    if (proposedHz < MIN_HZ)
    {
        proposedHz = MIN_HZ;
    }
    else if (proposedHz > MAX_HZ)
    {
        proposedHz = MAX_HZ;
    }

    proposedHz = hkMath::floor(proposedHz ); // clamp to no decimal places as no need.
    proposedDT = 1.0f / proposedHz;

    stepSizeNumericUpDowm->Value = System::Decimal( proposedHz );
    m_stepDelta = proposedDT;
}

System::Void hctPreviewControl::realtimeCheckBox_CheckedChanged(System::Object^  sender, System::EventArgs^  e)
{
    m_allowSubsteps = realtimeCheckBox->Checked;
}

#define MIN_SPEED 20.0f  //(0.2x)
#define MAX_SPEED 400.0f //(4x)

System::Void hctPreviewControl::playSpeedTrackBar_Scroll(System::Object^  sender, System::EventArgs^  e)
{
    System::Decimal v = playSpeedTrackBar->Value;
    float proposedSpeed = System::Decimal::ToSingle(v);
    if (proposedSpeed < MIN_SPEED)
    {
        proposedSpeed = MIN_SPEED;
    }
    else if (proposedSpeed > MAX_SPEED)
    {
        proposedSpeed = MAX_SPEED;
    }

    proposedSpeed = hkMath::floor(proposedSpeed );
    float proposedPercent = proposedSpeed / 100.0f;

    playSpeedNumericUpDown->Value = System::Decimal( proposedSpeed );
    m_playbackSpeed = proposedPercent;
}

System::Void hctPreviewControl::playSpeedNumericUpDown_ValueChanged(System::Object^  sender, System::EventArgs^  e)
{
    System::Decimal v = playSpeedNumericUpDown->Value;
    float proposedSpeed = System::Decimal::ToSingle(v);
    if (proposedSpeed < MIN_SPEED)
    {
        proposedSpeed = MIN_SPEED;
    }
    else if (proposedSpeed > MAX_SPEED)
    {
        proposedSpeed = MAX_SPEED;
    }

    proposedSpeed = hkMath::floor(proposedSpeed );
    float proposedPercent = proposedSpeed / 100.0f;

    playSpeedTrackBar->Value = hkMath::hkFloorToInt( proposedSpeed );
    m_playbackSpeed = proposedPercent;
}

System::Void hctPreviewControl::rendererLabel_Click(System::Object^  sender, System::EventArgs^  e)
{
    hctPreviewChooseRendererForm^ cf = gcnew hctPreviewChooseRendererForm();
    if ( cf->ShowDialog(this) == ::DialogResult::OK )
    {
        // Set the reg and indicate that they should restart the app.

#ifdef HK_PLATFORM_WIN64
        String^ keyName = "HKEY_CURRENT_USER\\Software\\Havok\\ManagedTools_x64";
#else
        String^ keyName = "HKEY_CURRENT_USER\\Software\\Havok\\ManagedTools";
#endif
        Registry::SetValue( keyName, "Renderer", ((hctPreviewChooseRendererFormItem^)cf->rendererListBox->SelectedItem)->renderer.ToString() );
        Registry::SetValue( keyName, "MSAA", ((hctPreviewChooseRendererFormItem^)cf->rendererListBox->SelectedItem)->msaa? "True" : "False" );

        rendererLabel->Text = "(RESTART TO INIT NEW RENDERER)";
    }
}



void FindShaderLibDir( hkStringOld& dir )
{
    dir = "";

#ifdef HK_PLATFORM_WIN64
    bool try64bit = true;
#else
    bool try64bit = false;
#endif

    String^ userRoot0 = "HKEY_CURRENT_USER\\Software\\Havok";
    String^ userRoot1 = "HKEY_LOCAL_MACHINE\\SOFTWARE\\Havok";
    String^ subkey;
    String^ userToolPath = nullptr;
    String^ shaderLibPath = nullptr;

    String^ pathSource = "none";

RETRY_WITHOUT_64BIT:

    if (try64bit)
    {
        subkey = "ManagedTools_x64";
        userToolPath = Environment::GetEnvironmentVariable( "HAVOK_TOOLS_ROOT_X64" );
        if ( (userToolPath != nullptr) && (userToolPath->Length > 0))
        {
            pathSource = "envvar HAVOK_TOOLS_ROOT_X64";
            userToolPath += "\\tools";
        }
    }
    else
    {
        subkey = "ManagedTools";
        userToolPath = Environment::GetEnvironmentVariable( "HAVOK_TOOLS_ROOT" );
        if ( (userToolPath != nullptr) && (userToolPath->Length > 0))
        {
            pathSource = "envvar HAVOK_TOOLS_ROOT_X64";
            userToolPath += "\\tools";
        }
    }

    if ( !System::IO::Directory::Exists(userToolPath) )
    {
        userToolPath = nullptr;
    }

    String^ backslash = "\\";
    String^ keyName = userRoot0 + backslash + subkey;

    // If no envvar, check reg keys
    if ( (userToolPath == nullptr) || (userToolPath->Length < 1))
    {
        userToolPath = (String^)Registry::GetValue( keyName, "ToolsDir", "");
        shaderLibPath = (String^)Registry::GetValue( keyName, "ShaderLibDir", "");

        pathSource = (shaderLibPath != nullptr) && (shaderLibPath->Length > 0)? keyName + "\\ShaderLibDir" : keyName + "\\ToolsDir";

        if ( !System::IO::Directory::Exists(userToolPath) )
        {
            userToolPath = nullptr;
        }
        if ( !System::IO::Directory::Exists(shaderLibPath) )
        {
            shaderLibPath = nullptr;
        }

        if ( ((shaderLibPath == nullptr) || (shaderLibPath->Length < 1)) && ((userToolPath == nullptr) || (userToolPath->Length < 1)) )
        {
            keyName = userRoot1 + backslash + subkey;
            userToolPath = (String^)Registry::GetValue( keyName, "ToolsDir", "");
            shaderLibPath = (String^)Registry::GetValue( keyName, "ShaderLibDir", "");

            if ( !System::IO::Directory::Exists(userToolPath) )
            {
                userToolPath = nullptr;
            }
            if ( !System::IO::Directory::Exists(shaderLibPath) )
            {
                shaderLibPath = nullptr;
            }

            pathSource = (shaderLibPath != nullptr) && (shaderLibPath->Length > 0)? keyName + "\\ShaderLibDir" : keyName + "\\ToolsDir";
        }
    }

    if ( (userToolPath != nullptr) && (userToolPath->Length > 0))
    {
        // Have filter/tool path, so use ShaderLib sub dir:
        if ( (shaderLibPath == nullptr) || (shaderLibPath->Length < 1))
        {
            if ( ( userToolPath->LastIndexOf("\\") == (userToolPath->Length - 1) ) ||
                ( userToolPath->LastIndexOf("/") == (userToolPath->Length - 1) ) )
            {
                shaderLibPath = userToolPath + gcnew String("ShaderLib");
            }
            else
            {
                shaderLibPath = userToolPath + gcnew String("\\ShaderLib");
            }
        }

        if ( !System::IO::Directory::Exists(userToolPath) )
        {
            userToolPath = nullptr;
        }
        if ( !System::IO::Directory::Exists(shaderLibPath) )
        {
            shaderLibPath = nullptr;
        }
    }

    // not set or none that are set exist..
    if (!try64bit && (shaderLibPath == nullptr) || (shaderLibPath->Length < 1) )
    {
        pathSource = "local fallback as no keys set, or none that are set exist";
        shaderLibPath = gcnew String(".\\tools\\shaderlib");
    }

    // see if there are any files in asset->m_convertedGraphicsObjects->m_shaderLibrary
    if ((shaderLibPath != nullptr) && (shaderLibPath->Length > 0) )
    {
        DirectoryInfo^ dirInfo = gcnew DirectoryInfo( shaderLibPath );
        if (dirInfo->Exists)    // make sure directory exists
        {
            array< FileInfo^ >^ files = dirInfo->GetFiles();
            for (int i=0; i < files->Length; ++i)
            {
                String^ filename = files[i]->ToString();
                if ( filename->EndsWith(".hlsl", System::StringComparison::CurrentCultureIgnoreCase) ||
                    filename->EndsWith(".cg", System::StringComparison::CurrentCultureIgnoreCase) )
                {
                    const char* pathString = (char*)Marshal::StringToHGlobalAnsi(shaderLibPath).ToPointer();
                    dir = pathString; // copy
                    Marshal::FreeHGlobal(IntPtr((void*)pathString));

                    break;
                }
            }

            if (dir.getLength() < 0)
            {
                MessageBox::Show("No shader files found in:\r\n" + shaderLibPath + " (from : " + pathSource + ")\r\nPreview rendering will not be as expected.", "Preview Shader Lib", MessageBoxButtons::OK, MessageBoxIcon::Error );
            }
        }
        else
        {
            MessageBox::Show("Directory not found :\r\n" + shaderLibPath + " (from : " + pathSource + ")\r\nPreview rendering will not be as expected.", "Preview Shader Lib", MessageBoxButtons::OK, MessageBoxIcon::Error );
        }
    }
    else if (try64bit)
    {
        try64bit = false;
        goto RETRY_WITHOUT_64BIT;
    }

}


void hctPreviewControl::enableFirstPersonCamera(bool enable)
{
    System::Windows::Forms::ToolStripButton^ firstPersonCameraButton = getFirstPersonCameraButton();

    if ( enable )
    {
        if ( firstPersonCameraButton ) { firstPersonCameraButton  ->Enabled = true; }
    }
    else
    {
        if ( firstPersonCameraButton ) { firstPersonCameraButton  ->Enabled = false; }
    }
}


System::Windows::Forms::ToolStripButton^ hctPreviewControl::getFirstPersonCameraButton()
{
    for (int i = 0; i < m_navigationToolBar->Items->Count; i++)
    {
        if ( m_navigationToolBar->Items[i]->Name->Equals("toolStripFirstPersonButton") )
        {
            return (System::Windows::Forms::ToolStripButton^)m_navigationToolBar->Items[i];
        }
    }

    return nullptr;
}


System::Windows::Forms::ToolStripButton^ hctPreviewControl::getFlyModeCameraButton()
{
    for (int i = 0; i < m_navigationToolBar->Items->Count; i++)
    {
        if ( m_navigationToolBar->Items[i]->Name->Equals("toolStripFlyModeButton") )
        {
            return (System::Windows::Forms::ToolStripButton^)m_navigationToolBar->Items[i];
        }
    }

    return nullptr;
}

void hctPreviewControl::configureProductsFromUI()
{
    // Synchronize all products to the UI settings.

    configurePhysicsFromUI();
    configureNewPhysicsFromUI();
    configureAnimFromUI();
    configureCompleteFromUI();
    configureClothFromUI();
    configureDestructionFromUI();
    configureNewDestructionFromUI();
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
