// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <Plugins/Preview/hctPreviewPlugin.h> //PCH
#include <Plugins/Preview/hctPreviewControl.h>

#pragma unmanaged

#include <Common/Base/hkBase.h>
#include <Common/SceneData/Scene/hkxScene.h>
#include <Common/SceneData/Graph/hkxNode.h>
#include <Common/Serialize/Util/hkRootLevelContainer.h>

#include <Plugins/Preview/hctPreviewUnmanaged.h>
#include <Plugins/Preview/hctPreviewAsset.h>

#include <Graphics/Common/hkGraphics.h>
#include <Graphics/Bridge/SceneData/hkgSceneDataConverter.h>
#include <Graphics/Common/Camera/hkgCamera.h>
#include <Graphics/Common/Window/hkgWindow.h>

#pragma  managed

using namespace PreviewPlugin;
using namespace Microsoft::Win32;
using namespace System::Runtime::InteropServices;

void hctPreviewControl::RefreshCameraLists()
{
    hkArray< hkStringOld > cameras;
    if (m_si->m_assetManager)
    {
        for (int ai=0; ai < m_si->m_assetManager->m_allAssets.getSize(); ++ai)
        {
            PreviewAsset* asset = m_si->m_assetManager->m_allAssets[ai];
            hkRootLevelContainer* root = asset->m_container;
            if (root)
            {
                hkxScene* scene = root->findObject<hkxScene>();
                if (scene && asset->m_convertedGraphicsObjects)
                {
                    hkStringOld assetName(scene->m_asset);
                    int lastBackSlash = assetName.lastIndexOf('\\') + 1;
                    int lastSlash = assetName.lastIndexOf('/') + 1;
                    hkStringOld shortAssetName = lastBackSlash > lastSlash? assetName.substr(lastBackSlash) : lastSlash > 0?  assetName.substr(lastSlash) : assetName;

                    for (int c = 0; c < asset->m_convertedGraphicsObjects->m_cameras.getSize(); ++c)
                    {
                        cameras.expandOne().printf("%s : %s",  shortAssetName.cString(), ((hkgCamera*)(asset->m_convertedGraphicsObjects->m_cameras[c].m_hkgObject))->getCameraName() );
                    }
                }
            }
        }
    }

    if (cameraMenuItem)
    {
        cameraMenuItem->DropDownItems->Clear();
    }

    if ((m_parentMenu != nullptr) && (cameras.getSize() > 0))
    {
        if (cameraMenuItem == nullptr)
        {
            cameraMenuItem = gcnew ToolStripMenuItem();
            cameraMenuItem->Name = "viewToolStripMenuItem";
            cameraMenuItem->Text = "&Cameras";

            m_parentMenu->Items->Insert(m_parentMenu->Items->Count - 1, cameraMenuItem);
        }

        for (int c=0; c < cameras.getSize(); ++c)
        {
            ToolStripMenuItem^ camItem = gcnew ToolStripMenuItem();
            String^ camName = gcnew String(cameras[c].cString());
            camItem->Name = camName + "ToolStripMenuItem";
            camItem->Text = camName;
            camItem->Click += gcnew System::EventHandler(this, &hctPreviewControl::cameraSelectToolStripMenuItem_Click);

            cameraMenuItem->DropDownItems->Add(camItem);
        }
    }
    else if (m_parentMenu != nullptr)
    {
        m_parentMenu->Items->Remove( cameraMenuItem );
        cameraMenuItem = nullptr;
    }
}

static void _setDefaultCameraName( const char* name )
{

#ifdef HK_PLATFORM_WIN64
    String^ userRoot = "HKEY_CURRENT_USER\\Software\\Havok\\ManagedTools_x64";
#else
    String^ userRoot = "HKEY_CURRENT_USER\\Software\\Havok\\ManagedTools";
#endif

    Registry::SetValue(userRoot, "defaultCameraName", gcnew String(name));
}

static void _getDefaultCameraName( hkStringOld& name )
{
#ifdef HK_PLATFORM_WIN64
    String^ userRoot = "HKEY_CURRENT_USER\\Software\\Havok\\ManagedTools_x64";
#else
    String^ userRoot = "HKEY_CURRENT_USER\\Software\\Havok\\ManagedTools";
#endif

    String^ sname = (String^) Registry::GetValue(userRoot, "defaultCameraName", nullptr);
    if (sname)
    {
        const char* mname = (char*)Marshal::StringToHGlobalAnsi(sname).ToPointer();
        name = mname; // copy
        Marshal::FreeHGlobal(IntPtr((void*)mname));
    }
    else
    {
        name = "defaultCamera";
    }
}


static int _findCameraByName(PreviewPlugin::PreviewAssetManager* assets, hkgDisplayContext* context, const char* searchName )
{
    if ((searchName != HK_NULL) && (hkString::strLen(searchName) > 0))
    {
        int curCamIndex = 0;
        for (int ai=0; ai < assets->m_allAssets.getSize(); ++ai)
        {
            PreviewAsset* asset = assets->m_allAssets[ai];
            hkRootLevelContainer* root = asset->m_container;
            if (root)
            {
                hkxScene* scene = root->findObject<hkxScene>();
                if (scene && asset->m_convertedGraphicsObjects)
                {
                    for (int ci=0; ci < asset->m_convertedGraphicsObjects->m_cameras.getSize(); ++ci)
                    {
                        hkgCamera* cam = (hkgCamera*)( asset->m_convertedGraphicsObjects->m_cameras[ci].m_hkgObject );
                        if (cam && cam->getCameraName() &&  ( hkString::strCmp(cam->getCameraName(), searchName) == 0 ) )
                        {
                            return curCamIndex;
                        }

                        ++curCamIndex;
                    }
                }
            }
        }
    }

    return -1;
}

static void _pickCameraByIndex(PreviewPlugin::PreviewAssetManager* assets, hkgDisplayContext* context, int camIndex )
{
    int curCamIndex = 0;
    for (int ai=0; ai < assets->m_allAssets.getSize(); ++ai)
    {
        PreviewAsset* asset = assets->m_allAssets[ai];
        hkRootLevelContainer* root = asset->m_container;
        if (root)
        {
            hkxScene* scene = root->findObject<hkxScene>();
            if (scene && asset->m_convertedGraphicsObjects)
            {
                int thisCamIndex = camIndex - curCamIndex;
                if (thisCamIndex < asset->m_convertedGraphicsObjects->m_cameras.getSize())
                {
                    hkgCamera* cam = (hkgCamera*)( asset->m_convertedGraphicsObjects->m_cameras[thisCamIndex].m_hkgObject );

                    _setDefaultCameraName( cam->getCameraName() );

                    // Set the camera to the position of the first camera in the scene.
                    hkgWindow* window = context->getOwner();
                    hkgCamera* viewCam = window->getCurrentViewport()->getCamera();
                    {
                        // Position the camera correctly.
                        // We copy the camera so that we can go back to its orgi state at later stage
                        viewCam->setFrom( cam->getFromPtr() );
                        viewCam->setTo( cam->getToPtr() );
                        viewCam->setUp( cam->getUpPtr() );
                        viewCam->setFOV( cam->getFOV() );
                        viewCam->setNear( hkMath::max2<float>( cam->getNear(), 0.01f ) );
                        viewCam->setFar( hkMath::min2<float>( cam->getFar(), 10000.0f) );
                        //viewCam->setHandednessMode( cam->getHandednessMode() ); // Keep existing handedness, not the one from file.
                        viewCam->computeModelView();
                        viewCam->computeProjection();
                    }

                    return;
                }
                else
                {
                    curCamIndex += asset->m_convertedGraphicsObjects->m_cameras.getSize();
                }
            }
        }
    }
}

System::Void hctPreviewControl::cameraSelectToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e)
{
    if (cameraMenuItem)
    {
        int camIndex = cameraMenuItem->DropDownItems->IndexOf( (ToolStripItem^) sender);
        if ((camIndex >= 0) && (m_si->m_assetManager))
        {
            _pickCameraByIndex( m_si->m_assetManager, m_si->m_displayContext, camIndex );
        }
    }
}

System::Void hctPreviewControl::PickDefaultCamera()
{
    hkStringOld cname;
    _getDefaultCameraName(cname);

    // look for cname
    int index = _findCameraByName( m_si->m_assetManager, m_si->m_displayContext, cname.cString() );
    if (index < 0)
    {
        index = 0;// just pick first (if one)
    }

    _pickCameraByIndex(m_si->m_assetManager, m_si->m_displayContext, index);
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
